/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons;

import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.commons.OrbitStateVectors;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;
import org.esa.snap.engine_utilities.datamodel.PosVector;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.eo.LocalGeometry;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;
import org.esa.snap.engine_utilities.util.Maths;

public final class SARGeocoding {
    public static final double NonValidZeroDopplerTime = -99999.0;
    public static final double NonValidIncidenceAngle = -99999.0;
    public static final String USE_PROJECTED_INCIDENCE_ANGLE_FROM_DEM = "Use projected local incidence angle from DEM";
    public static final String USE_LOCAL_INCIDENCE_ANGLE_FROM_DEM = "Use local incidence angle from DEM";
    public static final String USE_INCIDENCE_ANGLE_FROM_ELLIPSOID = "Use incidence angle from Ellipsoid";

    public static boolean isNearRangeOnLeft(TiePointGrid incidenceAngle, int sourceImageWidth) {
        double incidenceAngleToLastPixel;
        if (incidenceAngle == null) {
            return true;
        }
        double incidenceAngleToFirstPixel = incidenceAngle.getPixelDouble(0, 0);
        return incidenceAngleToFirstPixel < (incidenceAngleToLastPixel = incidenceAngle.getPixelDouble(sourceImageWidth - 1, 0));
    }

    public static double getEarthPointZeroDopplerTime(double firstLineUTC, double lineTimeInterval, double wavelength, PosVector earthPoint, PosVector[] sensorPosition, PosVector[] sensorVelocity) throws OperatorException {
        int lowerBound = 0;
        int upperBound = sensorPosition.length - 1;
        double lowerBoundFreq = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[lowerBound], sensorVelocity[lowerBound], wavelength);
        double upperBoundFreq = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[upperBound], sensorVelocity[upperBound], wavelength);
        if (Double.compare(lowerBoundFreq, 0.0) == 0) {
            return firstLineUTC + (double)lowerBound * lineTimeInterval;
        }
        if (Double.compare(upperBoundFreq, 0.0) == 0) {
            return firstLineUTC + (double)upperBound * lineTimeInterval;
        }
        if (lowerBoundFreq * upperBoundFreq > 0.0) {
            return -99999.0;
        }
        while (upperBound - lowerBound > 1) {
            int mid = (int)((double)(lowerBound + upperBound) / 2.0);
            double midFreq = sensorVelocity[mid].x * (earthPoint.x - sensorPosition[mid].x) + sensorVelocity[mid].y * (earthPoint.y - sensorPosition[mid].y) + sensorVelocity[mid].z * (earthPoint.z - sensorPosition[mid].z);
            if (midFreq * lowerBoundFreq > 0.0) {
                lowerBound = mid;
                lowerBoundFreq = midFreq;
                continue;
            }
            if (midFreq * upperBoundFreq > 0.0) {
                upperBound = mid;
                upperBoundFreq = midFreq;
                continue;
            }
            if (Double.compare(midFreq, 0.0) != 0) continue;
            return firstLineUTC + (double)mid * lineTimeInterval;
        }
        double y0 = (double)lowerBound - lowerBoundFreq * (double)(upperBound - lowerBound) / (upperBoundFreq - lowerBoundFreq);
        return firstLineUTC + y0 * lineTimeInterval;
    }

    public static double getEarthPointZeroDopplerTimeNewton(double lineTimeInterval, double wavelength, PosVector earthPoint, OrbitStateVectors orbit) throws OperatorException {
        int numOrbitVec = orbit.orbitStateVectors.length;
        double firstVecFreq = SARGeocoding.getDopplerFrequency(earthPoint, orbit.orbitStateVectors[0], wavelength);
        double firstVecTime = orbit.orbitStateVectors[0].time_mjd;
        double lastVecFreq = SARGeocoding.getDopplerFrequency(earthPoint, orbit.orbitStateVectors[numOrbitVec - 1], wavelength);
        double lastVecTime = orbit.orbitStateVectors[numOrbitVec - 1].time_mjd;
        if (firstVecFreq == 0.0) {
            return firstVecTime;
        }
        if (lastVecFreq == 0.0) {
            return lastVecTime;
        }
        if (firstVecFreq * lastVecFreq > 0.0) {
            return -99999.0;
        }
        double newTime = (firstVecTime + lastVecTime) / 2.0;
        OrbitStateVectors.PositionVelocity pv = orbit.getPositionVelocity(newTime);
        double newFreq = SARGeocoding.getDopplerFrequency(earthPoint, pv.position, pv.velocity, wavelength);
        for (int numIter = 0; Math.abs(newFreq) > 0.001 && numIter <= 10; ++numIter) {
            double oldTime = newTime;
            double oldFreq = newFreq;
            pv = orbit.getPositionVelocity(oldTime + lineTimeInterval);
            double oldFreqDel = SARGeocoding.getDopplerFrequency(earthPoint, pv.position, pv.velocity, wavelength);
            double d = (oldFreqDel - oldFreq) / lineTimeInterval;
            newTime = oldTime - oldFreq / d;
            if (newTime < 0.0) {
                newTime = 0.0;
            } else if (newTime > lastVecTime) {
                newTime = lastVecTime;
            }
            pv = orbit.getPositionVelocity(newTime);
            newFreq = SARGeocoding.getDopplerFrequency(earthPoint, pv.position, pv.velocity, wavelength);
        }
        return newTime;
    }

    public static double getZeroDopplerTime(double lineTimeInterval, double wavelength, PosVector earthPoint, OrbitStateVectors orbit) throws OperatorException {
        int numOrbitVec = orbit.orbitStateVectors.length;
        double firstVecTime = 0.0;
        double secondVecTime = 0.0;
        double firstVecFreq = 0.0;
        double secondVecFreq = 0.0;
        for (int i = 0; i < numOrbitVec; ++i) {
            OrbitStateVector orb = orbit.orbitStateVectors[i];
            double currentFreq = SARGeocoding.getDopplerFrequency(earthPoint, orb, wavelength);
            if (i != 0 && !(firstVecFreq * currentFreq > 0.0)) {
                secondVecTime = orb.time_mjd;
                secondVecFreq = currentFreq;
                break;
            }
            firstVecTime = orb.time_mjd;
            firstVecFreq = currentFreq;
        }
        if (firstVecFreq * secondVecFreq >= 0.0) {
            return -99999.0;
        }
        double lowerBoundTime = firstVecTime;
        double upperBoundTime = secondVecTime;
        double lowerBoundFreq = firstVecFreq;
        double upperBoundFreq = secondVecFreq;
        double diffTime = Math.abs(upperBoundTime - lowerBoundTime);
        double absLineTimeInterval = Math.abs(lineTimeInterval);
        int totalIterations = (int)(diffTime / absLineTimeInterval) + 1;
        for (int numIterations = 0; diffTime > absLineTimeInterval && numIterations <= totalIterations; ++numIterations) {
            double midTime = (upperBoundTime + lowerBoundTime) / 2.0;
            OrbitStateVectors.PositionVelocity pv = orbit.getPositionVelocity(midTime);
            double midFreq = SARGeocoding.getDopplerFrequency(earthPoint, pv.position, pv.velocity, wavelength);
            if (midFreq * lowerBoundFreq > 0.0) {
                lowerBoundTime = midTime;
                lowerBoundFreq = midFreq;
            } else if (midFreq * upperBoundFreq > 0.0) {
                upperBoundTime = midTime;
                upperBoundFreq = midFreq;
            } else if (Double.compare(midFreq, 0.0) == 0) {
                return midTime;
            }
            diffTime = Math.abs(upperBoundTime - lowerBoundTime);
        }
        return lowerBoundTime - lowerBoundFreq * (upperBoundTime - lowerBoundTime) / (upperBoundFreq - lowerBoundFreq);
    }

    private static double getDopplerFrequency(PosVector earthPoint, PosVector sensorPosition, PosVector sensorVelocity, double wavelength) {
        double xDiff = earthPoint.x - sensorPosition.x;
        double yDiff = earthPoint.y - sensorPosition.y;
        double zDiff = earthPoint.z - sensorPosition.z;
        double distance = Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
        return 2.0 * (sensorVelocity.x * xDiff + sensorVelocity.y * yDiff + sensorVelocity.z * zDiff) / (distance * wavelength);
    }

    private static double getDopplerFrequency(PosVector earthPoint, OrbitStateVector orbit, double wavelength) {
        double xDiff = earthPoint.x - orbit.x_pos;
        double yDiff = earthPoint.y - orbit.y_pos;
        double zDiff = earthPoint.z - orbit.z_pos;
        double distance = Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
        return 2.0 * (orbit.x_vel * xDiff + orbit.y_vel * yDiff + orbit.z_vel * zDiff) / (distance * wavelength);
    }

    public static double computeSlantRange(double time, OrbitStateVectors orbit, PosVector earthPoint, PosVector sensorPos) {
        orbit.getPosition(time, sensorPos);
        double xDiff = sensorPos.x - earthPoint.x;
        double yDiff = sensorPos.y - earthPoint.y;
        double zDiff = sensorPos.z - earthPoint.z;
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
    }

    public static double computeRangeIndex(boolean srgrFlag, int sourceImageWidth, double firstLineUTC, double lastLineUTC, double rangeSpacing, double zeroDopplerTime, double slantRange, double nearEdgeSlantRange, AbstractMetadata.SRGRCoefficientList[] srgrConvParams) {
        if (zeroDopplerTime < Math.min(firstLineUTC, lastLineUTC) || zeroDopplerTime > Math.max(firstLineUTC, lastLineUTC)) {
            return -1.0;
        }
        if (srgrFlag) {
            if (srgrConvParams.length == 1) {
                double groundRange = SARGeocoding.computeGroundRange(sourceImageWidth, rangeSpacing, slantRange, srgrConvParams[0].coefficients, srgrConvParams[0].ground_range_origin);
                if (groundRange < 0.0) {
                    return -1.0;
                }
                return (groundRange - srgrConvParams[0].ground_range_origin) / rangeSpacing;
            }
            int idx = 0;
            int i = 0;
            while (i < srgrConvParams.length && zeroDopplerTime >= srgrConvParams[i].timeMJD) {
                idx = i++;
            }
            double[] srgrCoefficients = new double[srgrConvParams[idx].coefficients.length];
            if (idx == srgrConvParams.length - 1) {
                --idx;
            }
            double mu = (zeroDopplerTime - srgrConvParams[idx].timeMJD) / (srgrConvParams[idx + 1].timeMJD - srgrConvParams[idx].timeMJD);
            for (int i2 = 0; i2 < srgrCoefficients.length; ++i2) {
                srgrCoefficients[i2] = Maths.interpolationLinear((double)srgrConvParams[idx].coefficients[i2], (double)srgrConvParams[idx + 1].coefficients[i2], (double)mu);
            }
            double groundRange = SARGeocoding.computeGroundRange(sourceImageWidth, rangeSpacing, slantRange, srgrCoefficients, srgrConvParams[idx].ground_range_origin);
            if (groundRange < 0.0) {
                return -1.0;
            }
            return (groundRange - srgrConvParams[idx].ground_range_origin) / rangeSpacing;
        }
        return (slantRange - nearEdgeSlantRange) / rangeSpacing;
    }

    public static double computeExtendedRangeIndex(boolean srgrFlag, int sourceImageWidth, double firstLineUTC, double lastLineUTC, double rangeSpacing, double zeroDopplerTime, double slantRange, double nearEdgeSlantRange, AbstractMetadata.SRGRCoefficientList[] srgrConvParams) {
        if (zeroDopplerTime < Math.min(firstLineUTC, lastLineUTC) || zeroDopplerTime > Math.max(firstLineUTC, lastLineUTC)) {
            return -1.0;
        }
        if (srgrFlag) {
            if (srgrConvParams.length == 1 || zeroDopplerTime < srgrConvParams[0].timeMJD) {
                double groundRange = SARGeocoding.computeGroundRange(sourceImageWidth, rangeSpacing, slantRange, srgrConvParams[0].coefficients, srgrConvParams[0].ground_range_origin);
                if (groundRange < 0.0) {
                    return -1.0;
                }
                return (groundRange - srgrConvParams[0].ground_range_origin) / rangeSpacing;
            }
            if (zeroDopplerTime > srgrConvParams[srgrConvParams.length - 1].timeMJD) {
                double groundRange = SARGeocoding.computeGroundRange(sourceImageWidth, rangeSpacing, slantRange, srgrConvParams[srgrConvParams.length - 1].coefficients, srgrConvParams[srgrConvParams.length - 1].ground_range_origin);
                if (groundRange < 0.0) {
                    return -1.0;
                }
                return (groundRange - srgrConvParams[srgrConvParams.length - 1].ground_range_origin) / rangeSpacing;
            }
            int idx = 0;
            int i = 0;
            while (i < srgrConvParams.length && zeroDopplerTime >= srgrConvParams[i].timeMJD) {
                idx = i++;
            }
            double[] srgrCoefficients = new double[srgrConvParams[idx].coefficients.length];
            if (idx == srgrConvParams.length - 1) {
                --idx;
            }
            double mu = (zeroDopplerTime - srgrConvParams[idx].timeMJD) / (srgrConvParams[idx + 1].timeMJD - srgrConvParams[idx].timeMJD);
            for (int i2 = 0; i2 < srgrCoefficients.length; ++i2) {
                srgrCoefficients[i2] = Maths.interpolationLinear((double)srgrConvParams[idx].coefficients[i2], (double)srgrConvParams[idx + 1].coefficients[i2], (double)mu);
            }
            double groundRange = SARGeocoding.computeGroundRange(sourceImageWidth, rangeSpacing, slantRange, srgrCoefficients, srgrConvParams[idx].ground_range_origin);
            if (groundRange < 0.0) {
                return -1.0;
            }
            return (groundRange - srgrConvParams[idx].ground_range_origin) / rangeSpacing;
        }
        return (slantRange - nearEdgeSlantRange) / rangeSpacing;
    }

    public static double computeGroundRange(int sourceImageWidth, double rangeSpacing, double slantRange, double[] srgrCoeff, double ground_range_origin) {
        double lowerBound = ground_range_origin;
        double lowerBoundSlantRange = Maths.computePolynomialValue((double)lowerBound, (double[])srgrCoeff);
        if (slantRange < lowerBoundSlantRange) {
            return -1.0;
        }
        double upperBound = ground_range_origin + (double)sourceImageWidth * rangeSpacing;
        double upperBoundSlantRange = Maths.computePolynomialValue((double)upperBound, (double[])srgrCoeff);
        if (slantRange > upperBoundSlantRange) {
            return -1.0;
        }
        while (upperBound - lowerBound > 0.0) {
            double mid = (lowerBound + upperBound) / 2.0;
            double midSlantRange = Maths.computePolynomialValue((double)mid, (double[])srgrCoeff);
            if (midSlantRange < slantRange) {
                lowerBound = mid;
                continue;
            }
            if (midSlantRange > slantRange) {
                upperBound = mid;
                continue;
            }
            double a = midSlantRange - slantRange;
            if (!(a > 0.0 && a < 0.1) && (!(a <= 0.0) || !(0.0 - a < 0.1))) continue;
            return mid;
        }
        return -1.0;
    }

    public static void computeLocalIncidenceAngle(LocalGeometry lg, Double demNoDataValue, boolean saveLocalIncidenceAngle, boolean saveProjectedLocalIncidenceAngle, boolean saveSigmaNought, int x0, int y0, int x, int y, double[][] localDEM, double[] localIncidenceAngles) {
        for (int i = 0; i < 3; ++i) {
            int yy = y - y0 + i;
            for (int j = 0; j < 3; ++j) {
                if (!demNoDataValue.equals(localDEM[yy][x - x0 + j])) continue;
                return;
            }
        }
        int yy = y - y0;
        int xx = x - x0;
        double rightPointHeight = (localDEM[yy][xx + 2] + localDEM[yy + 1][xx + 2] + localDEM[yy + 2][xx + 2]) / 3.0;
        double leftPointHeight = (localDEM[yy][xx] + localDEM[yy + 1][xx] + localDEM[yy + 2][xx]) / 3.0;
        double upPointHeight = (localDEM[yy][xx] + localDEM[yy][xx + 1] + localDEM[yy][xx + 2]) / 3.0;
        double downPointHeight = (localDEM[yy + 2][xx] + localDEM[yy + 2][xx + 1] + localDEM[yy + 2][xx + 2]) / 3.0;
        PosVector rightPoint = new PosVector();
        PosVector leftPoint = new PosVector();
        PosVector upPoint = new PosVector();
        PosVector downPoint = new PosVector();
        GeoUtils.geo2xyzWGS84((double)lg.rightPointLat, (double)lg.rightPointLon, (double)rightPointHeight, (PosVector)rightPoint);
        GeoUtils.geo2xyzWGS84((double)lg.leftPointLat, (double)lg.leftPointLon, (double)leftPointHeight, (PosVector)leftPoint);
        GeoUtils.geo2xyzWGS84((double)lg.upPointLat, (double)lg.upPointLon, (double)upPointHeight, (PosVector)upPoint);
        GeoUtils.geo2xyzWGS84((double)lg.downPointLat, (double)lg.downPointLon, (double)downPointHeight, (PosVector)downPoint);
        PosVector a = new PosVector(rightPoint.x - leftPoint.x, rightPoint.y - leftPoint.y, rightPoint.z - leftPoint.z);
        PosVector b = new PosVector(downPoint.x - upPoint.x, downPoint.y - upPoint.y, downPoint.z - upPoint.z);
        PosVector c = new PosVector(lg.centrePoint.x, lg.centrePoint.y, lg.centrePoint.z);
        PosVector n = new PosVector(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
        Maths.normalizeVector((PosVector)n);
        if (Maths.innerProduct((PosVector)n, (PosVector)c) < 0.0) {
            n.x = -n.x;
            n.y = -n.y;
            n.z = -n.z;
        }
        PosVector s = new PosVector(lg.sensorPos.x - lg.centrePoint.x, lg.sensorPos.y - lg.centrePoint.y, lg.sensorPos.z - lg.centrePoint.z);
        Maths.normalizeVector((PosVector)s);
        if (saveLocalIncidenceAngle) {
            double nsInnerProduct = Maths.innerProduct((PosVector)n, (PosVector)s);
            localIncidenceAngles[0] = FastMath.acos((double)nsInnerProduct) * 57.29577951308232;
        }
        if (saveProjectedLocalIncidenceAngle || saveSigmaNought) {
            PosVector m = new PosVector(s.y * c.z - s.z * c.y, s.z * c.x - s.x * c.z, s.x * c.y - s.y * c.x);
            Maths.normalizeVector((PosVector)m);
            double mnInnerProduct = Maths.innerProduct((PosVector)m, (PosVector)n);
            PosVector n1 = new PosVector(n.x - m.x * mnInnerProduct, n.y - m.y * mnInnerProduct, n.z - m.z * mnInnerProduct);
            Maths.normalizeVector((PosVector)n1);
            localIncidenceAngles[1] = FastMath.acos((double)Maths.innerProduct((PosVector)n1, (PosVector)s)) * 57.29577951308232;
        }
    }

    public static void computeLocalIncidenceAngle(LocalGeometry lg, double demNoDataValue, boolean saveLocalIncidenceAngle, boolean saveProjectedLocalIncidenceAngle, boolean saveSigmaNought, int x0, int y0, int x, int y, double[][] localDEM, double[] localIncidenceAngles, TileGeoreferencing tileGeoRef, ElevationModel dem) throws Exception {
        Double alt;
        int n;
        int yy = y - y0;
        int xx = x - x0;
        int maxX = localDEM[0].length - 1;
        int maxY = localDEM.length - 1;
        int numN = 3;
        GeoPos geo = new GeoPos();
        double rightPointHeight = 0.0;
        double leftPointHeight = 0.0;
        double upPointHeight = 0.0;
        double downPointHeight = 0.0;
        int cnt = 0;
        for (n = 0; n < 3; ++n) {
            if (xx + n > maxX) {
                tileGeoRef.getGeoPos(xx + n, yy, geo);
                alt = dem.getElevation(geo);
            } else {
                alt = localDEM[yy][xx + n];
            }
            if (alt.equals(demNoDataValue)) continue;
            rightPointHeight += alt.doubleValue();
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        rightPointHeight /= (double)cnt;
        cnt = 0;
        for (n = 0; n < 3; ++n) {
            if (xx - n < 0) {
                tileGeoRef.getGeoPos(xx - n, yy, geo);
                alt = dem.getElevation(geo);
            } else {
                alt = localDEM[yy][xx - n];
            }
            if (alt.equals(demNoDataValue)) continue;
            leftPointHeight += alt.doubleValue();
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        leftPointHeight /= (double)cnt;
        cnt = 0;
        for (n = 0; n < 3; ++n) {
            if (yy - n < 0) {
                tileGeoRef.getGeoPos(xx, yy - n, geo);
                alt = dem.getElevation(geo);
            } else {
                alt = localDEM[yy - n][xx];
            }
            if (alt.equals(demNoDataValue)) continue;
            upPointHeight += alt.doubleValue();
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        upPointHeight /= (double)cnt;
        cnt = 0;
        for (n = 0; n < 3; ++n) {
            if (yy + n > maxY) {
                tileGeoRef.getGeoPos(xx, yy + n, geo);
                alt = dem.getElevation(geo);
            } else {
                alt = localDEM[yy + n][xx];
            }
            if (alt.equals(demNoDataValue)) continue;
            downPointHeight += alt.doubleValue();
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        downPointHeight /= (double)cnt;
        PosVector rightPoint = new PosVector();
        PosVector leftPoint = new PosVector();
        PosVector upPoint = new PosVector();
        PosVector downPoint = new PosVector();
        PosVector centrePoint = new PosVector();
        GeoUtils.geo2xyzWGS84((double)lg.rightPointLat, (double)lg.rightPointLon, (double)rightPointHeight, (PosVector)rightPoint);
        GeoUtils.geo2xyzWGS84((double)lg.leftPointLat, (double)lg.leftPointLon, (double)leftPointHeight, (PosVector)leftPoint);
        GeoUtils.geo2xyzWGS84((double)lg.upPointLat, (double)lg.upPointLon, (double)upPointHeight, (PosVector)upPoint);
        GeoUtils.geo2xyzWGS84((double)lg.downPointLat, (double)lg.downPointLon, (double)downPointHeight, (PosVector)downPoint);
        tileGeoRef.getGeoPos(xx, yy, geo);
        double centerHeight = localDEM[yy][xx];
        GeoUtils.geo2xyzWGS84((double)geo.getLat(), (double)geo.lon, (double)centerHeight, (PosVector)centrePoint);
        PosVector a = new PosVector(rightPoint.x - leftPoint.x, rightPoint.y - leftPoint.y, rightPoint.z - leftPoint.z);
        PosVector b = new PosVector(downPoint.x - upPoint.x, downPoint.y - upPoint.y, downPoint.z - upPoint.z);
        PosVector c = new PosVector(centrePoint.x, centrePoint.y, centrePoint.z);
        PosVector n2 = new PosVector(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
        Maths.normalizeVector((PosVector)n2);
        if (Maths.innerProduct((PosVector)n2, (PosVector)c) < 0.0) {
            n2.x = -n2.x;
            n2.y = -n2.y;
            n2.z = -n2.z;
        }
        PosVector s = new PosVector(lg.sensorPos.x - centrePoint.x, lg.sensorPos.y - centrePoint.y, lg.sensorPos.z - centrePoint.z);
        Maths.normalizeVector((PosVector)s);
        if (saveLocalIncidenceAngle) {
            double nsInnerProduct = Maths.innerProduct((PosVector)n2, (PosVector)s);
            localIncidenceAngles[0] = FastMath.acos((double)nsInnerProduct) * 57.29577951308232;
        }
        if (saveProjectedLocalIncidenceAngle || saveSigmaNought) {
            PosVector m = new PosVector(s.y * c.z - s.z * c.y, s.z * c.x - s.x * c.z, s.x * c.y - s.y * c.x);
            Maths.normalizeVector((PosVector)m);
            double mnInnerProduct = Maths.innerProduct((PosVector)m, (PosVector)n2);
            PosVector n1 = new PosVector(n2.x - m.x * mnInnerProduct, n2.y - m.y * mnInnerProduct, n2.z - m.z * mnInnerProduct);
            Maths.normalizeVector((PosVector)n1);
            localIncidenceAngles[1] = FastMath.acos((double)Maths.innerProduct((PosVector)n1, (PosVector)s)) * 57.29577951308232;
        }
    }

    public static double getAzimuthPixelSpacing(Product srcProduct) throws Exception {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        return AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"azimuth_spacing");
    }

    public static double getRangePixelSpacing(Product srcProduct) throws Exception {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        double rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"range_spacing");
        boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)abs, (String)"srgr_flag");
        if (srgrFlag) {
            return rangeSpacing;
        }
        return rangeSpacing / FastMath.sin((double)SARGeocoding.getIncidenceAngleAtCentreRangePixel(srcProduct));
    }

    public static double getPixelSpacing(Product srcProduct) throws Exception {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        double rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"range_spacing");
        double azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"azimuth_spacing");
        boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)abs, (String)"srgr_flag");
        if (srgrFlag) {
            return Math.min(rangeSpacing, azimuthSpacing);
        }
        return Math.min(rangeSpacing / FastMath.sin((double)SARGeocoding.getIncidenceAngleAtCentreRangePixel(srcProduct)), azimuthSpacing);
    }

    private static double getIncidenceAngleAtCentreRangePixel(Product srcProduct) throws OperatorException {
        int sourceImageWidth = srcProduct.getSceneRasterWidth();
        int sourceImageHeight = srcProduct.getSceneRasterHeight();
        int x = sourceImageWidth / 2;
        int y = sourceImageHeight / 2;
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)srcProduct);
        if (incidenceAngle == null) {
            throw new OperatorException("incidence_angle tie point grid not found in product");
        }
        return incidenceAngle.getPixelDouble(x, y) * (Math.PI / 180);
    }

    public static double getPixelSpacingInDegree(double pixelSpacingInMeter) {
        return pixelSpacingInMeter / 6378137.0 * 57.29577951308232;
    }

    public static double getPixelSpacingInMeter(double pixelSpacingInDegree) {
        return pixelSpacingInDegree * 6356752.314245179 * (Math.PI / 180);
    }

    public static boolean isValidCell(double rangeIndex, double azimuthIndex, double lat, double lon, int diffLat, GeoCoding geoCoding, int srcMaxRange, int srcMaxAzimuth, PosVector sensorPos) {
        if (rangeIndex < 0.0 || rangeIndex >= (double)srcMaxRange || azimuthIndex < 0.0 || azimuthIndex >= (double)srcMaxAzimuth) {
            return false;
        }
        if (diffLat < 5) {
            return true;
        }
        GeoPos sensorGeoPos = new GeoPos();
        GeoUtils.xyz2geo((double[])sensorPos.toArray(), (GeoPos)sensorGeoPos, (GeoUtils.EarthModel)GeoUtils.EarthModel.WGS84);
        double delLatMax = Math.abs(lat - sensorGeoPos.lat);
        double delLonMax = lon < 0.0 && sensorGeoPos.lon > 0.0 ? Math.min(Math.abs(360.0 + lon - sensorGeoPos.lon), sensorGeoPos.lon - lon) : (lon > 0.0 && sensorGeoPos.lon < 0.0 ? Math.min(Math.abs(360.0 + sensorGeoPos.lon - lon), lon - sensorGeoPos.lon) : Math.abs(lon - sensorGeoPos.lon));
        GeoPos geoPos = geoCoding.getGeoPos(new PixelPos(rangeIndex, azimuthIndex), null);
        double delLat = Math.abs(lat - geoPos.lat);
        double srcLon = geoPos.lon;
        double delLon = lon < 0.0 && srcLon > 0.0 ? Math.min(Math.abs(360.0 + lon - srcLon), srcLon - lon) : (lon > 0.0 && srcLon < 0.0 ? Math.min(Math.abs(360.0 + srcLon - lon), lon - srcLon) : Math.abs(lon - srcLon));
        return delLat + delLon <= delLatMax + delLonMax;
    }

    public static void addLookDirection(String name, MetadataElement lookDirectionListElem, int index, int num, int sourceImageWidth, int sourceImageHeight, double firstLineUTC, double lineTimeInterval, boolean nearRangeOnLeft, GeoCoding geoCoding) {
        int xTail;
        int xHead;
        int y;
        MetadataElement lookDirectionElem = new MetadataElement(name + index);
        if (num == 1) {
            y = sourceImageHeight / 2;
        } else if (num > 1) {
            y = (index - 1) * sourceImageHeight / (num - 1);
        } else {
            throw new OperatorException("Invalid number of look directions");
        }
        double time = firstLineUTC + (double)y * lineTimeInterval;
        lookDirectionElem.setAttributeUTC("time", new ProductData.UTC(time));
        if (nearRangeOnLeft) {
            xHead = sourceImageWidth - 1;
            xTail = 0;
        } else {
            xHead = 0;
            xTail = sourceImageWidth - 1;
        }
        GeoPos geoPosHead = geoCoding.getGeoPos(new PixelPos((double)xHead, (double)y), null);
        GeoPos geoPosTail = geoCoding.getGeoPos(new PixelPos((double)xTail, (double)y), null);
        lookDirectionElem.setAttributeDouble("head_lat", geoPosHead.lat);
        lookDirectionElem.setAttributeDouble("head_lon", geoPosHead.lon);
        lookDirectionElem.setAttributeDouble("tail_lat", geoPosTail.lat);
        lookDirectionElem.setAttributeDouble("tail_lon", geoPosTail.lon);
        lookDirectionListElem.addElement(lookDirectionElem);
    }
}

