/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons;

import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;

public class RGBProfiles {
    static void registerRGBProfiles() {
        RGBImageProfileManager manager = RGBImageProfileManager.getInstance();
        manager.addProfile(new RGBImageProfile("Pauli", new String[]{"((i_HH-i_VV)*(i_HH-i_VV)+(q_HH-q_VV)*(q_HH-q_VV))/2", "((i_HV+i_VH)*(i_HV+i_VH)+(q_HV+q_VH)*(q_HV+q_VH))/2", "((i_HH+i_VV)*(i_HH+i_VV)+(q_HH+q_VV)*(q_HH+q_VV))/2"}));
        manager.addProfile(new RGBImageProfile("Pauli", new String[]{"sqrt(Sigma0_HH-Sigma0_VV)", "sqrt(Sigma0_HV+Sigma0_VH)", "sqrt(Sigma0_HH+Sigma0_VV)"}));
        manager.addProfile(new RGBImageProfile("Sinclair", new String[]{"i_VV*i_VV+q_VV*q_VV", "((i_HV+i_VH)*(i_HV+i_VH)+(q_HV+q_VH)*(q_HV+q_VH))/4", "i_HH*i_HH+q_HH*q_HH"}));
        RGBProfiles.addProfile(manager, TYPE.RATIO);
        RGBProfiles.addProfile(manager, TYPE.MULTIPLE);
        RGBProfiles.addProfile(manager, TYPE.DIFFERENCE);
    }

    private static void addProfile(RGBImageProfileManager manager, TYPE profileType) {
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Intensity", "HH", "HV", ""));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Intensity", "VV", "VH", ""));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Intensity", "HH", "VV", ""));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Intensity", "HH", "HV", "_db"));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Intensity", "VV", "VH", "_db"));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Intensity", "HH", "VV", "_db"));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Sigma0", "HH", "HV", ""));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Sigma0", "VV", "VH", ""));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Sigma0", "HH", "VV", ""));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Sigma0", "HH", "HV", "_db"));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Sigma0", "VV", "VH", "_db"));
        manager.addProfile(RGBProfiles.createDPProfile(profileType, "Sigma0", "HH", "VV", "_db"));
    }

    private static RGBImageProfile createDPProfile(TYPE profileType, String name, String pol1, String pol2, String suffix) {
        switch (profileType) {
            case RATIO: {
                return new RGBImageProfile("Dual Pol Ratio " + name + suffix + ' ' + pol1 + '+' + pol2, new String[]{name + '_' + pol1 + suffix, name + '_' + pol2 + suffix, name + '_' + pol1 + suffix + '/' + name + '_' + pol2 + suffix});
            }
            case MULTIPLE: {
                return new RGBImageProfile("Dual Pol Multiple " + name + suffix + ' ' + pol1 + '+' + pol2, new String[]{name + '_' + pol1 + suffix, name + '_' + pol2 + suffix, "abs(" + name + '_' + pol1 + suffix + '*' + name + '_' + pol2 + suffix + ')'});
            }
            case DIFFERENCE: {
                return new RGBImageProfile("Dual Pol Difference " + name + suffix + ' ' + pol1 + '+' + pol2, new String[]{name + '_' + pol2 + suffix, name + '_' + pol1 + suffix, "abs(" + name + '_' + pol1 + suffix + '-' + name + '_' + pol2 + suffix + ')'});
            }
        }
        return null;
    }

    private static enum TYPE {
        RATIO,
        MULTIPLE,
        DIFFERENCE;

    }
}

