/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.gmted2010;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.esa.beam.dataio.gmted2010.GMTED2010ElevationModel;
import org.esa.beam.framework.dataop.dem.AbstractElevationModelDescriptor;
import org.esa.beam.framework.dataop.dem.ElevationModel;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.resamp.Resampling;

public class GMTED2010ElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    public static final String NAME = "GMTED2010_30";
    public static final int NUM_X_TILES = 12;
    public static final int NUM_Y_TILES = 9;
    public static final int DEGREE_RES_X = 30;
    public static final int DEGREE_RES_Y = 20;
    public static final int TILE_WIDTH = 3600;
    public static final int TILE_HEIGHT = 2400;
    public static final int NO_DATA_VALUE = Short.MIN_VALUE;
    public static final int RASTER_WIDTH = 43200;
    public static final int RASTER_HEIGHT = 21600;
    public static final Datum DATUM = Datum.WGS_84;
    private static final String GMTED_MEA300_TIF = "20101117_gmted_mea300.tif";

    public String getName() {
        return NAME;
    }

    public Datum getDatum() {
        return DATUM;
    }

    public float getNoDataValue() {
        return -32768.0f;
    }

    public boolean isDemInstalled() {
        File file = this.getTileFile(0, 0);
        return file.canRead();
    }

    public URL getDemArchiveUrl() {
        return null;
    }

    public ElevationModel createDem(Resampling resampling) {
        try {
            return new GMTED2010ElevationModel(this, resampling);
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getTileFile(int lonIndex, int latIndex) {
        int minLat = GMTED2010ElevationModelDescriptor.getMinLat(latIndex);
        int minLon = GMTED2010ElevationModelDescriptor.getMinLon(lonIndex);
        String tileFilename = GMTED2010ElevationModelDescriptor.createTileFilename(minLat, minLon);
        return new File(this.getDemInstallDir(), tileFilename);
    }

    static int getMinLat(int latIndex) {
        return (8 - latIndex) * 20 - 90;
    }

    static int getMinLon(int lonIndex) {
        return lonIndex * 30 - 180;
    }

    static String createTileFilename(int minLat, int minLon) {
        int lat = Math.abs(minLat);
        int lon = Math.abs(minLon);
        String latChar = minLat < 0 ? "S" : "N";
        String lonChar = minLon < 0 ? "W" : "E";
        return String.format("%s%03d/%d%s%03d%s_20101117_gmted_mea300.tif", lonChar, lon, lat, latChar, lon, lonChar);
    }
}

