/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.gmted2010;

import com.bc.ceres.core.Assert;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.esa.beam.dataio.gmted2010.ElevationTile;
import org.esa.beam.dataio.gmted2010.GMTED2010ElevationModelDescriptor;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.dataop.dem.ElevationModel;
import org.esa.beam.framework.dataop.dem.ElevationModelDescriptor;
import org.esa.beam.framework.dataop.resamp.Resampling;

public class GMTED2010ElevationModel
implements ElevationModel,
Resampling.Raster {
    private final GMTED2010ElevationModelDescriptor descriptor;
    private final Resampling resampling;
    private final Resampling.Index resamplingIndex;
    private final Resampling.Raster resamplingRaster;
    private final ElevationTile[][] elevationTiles;

    public GMTED2010ElevationModel(GMTED2010ElevationModelDescriptor descriptor, Resampling resampling) throws IOException {
        Assert.notNull((Object)((Object)descriptor), (String)"descriptor");
        Assert.notNull((Object)resampling, (String)"resampling");
        this.descriptor = descriptor;
        this.resampling = resampling;
        this.resamplingIndex = resampling.createIndex();
        this.resamplingRaster = this;
        this.elevationTiles = new ElevationTile[12][9];
    }

    public ElevationModelDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Resampling getResampling() {
        return this.resampling;
    }

    public int getWidth() {
        return 43200;
    }

    public int getHeight() {
        return 21600;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getElevation(GeoPos geoPos) throws Exception {
        float elevation;
        float pixelX = (geoPos.lon + 180.0f) / 30.0f * 3600.0f;
        float pixelY = 21600.0f - (geoPos.lat + 90.0f) / 20.0f * 2400.0f;
        Resampling resampling = this.resampling;
        synchronized (resampling) {
            this.resampling.computeIndex((double)pixelX, (double)pixelY, 43200, 21600, this.resamplingIndex);
            elevation = (float)this.resampling.resample(this.resamplingRaster, this.resamplingIndex);
        }
        if (Float.isNaN(elevation)) {
            return this.descriptor.getNoDataValue();
        }
        return elevation;
    }

    public boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
        boolean isSomeNaNValue = false;
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                double value = this.getSample(x[j], y[i]);
                if (Double.isNaN(value)) {
                    isSomeNaNValue = true;
                }
                samples[i][j] = value;
            }
        }
        return isSomeNaNValue;
    }

    private float getSample(int pixelX, int pixelY) throws IOException {
        int tileY;
        int tileX;
        int tileXIndex = pixelX / 3600;
        int tileYIndex = pixelY / 2400;
        ElevationTile tile = this.getElevationTile(tileXIndex, tileYIndex);
        float sample = tile.getSample(tileX = pixelX - tileXIndex * 3600, tileY = pixelY - tileYIndex * 2400);
        if (sample == this.descriptor.getNoDataValue()) {
            return Float.NaN;
        }
        return sample;
    }

    private synchronized ElevationTile getElevationTile(int lonIndex, int latIndex) throws IOException {
        ElevationTile elevationTile = this.elevationTiles[lonIndex][latIndex];
        if (elevationTile == null) {
            this.elevationTiles[lonIndex][latIndex] = elevationTile = this.createTile(lonIndex, latIndex);
        }
        return elevationTile;
    }

    private ElevationTile createTile(int lonIndex, int latIndex) throws IOException {
        ProductReaderPlugIn geotiffPlugIn = GMTED2010ElevationModel.getGeoTiffReaderPlugIn();
        ProductReader productReader = geotiffPlugIn.createReaderInstance();
        File tileFile = this.descriptor.getTileFile(lonIndex, latIndex);
        Product product = productReader.readProductNodes((Object)tileFile, null);
        return new ElevationTile(product);
    }

    private static ProductReaderPlugIn getGeoTiffReaderPlugIn() {
        ProductIOPlugInManager plugInManager = ProductIOPlugInManager.getInstance();
        Iterator readerPlugIns = plugInManager.getReaderPlugIns("GeoTIFF");
        return (ProductReaderPlugIn)readerPlugIns.next();
    }
}

