/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import javax.media.jai.BorderExtender;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.util.ProductUtils;

@OperatorMetadata(alias="ga.upscale.southpole", description="Operator to correct for lost pixels near south pole.", authors="Olaf Danne", version="1.0", copyright="(C) 2011 by Brockmann Consult")
public class SouthPoleCorrectionOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;

    public void initialize() throws OperatorException {
        Band[] bands;
        Product targetProduct = new Product(this.getId(), ((Object)((Object)this)).getClass().getName(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        targetProduct.setStartTime(this.sourceProduct.getStartTime());
        targetProduct.setEndTime(this.sourceProduct.getEndTime());
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)targetProduct);
        for (Band band : bands = this.sourceProduct.getBands()) {
            if (targetProduct.containsBand(band.getName())) continue;
            Band targetBand = targetProduct.addBand(band.getName(), 30);
            targetBand.setDescription(band.getDescription());
            targetBand.setGeophysicalNoDataValue(band.getGeophysicalNoDataValue());
            targetBand.setNoDataValue(band.getNoDataValue());
            targetBand.setNoDataValueUsed(band.isNoDataValueUsed());
            targetBand.setScalingFactor(band.getScalingFactor());
            targetBand.setScalingOffset(band.getScalingOffset());
            targetBand.setUnit(band.getUnit());
        }
        this.setTargetProduct(targetProduct);
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        RasterDataNode sourceRaster = this.sourceProduct.getRasterDataNode(targetBand.getName());
        Rectangle rectangle = targetTile.getRectangle();
        Tile sourceTile = this.getSourceTile(sourceRaster, rectangle, BorderExtender.createInstance((int)1));
        for (int x = targetTile.getMinX(); x <= targetTile.getMaxX(); ++x) {
            for (int y = targetTile.getMinY(); y <= targetTile.getMaxY(); ++y) {
                float value = sourceTile.getSampleFloat(x, y);
                if (y > targetTile.getMinY()) {
                    float prevRowValue = sourceTile.getSampleFloat(x, y - 1);
                    if (((double)value == 0.0 || !AlbedoInversionUtils.isValid(value)) && (double)prevRowValue != 0.0 && AlbedoInversionUtils.isValid(prevRowValue) && this.isRestOfColumnZero(sourceTile, x, y)) {
                        targetTile.setSample(x, y, prevRowValue);
                        continue;
                    }
                    targetTile.setSample(x, y, value);
                    continue;
                }
                targetTile.setSample(x, targetTile.getMinY(), value);
            }
        }
    }

    private boolean isRestOfColumnZero(Tile tile, int x, int y) {
        for (int i = y; i < tile.getMaxY() - 1; ++i) {
            float value = tile.getSampleFloat(x, i);
            if ((double)value == 0.0 || Float.isNaN(value)) continue;
            return false;
        }
        return true;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SouthPoleCorrectionOp.class);
        }
    }
}

