/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.AbstractGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.util.Debug;
import org.geotools.factory.Hints;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.CRSUtilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public class ModisTileGeoCoding
extends AbstractGeoCoding {
    private final AffineTransform imageToMap;
    private final MathTransform imageToGeo;
    private final MathTransform geoToImage;
    private final Datum datum;

    public ModisTileGeoCoding(CoordinateReferenceSystem mapCRS, double easting, double northing, double pixelSizeX, double pixelSizeY) throws FactoryException, TransformException {
        this(mapCRS, easting, northing, pixelSizeX, pixelSizeY, 0.5, 0.5);
    }

    public ModisTileGeoCoding(CoordinateReferenceSystem mapCRS, double easting, double northing, double pixelSizeX, double pixelSizeY, double referencePixelX, double referencePixelY) throws FactoryException, TransformException {
        this(mapCRS, ModisTileGeoCoding.createImageToMapTransform(easting, northing, pixelSizeX, pixelSizeY, referencePixelX, referencePixelY));
    }

    public ModisTileGeoCoding(CoordinateReferenceSystem mapCRS, AffineTransform imageToMap) throws FactoryException, TransformException {
        this.imageToMap = imageToMap;
        this.setMapCRS(mapCRS);
        Ellipsoid gtEllipsoid = CRS.getEllipsoid((CoordinateReferenceSystem)mapCRS);
        String ellipsoidName = gtEllipsoid.getName().getCode();
        org.esa.beam.framework.dataop.maptransf.Ellipsoid ellipsoid = new org.esa.beam.framework.dataop.maptransf.Ellipsoid(ellipsoidName, gtEllipsoid.getSemiMinorAxis(), gtEllipsoid.getSemiMajorAxis());
        org.opengis.referencing.datum.Datum gtDatum = CRSUtilities.getDatum((CoordinateReferenceSystem)mapCRS);
        String datumName = gtDatum.getName().getCode();
        this.datum = new Datum(datumName, ellipsoid, 0.0, 0.0, 0.0);
        AffineTransform2D i2m = new AffineTransform2D(imageToMap);
        if (mapCRS instanceof DerivedCRS) {
            DerivedCRS derivedCRS = (DerivedCRS)mapCRS;
            CoordinateReferenceSystem baseCRS = derivedCRS.getBaseCRS();
            this.setGeoCRS(baseCRS);
        } else if (gtDatum instanceof GeodeticDatum) {
            this.setGeoCRS((CoordinateReferenceSystem)new DefaultGeographicCRS((GeodeticDatum)gtDatum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D));
        } else {
            this.setGeoCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        this.setImageCRS((CoordinateReferenceSystem)ModisTileGeoCoding.createImageCRS((CoordinateReferenceSystem)mapCRS, (MathTransform)i2m.inverse()));
        MathTransform map2Geo = CRS.findMathTransform((CoordinateReferenceSystem)mapCRS, (CoordinateReferenceSystem)this.getGeoCRS(), (boolean)true);
        Hints hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        CoordinateOperationFactory factory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)hints);
        MathTransformFactory mtFactory = factory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)factory).getMathTransformFactory() : ReferencingFactoryFinder.getMathTransformFactory((Hints)hints);
        this.imageToGeo = mtFactory.createConcatenatedTransform((MathTransform)i2m, map2Geo);
        this.geoToImage = this.imageToGeo.inverse();
    }

    public MathTransform getImageToMapTransform() {
        return new AffineTransform2D(this.imageToMap);
    }

    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        AffineTransform destTransform = new AffineTransform(this.imageToMap);
        Rectangle destBounds = new Rectangle(destScene.getRasterWidth(), destScene.getRasterHeight());
        if (subsetDef != null) {
            Rectangle region = subsetDef.getRegion();
            double scaleX = subsetDef.getSubSamplingX();
            double scaleY = subsetDef.getSubSamplingY();
            if (region != null) {
                destTransform.translate(region.getX(), region.getY());
                destBounds.setRect(0.0, 0.0, region.getWidth() / scaleX, region.getHeight() / scaleY);
            }
            destTransform.scale(scaleX, scaleY);
        }
        try {
            destScene.setGeoCoding((GeoCoding)new ModisTileGeoCoding(this.getMapCRS(), destTransform));
        }
        catch (Exception e) {
            Debug.trace((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isCrossingMeridianAt180() {
        return false;
    }

    public String toString() {
        String s = super.toString();
        return s + "\n\nMap CRS:\n" + this.getMapCRS().toString() + "\nImage To Map:\n" + this.imageToMap.toString();
    }

    public boolean canGetPixelPos() {
        return true;
    }

    public boolean canGetGeoPos() {
        return true;
    }

    public void dispose() {
    }

    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        try {
            DirectPosition2D directGeoPos = new DirectPosition2D((double)geoPos.getLon(), (double)geoPos.getLat());
            DirectPosition directPixelPos = this.geoToImage.transform((DirectPosition)directGeoPos, null);
            pixelPos.setLocation((float)directPixelPos.getOrdinate(0), (float)directPixelPos.getOrdinate(1));
        }
        catch (Exception ignored) {
            pixelPos.setInvalid();
        }
        return pixelPos;
    }

    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        try {
            DirectPosition2D directPixelPos = new DirectPosition2D((Point2D)pixelPos);
            DirectPosition directGeoPos = this.imageToGeo.transform((DirectPosition)directPixelPos, null);
            geoPos.setLocation((float)directGeoPos.getOrdinate(1), (float)directGeoPos.getOrdinate(0));
        }
        catch (Exception ignored) {
            geoPos.setInvalid();
        }
        return geoPos;
    }

    public Datum getDatum() {
        return this.datum;
    }

    private static AffineTransform createImageToMapTransform(double easting, double northing, double pixelSizeX, double pixelSizeY, double referencePixelX, double referencePixelY) {
        AffineTransform at = new AffineTransform();
        at.translate(easting, northing);
        at.scale(pixelSizeX, -pixelSizeY);
        at.translate(-referencePixelX, -referencePixelY);
        return at;
    }
}

