/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.globalbedo.auxdata.ModisTileCoordinates;
import org.esa.beam.globalbedo.inversion.util.ModisTileGeoCoding;
import org.esa.beam.util.ProductUtils;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@OperatorMetadata(alias="ga.albedo.modis.geocoding", description="Attaches Geocoding to a MODIS tile product.", authors="Olaf Danne", version="1.0", copyright="(C) 2012 by Brockmann Consult")
public class ModisTileAttachGeocodingOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @Parameter(defaultValue="", description="MODIS tile")
    private String tile;
    @Parameter(defaultValue="1200", description="Number of horizontal/vertical pixels in tile")
    private int numPixels;

    public void initialize() throws OperatorException {
        Product targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        for (Band sourceBand : this.sourceProduct.getBands()) {
            ProductUtils.copyBand((String)sourceBand.getName(), (Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
        }
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)targetProduct);
        ModisTileCoordinates modisTileCoordinates = ModisTileCoordinates.getInstance();
        int tileIndex = modisTileCoordinates.findTileIndex(this.tile);
        if (tileIndex == -1) {
            throw new OperatorException("Found no tileIndex for tileName=''" + this.tile + "");
        }
        double easting = modisTileCoordinates.getUpperLeftX(tileIndex);
        double northing = modisTileCoordinates.getUpperLeftY(tileIndex);
        int imageWidth = this.numPixels;
        int imageHeight = this.numPixels;
        double pixelSizeX = 1111950.51966696 / (double)imageWidth;
        double pixelSizeY = 1111950.51966696 / (double)imageHeight;
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"MODIS Sinusoidal\",GEOGCS[\"WGS 84\",  DATUM[\"WGS_1984\",    SPHEROID[\"WGS 84\",6378137,298.257223563,      AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],   AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Sinusoidal\"],PARAMETER[\"false_easting\",0.0],PARAMETER[\"false_northing\",0.0],PARAMETER[\"central_meridian\",0.0],PARAMETER[\"semi_major\",6371007.181],PARAMETER[\"semi_minor\",6371007.181],UNIT[\"m\",1.0],AUTHORITY[\"SR-ORG\",\"6974\"]]");
            ModisTileGeoCoding geoCoding = new ModisTileGeoCoding(crs, easting, northing, pixelSizeX, pixelSizeY);
            targetProduct.setGeoCoding((GeoCoding)geoCoding);
        }
        catch (Exception e) {
            throw new OperatorException("Cannot attach geocoding for tileName= ''" + this.tile + " : ", (Throwable)e);
        }
        this.setTargetProduct(targetProduct);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ModisTileAttachGeocodingOp.class);
        }
    }
}

