/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;

public class MetadataUtils {
    static final Map<String, String> waveBandsTextsMap = new HashMap<String, String>();

    public static void addBrdfMetadata(Product inversionProduct) {
        MetadataElement globalElement = new MetadataElement("BRDF_Global_Attributes");
        ProductData historyAttrData = ProductData.createInstance((String)"QA4ECV Processing, 2014-2017");
        MetadataAttribute historyAttr = new MetadataAttribute("history", historyAttrData, true);
        globalElement.addAttribute(historyAttr);
        ProductData conventionsAttrData = ProductData.createInstance((String)"CF-1.4");
        MetadataAttribute conventionsAttr = new MetadataAttribute("conventions", conventionsAttrData, true);
        globalElement.addAttribute(conventionsAttr);
        ProductData titleAttrData = ProductData.createInstance((String)"QA4ECV BRDF Product");
        MetadataAttribute titleAttr = new MetadataAttribute("title", titleAttrData, true);
        globalElement.addAttribute(titleAttr);
        String institutionString = "Mullard Space Science Laboratory, Department of Space and Climate Physics, University College London";
        ProductData institutionAttrData = ProductData.createInstance((String)"Mullard Space Science Laboratory, Department of Space and Climate Physics, University College London");
        MetadataAttribute institutionAttr = new MetadataAttribute("institution", institutionAttrData, true);
        globalElement.addAttribute(institutionAttr);
        ProductData sourceAttrData = ProductData.createInstance((String)"Satellite observations, BRDF/Albedo Inversion Model");
        MetadataAttribute sourceAttr = new MetadataAttribute("source", sourceAttrData, true);
        globalElement.addAttribute(sourceAttr);
        ProductData referencesAttrData = ProductData.createInstance((String)"GlobAlbedo ATBD V4.12");
        MetadataAttribute referencesAttr = new MetadataAttribute("references", referencesAttrData, true);
        globalElement.addAttribute(referencesAttr);
        ProductData commentAttrData = ProductData.createInstance((String)"none");
        MetadataAttribute commentAttr = new MetadataAttribute("comment", commentAttrData, true);
        globalElement.addAttribute(commentAttr);
        MetadataUtils.addVariableAttributes(inversionProduct);
        inversionProduct.getMetadataRoot().addElement(globalElement);
    }

    private static void addVariableAttributes(Product inversionProduct) {
        MetadataElement variablesRootElement = new MetadataElement("BRDF_Variable_Attributes");
        for (MetadataElement metadataElement : variablesRootElement.getElements()) {
            if (!metadataElement.getName().equals("metadata")) continue;
            variablesRootElement.removeElement(metadataElement);
        }
        String delims = "[_]";
        for (Band b : inversionProduct.getBands()) {
            String[] tokens;
            MetadataElement variableElement = new MetadataElement(b.getName());
            String longNameString = "";
            if (b.getName().startsWith("mean_")) {
                tokens = b.getName().split(delims);
                if (tokens.length == 3) {
                    longNameString = "BRDF model parameter " + tokens[2] + " - " + waveBandsTextsMap.get(tokens[1]) + " band";
                }
            } else if (b.getName().startsWith("VAR_")) {
                tokens = b.getName().split(delims);
                if (tokens.length == 5) {
                    longNameString = "Covariance of BRDF model parameters " + tokens[1] + "-" + tokens[2] + "/" + tokens[1] + "-" + tokens[2];
                }
            } else if (b.getName().equals("Entropy")) {
                longNameString = "Entropy";
            } else if (b.getName().equals("Relative_Entropy")) {
                longNameString = "Relative entropy";
            } else if (b.getName().equals("Weighted_Number_of_Samples")) {
                longNameString = "Weighted number of BRDF samples";
            } else if (b.getName().equals("Goodness_of_Fit")) {
                longNameString = "Goodness of fit";
            } else if (b.getName().equals("Proportion_NSamples")) {
                longNameString = "Proportion of numbers of snow/noSnow samples";
            } else if (b.getName().equals("Time_to_the_Closest_Sample")) {
                longNameString = "Time to the closest sample";
                String unitString = "day";
                MetadataUtils.addMDElement(variableElement, "units", "day");
            }
            MetadataUtils.addMDElements(b, longNameString, variableElement);
            variablesRootElement.addElement(variableElement);
        }
        inversionProduct.getMetadataRoot().addElement(variablesRootElement);
    }

    private static void addMDElement(MetadataElement variableElement, String key, String value) {
        ProductData attrData = ProductData.createInstance((String)value);
        MetadataAttribute attr = new MetadataAttribute(key, attrData, true);
        variableElement.addAttribute(attr);
    }

    private static void addMDElement(MetadataElement variableElement, String key, float value) {
        ProductData attrData = ProductData.createInstance((int)30);
        attrData.setElemFloat(value);
        MetadataAttribute attr = new MetadataAttribute(key, attrData, true);
        variableElement.addAttribute(attr);
    }

    private static void addMDElements(Band b, String longNameString, MetadataElement variableElement) {
        MetadataUtils.addMDElement(variableElement, "long_name", longNameString);
        MetadataUtils.addMDElement(variableElement, "standard_name", b.getName());
        MetadataUtils.addMDElement(variableElement, "fill_value", (float)b.getNoDataValue());
        MetadataUtils.addMDElement(variableElement, "scale_factor", (float)b.getScalingFactor());
        MetadataUtils.addMDElement(variableElement, "add_offset", (float)b.getScalingOffset());
        if (b.getUnit() != null) {
            MetadataUtils.addMDElement(variableElement, "units", b.getUnit());
        }
    }

    static {
        waveBandsTextsMap.put("VIS", "visible");
        waveBandsTextsMap.put("NIR", "near infrared");
        waveBandsTextsMap.put("SW", "shortwave");
    }
}

