/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.util.ProductUtils;

@OperatorMetadata(alias="MergeTest", description="Allows copying raster data from any number of source products to a specified 'master' product.", authors="BEAM team", version="1.0", copyright="(c) 2012 by Brockmann Consult", internal=false)
public class MergeTestOp
extends Operator {
    @SourceProduct
    private Product masterProduct;
    @SourceProduct
    private Product slaveProduct;

    public void initialize() throws OperatorException {
        Product targetProduct = this.createTargetProduct();
        this.setTargetProduct(targetProduct);
    }

    private Product createTargetProduct() {
        Product targetProduct = new Product(this.masterProduct.getName(), this.masterProduct.getProductType(), this.masterProduct.getSceneRasterWidth(), this.masterProduct.getSceneRasterHeight());
        ProductUtils.copyMetadata((Product)this.masterProduct, (Product)targetProduct);
        ProductUtils.copyFlagCodings((Product)this.masterProduct, (Product)targetProduct);
        ProductUtils.copyGeoCoding((Product)this.masterProduct, (Product)targetProduct);
        ProductUtils.copyFlagBands((Product)this.masterProduct, (Product)targetProduct, (boolean)true);
        ProductUtils.copyMasks((Product)this.masterProduct, (Product)targetProduct);
        targetProduct.setStartTime(this.masterProduct.getStartTime());
        targetProduct.setEndTime(this.masterProduct.getEndTime());
        for (Band band : this.masterProduct.getBands()) {
            if (targetProduct.containsBand(band.getName())) continue;
            ProductUtils.copyBand((String)band.getName(), (Product)this.masterProduct, (Product)targetProduct, (boolean)true);
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)band, (RasterDataNode)targetProduct.getBand(band.getName()));
        }
        for (Band band : this.slaveProduct.getBands()) {
            if (targetProduct.containsBand(band.getName())) continue;
            ProductUtils.copyBand((String)band.getName(), (Product)this.slaveProduct, (Product)targetProduct, (boolean)true);
        }
        for (Band band : this.masterProduct.getTiePointGrids()) {
            if (targetProduct.containsTiePointGrid(band.getName())) continue;
            ProductUtils.copyTiePointGrid((String)band.getName(), (Product)this.masterProduct, (Product)targetProduct);
        }
        return targetProduct;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MergeTestOp.class);
        }
    }
}

