/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.globalbedo.auxdata.AVHRR.AvhrrBrfBlacklist;
import org.esa.beam.globalbedo.auxdata.ModisTileCoordinates;
import org.esa.beam.globalbedo.inversion.AccumulatorHolder;
import org.esa.beam.globalbedo.inversion.AlbedoInversionConstants;
import org.esa.beam.globalbedo.inversion.FullAccumulator;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.ModisTileGeoCoding;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class IOUtils {
    public static Product[] getAccumulationInputProducts(String bbdrRootDir, String tile, int year, int doy) throws IOException {
        Product product;
        String sourceProductFileName;
        String daystring = AlbedoInversionUtils.getDateFromDoy(year, doy);
        String merisBbdrDir = bbdrRootDir + File.separator + "MERIS" + File.separator + year + File.separator + tile;
        String[] merisBbdrFiles = new File(merisBbdrDir).list();
        List<String> merisBbdrFileList = IOUtils.getDailyBBDRFilenames(merisBbdrFiles, daystring);
        String vgtBbdrDir = bbdrRootDir + File.separator + "VGT" + File.separator + year + File.separator + tile;
        String[] vgtBbdrFiles = new File(vgtBbdrDir).list();
        List<String> vgtBbdrFileList = IOUtils.getDailyBBDRFilenames(vgtBbdrFiles, daystring);
        int numberOfInputProducts = merisBbdrFileList.size() + vgtBbdrFileList.size();
        Product[] bbdrProducts = new Product[numberOfInputProducts];
        int productIndex = 0;
        for (String merisBBDRFileName : merisBbdrFileList) {
            sourceProductFileName = merisBbdrDir + File.separator + merisBBDRFileName;
            bbdrProducts[productIndex] = product = ProductIO.readProduct((String)sourceProductFileName);
            ++productIndex;
        }
        for (String vgtBBDRFileName : vgtBbdrFileList) {
            sourceProductFileName = vgtBbdrDir + File.separator + vgtBBDRFileName;
            bbdrProducts[productIndex] = product = ProductIO.readProduct((String)sourceProductFileName);
            ++productIndex;
        }
        if (productIndex == 0) {
            BeamLogManager.getSystemLogger().log(Level.WARNING, "No BBDR source products found for DoY " + IOUtils.getDoyString(doy) + " ...");
        }
        return bbdrProducts;
    }

    public static Product[] getAccumulationInputProducts(String bbdrRootDir, String[] sensors, final boolean meteosatUseAllLongitudes, String tile, int year, int doy) throws IOException {
        final String daystring_yyyymmdd = AlbedoInversionUtils.getDateFromDoy(year, doy);
        final String daystring_yyyy_mm_dd = AlbedoInversionUtils.getDateFromDoy(year, doy, "yyyy_MM_dd");
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!meteosatUseAllLongitudes && (name.contains("_057_C_") || name.contains("_063_C_"))) {
                    return false;
                }
                if (name.contains("AVH_") && IOUtils.isBadAvhrrProduct(name)) {
                    return false;
                }
                return !(!name.endsWith(".nc") && !name.endsWith(".nc.gz") && !name.endsWith(".dim") || !name.contains(daystring_yyyymmdd) && !name.contains(daystring_yyyy_mm_dd));
            }
        };
        ArrayList<Product> bbdrProductList = new ArrayList<Product>();
        if (StringUtils.isNotNullAndNotEmpty((String)daystring_yyyymmdd)) {
            for (String sensor : sensors) {
                int numProducts = 0;
                String sensorBbdrDirName = bbdrRootDir + File.separator + sensor + File.separator + year + File.separator + tile;
                File sensorBbdrDir = new File(sensorBbdrDirName);
                if (sensorBbdrDir.exists()) {
                    String[] sensorBbdrFiles;
                    for (String sensorBbdrFile : sensorBbdrFiles = sensorBbdrDir.list(filenameFilter)) {
                        String sourceProductFileName = sensorBbdrDirName + File.separator + sensorBbdrFile;
                        Product product = ProductIO.readProduct((String)sourceProductFileName);
                        if (product == null) continue;
                        bbdrProductList.add(product);
                        ++numProducts;
                    }
                }
                BeamLogManager.getSystemLogger().log(Level.INFO, "Collecting Daily accumulation BBDR/SDR products for tile - year/doy: " + tile + " - " + year + "/" + IOUtils.getDoyString(doy) + " (" + daystring_yyyymmdd + ") : ");
                BeamLogManager.getSystemLogger().log(Level.INFO, "      Sensor '" + sensor + "': " + numProducts + " products added.");
            }
        }
        return bbdrProductList.toArray(new Product[bbdrProductList.size()]);
    }

    public static boolean isBadAvhrrProduct(String name) {
        AvhrrBrfBlacklist brfBlacklist = AvhrrBrfBlacklist.getInstance();
        for (int i = 0; i < brfBlacklist.getBrfBadDatesNumber(); ++i) {
            if (!name.startsWith("AVH_" + brfBlacklist.getBrfBadDate(i))) continue;
            return true;
        }
        return false;
    }

    public static List<Product> getAccumulationSinglePixelInputProducts(String bbdrRootDir, String tile, int year, int day, String pixelX, String pixelY, String versionString) throws IOException {
        Product product;
        String sourceProductFileName;
        String merisBbdrDir = bbdrRootDir + File.separator + "MERIS" + File.separator + year + File.separator + tile;
        String[] merisBbdrFiles = new File(merisBbdrDir).list();
        List<String> merisBbdrFileList = IOUtils.getDailyBBDRFilenamesSinglePixel(merisBbdrFiles, year, day, pixelX, pixelY, versionString);
        String vgtBbdrDir = bbdrRootDir + File.separator + "VGT" + File.separator + year + File.separator + tile;
        String[] vgtBbdrFiles = new File(vgtBbdrDir).list();
        List<String> vgtBbdrFileList = IOUtils.getDailyBBDRFilenamesSinglePixel(vgtBbdrFiles, year, day, pixelX, pixelY, versionString);
        ArrayList<Product> accInputProductList = new ArrayList<Product>();
        for (String merisBBDRFileName : merisBbdrFileList) {
            sourceProductFileName = merisBbdrDir + File.separator + merisBBDRFileName;
            product = ProductIO.readProduct((String)sourceProductFileName);
            accInputProductList.add(product);
        }
        for (String vgtBBDRFileName : vgtBbdrFileList) {
            sourceProductFileName = vgtBbdrDir + File.separator + vgtBBDRFileName;
            product = ProductIO.readProduct((String)sourceProductFileName);
            accInputProductList.add(product);
        }
        if (accInputProductList.size() == 0) {
            BeamLogManager.getSystemLogger().log(Level.WARNING, "No BBDR source products found for year/day " + year + "/" + IOUtils.getDoyString(day) + " ...");
        }
        return accInputProductList;
    }

    static List<String> getDailyBBDRFilenames(String[] bbdrFilenames, String daystring) {
        ArrayList<String> dailyBBDRFilenames = new ArrayList<String>();
        if (bbdrFilenames != null && bbdrFilenames.length > 0 && StringUtils.isNotNullAndNotEmpty((String)daystring)) {
            for (String s : bbdrFilenames) {
                if (!s.endsWith(".dim") && !s.endsWith(".nc") && !s.endsWith(".dim.gz") && !s.endsWith(".nc.gz") || !s.contains(daystring)) continue;
                dailyBBDRFilenames.add(s);
            }
        }
        Collections.sort(dailyBBDRFilenames);
        return dailyBBDRFilenames;
    }

    static List<String> getDailyBBDRFilenamesSinglePixel(String[] bbdrFilenames, int year, int iDay, String pixelX, String pixelY, String versionString) {
        ArrayList<String> dailyBBDRFilenames = new ArrayList<String>();
        String dateString = AlbedoInversionUtils.getDateFromDoy(year, iDay);
        if (bbdrFilenames != null && bbdrFilenames.length > 0) {
            for (String s : bbdrFilenames) {
                if (!s.contains(dateString) || !s.contains(pixelX + "_" + pixelY) || versionString != null && !s.contains(versionString) || !s.endsWith(".csv") && !s.endsWith(".nc")) continue;
                dailyBBDRFilenames.add(s);
            }
        }
        Collections.sort(dailyBBDRFilenames);
        return dailyBBDRFilenames;
    }

    public static Product getPriorProduct(int priorVersion, String priorDir, String priorFileNamePrefix, int doy, boolean computeSnow) throws IOException {
        File priorPath = new File(priorDir);
        if (priorPath.exists()) {
            String[] priorFiles = priorPath.list();
            List<String> snowFilteredPriorList = IOUtils.getPriorProductNames(priorVersion, priorFiles, computeSnow);
            String doyString = IOUtils.getDoyString(doy);
            BeamLogManager.getSystemLogger().log(Level.INFO, "priorDir = " + priorDir);
            BeamLogManager.getSystemLogger().log(Level.INFO, "priorFiles = " + priorFiles.length);
            BeamLogManager.getSystemLogger().log(Level.INFO, "doyString = " + doyString);
            BeamLogManager.getSystemLogger().log(Level.INFO, "priorFileNamePrefix = " + priorFileNamePrefix);
            for (String priorFileName : snowFilteredPriorList) {
                BeamLogManager.getSystemLogger().log(Level.INFO, "priorFileName: " + priorFileName);
                if (!priorFileName.startsWith(priorFileNamePrefix + "." + doyString)) continue;
                String sourceProductFileName = priorDir + File.separator + priorFileName;
                BeamLogManager.getSystemLogger().log(Level.INFO, "sourceProductFileName: " + sourceProductFileName);
                return ProductIO.readProduct((String)sourceProductFileName);
            }
        }
        BeamLogManager.getSystemLogger().log(Level.WARNING, "Warning: No prior file found. Searched in priorDir: '" + priorDir + "'.");
        return null;
    }

    public static void attachGeoCodingToPriorProduct(Product priorProduct, String tile, Product tileInfoProduct) throws IOException {
        if (tileInfoProduct != null) {
            ProductUtils.copyGeoCoding((Product)tileInfoProduct, (Product)priorProduct);
        } else {
            priorProduct.setGeoCoding((GeoCoding)IOUtils.getSinusoidalTileGeocoding(tile));
        }
    }

    public static ModisTileGeoCoding getSinusoidalTileGeocoding(String tile) {
        return IOUtils.getSinusoidalTileGeocoding(tile, 1.0);
    }

    public static ModisTileGeoCoding getSinusoidalTileGeocoding(String tile, double scaleFactor) {
        ModisTileGeoCoding geoCoding;
        ModisTileCoordinates modisTileCoordinates = ModisTileCoordinates.getInstance();
        int tileIndex = modisTileCoordinates.findTileIndex(tile);
        if (tileIndex == -1) {
            throw new OperatorException("Found no tileIndex for tileName=''" + tile + "");
        }
        double easting = modisTileCoordinates.getUpperLeftX(tileIndex);
        double northing = modisTileCoordinates.getUpperLeftY(tileIndex);
        String crsString = "PROJCS[\"MODIS Sinusoidal\",GEOGCS[\"WGS 84\",  DATUM[\"WGS_1984\",    SPHEROID[\"WGS 84\",6378137,298.257223563,      AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],   AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Sinusoidal\"],PARAMETER[\"false_easting\",0.0],PARAMETER[\"false_northing\",0.0],PARAMETER[\"central_meridian\",0.0],PARAMETER[\"semi_major\",6371007.181],PARAMETER[\"semi_minor\",6371007.181],UNIT[\"m\",1.0],AUTHORITY[\"SR-ORG\",\"6974\"]]";
        double pixelSizeX = 926.6254330558 * scaleFactor;
        double pixelSizeY = 926.6254330558 * scaleFactor;
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"MODIS Sinusoidal\",GEOGCS[\"WGS 84\",  DATUM[\"WGS_1984\",    SPHEROID[\"WGS 84\",6378137,298.257223563,      AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],   AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Sinusoidal\"],PARAMETER[\"false_easting\",0.0],PARAMETER[\"false_northing\",0.0],PARAMETER[\"central_meridian\",0.0],PARAMETER[\"semi_major\",6371007.181],PARAMETER[\"semi_minor\",6371007.181],UNIT[\"m\",1.0],AUTHORITY[\"SR-ORG\",\"6974\"]]");
            geoCoding = new ModisTileGeoCoding(crs, easting, northing, pixelSizeX, pixelSizeY);
        }
        catch (Exception e) {
            throw new OperatorException("Cannot attach geocoding for tileName= ''" + tile + " : ", (Throwable)e);
        }
        return geoCoding;
    }

    public static Product getBrdfProduct(String brdfDirName, int year, int doy, boolean isSnow) throws IOException {
        File brdfDir = new File(brdfDirName);
        if (brdfDir.exists()) {
            String[] brdfFiles = brdfDir.list();
            List<String> brdfFileList = IOUtils.getBrdfProductNames(brdfFiles, isSnow);
            String doyString = IOUtils.getDoyString(doy);
            for (String brdfFileName : brdfFileList) {
                if (!brdfFileName.startsWith("Qa4ecv.") || !brdfFileName.contains("brdf") || !brdfFileName.contains(Integer.toString(year) + doyString)) continue;
                String sourceProductFileName = brdfDirName + File.separator + brdfFileName;
                return ProductIO.readProduct((String)sourceProductFileName);
            }
        }
        return null;
    }

    public static Product getBrdfSeaiceProduct(String brdfDir, int year, int doy) throws IOException {
        String[] brdfFiles = new File(brdfDir).list();
        List<String> brdfFileList = IOUtils.getBrdfSeaiceProductNames(brdfFiles);
        String doyString = IOUtils.getDoyString(doy);
        for (String brdfFileName : brdfFileList) {
            if (!brdfFileName.startsWith("Qa4ecv.brdf." + Integer.toString(year) + doyString)) continue;
            String sourceProductFileName = brdfDir + File.separator + brdfFileName;
            return ProductIO.readProduct((String)sourceProductFileName);
        }
        return null;
    }

    public static String getDoyString(int doy) {
        if (doy < 0 || doy > 366) {
            return null;
        }
        return String.format("%03d", doy);
    }

    public static String getMonthString(int month) {
        if (month < 0 || month > 12) {
            return null;
        }
        return String.format("%02d", month);
    }

    static List<String> getPriorProductNames(int priorVersion, String[] priorFiles, boolean computeSnow) {
        ArrayList<String> snowFilteredPriorList = new ArrayList<String>();
        if (priorFiles != null && priorFiles.length > 0) {
            for (String s : priorFiles) {
                if (priorVersion == 5) {
                    if (!(computeSnow && s.endsWith(".Snow.hdr") || !computeSnow && s.endsWith(".NoSnow.hdr") || computeSnow && s.endsWith(".Snow.nc") || !computeSnow && s.endsWith(".NoSnow.nc") || computeSnow && s.endsWith(".Snow.1km.nc")) && (computeSnow || !s.endsWith(".NoSnow.1km.nc"))) continue;
                    snowFilteredPriorList.add(s);
                    continue;
                }
                if (priorVersion == 6) {
                    if (!s.endsWith("snownosnow.stage2.nc")) continue;
                    snowFilteredPriorList.add(s);
                    continue;
                }
                throw new OperatorException("Prior version " + priorVersion + " not supported.");
            }
        }
        Collections.sort(snowFilteredPriorList);
        return snowFilteredPriorList;
    }

    public static AccumulatorHolder getDailyAccumulator(String accumulatorRootDir, int doy, int year, String tile, int wings, boolean computeSnow, boolean computeSeaice) {
        AccumulatorHolder accumulatorHolder = null;
        List<String> albedoInputProductBinaryFileList = IOUtils.getDailyAccumulatorBinaryFileNames(accumulatorRootDir, doy, year, tile, wings, computeSnow, computeSeaice);
        if (albedoInputProductBinaryFileList.size() > 0) {
            accumulatorHolder = new AccumulatorHolder();
            accumulatorHolder.setReferenceYear(year);
            accumulatorHolder.setReferenceDoy(doy);
            String[] albedoInputProductBinaryFilenames = new String[albedoInputProductBinaryFileList.size()];
            int binaryProductIndex = 0;
            for (String albedoInputProductBinaryName : albedoInputProductBinaryFileList) {
                String sourceProductBinaryFileName;
                String thisProductYear = albedoInputProductBinaryName.substring(9, 13);
                String productYearRootDir = computeSnow ? accumulatorRootDir.concat(File.separator + thisProductYear + File.separator + tile + File.separator + "Snow") : (computeSeaice ? accumulatorRootDir.concat(File.separator + thisProductYear + File.separator + tile) : accumulatorRootDir.concat(File.separator + thisProductYear + File.separator + tile + File.separator + "NoSnow"));
                albedoInputProductBinaryFilenames[binaryProductIndex] = sourceProductBinaryFileName = productYearRootDir + File.separator + albedoInputProductBinaryName;
                ++binaryProductIndex;
            }
            accumulatorHolder.setProductBinaryFilenames(albedoInputProductBinaryFilenames);
        }
        return accumulatorHolder;
    }

    static List<String> getDailyAccumulatorBinaryFileNames(String accumulatorRootDir, int doy, final int year, String tile, int wings, boolean computeSnow, boolean computeSeaice) {
        String[] accumulatorYears;
        ArrayList<String> accumulatorNameList = new ArrayList<String>();
        FilenameFilter yearFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int startYear = 1982;
                for (int i = 0; i <= 35; ++i) {
                    String thisYear = new Integer(startYear + i).toString();
                    if (!name.equals(thisYear) || Math.abs(startYear + i - year) > 1) continue;
                    return true;
                }
                return false;
            }
        };
        FilenameFilter accumulatorNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("matrices_[0-9]{7}.bin");
            }
        };
        for (String accProductYear : accumulatorYears = new File(accumulatorRootDir).list(yearFilter)) {
            String thisYearsRootDir = computeSnow ? accumulatorRootDir.concat(File.separator + accProductYear + File.separator + tile + File.separator + "Snow") : (computeSeaice ? accumulatorRootDir.concat(File.separator + accProductYear + File.separator + tile) : accumulatorRootDir.concat(File.separator + accProductYear + File.separator + tile + File.separator + "NoSnow"));
            String[] thisYearAccumulatorFiles = new File(thisYearsRootDir).list(accumulatorNameFilter);
            if (thisYearAccumulatorFiles == null || thisYearAccumulatorFiles.length <= 0) continue;
            for (String s : thisYearAccumulatorFiles) {
                if (!s.startsWith("matrices_" + accProductYear) || accumulatorNameList.contains(s) || !IOUtils.isInWingsInterval(wings, year, doy, tile, s)) continue;
                accumulatorNameList.add(s);
            }
        }
        return IOUtils.sortAccumulatorFileList(accumulatorNameList, year, doy);
    }

    static List<String> sortAccumulatorFileList(List<String> accumulatorNameList, int refYear, int refDoy) {
        int doyPlus;
        ArrayList<String> accumulatorNameSortedList = new ArrayList<String>();
        int doyMinus = refDoy;
        int maxAccs = 60;
        double weightThresh = 1.0E-7;
        for (doyPlus = refDoy; doyMinus > 0 && doyPlus < 366; ++doyPlus) {
            String accName = "matrices_" + Integer.toString(refYear) + String.format("%03d", doyMinus) + ".bin";
            if (accumulatorNameList.contains(accName) && !accumulatorNameSortedList.contains(accName) && (double)AlbedoInversionUtils.getWeight(refDoy - doyMinus) > 1.0E-7 && accumulatorNameSortedList.size() < 60) {
                accumulatorNameSortedList.add(accName);
            }
            --doyMinus;
            accName = "matrices_" + Integer.toString(refYear) + String.format("%03d", doyPlus) + ".bin";
            if (!accumulatorNameList.contains(accName) || accumulatorNameSortedList.contains(accName) || !((double)AlbedoInversionUtils.getWeight(doyPlus - refDoy) > 1.0E-7) || accumulatorNameSortedList.size() >= 60) continue;
            accumulatorNameSortedList.add(accName);
        }
        if (accumulatorNameSortedList.size() < 60) {
            if (doyMinus == 0) {
                int doyMinus2 = 365;
                while (doyMinus2 > 180 && doyPlus < 366) {
                    String accName = "matrices_" + Integer.toString(refYear - 1) + String.format("%03d", doyMinus2) + ".bin";
                    if (accumulatorNameList.contains(accName) && !accumulatorNameSortedList.contains(accName) && (double)AlbedoInversionUtils.getWeight(refDoy + 365 - doyMinus2) > 1.0E-7 && accumulatorNameSortedList.size() < 60) {
                        accumulatorNameSortedList.add(accName);
                    }
                    --doyMinus2;
                    accName = "matrices_" + Integer.toString(refYear) + String.format("%03d", doyPlus) + ".bin";
                    if (accumulatorNameList.contains(accName) && !accumulatorNameSortedList.contains(accName) && (double)AlbedoInversionUtils.getWeight(doyPlus - refDoy) > 1.0E-7 && accumulatorNameSortedList.size() < 60) {
                        accumulatorNameSortedList.add(accName);
                    }
                    ++doyPlus;
                }
            } else if (doyPlus == 366) {
                for (int doyPlus2 = 0; doyPlus2 < 180 && doyMinus > 0; ++doyPlus2) {
                    String accName = "matrices_" + Integer.toString(refYear) + String.format("%03d", doyMinus) + ".bin";
                    if (accumulatorNameList.contains(accName) && !accumulatorNameSortedList.contains(accName) && (double)AlbedoInversionUtils.getWeight(refDoy - doyMinus) > 1.0E-7 && accumulatorNameSortedList.size() < 60) {
                        accumulatorNameSortedList.add(accName);
                    }
                    --doyMinus;
                    accName = "matrices_" + Integer.toString(refYear + 1) + String.format("%03d", doyPlus2) + ".bin";
                    if (!accumulatorNameList.contains(accName) || accumulatorNameSortedList.contains(accName) || !((double)AlbedoInversionUtils.getWeight(doyPlus2 + 365 - refDoy) > 1.0E-7) || accumulatorNameSortedList.size() >= 60) continue;
                    accumulatorNameSortedList.add(accName);
                }
            }
        }
        Collections.sort(accumulatorNameSortedList);
        return accumulatorNameSortedList;
    }

    public static boolean isInWingsInterval(int wings, int processYear, int processDoy, String tile, String accName) {
        boolean isInWingsInterval = false;
        try {
            int lastRightDoy;
            int firstLeftDoy;
            int accYear = Integer.parseInt(accName.substring(9, 13));
            int accDoy = Integer.parseInt(accName.substring(13, 16));
            int offset = wings;
            if (365 + (processDoy - wings) <= 366 && accDoy >= (firstLeftDoy = Math.min(365, Math.max(1, 366 - offset))) && accDoy >= 366 + (processDoy - offset) && accYear < processYear) {
                isInWingsInterval = true;
            }
            if (!isInWingsInterval && accDoy < processDoy + offset && accDoy >= processDoy - offset && accYear == processYear) {
                isInWingsInterval = true;
            }
            if (!isInWingsInterval && processDoy + wings - 365 > 0 && accDoy <= (lastRightDoy = Math.max(1, Math.min(365, offset))) && accDoy <= processDoy + offset - 365 && accYear > processYear) {
                isInWingsInterval = true;
            }
        }
        catch (NumberFormatException e) {
            BeamLogManager.getSystemLogger().log(Level.WARNING, "Cannot determine wings for accumulator '" + accName + "' - skipping.");
        }
        return isInWingsInterval;
    }

    public static String[] getDailyAccumulatorBandNames() {
        int i;
        String[] bandNames = new String[92];
        int index = 0;
        for (i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                bandNames[index++] = "M_" + i + "" + j;
            }
        }
        for (i = 0; i < 9; ++i) {
            bandNames[index++] = "V_" + i;
        }
        bandNames[index++] = "E";
        bandNames[index] = "mask";
        return bandNames;
    }

    public static String[] getInversionParameterBandNames() {
        String[] bandNames = new String[9];
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                bandNames[index] = "mean_" + AlbedoInversionConstants.BBDR_WAVE_BANDS[i] + "_f" + j;
                ++index;
            }
        }
        return bandNames;
    }

    public static String[][] getInversionUncertaintyBandNames() {
        String[][] bandNames = new String[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = i; j < 9; ++j) {
                bandNames[i][j] = "VAR_" + AlbedoInversionConstants.BBDR_WAVE_BANDS[i / 3] + "_f" + i % 3 + "_" + AlbedoInversionConstants.BBDR_WAVE_BANDS[j / 3] + "_f" + j % 3;
            }
        }
        return bandNames;
    }

    public static String[] getAlbedoDhrBandNames() {
        String[] bandNames = new String[3];
        for (int i = 0; i < 3; ++i) {
            bandNames[i] = "DHR_" + AlbedoInversionConstants.BBDR_WAVE_BANDS[i];
        }
        return bandNames;
    }

    public static String[] getAlbedoBhrBandNames() {
        String[] bandNames = new String[3];
        for (int i = 0; i < 3; ++i) {
            bandNames[i] = "BHR_" + AlbedoInversionConstants.BBDR_WAVE_BANDS[i];
        }
        return bandNames;
    }

    public static String[] getAlbedoDhrAlphaBandNames() {
        return new String[]{"DHR_alpha_VIS_NIR", "DHR_alpha_VIS_SW", "DHR_alpha_NIR_SW"};
    }

    public static String[] getAlbedoBhrAlphaBandNames() {
        return new String[]{"BHR_alpha_VIS_NIR", "BHR_alpha_VIS_SW", "BHR_alpha_NIR_SW"};
    }

    public static String[] getAlbedoDhrSigmaBandNames() {
        String[] bandNames = new String[3];
        for (int i = 0; i < 3; ++i) {
            bandNames[i] = "DHR_sigma_" + AlbedoInversionConstants.BBDR_WAVE_BANDS[i];
        }
        return bandNames;
    }

    public static String[] getAlbedoBhrSigmaBandNames() {
        String[] bandNames = new String[3];
        for (int i = 0; i < 3; ++i) {
            bandNames[i] = "BHR_sigma_" + AlbedoInversionConstants.BBDR_WAVE_BANDS[i];
        }
        return bandNames;
    }

    public static String[] getPriorMeanBandNames() {
        String[] bandNames = new String[9];
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                bandNames[index++] = "MEAN__BAND________" + i + "_PARAMETER_F" + j;
            }
        }
        return bandNames;
    }

    public static FullAccumulator getAccumulatorFromBinaryFile(int year, int doy, String filename, int numBands, int rasterWidth, int rasterHeight, boolean isFullAcc) {
        FileInputStream f;
        int size = numBands * rasterWidth * rasterHeight * 4;
        File accumulatorBinaryFile = new File(filename);
        try {
            f = new FileInputStream(accumulatorBinaryFile);
        }
        catch (FileNotFoundException e) {
            BeamLogManager.getSystemLogger().log(Level.WARNING, "No accumulator file found for year: " + year + ", DoY: " + IOUtils.getDoyString(doy) + " - will use data from MODIS priors...");
            return null;
        }
        FileChannel ch = f.getChannel();
        ByteBuffer bb = ByteBuffer.allocateDirect(size);
        FloatBuffer floatBuffer = bb.asFloatBuffer();
        float[][] daysToTheClosestSample = new float[rasterWidth][rasterHeight];
        float[][][] sumMatrices = new float[numBands][rasterWidth][rasterHeight];
        FullAccumulator accumulator = null;
        try {
            long t1 = System.currentTimeMillis();
            ch.read(bb);
            for (int ii = 0; ii < numBands - 1; ++ii) {
                for (int jj = 0; jj < rasterWidth; ++jj) {
                    floatBuffer.get(sumMatrices[ii][jj]);
                }
            }
            if (isFullAcc) {
                for (int jj = 0; jj < rasterWidth; ++jj) {
                    floatBuffer.get(daysToTheClosestSample[jj]);
                }
            }
            bb.clear();
            floatBuffer.clear();
            ch.close();
            f.close();
            long t2 = System.currentTimeMillis();
            BeamLogManager.getSystemLogger().log(Level.INFO, "Full accumulator read in: " + (t2 - t1) + " ms");
            accumulator = new FullAccumulator(year, doy, sumMatrices, daysToTheClosestSample);
        }
        catch (IOException e) {
            BeamLogManager.getSystemLogger().log(Level.SEVERE, "Could not read full accumulator file '" + filename + "':  " + e.getMessage());
        }
        return accumulator;
    }

    public static void writeFloatArrayToFile(File file, float[][][] values) {
        int index = 0;
        try {
            FileOutputStream file_output = new FileOutputStream(file);
            FileChannel wChannel = file_output.getChannel();
            int dim1 = values.length;
            int dim2 = values[0].length;
            int dim3 = values[0][0].length;
            ByteBuffer bb = ByteBuffer.allocateDirect(dim1 * dim2 * dim3 * 4);
            FloatBuffer floatBuffer = bb.asFloatBuffer();
            for (float[][] value : values) {
                for (int j = 0; j < dim2; ++j) {
                    floatBuffer.put(value[j], 0, dim3);
                }
            }
            wChannel.write(bb);
            wChannel.close();
            file_output.close();
        }
        catch (IOException e) {
            BeamLogManager.getSystemLogger().log(Level.WARNING, "Could not write array to file:  " + e + " // " + e.getMessage() + " // buffer index =  " + index);
        }
    }

    public static void writeFullAccumulatorToFile(File file, float[][][] sumMatrices, float[][] daysClosestSample) {
        int index = 0;
        try {
            FileOutputStream file_output = new FileOutputStream(file);
            FileChannel wChannel = file_output.getChannel();
            int dim1 = sumMatrices.length;
            int dim2 = sumMatrices[0].length;
            int dim3 = sumMatrices[0][0].length;
            ByteBuffer bb = ByteBuffer.allocateDirect((dim1 + 1) * dim2 * dim3 * 4);
            FloatBuffer floatBuffer = bb.asFloatBuffer();
            for (float[][] sumMatrice : sumMatrices) {
                for (int j = 0; j < dim2; ++j) {
                    floatBuffer.put(sumMatrice[j], 0, dim3);
                }
            }
            for (int j = 0; j < dim2; ++j) {
                floatBuffer.put(daysClosestSample[j], 0, dim3);
            }
            wChannel.write(bb);
            wChannel.close();
            file_output.close();
        }
        catch (IOException e) {
            BeamLogManager.getSystemLogger().log(Level.WARNING, "Could not write full accumulator to file:  " + e + " // " + e.getMessage() + " // buffer index =  " + index);
        }
    }

    public static int getDoyFromAlbedoProductName(String productName) {
        String doyString;
        if (productName.startsWith("GlobAlbedo.albedo.")) {
            doyString = productName.substring(22, 25);
        } else if (productName.startsWith("GlobAlbedo.")) {
            doyString = productName.substring(15, 18);
        } else {
            return -1;
        }
        int doy = Integer.parseInt(doyString);
        if (doy < 0 || doy > 366) {
            return -1;
        }
        return doy;
    }

    public static int getDayDifference(int doy, int year, int referenceDoy, int referenceYear) {
        int difference = 365 * (year - referenceYear) + (doy - referenceDoy);
        return Math.abs(difference);
    }

    public static Product[] getAlbedo8DayTileProducts(String gaRootDir, String year, final String tile) {
        FilenameFilter inputProductNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.length() == 36 && name.startsWith("GlobAlbedo.albedo.") && name.endsWith(tile + ".dim") || name.length() == 29 && name.startsWith("GlobAlbedo.") && name.endsWith(tile + ".dim");
            }
        };
        String albedoDir = gaRootDir + File.separator + "Albedo" + File.separator + year + File.separator + tile + File.separator;
        String[] albedoFiles = new File(albedoDir).list(inputProductNameFilter);
        if (albedoFiles != null && albedoFiles.length > 0) {
            Product[] albedoProducts = new Product[albedoFiles.length];
            int productIndex = 0;
            for (String albedoFile : albedoFiles) {
                String albedoProductFileName = albedoDir + File.separator + albedoFile;
                if (!new File(albedoProductFileName).exists()) continue;
                try {
                    Product product;
                    albedoProducts[productIndex] = product = ProductIO.readProduct((String)albedoProductFileName);
                    ++productIndex;
                }
                catch (IOException e) {
                    throw new OperatorException("Cannot load Albedo 8-day product " + albedoProductFileName + ": " + e.getMessage());
                }
            }
            return albedoProducts;
        }
        return null;
    }

    public static Product[] getAlbedo8DayMosaicProducts(String gaRootDir, final int monthIndex, String year, String mosaicScaling) {
        FilenameFilter inputProductNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean isCorrectPattern;
                boolean isCorrectSuffix = name.endsWith(".dim") || name.endsWith(".nc");
                boolean bl = isCorrectPattern = name.length() > 30 && name.substring(0, 29).matches("GlobAlbedo.albedo.[0-9]{7}.[0-9]{2}.");
                if (isCorrectSuffix && isCorrectPattern) {
                    String doy = name.substring(22, 25);
                    for (String doyOfMonth : AlbedoInversionConstants.doysOfMonth[monthIndex - 1]) {
                        if (!doy.equals(doyOfMonth)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        String albedoDir = gaRootDir + File.separator + "Mosaic" + File.separator + "albedo" + File.separator + year + File.separator + mosaicScaling + File.separator;
        String[] albedoFiles = new File(albedoDir).list(inputProductNameFilter);
        if (albedoFiles != null && albedoFiles.length > 0) {
            Product[] albedoProducts = new Product[albedoFiles.length];
            int productIndex = 0;
            for (String albedoFile : albedoFiles) {
                String albedoProductFileName = albedoDir + File.separator + albedoFile;
                if (!new File(albedoProductFileName).exists()) continue;
                try {
                    Product product;
                    albedoProducts[productIndex] = product = ProductIO.readProduct((String)albedoProductFileName);
                    ++productIndex;
                }
                catch (IOException e) {
                    throw new OperatorException("Cannot load Albedo 8-day product " + albedoProductFileName + ": " + e.getMessage());
                }
            }
            return albedoProducts;
        }
        return null;
    }

    public static File[] getTileDirectories(String rootDirString) {
        final Pattern finalPattern = Pattern.compile("h(\\d\\d)v(\\d\\d)");
        FileFilter tileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && finalPattern.matcher(file.getName()).matches();
            }
        };
        File rootDir = new File(rootDirString);
        return rootDir.listFiles(tileFilter);
    }

    private static List<String> getBrdfProductNames(String[] brdfFiles, boolean snow) {
        ArrayList<String> brdfFileList = new ArrayList<String>();
        for (String s : brdfFiles) {
            if ((snow || !s.contains(".NoSnow") || !s.endsWith(".dim") && !s.endsWith(".nc") && !s.endsWith(".csv")) && (!snow || !s.contains(".Snow") || !s.endsWith(".dim") && !s.endsWith(".nc") && !s.endsWith(".csv"))) continue;
            brdfFileList.add(s);
        }
        Collections.sort(brdfFileList);
        return brdfFileList;
    }

    private static List<String> getBrdfSeaiceProductNames(String[] brdfFiles) {
        ArrayList<String> brdfFileList = new ArrayList<String>();
        for (String s : brdfFiles) {
            if (!s.contains(".Seaice") || !s.endsWith(".dim") && !s.endsWith(".nc")) continue;
            brdfFileList.add(s);
        }
        Collections.sort(brdfFileList);
        return brdfFileList;
    }
}

