/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.globalbedo.auxdata.ModisTileCoordinates;
import org.esa.beam.globalbedo.inversion.util.ModisTileGeoCoding;
import org.esa.beam.util.ProductUtils;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@OperatorMetadata(alias="ga.adaptgeocoding", description="Adapts misaligned MODIS geocoding.")
public class GaAdaptTileGeocodingOp
extends Operator {
    @Parameter(defaultValue="", description="MODIS tile")
    private String tile;
    @SourceProduct
    private Product sourceProduct;

    public void initialize() throws OperatorException {
        if (this.tile == null || this.tile.length() != 6) {
            throw new OperatorException("Invalid tile name - exiting.");
        }
        Product targetProduct = this.createTargetProduct();
        this.setTargetProduct(targetProduct);
    }

    private Product createTargetProduct() {
        Product targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ModisTileGeoCoding geoCoding = GaAdaptTileGeocodingOp.getModisTileGeocoding(this.tile);
        targetProduct.setGeoCoding((GeoCoding)geoCoding);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)targetProduct);
        targetProduct.setStartTime(this.sourceProduct.getStartTime());
        targetProduct.setEndTime(this.sourceProduct.getEndTime());
        for (Band band : this.sourceProduct.getBands()) {
            if (targetProduct.containsBand(band.getName())) continue;
            ProductUtils.copyBand((String)band.getName(), (Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)band, (RasterDataNode)targetProduct.getBand(band.getName()));
        }
        for (Band band : this.sourceProduct.getTiePointGrids()) {
            if (targetProduct.containsTiePointGrid(band.getName())) continue;
            ProductUtils.copyTiePointGrid((String)band.getName(), (Product)this.sourceProduct, (Product)targetProduct);
        }
        return targetProduct;
    }

    private static ModisTileGeoCoding getModisTileGeocoding(String tile) {
        ModisTileGeoCoding geoCoding;
        ModisTileCoordinates modisTileCoordinates = ModisTileCoordinates.getInstance();
        int tileIndex = modisTileCoordinates.findTileIndex(tile);
        if (tileIndex == -1) {
            throw new OperatorException("Found no tileIndex for tileName=''" + tile + "");
        }
        double easting = modisTileCoordinates.getUpperLeftX(tileIndex);
        double northing = modisTileCoordinates.getUpperLeftY(tileIndex);
        double referencePixelX = 0.0;
        double referencePixelY = 0.0;
        String crsString = "PROJCS[\"MODIS Sinusoidal\",GEOGCS[\"WGS 84\",  DATUM[\"WGS_1984\",    SPHEROID[\"WGS 84\",6378137,298.257223563,      AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],   AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Sinusoidal\"],PARAMETER[\"false_easting\",0.0],PARAMETER[\"false_northing\",0.0],PARAMETER[\"central_meridian\",0.0],PARAMETER[\"semi_major\",6371007.181],PARAMETER[\"semi_minor\",6371007.181],UNIT[\"m\",1.0],AUTHORITY[\"SR-ORG\",\"6974\"]]";
        double pixelSizeX = 926.6254330558;
        double pixelSizeY = 926.6254330558;
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"MODIS Sinusoidal\",GEOGCS[\"WGS 84\",  DATUM[\"WGS_1984\",    SPHEROID[\"WGS 84\",6378137,298.257223563,      AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],   AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Sinusoidal\"],PARAMETER[\"false_easting\",0.0],PARAMETER[\"false_northing\",0.0],PARAMETER[\"central_meridian\",0.0],PARAMETER[\"semi_major\",6371007.181],PARAMETER[\"semi_minor\",6371007.181],UNIT[\"m\",1.0],AUTHORITY[\"SR-ORG\",\"6974\"]]");
            geoCoding = new ModisTileGeoCoding(crs, easting, northing, 926.6254330558, 926.6254330558, 0.0, 0.0);
        }
        catch (Exception e) {
            throw new OperatorException("Cannot attach geocoding for tileName= ''" + tile + " : ", (Throwable)e);
        }
        return geoCoding;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GaAdaptTileGeocodingOp.class);
        }
    }
}

