/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import Jama.Matrix;

public class DailyAccumulationUtils {
    public static void setDailyAccThisCMatrix(Matrix c, Matrix thisC, int count) {
        for (int j = 0; j < 3; ++j) {
            for (int k = j; k < 3; ++k) {
                thisC.set(j, k, c.get(count, 0));
                thisC.set(k, j, thisC.get(j, k));
                ++count;
            }
        }
    }

    public static void setDailyAccCMatrix(double[] stdev, double v, Matrix c, int count, int cCount) {
        for (int j = 0; j < 3; ++j) {
            for (int k = j + 1; k < 3; ++k) {
                if (k == j + 1) {
                    ++cCount;
                }
                c.set(cCount, 0, v * stdev[j] * stdev[k]);
                ++count;
                ++cCount;
            }
        }
    }

    public static Matrix getRectangularDiagonalMatrix(Matrix m) {
        if (m.getRowDimension() != m.getColumnDimension()) {
            return null;
        }
        Matrix diag = new Matrix(m.getRowDimension(), m.getRowDimension());
        for (int i = 0; i < m.getRowDimension(); ++i) {
            diag.set(i, i, m.get(i, i));
        }
        return diag;
    }

    public static boolean isAccumulatorInputInvalid(Matrix bbdr, double[] stdev, double[] correlation, Matrix kernels) {
        return DailyAccumulationUtils.isBBDRInvalid(bbdr) || DailyAccumulationUtils.isSDInvalid(stdev) || DailyAccumulationUtils.isCorrelationInvalid(correlation) || DailyAccumulationUtils.areKernelsInvalid(kernels);
    }

    public static boolean isAccumulatorInputInvalid(Matrix bbdr, double[] stdev, Matrix kernels) {
        return DailyAccumulationUtils.isBBDRInvalid(bbdr) || DailyAccumulationUtils.isSDInvalid(stdev) || DailyAccumulationUtils.areKernelsInvalid(kernels);
    }

    public static boolean isBBDRInvalid(Matrix bbdr) {
        for (int i = 0; i < bbdr.getRowDimension(); ++i) {
            for (int j = 0; j < bbdr.getColumnDimension(); ++j) {
                double elem = bbdr.get(i, j);
                if (!(elem <= 0.0) && !(elem >= 1.0) && !Double.isNaN(elem)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areKernelsInvalid(Matrix kernels) {
        for (int i = 0; i < kernels.getRowDimension(); ++i) {
            for (int j = 0; j < kernels.getColumnDimension(); ++j) {
                double elem = kernels.get(i, j);
                if (elem != -9999.0 && !Double.isNaN(elem)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSDInvalid(double[] stdevArr) {
        for (double stdev : stdevArr) {
            if (!(stdev <= 0.0 | Double.isNaN(stdev))) continue;
            return true;
        }
        return false;
    }

    private static boolean isCorrelationInvalid(double[] correlArr) {
        for (double correl : correlArr) {
            if (!(correl < 0.0 | Double.isNaN(correl))) continue;
            return true;
        }
        return false;
    }
}

