/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import Jama.Matrix;
import java.awt.image.Raster;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.globalbedo.auxdata.ModisTileCoordinates;
import org.esa.beam.gpf.operators.standard.reproject.ReprojectionOp;

public class AlbedoInversionUtils {
    public static String getDateFromDoy(int year, int doy) {
        return AlbedoInversionUtils.getDateFromDoy(year, doy, "yyyyMMdd");
    }

    public static String getDateFromDoy(int year, int doy, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, doy);
        calendar.set(1, year);
        return sdf.format(calendar.getTime());
    }

    public static Matrix getRectangularDiagonalFlatMatrix(Matrix m) {
        if (m.getRowDimension() != m.getColumnDimension()) {
            return null;
        }
        Matrix diagFlat = new Matrix(m.getRowDimension(), 1);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            diagFlat.set(i, 0, m.get(i, i));
        }
        return diagFlat;
    }

    public static boolean matrixHasNanElements(Matrix m) {
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                if (!Double.isNaN(m.get(i, j))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matrixHasZerosInDiagonale(Matrix m) {
        for (int i = 0; i < m.getRowDimension(); ++i) {
            if (m.get(i, i) != 0.0) continue;
            return true;
        }
        return false;
    }

    public static double computeSza(GeoPos geoPos, int doy) {
        double latitude = (double)geoPos.getLat() * (Math.PI / 180);
        double LST = 12.0;
        double h = 0.0;
        double delta = -0.4092797095926703 * Math.cos(0.01721420632103996 * (double)(doy + 10));
        double SZArad = Math.acos(Math.sin(latitude) * Math.sin(delta) + Math.cos(latitude) * Math.cos(delta) * Math.cos(0.0));
        return SZArad * 57.29577951308232;
    }

    public static Product createDummySourceProduct(int width, int height) {
        Product product = new Product("dummy", "dummy", width, height);
        Band b = product.addBand("b1", 30);
        float[] bData = new float[width * height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                bData[i * width + j] = 1.0f;
            }
        }
        b.setRasterData(ProductData.createInstance((float[])bData));
        product.setPreferredTileSize(product.getSceneRasterWidth(), Math.min(45, product.getSceneRasterHeight()));
        return product;
    }

    public static float[][] getMonthlyWeighting() {
        int[] startingDoy = new int[]{1, 32, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        int[] nDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] eightDayTimePeriod = new int[46];
        int[] eightDayTimePeriodExtended = new int[47];
        for (int i = 0; i < eightDayTimePeriod.length; ++i) {
            eightDayTimePeriod[i] = 1 + 8 * i;
            eightDayTimePeriodExtended[i] = 1 + 8 * i;
        }
        eightDayTimePeriodExtended[46] = 369;
        int[] daysInYear = new int[365];
        for (int i = 0; i < daysInYear.length; ++i) {
            daysInYear[i] = 1 + i;
        }
        float[][] monthlyWeighting = new float[12][daysInYear.length];
        float[][] weight = new float[47][365];
        int[] deltaTime = new int[365];
        for (int i = 0; i < eightDayTimePeriodExtended.length; ++i) {
            for (int j = 0; j < deltaTime.length; ++j) {
                deltaTime[j] = daysInYear[j] - eightDayTimePeriodExtended[i];
                weight[i][j] = AlbedoInversionUtils.getWeight(deltaTime[j]);
            }
        }
        int j = 0;
        for (int startingDayInMonth : startingDoy) {
            int numberOfDaysInMonth = nDays[j];
            for (int day : daysInYear) {
                float nd = 0.0f;
                float sum = 0.0f;
                for (int doy : eightDayTimePeriod) {
                    float distance;
                    if (doy < startingDayInMonth || doy > startingDayInMonth + numberOfDaysInMonth) continue;
                    float monthlyWeight = 1.0f;
                    if (doy >= startingDayInMonth + numberOfDaysInMonth - 8) {
                        distance = (float)(startingDayInMonth + numberOfDaysInMonth - doy) / 8.0f;
                        monthlyWeight = distance * 0.5f + 0.5f;
                    }
                    if (doy <= startingDayInMonth) {
                        distance = (float)(startingDayInMonth - doy) / 8.0f;
                        monthlyWeight = distance * 0.5f + 0.5f;
                    }
                    nd += monthlyWeight;
                    sum += weight[(doy - 1) / 8][day - 1] * monthlyWeight;
                }
                monthlyWeighting[j][day - 1] = sum / nd;
            }
            ++j;
        }
        return monthlyWeighting;
    }

    public static RealMatrix getRealMatrixFromJamaMatrix(Matrix m) {
        int rDim = m.getRowDimension();
        int cDim = m.getColumnDimension();
        Array2DRowRealMatrix rm = new Array2DRowRealMatrix(rDim, cDim);
        for (int i = 0; i < rDim; ++i) {
            for (int j = 0; j < cDim; ++j) {
                rm.setEntry(i, j, m.get(i, j));
            }
        }
        return rm;
    }

    public static boolean isValid(float srcValue) {
        return srcValue != -9999.0f && !Float.isNaN(srcValue);
    }

    public static boolean isValid(double srcValue) {
        return srcValue != -9999.0 && !Double.isNaN(srcValue);
    }

    public static float getWeight(int dayDifference) {
        return (float)Math.exp(-1.0 * (double)Math.abs(dayDifference) / 11.54);
    }

    public static boolean isValidCMatrix(Matrix c) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (c.get(i, j) == -9999.0) continue;
                return true;
            }
        }
        return false;
    }

    public static GeoPos getLatLonFromProduct(Product inputProduct) {
        Band latBand = inputProduct.getBand("latitude");
        Raster latData = latBand.getSourceImage().getData();
        float latitude = latData.getSampleFloat(0, 0, 0);
        Band lonBand = inputProduct.getBand("longitude");
        Raster lonData = lonBand.getSourceImage().getData();
        float longitude = lonData.getSampleFloat(0, 0, 0);
        return new GeoPos(latitude, longitude);
    }

    public static Product reprojectToModisTile(Product bbdrProduct, String tileName, String resampling, double scaleFactor) {
        ModisTileCoordinates modisTileCoordinates = ModisTileCoordinates.getInstance();
        int tileIndex = modisTileCoordinates.findTileIndex(tileName);
        if (tileIndex == -1) {
            throw new OperatorException("Found no tileIndex for tileName=''" + tileName + "");
        }
        double easting = modisTileCoordinates.getUpperLeftX(tileIndex);
        double northing = modisTileCoordinates.getUpperLeftY(tileIndex);
        ReprojectionOp repro = new ReprojectionOp();
        repro.setParameterDefaultValues();
        repro.setParameter("easting", (Object)easting);
        repro.setParameter("northing", (Object)northing);
        repro.setParameter("crs", (Object)"PROJCS[\"MODIS Sinusoidal\",GEOGCS[\"WGS 84\",  DATUM[\"WGS_1984\",    SPHEROID[\"WGS 84\",6378137,298.257223563,      AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],   AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Sinusoidal\"],PARAMETER[\"false_easting\",0.0],PARAMETER[\"false_northing\",0.0],PARAMETER[\"central_meridian\",0.0],PARAMETER[\"semi_major\",6371007.181],PARAMETER[\"semi_minor\",6371007.181],UNIT[\"m\",1.0],AUTHORITY[\"SR-ORG\",\"6974\"]]");
        repro.setParameter("resampling", (Object)resampling);
        repro.setParameter("includeTiePointGrids", (Object)false);
        repro.setParameter("referencePixelX", (Object)0.0);
        repro.setParameter("referencePixelY", (Object)0.0);
        repro.setParameter("orientation", (Object)0.0);
        double pixelSizeX = 926.6254330558 * scaleFactor;
        double pixelSizeY = 926.6254330558 * scaleFactor;
        int width = (int)(1200.0 / scaleFactor);
        int height = (int)(1200.0 / scaleFactor);
        repro.setParameter("pixelSizeX", (Object)pixelSizeX);
        repro.setParameter("pixelSizeY", (Object)pixelSizeY);
        repro.setParameter("width", (Object)width);
        repro.setParameter("height", (Object)height);
        repro.setParameter("orthorectify", (Object)true);
        repro.setParameter("noDataValue", (Object)0.0);
        repro.setSourceProduct(bbdrProduct);
        return repro.getTargetProduct();
    }
}

