/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.util;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.globalbedo.inversion.FullAccumulator;
import org.esa.beam.globalbedo.inversion.util.IOUtils;

@OperatorMetadata(alias="ga.l3.acc2dimap", description="Utility operator to write a full or daily accumulator into a Dimap product for debugging.", version="1.0", copyright="(C) 2013 by Brockmann Consult")
public class AccToDimapOp
extends Operator {
    @Parameter(description="Year")
    private int year;
    @Parameter(description="Day of year")
    private int doy;
    @Parameter(description="Full accumulator filename (full path)")
    private String accumulatorFilePath;
    @Parameter(description="raster width", defaultValue="1200")
    private int rasterWidth;
    @Parameter(description="raster height", defaultValue="1200")
    private int rasterHeight;
    @Parameter(description="set to true for full accumulator", defaultValue="true")
    private boolean isFullAcc;
    private FullAccumulator fullAcc;

    public void initialize() throws OperatorException {
        System.out.println("Reading accumulator file: " + this.accumulatorFilePath);
        int numBands = IOUtils.getDailyAccumulatorBandNames().length;
        if (this.isFullAcc) {
            ++numBands;
        }
        this.fullAcc = IOUtils.getAccumulatorFromBinaryFile(this.year, this.doy, this.accumulatorFilePath, numBands, this.rasterWidth, this.rasterHeight, this.isFullAcc);
        System.out.println("Done reading full accumulator file.");
        float[][][] sumMatrices = this.fullAcc.getSumMatrices();
        int dim1 = sumMatrices.length;
        int dim2 = sumMatrices[0].length;
        int dim3 = sumMatrices[0][0].length;
        Product targetProduct = new Product("fullAcc", "fullAcc", dim2, dim3);
        targetProduct.setPreferredTileSize(50, 50);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                targetProduct.addBand("M_" + i + j, 30);
            }
        }
        for (int j = 0; j < 9; ++j) {
            targetProduct.addBand("V_" + j, 30);
        }
        targetProduct.addBand("E", 30);
        this.setTargetProduct(targetProduct);
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        int sumMatrixIndex;
        Rectangle rectangle = targetTile.getRectangle();
        if (targetBand.getName().startsWith("M")) {
            int i = Integer.parseInt(targetBand.getName().substring(2, 3));
            int j = Integer.parseInt(targetBand.getName().substring(3, 4));
            sumMatrixIndex = 9 * i + j;
        } else if (targetBand.getName().startsWith("V")) {
            int j = Integer.parseInt(targetBand.getName().substring(2, 3));
            sumMatrixIndex = 81 + j;
        } else {
            sumMatrixIndex = 90;
        }
        for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
            for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                float value = this.fullAcc.getSumMatrices()[sumMatrixIndex][x][y];
                targetTile.setSample(x, y, value);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AccToDimapOp.class);
        }
    }
}

