/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

public class SpectralInversionUtils {
    public static int[] getSigmaSdrDiagonalIndices(int numSdrBands) {
        int[] sigmaSdrDiagonalIndices = new int[numSdrBands];
        int index = 0;
        for (int j = 0; j < numSdrBands; ++j) {
            sigmaSdrDiagonalIndices[j] = index;
            index += 7 - j;
        }
        return sigmaSdrDiagonalIndices;
    }

    public static int[] getSigmaSdrURIndices(int numSdrBands, int numSigmaSdrBands) {
        int[] sigmaSdrURIndices = new int[numSigmaSdrBands - numSdrBands];
        int index = 0;
        int count = 0;
        for (int i = 0; i < numSdrBands; ++i) {
            for (int j = i; j < numSdrBands; ++j) {
                if (j > i) {
                    sigmaSdrURIndices[index] = count;
                    ++index;
                }
                ++count;
            }
        }
        return sigmaSdrURIndices;
    }

    public static String[] getSigmaSdrBandNames(int numSigmaSdrBands) {
        String[] sdrBandNames = new String[numSigmaSdrBands];
        for (int i = 0; i < numSigmaSdrBands; ++i) {
            sdrBandNames[i] = "SDR_SIGMA_" + i;
        }
        return sdrBandNames;
    }

    public static String[] getSdrBandNames(int numSdrBands) {
        String[] sdrBandNames = new String[numSdrBands];
        for (int i = 0; i < numSdrBands; ++i) {
            sdrBandNames[i] = "SDR_" + i;
        }
        return sdrBandNames;
    }
}

