/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

import Jama.LUDecomposition;
import Jama.Matrix;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.pointop.PixelOperator;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.globalbedo.inversion.FullAccumulator;
import org.esa.beam.globalbedo.inversion.spectral.SpectralAccumulator;
import org.esa.beam.globalbedo.inversion.spectral.SpectralFullAccumulation;
import org.esa.beam.globalbedo.inversion.spectral.SpectralIOUtils;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;

@OperatorMetadata(alias="ga.inversion.inversion.spectral", description="Implements the inversion part extended from broadband to spectral appropach (MODIS bands).", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class SpectralInversionOp
extends PixelOperator {
    @SourceProduct(description="Source product", optional=true)
    private Product sourceProduct;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="Tile")
    private String tile;
    @Parameter(description="Day of year")
    private int doy;
    @Parameter(defaultValue="180", description="Wings")
    private int wings;
    @Parameter(defaultValue="", description="Globalbedo SDR root directory")
    private String sdrRootDir;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="7", valueSet={"7"}, description="Number of spectral bands (currently always 7 for standard MODIS spectral mapping")
    private int numSdrBands;
    @Parameter(description="Sub tiling factor (e.g. 4 for 300x300 subtile size")
    private int subtileFactor;
    @Parameter(description="Sub tile start X", valueSet={"0", "300", "600", "900"})
    private int subStartX;
    @Parameter(description="Sub tile start Y", valueSet={"0", "300", "600", "900"})
    private int subStartY;
    private static final int TRG_REL_ENTROPY = 1;
    private static final int TRG_WEIGHTED_NUM_SAMPLES = 2;
    private static final int TRG_GOODNESS_OF_FIT = 3;
    private static final int TRG_DAYS_TO_THE_CLOSEST_SAMPLE = 4;
    private String[] parameterBandNames;
    private String[][] uncertaintyBandNames;
    private int numTargetParameters;
    private int numTargetUncertainties;
    static final Map<Integer, String> spectralWaveBandsMap = new HashMap<Integer, String>();
    private FullAccumulator fullAccumulator;

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        SpectralInversionOp.setupSpectralWaveBandsMap(this.numSdrBands);
        this.parameterBandNames = SpectralIOUtils.getSpectralInversionParameterBandNames(this.numSdrBands);
        this.uncertaintyBandNames = SpectralIOUtils.getSpectralInversionUncertaintyBandNames(this.numSdrBands, spectralWaveBandsMap);
        this.numTargetParameters = 3 * this.numSdrBands;
        this.numTargetUncertainties = 3 * this.numSdrBands;
        int subtileWidth = 1200 / this.subtileFactor;
        int subtileHeight = 1200 / this.subtileFactor;
        SpectralFullAccumulation fullAccumulation = new SpectralFullAccumulation(this.numSdrBands, subtileWidth, subtileHeight, this.subStartX, this.subStartY, this.sdrRootDir, this.tile, this.year, this.doy, this.wings, this.computeSnow);
        this.fullAccumulator = fullAccumulation.getResult();
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        double relEntropy;
        Matrix uncertainties;
        Matrix parameters = new Matrix(this.numSdrBands * 3, 1, -9999.0);
        double entropy = 0.0;
        double maskAcc = 0.0;
        SpectralAccumulator accumulator = null;
        if (this.fullAccumulator != null) {
            accumulator = SpectralAccumulator.createForInversion(this.fullAccumulator.getSumMatrices(), x, y, 7);
            maskAcc = accumulator.getMask();
        }
        double goodnessOfFit = 0.0;
        float daysToTheClosestSample = 0.0f;
        if (accumulator != null && maskAcc > 0.0) {
            Matrix mAcc = accumulator.getM();
            Matrix vAcc = accumulator.getV();
            Matrix eAcc = accumulator.getE();
            LUDecomposition lud = new LUDecomposition(mAcc);
            if (lud.isNonsingular()) {
                Matrix tmpM = mAcc.inverse();
                if (AlbedoInversionUtils.matrixHasNanElements(tmpM) || AlbedoInversionUtils.matrixHasZerosInDiagonale(tmpM)) {
                    tmpM = new Matrix(3 * this.numSdrBands, 9, -9999.0);
                }
                uncertainties = tmpM;
            } else {
                parameters = new Matrix(this.numSdrBands * 3, 1, -9999.0);
                uncertainties = new Matrix(3 * this.numSdrBands, 3 * this.numSdrBands, -9999.0);
                maskAcc = 0.0;
            }
            if (maskAcc != 0.0) {
                parameters = mAcc.solve(vAcc);
                entropy = this.getEntropy(mAcc);
            }
            goodnessOfFit = this.getGoodnessOfFit(mAcc, vAcc, eAcc, parameters, maskAcc);
            relEntropy = -9999.0;
            daysToTheClosestSample = this.fullAccumulator.getDaysToTheClosestSample()[x][y];
        } else {
            uncertainties = new Matrix(3 * this.numSdrBands, 3 * this.numSdrBands, -9999.0);
            entropy = -9999.0;
            relEntropy = -9999.0;
        }
        this.fillTargetSamples(targetSamples, parameters, uncertainties, entropy, relEntropy, maskAcc, goodnessOfFit, daysToTheClosestSample);
    }

    protected void configureSourceSamples(SampleConfigurer sampleConfigurer) throws OperatorException {
    }

    protected void configureTargetSamples(SampleConfigurer configurator) throws OperatorException {
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            configurator.defineSample(i, this.parameterBandNames[i]);
        }
        int index = 0;
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            configurator.defineSample(this.numTargetParameters + index, this.uncertaintyBandNames[i][i]);
            ++index;
        }
        int offset = this.numTargetParameters + this.numTargetUncertainties;
        configurator.defineSample(offset, "Entropy");
        configurator.defineSample(offset + 1, "Relative_Entropy");
        configurator.defineSample(offset + 2, "Weighted_Number_of_Samples");
        configurator.defineSample(offset + 3, "Goodness_of_Fit");
        configurator.defineSample(offset + 4, "Time_to_the_Closest_Sample");
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        for (String parameterBandName : this.parameterBandNames) {
            productConfigurer.addBand(parameterBandName, 30, -9999.0);
        }
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            productConfigurer.addBand(this.uncertaintyBandNames[i][i], 30, -9999.0);
        }
        productConfigurer.addBand("Entropy", 30, -9999.0);
        productConfigurer.addBand("Relative_Entropy", 30, -9999.0);
        productConfigurer.addBand("Weighted_Number_of_Samples", 30, -9999.0);
        productConfigurer.addBand("Time_to_the_Closest_Sample", 30, -9999.0);
        productConfigurer.addBand("Goodness_of_Fit", 30, -9999.0);
        for (Band b : this.getTargetProduct().getBands()) {
            b.setNoDataValue(-9999.0);
            b.setNoDataValueUsed(true);
        }
    }

    static void setupSpectralWaveBandsMap(int numSdrBands) {
        for (int i = 0; i < numSdrBands; ++i) {
            spectralWaveBandsMap.put(i, "b" + (i + 1));
        }
    }

    private double getGoodnessOfFit(Matrix mAcc, Matrix vAcc, Matrix eAcc, Matrix fPars, double maskAcc) {
        Matrix goodnessOfFitMatrix = new Matrix(1, 1, 0.0);
        if (maskAcc > 0.0) {
            Matrix gofTerm1 = fPars.transpose().times(mAcc).times(fPars);
            Matrix gofTerm2 = fPars.transpose().times(vAcc);
            Matrix m2 = new Matrix(1, 1, 2.0);
            Matrix gofTerm3 = m2.times(eAcc);
            goodnessOfFitMatrix = gofTerm1.plus(gofTerm2).minus(gofTerm3);
        }
        return goodnessOfFitMatrix.get(0, 0);
    }

    private void fillTargetSamples(WritableSample[] targetSamples, Matrix parameters, Matrix uncertainties, double entropy, double relEntropy, double weightedNumberOfSamples, double goodnessOfFit, float daysToTheClosestSample) {
        int i;
        int index = 0;
        for (i = 0; i < 3 * this.numSdrBands; ++i) {
            targetSamples[index].set(parameters.get(index, 0));
            ++index;
        }
        index = 0;
        for (i = 0; i < 3 * this.numSdrBands; ++i) {
            targetSamples[this.numTargetParameters + index].set(uncertainties.get(i, i));
            ++index;
        }
        int offset = this.numTargetParameters + this.numTargetUncertainties;
        targetSamples[offset].set(entropy);
        targetSamples[offset + 1].set(relEntropy);
        targetSamples[offset + 2].set(weightedNumberOfSamples);
        targetSamples[offset + 3].set(goodnessOfFit);
        targetSamples[offset + 4].set(daysToTheClosestSample);
    }

    private double getEntropy(Matrix m) {
        RealMatrix rm = AlbedoInversionUtils.getRealMatrixFromJamaMatrix(m);
        SingularValueDecomposition svdM = new SingularValueDecomposition(rm);
        double[] svdMSingularValues = svdM.getSingularValues();
        double productSvdMSRecip = 1.0;
        for (double svdMSingularValue : svdMSingularValues) {
            if (svdMSingularValue == 0.0) continue;
            productSvdMSRecip *= 1.0 / svdMSingularValue;
        }
        return 0.5 * Math.log(productSvdMSRecip) + (double)svdMSingularValues.length * Math.sqrt(Math.log(17.079468445347132));
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SpectralInversionOp.class);
        }
    }
}

