/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.globalbedo.auxdata.ModisTileCoordinates;
import org.esa.beam.globalbedo.inversion.AccumulatorHolder;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.globalbedo.inversion.util.ModisTileGeoCoding;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpectralIOUtils {
    public static String[] getSpectralInversionParameterBandNames(int numSdrBands) {
        String[] bandNames = new String[numSdrBands * 3];
        int index = 0;
        for (int i = 0; i < numSdrBands; ++i) {
            for (int j = 0; j < 3; ++j) {
                bandNames[index] = "mean_b" + (i + 1) + "_f" + j;
                ++index;
            }
        }
        return bandNames;
    }

    public static String[][] getSpectralInversionUncertaintyBandNames(int numSdrBands, Map<Integer, String> spectralWaveBandsMap) {
        String[][] bandNames = new String[3 * numSdrBands][3 * numSdrBands];
        for (int i = 0; i < 3 * numSdrBands; ++i) {
            for (int j = i; j < 3 * numSdrBands; ++j) {
                bandNames[i][j] = "VAR_" + spectralWaveBandsMap.get(i / 3) + "_f" + i % 3 + "_" + spectralWaveBandsMap.get(j / 3) + "_f" + j % 3;
            }
        }
        return bandNames;
    }

    public static Product[] getSpectralAccumulationInputProducts(String sdrRootDir, String[] sensors, int subStartX, int subStartY, String tile, int year, int doy) throws IOException {
        String daystring_yyyymmdd = AlbedoInversionUtils.getDateFromDoy(year, doy);
        String daystring_yyyy_mm_dd = AlbedoInversionUtils.getDateFromDoy(year, doy, "yyyy_MM_dd");
        ArrayList<Product> bbdrProductList = new ArrayList<Product>();
        if (StringUtils.isNotNullAndNotEmpty((String)daystring_yyyymmdd)) {
            for (String sensor : sensors) {
                int numProducts = 0;
                String subTileDir = "SUB_" + Integer.toString(subStartX) + "_" + Integer.toString(subStartY);
                String sensorBbdrDirName = sdrRootDir + File.separator + sensor + File.separator + year + File.separator + tile + File.separator + subTileDir;
                File sensorBbdrDir = new File(sensorBbdrDirName);
                if (sensorBbdrDir.exists()) {
                    String[] sensorBbdrFiles;
                    for (String sensorBbdrFile : sensorBbdrFiles = sensorBbdrDir.list()) {
                        String sourceProductFileName;
                        Product product;
                        if (!sensorBbdrFile.endsWith(".nc") && !sensorBbdrFile.endsWith(".nc.gz") || !sensorBbdrFile.contains(subTileDir) || !sensorBbdrFile.contains(daystring_yyyymmdd) && !sensorBbdrFile.contains(daystring_yyyy_mm_dd) || (product = ProductIO.readProduct((String)(sourceProductFileName = sensorBbdrDirName + File.separator + sensorBbdrFile))) == null) continue;
                        bbdrProductList.add(product);
                        ++numProducts;
                    }
                }
                BeamLogManager.getSystemLogger().log(Level.INFO, "Collecting Daily accumulation BBDR/SDR products for tile/year/doy: " + tile + "/" + year + "/" + IOUtils.getDoyString(doy) + ": ");
                BeamLogManager.getSystemLogger().log(Level.INFO, "      Sensor '" + sensor + "': " + numProducts + " products added.");
            }
        }
        return bbdrProductList.toArray(new Product[bbdrProductList.size()]);
    }

    public static AccumulatorHolder getDailyAccumulator(String accumulatorRootDir, int doy, int year, String tile, int subStartX, int subStartY, int wings, boolean computeSnow, boolean computeSeaice) {
        AccumulatorHolder accumulatorHolder = null;
        List<String> albedoInputProductBinaryFileList = SpectralIOUtils.getDailyAccumulatorBinaryFileNames(accumulatorRootDir, doy, year, tile, subStartX, subStartY, wings, computeSnow);
        String subTileDir = "SUB_" + Integer.toString(subStartX) + "_" + Integer.toString(subStartY);
        if (albedoInputProductBinaryFileList.size() > 0) {
            accumulatorHolder = new AccumulatorHolder();
            accumulatorHolder.setReferenceYear(year);
            accumulatorHolder.setReferenceDoy(doy);
            String[] albedoInputProductBinaryFilenames = new String[albedoInputProductBinaryFileList.size()];
            int binaryProductIndex = 0;
            for (String albedoInputProductBinaryName : albedoInputProductBinaryFileList) {
                String sourceProductBinaryFileName;
                String thisProductYear = albedoInputProductBinaryName.substring(9, 13);
                String productYearRootDir = computeSnow ? accumulatorRootDir.concat(File.separator + thisProductYear + File.separator + tile + File.separator + "Snow") : (computeSeaice ? accumulatorRootDir.concat(File.separator + thisProductYear + File.separator + tile) : accumulatorRootDir.concat(File.separator + thisProductYear + File.separator + tile + File.separator + "NoSnow"));
                productYearRootDir = productYearRootDir.concat(File.separator + subTileDir);
                albedoInputProductBinaryFilenames[binaryProductIndex] = sourceProductBinaryFileName = productYearRootDir + File.separator + albedoInputProductBinaryName;
                ++binaryProductIndex;
            }
            accumulatorHolder.setProductBinaryFilenames(albedoInputProductBinaryFilenames);
        }
        return accumulatorHolder;
    }

    static List<String> getDailyAccumulatorBinaryFileNames(String accumulatorRootDir, int doy, final int year, String tile, int subStartX, int subStartY, int wings, boolean computeSnow) {
        ArrayList<String> accumulatorNameList = new ArrayList<String>();
        FilenameFilter yearFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int startYear = 1982;
                for (int i = 0; i <= 35; ++i) {
                    String thisYear = new Integer(startYear + i).toString();
                    if (!name.equals(thisYear) || Math.abs(startYear + i - year) > 1) continue;
                    return true;
                }
                return false;
            }
        };
        FilenameFilter accumulatorNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("matrices_") && name.endsWith(".bin");
            }
        };
        String[] accumulatorYears = new File(accumulatorRootDir).list(yearFilter);
        String subTileDir = "SUB_" + Integer.toString(subStartX) + "_" + Integer.toString(subStartY);
        for (String accProductYear : accumulatorYears) {
            String thisYearsRootDir = computeSnow ? accumulatorRootDir.concat(File.separator + accProductYear + File.separator + tile + File.separator + "Snow") : accumulatorRootDir.concat(File.separator + accProductYear + File.separator + tile + File.separator + "NoSnow");
            String[] thisYearAccumulatorFiles = new File(thisYearsRootDir = thisYearsRootDir.concat(File.separator + subTileDir)).list(accumulatorNameFilter);
            if (thisYearAccumulatorFiles == null || thisYearAccumulatorFiles.length <= 0) continue;
            for (String s : thisYearAccumulatorFiles) {
                if (!s.startsWith("matrices_" + accProductYear) || accumulatorNameList.contains(s) || !IOUtils.isInWingsInterval(wings, year, doy, tile, s)) continue;
                accumulatorNameList.add(s);
            }
        }
        return SpectralIOUtils.sortAccumulatorFileList(accumulatorNameList, year, doy, subTileDir);
    }

    static List<String> sortAccumulatorFileList(List<String> accumulatorNameList, int refYear, int refDoy, String subTileDir) {
        int doyPlus;
        ArrayList<String> accumulatorNameSortedList = new ArrayList<String>();
        int doyMinus = refDoy;
        for (doyPlus = refDoy; doyMinus > 0 && doyPlus < 366; ++doyPlus) {
            String accName = "matrices_" + Integer.toString(refYear) + String.format("%03d", doyMinus) + "_" + subTileDir + ".bin";
            if (accumulatorNameList.contains(accName) && !accumulatorNameSortedList.contains(accName) && ((double)AlbedoInversionUtils.getWeight(refDoy - doyMinus) > 0.05 || accumulatorNameSortedList.size() < 60)) {
                accumulatorNameSortedList.add(accName);
            }
            --doyMinus;
            accName = "matrices_" + Integer.toString(refYear) + String.format("%03d", doyPlus) + "_" + subTileDir + ".bin";
            if (!accumulatorNameList.contains(accName) || accumulatorNameSortedList.contains(accName) || !((double)AlbedoInversionUtils.getWeight(doyPlus - refDoy) > 0.05) && accumulatorNameSortedList.size() >= 60) continue;
            accumulatorNameSortedList.add(accName);
        }
        if (accumulatorNameSortedList.size() < 60) {
            if (doyMinus == 0) {
                int doyMinus2 = 365;
                while (doyMinus2 > 180 && doyPlus < 366) {
                    String accName = "matrices_" + Integer.toString(refYear - 1) + String.format("%03d", doyMinus2) + "_" + subTileDir + ".bin";
                    if (accumulatorNameList.contains(accName) && !accumulatorNameSortedList.contains(accName) && ((double)AlbedoInversionUtils.getWeight(refDoy + 365 - doyMinus2) > 0.05 || accumulatorNameSortedList.size() < 60)) {
                        accumulatorNameSortedList.add(accName);
                    }
                    --doyMinus2;
                    accName = "matrices_" + Integer.toString(refYear) + String.format("%03d", doyPlus) + "_" + subTileDir + ".bin";
                    if (accumulatorNameList.contains(accName) && !accumulatorNameSortedList.contains(accName) && ((double)AlbedoInversionUtils.getWeight(doyPlus - refDoy) > 0.05 || accumulatorNameSortedList.size() < 60)) {
                        accumulatorNameSortedList.add(accName);
                    }
                    ++doyPlus;
                }
            } else if (doyPlus == 366) {
                for (int doyPlus2 = 0; doyPlus2 < 180 && doyMinus > 0; ++doyPlus2) {
                    String accName = "matrices_" + Integer.toString(refYear) + String.format("%03d", doyMinus) + "_" + subTileDir + ".bin";
                    if (accumulatorNameList.contains(accName) && !accumulatorNameSortedList.contains(accName) && ((double)AlbedoInversionUtils.getWeight(refDoy - doyMinus) > 0.05 || accumulatorNameSortedList.size() < 60)) {
                        accumulatorNameSortedList.add(accName);
                    }
                    --doyMinus;
                    accName = "matrices_" + Integer.toString(refYear + 1) + String.format("%03d", doyPlus2) + "_" + subTileDir + ".bin";
                    if (!accumulatorNameList.contains(accName) || accumulatorNameSortedList.contains(accName) || !((double)AlbedoInversionUtils.getWeight(doyPlus2 + 365 - refDoy) > 0.05) && accumulatorNameSortedList.size() >= 60) continue;
                    accumulatorNameSortedList.add(accName);
                }
            }
        }
        Collections.sort(accumulatorNameSortedList);
        return accumulatorNameSortedList;
    }

    public static String[] getSpectralDailyAccumulatorBandNames(int numSdrBands) {
        int i;
        String[] bandNames = new String[3 * numSdrBands * 3 * numSdrBands + 3 * numSdrBands + 1 + 1];
        int index = 0;
        for (i = 0; i < 3 * numSdrBands; ++i) {
            for (int j = 0; j < 3 * numSdrBands; ++j) {
                bandNames[index++] = "M_" + i + "" + j;
            }
        }
        for (i = 0; i < 3 * numSdrBands; ++i) {
            bandNames[index++] = "V_" + i;
        }
        bandNames[index++] = "E";
        bandNames[index] = "mask";
        return bandNames;
    }

    public static String[] getSpectralAlbedoDhrBandNames(int numSdrBands, Map<Integer, String> spectralWaveBandsMap) {
        String[] bandNames = new String[numSdrBands];
        for (int i = 0; i < numSdrBands; ++i) {
            bandNames[i] = "DHR_" + spectralWaveBandsMap.get(i);
        }
        return bandNames;
    }

    public static String[] getSpectralAlbedoBhrBandNames(int numSdrBands, Map<Integer, String> spectralWaveBandsMap) {
        String[] bandNames = new String[numSdrBands];
        for (int i = 0; i < numSdrBands; ++i) {
            bandNames[i] = "BHR_" + spectralWaveBandsMap.get(i);
        }
        return bandNames;
    }

    public static String[][] getSpectralAlbedoAlphaBandNames(String type, int numSdrBands, Map<Integer, String> spectralWaveBandsMap) {
        String[][] bandNames = new String[numSdrBands - 1][numSdrBands - 1];
        for (int i = 0; i < numSdrBands - 1; ++i) {
            for (int j = i; j < numSdrBands - 1; ++j) {
                bandNames[i][j] = type + "_alpha_" + spectralWaveBandsMap.get(i) + "_" + spectralWaveBandsMap.get(j);
            }
        }
        return bandNames;
    }

    public static String[] getSpectralAlbedoDhrSigmaBandNames(int numSdrBands, Map<Integer, String> spectralWaveBandsMap) {
        String[] bandNames = new String[numSdrBands];
        for (int i = 0; i < numSdrBands; ++i) {
            bandNames[i] = "DHR_sigma_" + spectralWaveBandsMap.get(i);
        }
        return bandNames;
    }

    public static String[] getSpectralAlbedoBhrSigmaBandNames(int numSdrBands, Map<Integer, String> spectralWaveBandsMap) {
        String[] bandNames = new String[numSdrBands];
        for (int i = 0; i < numSdrBands; ++i) {
            bandNames[i] = "BHR_sigma_" + spectralWaveBandsMap.get(i);
        }
        return bandNames;
    }

    public static ModisTileGeoCoding getSinusoidalSubtileGeocoding(String tile, int startX, int startY) {
        ModisTileGeoCoding geoCoding;
        ModisTileCoordinates modisTileCoordinates = ModisTileCoordinates.getInstance();
        int tileIndex = modisTileCoordinates.findTileIndex(tile);
        if (tileIndex == -1) {
            throw new OperatorException("Found no tileIndex for tileName=''" + tile + "");
        }
        double pixelSizeX = 926.6254330558;
        double pixelSizeY = 926.6254330558;
        double easting = modisTileCoordinates.getUpperLeftX(tileIndex) + (double)startX * 926.6254330558;
        double northing = modisTileCoordinates.getUpperLeftY(tileIndex) - (double)startY * 926.6254330558;
        String crsString = "PROJCS[\"MODIS Sinusoidal\",GEOGCS[\"WGS 84\",  DATUM[\"WGS_1984\",    SPHEROID[\"WGS 84\",6378137,298.257223563,      AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],   AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Sinusoidal\"],PARAMETER[\"false_easting\",0.0],PARAMETER[\"false_northing\",0.0],PARAMETER[\"central_meridian\",0.0],PARAMETER[\"semi_major\",6371007.181],PARAMETER[\"semi_minor\",6371007.181],UNIT[\"m\",1.0],AUTHORITY[\"SR-ORG\",\"6974\"]]";
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"MODIS Sinusoidal\",GEOGCS[\"WGS 84\",  DATUM[\"WGS_1984\",    SPHEROID[\"WGS 84\",6378137,298.257223563,      AUTHORITY[\"EPSG\",\"7030\"]],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],   AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Sinusoidal\"],PARAMETER[\"false_easting\",0.0],PARAMETER[\"false_northing\",0.0],PARAMETER[\"central_meridian\",0.0],PARAMETER[\"semi_major\",6371007.181],PARAMETER[\"semi_minor\",6371007.181],UNIT[\"m\",1.0],AUTHORITY[\"SR-ORG\",\"6974\"]]");
            geoCoding = new ModisTileGeoCoding(crs, easting, northing, 926.6254330558, 926.6254330558);
        }
        catch (Exception e) {
            throw new OperatorException("Cannot attach geocoding for tileName= ''" + tile + " : ", (Throwable)e);
        }
        return geoCoding;
    }

    public static Product getSpectralBrdfProduct(String brdfDir, int year, int doy, boolean isSnow, int subStartX, int subStartY) throws IOException {
        String[] brdfFiles = new File(brdfDir).list();
        String subTileString = Integer.toString(subStartX) + "_" + Integer.toString(subStartY);
        List<String> brdfFileList = SpectralIOUtils.getSpectralBrdfProductNames(brdfFiles, isSnow, subTileString);
        String doyString = IOUtils.getDoyString(doy);
        for (String brdfFileName : brdfFileList) {
            if (!brdfFileName.startsWith("Qa4ecv.brdf.spectral." + Integer.toString(year) + doyString)) continue;
            String sourceProductFileName = brdfDir + File.separator + brdfFileName;
            return ProductIO.readProduct((String)sourceProductFileName);
        }
        return null;
    }

    private static List<String> getSpectralBrdfProductNames(String[] brdfFiles, boolean snow, String subTileString) {
        ArrayList<String> brdfFileList = new ArrayList<String>();
        for (String s : brdfFiles) {
            if ((snow || !s.contains(".NoSnow") || !s.contains(subTileString) || !s.endsWith(".nc")) && (!snow || !s.contains(".Snow") || !s.contains(subTileString) || !s.endsWith(".nc"))) continue;
            brdfFileList.add(s);
        }
        Collections.sort(brdfFileList);
        return brdfFileList;
    }
}

