/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

import Jama.Matrix;
import java.awt.Rectangle;
import java.io.File;
import java.util.logging.Level;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProducts;
import org.esa.beam.globalbedo.inversion.Accumulator;
import org.esa.beam.globalbedo.inversion.AlbedoInversionConstants;
import org.esa.beam.globalbedo.inversion.spectral.SpectralInversionUtils;
import org.esa.beam.globalbedo.inversion.util.DailyAccumulationUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.inversion.dailyaccbinary.spectral", description="Provides spectral daily accumulation of single SDR observations", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class SpectralDailyAccumulationOp
extends Operator {
    @SourceProducts(description="SDR source products")
    private Product[] sourceProducts;
    @Parameter(description="Sub tiling factor (e.g. 4 for 300x300 subtile size")
    private int subtileFactor;
    @Parameter(defaultValue="7", description="Number of spectral bands (7 for standard MODIS spectral mapping")
    private int numSdrBands;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="false", description="Debug - run additional parts of code if needed.")
    private boolean debug;
    @Parameter(description="Daily accumulator binary file")
    private File dailyAccumulatorBinaryFile;
    private static final int sourceSampleOffset = 100;
    private float[][][] resultArray;
    private Tile[][] sdrTiles;
    private Tile[][] sigmaSdrTiles;
    private Tile[] kvolTile;
    private Tile[] kgeoTile;
    private Tile[] snowMaskTile;
    private int currentSourceProductIndex;
    private int numSigmaSdrBands;
    private int[] sigmaSdrDiagonalIndices;
    private int[] sigmaSdrURIndices;
    int subtileWidth;
    int subtileHeight;

    public void initialize() throws OperatorException {
        this.subtileWidth = 1200 / this.subtileFactor;
        this.subtileHeight = 1200 / this.subtileFactor;
        Rectangle sourceRect = new Rectangle(0, 0, this.subtileWidth, this.subtileHeight);
        this.sdrTiles = new Tile[this.sourceProducts.length][this.numSdrBands];
        this.numSigmaSdrBands = this.numSdrBands;
        this.sigmaSdrTiles = new Tile[this.sourceProducts.length][this.numSigmaSdrBands];
        String[] sdrBandNames = SpectralInversionUtils.getSdrBandNames(this.numSdrBands);
        String[] sigmaSdrBandNames = SpectralInversionUtils.getSigmaSdrBandNames(this.numSigmaSdrBands);
        this.kvolTile = new Tile[this.sourceProducts.length];
        this.kgeoTile = new Tile[this.sourceProducts.length];
        this.snowMaskTile = new Tile[this.sourceProducts.length];
        int resultArrayElements = 464;
        this.resultArray = new float[464][this.subtileWidth][this.subtileHeight];
        for (int k = 0; k < this.sourceProducts.length; ++k) {
            int sdrIndex = 0;
            for (int j = 0; j < this.numSdrBands; ++j) {
                this.sdrTiles[k][j] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand(sdrBandNames[sdrIndex++]), sourceRect);
            }
            int sigmaSdrIndex = 0;
            for (int j = 0; j < this.numSigmaSdrBands; ++j) {
                this.sigmaSdrTiles[k][j] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand(sigmaSdrBandNames[sigmaSdrIndex++]), sourceRect);
            }
            this.kvolTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand(AlbedoInversionConstants.CONSTANT_KERNEL_BAND_NAMES[0]), sourceRect);
            this.kgeoTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand(AlbedoInversionConstants.CONSTANT_KERNEL_BAND_NAMES[1]), sourceRect);
            this.snowMaskTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("snow_mask"), sourceRect);
        }
        for (int x = 0; x < 1200 / this.subtileFactor; ++x) {
            for (int y = 0; y < 1200 / this.subtileFactor; ++y) {
                this.accumulate(x, y);
            }
        }
        BeamLogManager.getSystemLogger().log(Level.INFO, "all pixels processed.");
        BeamLogManager.getSystemLogger().log(Level.INFO, "...writing accumulator result array...");
        IOUtils.writeFloatArrayToFile(this.dailyAccumulatorBinaryFile, this.resultArray);
        BeamLogManager.getSystemLogger().log(Level.INFO, "accumulator result array written.");
        this.setTargetProduct(new Product("n", "d", 1, 1));
    }

    private void accumulate(int x, int y) {
        Matrix M = new Matrix(3 * this.numSdrBands, 3 * this.numSdrBands);
        Matrix V = new Matrix(3 * this.numSdrBands, 1);
        Matrix E = new Matrix(1, 1);
        double mask = 0.0;
        int k = 0;
        while (k < this.sourceProducts.length) {
            this.currentSourceProductIndex = k++;
            Accumulator accumulator = this.getMatricesPerSDRDataset(x, y);
            M.plusEquals(accumulator.getM());
            V.plusEquals(accumulator.getV());
            E.plusEquals(accumulator.getE());
            mask += accumulator.getMask();
        }
        Accumulator finalAccumulator = new Accumulator(M, V, E, mask);
        this.fillBinaryResultArray(finalAccumulator, x, y);
    }

    private Accumulator getMatricesPerSDRDataset(int x, int y) {
        int k;
        int j;
        Matrix sdr = this.getSDR(x, y);
        double[] stdev = this.getSD(x, y);
        Matrix kernels = this.getKernels(x, y);
        if (this.isSnowFilter(x, y) || DailyAccumulationUtils.isAccumulatorInputInvalid(sdr, stdev, kernels)) {
            return this.getZeroAccumulator();
        }
        Matrix C = new Matrix(this.numSdrBands * this.numSdrBands, 1);
        Matrix thisC = new Matrix(this.numSdrBands, this.numSdrBands);
        int count = 0;
        int cCount = 0;
        for (j = 0; j < this.numSdrBands; ++j) {
            for (k = j + 1; k < this.numSdrBands; ++k) {
                if (k == j + 1) {
                    ++cCount;
                }
                C.set(cCount, 0, 0.0);
                ++count;
                ++cCount;
            }
        }
        cCount = 0;
        for (j = 0; j < this.numSdrBands; ++j) {
            C.set(cCount, 0, stdev[j] * stdev[j]);
            cCount = cCount + this.numSdrBands - j;
        }
        count = 0;
        for (j = 0; j < this.numSdrBands; ++j) {
            for (k = j; k < this.numSdrBands; ++k) {
                thisC.set(j, k, C.get(count, 0));
                thisC.set(k, j, thisC.get(j, k));
                ++count;
            }
        }
        if (thisC.lu().isNonsingular()) {
            Matrix inverseC = thisC.inverse();
            Matrix M = kernels.transpose().times(inverseC).times(kernels);
            Matrix inverseCDiagFlat = DailyAccumulationUtils.getRectangularDiagonalMatrix(inverseC);
            Matrix kernelTimesInvCDiag = kernels.transpose().times(inverseCDiagFlat);
            Matrix V = kernelTimesInvCDiag.times(sdr);
            Matrix E = sdr.transpose().times(inverseC).times(sdr);
            return new Accumulator(M, V, E, 1.0);
        }
        return this.getZeroAccumulator();
    }

    private Accumulator getZeroAccumulator() {
        Matrix zeroM = new Matrix(3 * this.numSdrBands, 3 * this.numSdrBands);
        Matrix zeroV = new Matrix(3 * this.numSdrBands, 1);
        Matrix zeroE = new Matrix(1, 1);
        return new Accumulator(zeroM, zeroV, zeroE, 0.0);
    }

    private Matrix getSDR(int x, int y) {
        Matrix sdr = new Matrix(this.numSdrBands, 1);
        for (int j = 0; j < this.numSdrBands; ++j) {
            sdr.set(j, 0, this.sdrTiles[this.currentSourceProductIndex][j].getSampleDouble(x, y));
        }
        return sdr;
    }

    private double[] getSD(int x, int y) {
        double[] SD = new double[this.numSdrBands];
        for (int j = 0; j < this.numSdrBands; ++j) {
            SD[j] = this.sigmaSdrTiles[this.currentSourceProductIndex][j].getSampleDouble(x, y);
        }
        return SD;
    }

    private void fillBinaryResultArray(Accumulator accumulator, int x, int y) {
        int i;
        int offset = 0;
        for (i = 0; i < 3 * this.numSdrBands; ++i) {
            for (int j = 0; j < 3 * this.numSdrBands; ++j) {
                this.resultArray[offset++][x][y] = (float)accumulator.getM().get(i, j);
            }
        }
        for (i = 0; i < 3 * this.numSdrBands; ++i) {
            this.resultArray[offset++][x][y] = (float)accumulator.getV().get(i, 0);
        }
        this.resultArray[offset++][x][y] = (float)accumulator.getE().get(0, 0);
        this.resultArray[offset][x][y] = (float)accumulator.getMask();
    }

    private Matrix getKernels(int x, int y) {
        Matrix kernels = new Matrix(this.numSdrBands, 3 * this.numSdrBands);
        for (int i = 0; i < this.numSdrBands; ++i) {
            for (int j = 0; j < 3 * this.numSdrBands; ++j) {
                if (j % 3 == 0 && j / 3 == i) {
                    kernels.set(i, j, 1.0);
                    continue;
                }
                if ((j - 1) % 3 == 0 && (j - 1) / 3 == i) {
                    kernels.set(i, j, this.kvolTile[this.currentSourceProductIndex].getSampleDouble(x, y));
                    continue;
                }
                if ((j - 2) % 3 != 0 || (j - 2) / 3 != i) continue;
                kernels.set(i, j, this.kgeoTile[this.currentSourceProductIndex].getSampleDouble(x, y));
            }
        }
        return kernels;
    }

    private boolean isSnowFilter(int x, int y) {
        return this.computeSnow && this.snowMaskTile[this.currentSourceProductIndex].getSampleInt(x, y) != 1 || !this.computeSnow && this.snowMaskTile[this.currentSourceProductIndex].getSampleInt(x, y) == 1;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SpectralDailyAccumulationOp.class);
        }
    }
}

