/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

import Jama.LUDecomposition;
import Jama.Matrix;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.pointop.PixelOperator;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.globalbedo.inversion.AlbedoResult;
import org.esa.beam.globalbedo.inversion.spectral.SpectralIOUtils;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;

@OperatorMetadata(alias="ga.albedo.albedo.spectral", description="Provides final spectral albedo from spectral BRDF files", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class SpectralBrdfToAlbedoOp
extends PixelOperator {
    @SourceProduct(description="Spectral BRDF product")
    private Product spectralBrdfProduct;
    @Parameter(description="doy", interval="[1,366]")
    private int doy;
    @Parameter(defaultValue="7", description="Number of spectral bands (7 for standard MODIS spectral mapping")
    private int numSdrBands;
    private static final int SRC_ENTROPY = 0;
    private static final int SRC_REL_ENTROPY = 1;
    private static final int SRC_WEIGHTED_NUM_SAMPLES = 2;
    private static final int SRC_DAYS_CLOSEST_SAMPLE = 3;
    private static final int SRC_GOODNESS_OF_FIT = 4;
    private static final int SRC_PROPORTION_NSAMPLE = 5;
    private int[] srcParameters;
    private int[] srcUncertainties;
    private String[] dhrBandNames;
    private String[] bhrBandNames;
    private String[][] dhrAlphaBandNames;
    private String[][] bhrAlphaBandNames;
    private String[] dhrSigmaBandNames;
    private String[] bhrSigmaBandNames;
    private String relEntropyBandName;
    private String weightedNumberOfSamplesBandName;
    private String goodnessOfFitBandName;
    private String snowFractionBandName;
    private String dataMaskBandName;
    private String szaBandName;
    private String[] parameterBandNames;
    private String[][] uncertaintyBandNames;
    private Map<Integer, String> spectralWaveBandsMap = new HashMap<Integer, String>();
    private int numAlphaTerms;

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        this.setupSpectralWaveBandsMap(this.numSdrBands);
        this.srcParameters = new int[3 * this.numSdrBands];
        int urMatrixOffset = ((int)Math.pow(3 * this.numSdrBands, 2.0) + 3 * this.numSdrBands) / 2;
        this.srcUncertainties = new int[urMatrixOffset];
        this.numAlphaTerms = ((this.numSdrBands - 1) * (this.numSdrBands - 1) - (this.numSdrBands - 1)) / 2 + (this.numSdrBands - 1);
        this.dhrBandNames = new String[this.numSdrBands];
        this.bhrBandNames = new String[this.numSdrBands];
        this.dhrAlphaBandNames = new String[this.numSdrBands - 1][this.numSdrBands - 1];
        this.bhrAlphaBandNames = new String[this.numSdrBands - 1][this.numSdrBands - 1];
        this.dhrSigmaBandNames = new String[this.numSdrBands];
        this.bhrSigmaBandNames = new String[this.numSdrBands];
        this.parameterBandNames = SpectralIOUtils.getSpectralInversionParameterBandNames(this.numSdrBands);
        this.uncertaintyBandNames = SpectralIOUtils.getSpectralInversionUncertaintyBandNames(this.numSdrBands, this.spectralWaveBandsMap);
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        int i;
        double relEntropy;
        PixelPos pixelPos = new PixelPos((float)x, (float)y);
        GeoPos latLon = this.spectralBrdfProduct.getGeoCoding().getGeoPos(pixelPos, null);
        double SZAdeg = AlbedoInversionUtils.computeSza(latLon, this.doy);
        double SZA = SZAdeg * (Math.PI / 180);
        if (x == 40 && y == 160) {
            System.out.println("x = " + x);
        }
        Matrix C = this.getCMatrixFromSpectralInversionProduct(sourceSamples);
        Matrix[] sigmaBHR = new Matrix[this.numSdrBands];
        Matrix[] sigmaDHR = new Matrix[this.numSdrBands];
        Matrix[] uWsa = new Matrix[this.numSdrBands];
        Matrix[] uBsa = new Matrix[this.numSdrBands];
        for (int i2 = 0; i2 < this.numSdrBands; ++i2) {
            uWsa[i2] = new Matrix(1, 3 * this.numSdrBands);
            uBsa[i2] = new Matrix(1, 3 * this.numSdrBands);
            sigmaBHR[i2] = new Matrix(1, 1, -9999.0);
            sigmaDHR[i2] = new Matrix(1, 1, -9999.0);
        }
        double[] uWsaArray = new double[]{1.0, 0.189184, -1.377622};
        for (int i3 = 0; i3 < this.numSdrBands; ++i3) {
            for (int j = 0; j < 3; ++j) {
                uWsa[i3].set(0, 3 * i3 + j, uWsaArray[j]);
            }
        }
        int numParams = this.numSdrBands * 3;
        double[] fParams = new double[numParams];
        for (int i4 = 0; i4 < numParams; ++i4) {
            fParams[i4] = sourceSamples[i4].getDouble();
        }
        double[] DHR = new double[this.numSdrBands];
        for (int i5 = 0; i5 < DHR.length; ++i5) {
            DHR[i5] = AlbedoInversionUtils.isValid(fParams[3 * i5]) && AlbedoInversionUtils.isValid(fParams[1 + 3 * i5]) && AlbedoInversionUtils.isValid(fParams[2 + 3 * i5]) ? fParams[3 * i5] + fParams[1 + 3 * i5] * uBsa[i5].get(0, 3 * i5 + 1) + fParams[2 + 3 * i5] * uBsa[i5].get(0, 3 * i5 + 2) : -9999.0;
        }
        double[] BHR = new double[this.numSdrBands];
        for (int i6 = 0; i6 < BHR.length; ++i6) {
            BHR[i6] = AlbedoInversionUtils.isValid(fParams[3 * i6]) && AlbedoInversionUtils.isValid(fParams[1 + 3 * i6]) && AlbedoInversionUtils.isValid(fParams[2 + 3 * i6]) ? fParams[3 * i6] + fParams[1 + 3 * i6] * uWsa[i6].get(0, 3 * i6 + 1) + fParams[2 + 3 * i6] * uWsa[i6].get(0, 3 * i6 + 2) : -9999.0;
        }
        double maskEntropyDataValue = sourceSamples[this.srcParameters.length + this.srcUncertainties.length + 0].getDouble();
        if (AlbedoInversionUtils.isValid(maskEntropyDataValue)) {
            LUDecomposition cLUD = new LUDecomposition(C.transpose());
            if (cLUD.isNonsingular()) {
                int i7;
                int i8;
                for (i8 = 0; i8 < this.numSdrBands; ++i8) {
                    sigmaBHR[i8] = uWsa[i8].times(C.transpose()).times(uWsa[i8].transpose());
                }
                for (i8 = 0; i8 < this.numSdrBands; ++i8) {
                    uBsa[i8] = new Matrix(1, 3 * this.numSdrBands);
                }
                double[] uBsaArray = new double[]{1.0, -0.007574 + -0.070887 * Math.pow(SZA, 2.0) + 0.307588 * Math.pow(SZA, 3.0), -1.284909 + -0.166314 * Math.pow(SZA, 2.0) + 0.04184 * Math.pow(SZA, 3.0)};
                for (i7 = 0; i7 < this.numSdrBands; ++i7) {
                    for (int j = 0; j < 3; ++j) {
                        uBsa[i7].set(0, 3 * i7 + j, uBsaArray[j]);
                    }
                }
                for (i7 = 0; i7 < this.numSdrBands; ++i7) {
                    sigmaDHR[i7] = uBsa[i7].times(C.transpose()).times(uBsa[i7].transpose());
                }
            } else {
                for (int i9 = 0; i9 < this.numSdrBands; ++i9) {
                    sigmaBHR[i9].set(0, 0, Math.abs(0.03 * BHR[i9]));
                    sigmaDHR[i9].set(0, 0, Math.abs(0.03 * DHR[i9]));
                }
            }
        }
        if (AlbedoInversionUtils.isValid(relEntropy = sourceSamples[this.srcParameters.length + this.srcUncertainties.length + 1].getDouble())) {
            relEntropy = Math.exp(relEntropy / 9.0);
        }
        double[] alphaDHR = new double[this.numAlphaTerms];
        double[] alphaBHR = new double[this.numAlphaTerms];
        if (AlbedoInversionUtils.isValid(maskEntropyDataValue)) {
            alphaDHR = this.computeSpectralAlphaDHR(SZA, C);
            alphaBHR = this.computeSpectralAlphaBHR(C);
        } else {
            for (i = 0; i < this.numAlphaTerms; ++i) {
                alphaDHR[i] = -9999.0;
                alphaBHR[i] = -9999.0;
            }
        }
        for (i = 0; i < this.numSdrBands; ++i) {
            double bsa;
            double wsa = sigmaBHR[i].get(0, 0);
            if (AlbedoInversionUtils.isValid(wsa)) {
                sigmaBHR[i].set(0, 0, Math.min(1.0, Math.sqrt(wsa)));
            }
            if (!AlbedoInversionUtils.isValid(bsa = sigmaDHR[i].get(0, 0))) continue;
            sigmaDHR[i].set(0, 0, Math.min(1.0, Math.sqrt(bsa)));
        }
        double weightedNumberOfSamples = sourceSamples[this.srcParameters.length + this.srcUncertainties.length + 2].getDouble();
        double goodnessOfFit = sourceSamples[this.srcParameters.length + this.srcUncertainties.length + 4].getDouble();
        double snowFraction = sourceSamples[this.srcParameters.length + this.srcUncertainties.length + 5].getDouble();
        double entropy = sourceSamples[this.srcParameters.length + this.srcUncertainties.length + 0].getDouble();
        double maskEntropy = AlbedoInversionUtils.isValid(entropy) ? 1.0 : 0.0;
        AlbedoResult result = new AlbedoResult(DHR, alphaDHR, sigmaDHR, BHR, alphaBHR, sigmaBHR, weightedNumberOfSamples, relEntropy, goodnessOfFit, snowFraction, maskEntropy, SZAdeg);
        this.fillTargetSamples(targetSamples, result);
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        int j;
        int i;
        Product targetProduct = productConfigurer.getTargetProduct();
        this.dhrBandNames = SpectralIOUtils.getSpectralAlbedoDhrBandNames(this.numSdrBands, this.spectralWaveBandsMap);
        for (i = 0; i < this.numSdrBands; ++i) {
            targetProduct.addBand(this.dhrBandNames[i], 30);
        }
        this.dhrAlphaBandNames = SpectralIOUtils.getSpectralAlbedoAlphaBandNames("DHR", this.numSdrBands, this.spectralWaveBandsMap);
        for (i = 0; i < this.numSdrBands - 1; ++i) {
            for (j = i; j < this.numSdrBands - 1; ++j) {
                targetProduct.addBand(this.dhrAlphaBandNames[i][j], 30);
            }
        }
        this.dhrSigmaBandNames = SpectralIOUtils.getSpectralAlbedoDhrSigmaBandNames(this.numSdrBands, this.spectralWaveBandsMap);
        for (i = 0; i < this.numSdrBands; ++i) {
            targetProduct.addBand(this.dhrSigmaBandNames[i], 30);
        }
        this.bhrBandNames = SpectralIOUtils.getSpectralAlbedoBhrBandNames(this.numSdrBands, this.spectralWaveBandsMap);
        for (i = 0; i < this.numSdrBands; ++i) {
            targetProduct.addBand(this.bhrBandNames[i], 30);
        }
        this.bhrAlphaBandNames = SpectralIOUtils.getSpectralAlbedoAlphaBandNames("BHR", this.numSdrBands, this.spectralWaveBandsMap);
        for (i = 0; i < this.numSdrBands - 1; ++i) {
            for (j = i; j < this.numSdrBands - 1; ++j) {
                targetProduct.addBand(this.bhrAlphaBandNames[i][j], 30);
            }
        }
        this.bhrSigmaBandNames = SpectralIOUtils.getSpectralAlbedoBhrSigmaBandNames(this.numSdrBands, this.spectralWaveBandsMap);
        for (i = 0; i < this.numSdrBands; ++i) {
            targetProduct.addBand(this.bhrSigmaBandNames[i], 30);
        }
        this.weightedNumberOfSamplesBandName = "Weighted_Number_of_Samples";
        targetProduct.addBand(this.weightedNumberOfSamplesBandName, 30);
        this.relEntropyBandName = "Relative_Entropy";
        targetProduct.addBand(this.relEntropyBandName, 30);
        this.goodnessOfFitBandName = "Goodness_of_Fit";
        targetProduct.addBand(this.goodnessOfFitBandName, 30);
        this.snowFractionBandName = "Snow_Fraction";
        targetProduct.addBand(this.snowFractionBandName, 30);
        this.dataMaskBandName = "Data_Mask";
        targetProduct.addBand(this.dataMaskBandName, 30);
        this.szaBandName = "Solar_Zenith_Angle";
        targetProduct.addBand(this.szaBandName, 30);
        for (Band b : targetProduct.getBands()) {
            b.setNoDataValue(-9999.0);
            b.setNoDataValueUsed(true);
        }
        for (Band b : targetProduct.getBands()) {
            b.setValidPixelExpression("Weighted_Number_of_Samples > 0.0");
        }
    }

    protected void configureSourceSamples(SampleConfigurer configurator) throws OperatorException {
        this.parameterBandNames = SpectralIOUtils.getSpectralInversionParameterBandNames(this.numSdrBands);
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            this.srcParameters[i] = i;
            configurator.defineSample(this.srcParameters[i], this.parameterBandNames[i], this.spectralBrdfProduct);
        }
        int index = 0;
        this.uncertaintyBandNames = SpectralIOUtils.getSpectralInversionUncertaintyBandNames(this.numSdrBands, this.spectralWaveBandsMap);
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            for (int j = i; j < 3 * this.numSdrBands; ++j) {
                this.srcUncertainties[index] = index;
                configurator.defineSample(this.srcParameters.length + this.srcUncertainties[index], this.uncertaintyBandNames[i][j], this.spectralBrdfProduct);
                ++index;
            }
        }
        String entropyBandName = "Entropy";
        configurator.defineSample(this.srcParameters.length + this.srcUncertainties.length + 0, entropyBandName, this.spectralBrdfProduct);
        this.relEntropyBandName = "Relative_Entropy";
        configurator.defineSample(this.srcParameters.length + this.srcUncertainties.length + 1, this.relEntropyBandName, this.spectralBrdfProduct);
        this.weightedNumberOfSamplesBandName = "Weighted_Number_of_Samples";
        configurator.defineSample(this.srcParameters.length + this.srcUncertainties.length + 2, this.weightedNumberOfSamplesBandName, this.spectralBrdfProduct);
        configurator.defineSample(this.srcParameters.length + this.srcUncertainties.length + 3, "Time_to_the_Closest_Sample", this.spectralBrdfProduct);
        this.goodnessOfFitBandName = "Goodness_of_Fit";
        configurator.defineSample(this.srcParameters.length + this.srcUncertainties.length + 4, this.goodnessOfFitBandName, this.spectralBrdfProduct);
        String proportionNsamplesBandName = "Proportion_NSamples";
        configurator.defineSample(this.srcParameters.length + this.srcUncertainties.length + 5, proportionNsamplesBandName, this.spectralBrdfProduct);
    }

    protected void configureTargetSamples(SampleConfigurer configurator) throws OperatorException {
        int j;
        int i;
        int index = 0;
        for (i = 0; i < this.numSdrBands; ++i) {
            configurator.defineSample(index++, this.dhrBandNames[i]);
        }
        for (i = 0; i < this.numSdrBands - 1; ++i) {
            for (j = i; j < this.numSdrBands - 1; ++j) {
                configurator.defineSample(index++, this.dhrAlphaBandNames[i][j]);
            }
        }
        for (i = 0; i < this.numSdrBands; ++i) {
            configurator.defineSample(index++, this.bhrBandNames[i]);
        }
        for (i = 0; i < this.numSdrBands - 1; ++i) {
            for (j = i; j < this.numSdrBands - 1; ++j) {
                configurator.defineSample(index++, this.bhrAlphaBandNames[i][j]);
            }
        }
        for (i = 0; i < this.numSdrBands; ++i) {
            configurator.defineSample(index++, this.dhrSigmaBandNames[i]);
        }
        for (i = 0; i < this.numSdrBands; ++i) {
            configurator.defineSample(index++, this.bhrSigmaBandNames[i]);
        }
        configurator.defineSample(index++, this.weightedNumberOfSamplesBandName);
        configurator.defineSample(index++, this.relEntropyBandName);
        configurator.defineSample(index++, this.goodnessOfFitBandName);
        configurator.defineSample(index++, this.snowFractionBandName);
        configurator.defineSample(index++, this.dataMaskBandName);
        configurator.defineSample(index, this.szaBandName);
    }

    private void setupSpectralWaveBandsMap(int numSdrBands) {
        for (int i = 0; i < numSdrBands; ++i) {
            this.spectralWaveBandsMap.put(i, "b" + (i + 1));
        }
    }

    private double[] computeSpectralAlphaDHR(double SZA, Matrix c) {
        double[] alphaDHR = new double[this.numAlphaTerms];
        for (int i = 0; i < this.numAlphaTerms; ++i) {
            alphaDHR[i] = -9999.0;
        }
        return alphaDHR;
    }

    private double[] computeSpectralAlphaBHR(Matrix c) {
        double[] alphaBHR = new double[this.numAlphaTerms];
        for (int i = 0; i < this.numAlphaTerms; ++i) {
            alphaBHR[i] = -9999.0;
        }
        return alphaBHR;
    }

    private void fillTargetSamples(WritableSample[] targetSamples, AlbedoResult result) {
        int i;
        int i2;
        int index = 0;
        for (int i3 = 0; i3 < this.numSdrBands; ++i3) {
            targetSamples[index++].set(result.getBsa()[i3]);
        }
        int dhrAlphaIndex = 0;
        for (i2 = 0; i2 < this.numSdrBands - 1; ++i2) {
            for (int j = i2; j < this.numSdrBands - 1; ++j) {
                targetSamples[index++].set(result.getBsaAlpha()[dhrAlphaIndex++]);
            }
        }
        for (i2 = 0; i2 < this.numSdrBands; ++i2) {
            targetSamples[index++].set(result.getWsa()[i2]);
        }
        int bhrAlphaIndex = 0;
        for (i = 0; i < this.numSdrBands - 1; ++i) {
            for (int j = i; j < this.numSdrBands - 1; ++j) {
                targetSamples[index++].set(result.getWsaAlpha()[bhrAlphaIndex++]);
            }
        }
        for (i = 0; i < this.numSdrBands; ++i) {
            targetSamples[index++].set(result.getBsaSigma()[i].get(0, 0));
        }
        for (i = 0; i < this.numSdrBands; ++i) {
            targetSamples[index++].set(result.getWsaSigma()[i].get(0, 0));
        }
        targetSamples[index++].set(result.getWeightedNumberOfSamples());
        targetSamples[index++].set(result.getRelEntropy());
        targetSamples[index++].set(result.getGoodnessOfFit());
        targetSamples[index++].set(result.getSnowFraction());
        targetSamples[index++].set(result.getDataMask());
        targetSamples[index].set(result.getSza());
    }

    private Matrix getCMatrixFromSpectralInversionProduct(Sample[] sourceSamples) {
        int n = this.numSdrBands * this.numSdrBands;
        Matrix C = new Matrix(n, n);
        double[] cTmp = new double[this.srcUncertainties.length];
        int index = 0;
        for (int i = 0; i < this.srcUncertainties.length; ++i) {
            double sampleUncertainty;
            cTmp[i] = sampleUncertainty = sourceSamples[this.srcParameters.length + index].getDouble();
            ++index;
        }
        int index2 = 0;
        for (int k = n; k > 0; --k) {
            int index1;
            if (k == n) {
                index1 = n;
                index2 = 2 * index1 - 1;
            } else {
                index1 = index2 + 1;
                index2 += k;
            }
            for (int i = 0; i < k; ++i) {
                int finalIndex = (index1 - n) / 7 + i;
                C.set(n - k, n - k + i, cTmp[finalIndex]);
                C.set(n - k + i, n - k, cTmp[finalIndex]);
            }
        }
        return C;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SpectralBrdfToAlbedoOp.class);
        }
    }
}

