/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

import Jama.Matrix;

public class SpectralAccumulator {
    private Matrix M;
    private Matrix V;
    private Matrix E;
    private double mask;

    public SpectralAccumulator(Matrix m, Matrix v, Matrix e, double mask) {
        this.M = m;
        this.V = v;
        this.E = e;
        this.mask = mask;
    }

    public static SpectralAccumulator createForInversion(float[][][] sumMatrices, int x, int y, int numWaveBands) {
        int i;
        Matrix M = new Matrix(3 * numWaveBands, 3 * numWaveBands);
        Matrix V = new Matrix(3 * numWaveBands, 1);
        Matrix E = new Matrix(1, 1);
        int index = 0;
        for (i = 0; i < 3 * numWaveBands; ++i) {
            for (int j = 0; j < 3 * numWaveBands; ++j) {
                M.set(i, j, (double)sumMatrices[index++][x][y]);
            }
        }
        for (i = 0; i < 3 * numWaveBands; ++i) {
            V.set(i, 0, (double)sumMatrices[index++][x][y]);
        }
        E.set(0, 0, (double)sumMatrices[index++][x][y]);
        double mask = sumMatrices[index][x][y];
        return new SpectralAccumulator(M, V, E, mask);
    }

    private static SpectralAccumulator createZeroAccumulator(int numWaveBands) {
        Matrix zeroM = new Matrix(3 * numWaveBands, 3 * numWaveBands);
        Matrix zeroV = new Matrix(3 * numWaveBands, 1);
        Matrix zeroE = new Matrix(1, 1);
        return new SpectralAccumulator(zeroM, zeroV, zeroE, 0.0);
    }

    public Matrix getM() {
        return this.M;
    }

    public Matrix getV() {
        return this.V;
    }

    public Matrix getE() {
        return this.E;
    }

    public double getMask() {
        return this.mask;
    }

    public void setM(Matrix m) {
        this.M = m;
    }

    public void setV(Matrix v) {
        this.V = v;
    }

    public void setE(Matrix e) {
        this.E = e;
    }

    public void setMask(double mask) {
        this.mask = mask;
    }
}

