/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.pointop.PixelOperator;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.globalbedo.inversion.spectral.SpectralIOUtils;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;

@OperatorMetadata(alias="ga.albedo.mergebrdf.spectral", description="Merges spectral BRDF Snow/NoSnow products.", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class MergeSpectralBrdfOp
extends PixelOperator {
    private static final int SRC_SNOW_ENTROPY = 0;
    private static final int SRC_NOSNOW_ENTROPY = 0;
    private static final int SRC_SNOW_REL_ENTROPY = 1;
    private static final int SRC_NOSNOW_REL_ENTROPY = 1;
    private static final int SRC_SNOW_WEIGHTED_NUM_SAMPLES = 2;
    private static final int SRC_NOSNOW_WEIGHTED_NUM_SAMPLES = 2;
    private static final int SRC_SNOW_DAYS_CLOSEST_SAMPLE = 3;
    private static final int SRC_NOSNOW_DAYS_CLOSEST_SAMPLE = 3;
    private static final int SRC_SNOW_GOODNESS_OF_FIT = 4;
    private static final int SRC_NOSNOW_GOODNESS_OF_FIT = 4;
    private static final int sourceSampleOffset = 300;
    private static final int TRG_ENTROPY = 0;
    private static final int TRG_REL_ENTROPY = 1;
    private static final int TRG_WEIGHTED_NUM_SAMPLES = 2;
    private static final int TRG_DAYS_CLOSEST_SAMPLE = 3;
    private static final int TRG_GOODNESS_OF_FIT = 4;
    private static final int TRG_PROPORTION_NSAMPLES = 5;
    private String[] parameterBandNames;
    private String[][] uncertaintyBandNames;
    private String entropyBandName;
    private String relEntropyBandName;
    private String weightedNumberOfSamplesBandName;
    private String daysToTheClosestSampleBandName;
    private String goodnessOfFitBandName;
    private String proportionNsamplesBandName;
    private int[] srcSnowParams;
    private int[] srcSnowUncertainties;
    private int[] srcNoSnowParams;
    private int[] srcNoSnowUncertainties;
    private int[] trgParameters;
    private int[] trgUncertainties;
    private Map<Integer, String> spectralWaveBandsMap = new HashMap<Integer, String>();
    @SourceProduct(description="BRDF Snow product")
    private Product snowProduct;
    @SourceProduct(description="BRDF NoSnow product")
    private Product noSnowProduct;
    @Parameter(defaultValue="7", description="Number of spectral bands (7 for standard MODIS spectral mapping")
    private int numSdrBands;

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        this.setupSpectralWaveBandsMap(this.numSdrBands);
        this.srcSnowParams = new int[3 * this.numSdrBands];
        this.srcNoSnowParams = new int[3 * this.numSdrBands];
        int urMatrixOffset = ((int)Math.pow(3 * this.numSdrBands, 2.0) + 3 * this.numSdrBands) / 2;
        this.srcSnowUncertainties = new int[urMatrixOffset];
        this.srcNoSnowUncertainties = new int[urMatrixOffset];
        this.trgParameters = new int[3 * this.numSdrBands];
        this.trgUncertainties = new int[urMatrixOffset];
        this.parameterBandNames = new String[3 * this.numSdrBands];
        this.uncertaintyBandNames = new String[3 * this.numSdrBands][3 * this.numSdrBands];
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        double entropyNoSnow;
        int snowOffset = 6 * this.numSdrBands + 5;
        double nSamplesSnowDataValue = sourceSamples[6 * this.numSdrBands + 2].getDouble();
        double nSamplesSnow = AlbedoInversionUtils.isValid(nSamplesSnowDataValue) ? nSamplesSnowDataValue : 0.0;
        double nSamplesNoSnowDataValue = sourceSamples[snowOffset + 6 * this.numSdrBands + 2].getDouble();
        double nSamplesNoSnow = AlbedoInversionUtils.isValid(nSamplesNoSnowDataValue) ? nSamplesNoSnowDataValue : 0.0;
        double totalNSamples = nSamplesSnow + nSamplesNoSnow;
        double entropySnowDataValue = sourceSamples[6 * this.numSdrBands + 0].getDouble();
        double entropySnow = AlbedoInversionUtils.isValid(entropySnowDataValue) ? entropySnowDataValue : 0.0;
        double entropyNoSnowDataValue = sourceSamples[snowOffset + 6 * this.numSdrBands + 0].getDouble();
        double d = entropyNoSnow = AlbedoInversionUtils.isValid(entropyNoSnowDataValue) ? entropyNoSnowDataValue : 0.0;
        if (!(!(totalNSamples > 0.0) || this.areSnowSamplesZero() && this.areNoSnowSamplesZero())) {
            double proportionNsamplesNoSnow = nSamplesNoSnow / totalNSamples;
            double proportionNsamplesSnow = nSamplesSnow / totalNSamples;
            this.setMergedBands(sourceSamples, targetSamples, proportionNsamplesSnow, proportionNsamplesNoSnow);
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 5].set(proportionNsamplesSnow);
        } else if (entropySnow != 0.0 && entropyNoSnow != 0.0) {
            if (entropySnow <= entropyNoSnow) {
                this.setMergedBandsToSnowBands(sourceSamples, targetSamples);
                targetSamples[this.trgParameters.length + this.trgUncertainties.length + 5].set(1.0);
            } else {
                this.setMergedBandsToNoSnowBands(sourceSamples, targetSamples);
                targetSamples[this.trgParameters.length + this.trgUncertainties.length + 5].set(0.0);
            }
        } else {
            this.setMergedBandsToZero(sourceSamples, targetSamples);
            targetSamples[5].set(-9999.0f);
        }
    }

    private boolean areSnowSamplesZero() {
        for (int SRC_SNOW_PARAMETER : this.srcSnowParams) {
            if (!((double)SRC_SNOW_PARAMETER > 0.0)) continue;
            return false;
        }
        return true;
    }

    private boolean areNoSnowSamplesZero() {
        for (int SRC_NOSNOW_PARAMETER : this.srcNoSnowParams) {
            if (!((double)SRC_NOSNOW_PARAMETER > 0.0)) continue;
            return false;
        }
        return true;
    }

    private void setMergedBandsToSnowBands(Sample[] sourceSamples, WritableSample[] targetSamples) {
        this.setMergedBands(sourceSamples, targetSamples, 1.0, 0.0);
    }

    private void setMergedBandsToZero(Sample[] sourceSamples, WritableSample[] targetSamples) {
        this.setMergedBands(sourceSamples, targetSamples, 0.0, 0.0);
    }

    private void setMergedBandsToNoSnowBands(Sample[] sourceSamples, WritableSample[] targetSamples) {
        this.setMergedBands(sourceSamples, targetSamples, 0.0, 1.0);
    }

    private void setMergedBands(Sample[] sourceSamples, WritableSample[] targetSamples, double proportionNsamplesSnow, double proportionNsamplesNoSnow) {
        int snowOffset = 6 * this.numSdrBands + 5;
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            double sampleParameterSnowDataValue = sourceSamples[i].getDouble();
            double sampleParameterSnow = AlbedoInversionUtils.isValid(sampleParameterSnowDataValue) ? sampleParameterSnowDataValue : 0.0;
            double sampleParameterNoSnowDataValue = sourceSamples[snowOffset + i].getDouble();
            double sampleParameterNoSnow = AlbedoInversionUtils.isValid(sampleParameterNoSnowDataValue) ? sampleParameterNoSnowDataValue : 0.0;
            double resultParameters = sampleParameterSnow * proportionNsamplesSnow + sampleParameterNoSnow * proportionNsamplesNoSnow;
            if (sampleParameterNoSnow == 0.0 && sampleParameterSnow == 0.0) {
                targetSamples[this.trgParameters[i]].set(-9999.0f);
                continue;
            }
            targetSamples[this.trgParameters[i]].set(resultParameters);
        }
        int offset = snowOffset + 3 * this.numSdrBands;
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            double sampleUncertaintySnowDataValue = sourceSamples[3 * this.numSdrBands + i].getDouble();
            double sampleUncertaintySnow = AlbedoInversionUtils.isValid(sampleUncertaintySnowDataValue) ? sampleUncertaintySnowDataValue : 0.0;
            double sampleUncertaintyNoSnowDataValue = sourceSamples[offset + i].getDouble();
            double sampleUncertaintyNoSnow = AlbedoInversionUtils.isValid(sampleUncertaintyNoSnowDataValue) ? sampleUncertaintyNoSnowDataValue : 0.0;
            double resultUncertainties = sampleUncertaintySnow * proportionNsamplesSnow + sampleUncertaintyNoSnow * proportionNsamplesNoSnow;
            if (sampleUncertaintySnow == 0.0 && sampleUncertaintyNoSnow == 0.0) {
                targetSamples[3 * this.numSdrBands + i].set(-9999.0f);
                continue;
            }
            targetSamples[3 * this.numSdrBands + i].set(resultUncertainties);
        }
        double sampleEntropySnowDataValue = sourceSamples[6 * this.numSdrBands + 0].getDouble();
        double sampleEntropySnow = AlbedoInversionUtils.isValid(sampleEntropySnowDataValue) ? sampleEntropySnowDataValue : 0.0;
        double sampleEntropyNoSnowDataValue = sourceSamples[snowOffset + 6 * this.numSdrBands + 0].getDouble();
        double sampleEntropyNoSnow = AlbedoInversionUtils.isValid(sampleEntropyNoSnowDataValue) ? sampleEntropyNoSnowDataValue : 0.0;
        double resultEntropy = sampleEntropySnow * proportionNsamplesSnow + sampleEntropyNoSnow * proportionNsamplesNoSnow;
        if (sampleEntropyNoSnow == 0.0 && sampleEntropySnow == 0.0) {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 0].set(-9999.0f);
        } else {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 0].set(resultEntropy);
        }
        double sampleRelEntropySnowDataValue = sourceSamples[6 * this.numSdrBands + 1].getDouble();
        double sampleRelEntropySnow = AlbedoInversionUtils.isValid(sampleRelEntropySnowDataValue) ? sampleRelEntropySnowDataValue : 0.0;
        double sampleRelEntropyNoSnowDataValue = sourceSamples[snowOffset + 6 * this.numSdrBands + 1].getDouble();
        double sampleRelEntropyNoSnow = AlbedoInversionUtils.isValid(sampleRelEntropyNoSnowDataValue) ? sampleRelEntropyNoSnowDataValue : 0.0;
        double resultRelEntropy = sampleRelEntropySnow * proportionNsamplesSnow + sampleRelEntropyNoSnow * proportionNsamplesNoSnow;
        if (sampleRelEntropyNoSnow == 0.0 && sampleRelEntropySnow == 0.0) {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 1].set(-9999.0f);
        } else {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 1].set(resultRelEntropy);
        }
        double sampleWeightedNumSamplesSnowDataValue = sourceSamples[6 * this.numSdrBands + 2].getDouble();
        double sampleWeightedNumSamplesSnow = AlbedoInversionUtils.isValid(sampleWeightedNumSamplesSnowDataValue) ? sampleWeightedNumSamplesSnowDataValue : 0.0;
        double sampleWeightedNumSamplesNoSnowDataValue = sourceSamples[snowOffset + 6 * this.numSdrBands + 2].getDouble();
        double sampleWeightedNumSamplesNoSnow = AlbedoInversionUtils.isValid(sampleWeightedNumSamplesNoSnowDataValue) ? sampleWeightedNumSamplesNoSnowDataValue : 0.0;
        double resultWeightedNumSamples = sampleWeightedNumSamplesSnow * proportionNsamplesSnow + sampleWeightedNumSamplesNoSnow * proportionNsamplesNoSnow;
        if (sampleWeightedNumSamplesNoSnow == 0.0 && sampleWeightedNumSamplesSnow == 0.0) {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 2].set(-9999.0f);
        } else {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 2].set(resultWeightedNumSamples);
        }
        double sampleDoyClosestSampleSnowDataValue = sourceSamples[6 * this.numSdrBands + 3].getDouble();
        double sampleDoyClosestSampleSnow = AlbedoInversionUtils.isValid(sampleDoyClosestSampleSnowDataValue) ? sampleDoyClosestSampleSnowDataValue : 0.0;
        double sampleDoyClosestSampleNoSnowDataValue = sourceSamples[snowOffset + 6 * this.numSdrBands + 3].getDouble();
        double sampleDoyClosestSampleNoSnow = AlbedoInversionUtils.isValid(sampleDoyClosestSampleNoSnowDataValue) ? sampleDoyClosestSampleNoSnowDataValue : 0.0;
        double resultDoyClosestSample = sampleDoyClosestSampleSnow * proportionNsamplesSnow + sampleDoyClosestSampleNoSnow * proportionNsamplesNoSnow;
        if (sampleDoyClosestSampleNoSnow == 0.0 && sampleDoyClosestSampleSnow == 0.0) {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 3].set(-9999.0f);
        } else {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 3].set(resultDoyClosestSample);
        }
        double sampleGoodnessOfFitSnowDataValue = sourceSamples[6 * this.numSdrBands + 4].getDouble();
        double sampleGoodnessOfFitSnow = AlbedoInversionUtils.isValid(sampleGoodnessOfFitSnowDataValue) ? sampleGoodnessOfFitSnowDataValue : 0.0;
        double sampleGoodnessOfFitNoSnowDataValue = sourceSamples[snowOffset + 6 * this.numSdrBands + 4].getDouble();
        double sampleGoodnessOfFitNoSnow = AlbedoInversionUtils.isValid(sampleGoodnessOfFitNoSnowDataValue) ? sampleGoodnessOfFitNoSnowDataValue : 0.0;
        double resultGoodnessOfFit = sampleGoodnessOfFitSnow * proportionNsamplesSnow + sampleGoodnessOfFitNoSnow * proportionNsamplesNoSnow;
        if (sampleGoodnessOfFitNoSnow == 0.0 && sampleGoodnessOfFitSnow == 0.0) {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 4].set(-9999.0f);
        } else {
            targetSamples[this.trgParameters.length + this.trgUncertainties.length + 4].set(resultGoodnessOfFit);
        }
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) throws OperatorException {
        super.configureTargetProduct(productConfigurer);
        Product targetProduct = productConfigurer.getTargetProduct();
        for (String parameterBandName : this.parameterBandNames = SpectralIOUtils.getSpectralInversionParameterBandNames(this.numSdrBands)) {
            targetProduct.addBand(parameterBandName, 30);
        }
        this.uncertaintyBandNames = SpectralIOUtils.getSpectralInversionUncertaintyBandNames(this.numSdrBands, this.spectralWaveBandsMap);
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            for (int j = i; j < 3 * this.numSdrBands; ++j) {
                targetProduct.addBand(this.uncertaintyBandNames[i][j], 30);
            }
        }
        this.entropyBandName = "Entropy";
        targetProduct.addBand(this.entropyBandName, 30);
        this.relEntropyBandName = "Relative_Entropy";
        targetProduct.addBand(this.relEntropyBandName, 30);
        this.weightedNumberOfSamplesBandName = "Weighted_Number_of_Samples";
        targetProduct.addBand(this.weightedNumberOfSamplesBandName, 30);
        this.daysToTheClosestSampleBandName = "Time_to_the_Closest_Sample";
        targetProduct.addBand(this.daysToTheClosestSampleBandName, 30);
        this.goodnessOfFitBandName = "Goodness_of_Fit";
        targetProduct.addBand(this.goodnessOfFitBandName, 30);
        this.proportionNsamplesBandName = "Proportion_NSamples";
        targetProduct.addBand(this.proportionNsamplesBandName, 30);
        for (Band b : targetProduct.getBands()) {
            b.setNoDataValue(-9999.0);
            b.setNoDataValueUsed(true);
        }
    }

    protected void configureSourceSamples(SampleConfigurer configurator) throws OperatorException {
        int i;
        for (int i2 = 0; i2 < 3 * this.numSdrBands; ++i2) {
            this.srcSnowParams[i2] = i2;
            configurator.defineSample(this.srcSnowParams[i2], this.parameterBandNames[i2], this.snowProduct);
        }
        int offset = 3 * this.numSdrBands;
        for (i = 0; i < 3 * this.numSdrBands; ++i) {
            configurator.defineSample(offset + i, this.uncertaintyBandNames[i][i], this.snowProduct);
        }
        offset = 6 * this.numSdrBands;
        configurator.defineSample(offset + 0, this.entropyBandName, this.snowProduct);
        configurator.defineSample(offset + 1, this.relEntropyBandName, this.snowProduct);
        configurator.defineSample(offset + 2, this.weightedNumberOfSamplesBandName, this.snowProduct);
        configurator.defineSample(offset + 3, "Time_to_the_Closest_Sample", this.snowProduct);
        configurator.defineSample(offset + 4, this.goodnessOfFitBandName, this.snowProduct);
        offset = 6 * this.numSdrBands + 5;
        for (i = 0; i < 3 * this.numSdrBands; ++i) {
            configurator.defineSample(offset + i, this.parameterBandNames[i], this.noSnowProduct);
        }
        offset = 9 * this.numSdrBands + 5;
        for (i = 0; i < 3 * this.numSdrBands; ++i) {
            configurator.defineSample(offset + i, this.uncertaintyBandNames[i][i], this.noSnowProduct);
        }
        offset = 12 * this.numSdrBands + 5;
        configurator.defineSample(offset + 0, this.entropyBandName, this.noSnowProduct);
        configurator.defineSample(offset + 1, this.relEntropyBandName, this.noSnowProduct);
        configurator.defineSample(offset + 2, this.weightedNumberOfSamplesBandName, this.noSnowProduct);
        configurator.defineSample(offset + 3, "Time_to_the_Closest_Sample", this.noSnowProduct);
        configurator.defineSample(offset + 4, this.goodnessOfFitBandName, this.noSnowProduct);
    }

    protected void configureTargetSamples(SampleConfigurer configurator) throws OperatorException {
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            this.trgParameters[i] = i;
            configurator.defineSample(this.trgParameters[i], this.parameterBandNames[i]);
        }
        int index = 0;
        for (int i = 0; i < 3 * this.numSdrBands; ++i) {
            for (int j = i; j < 3 * this.numSdrBands; ++j) {
                this.trgUncertainties[index] = index;
                configurator.defineSample(this.trgParameters.length + this.trgUncertainties[index], this.uncertaintyBandNames[i][j]);
                ++index;
            }
        }
        configurator.defineSample(this.trgParameters.length + this.trgUncertainties.length + 0, this.entropyBandName);
        configurator.defineSample(this.trgParameters.length + this.trgUncertainties.length + 1, this.relEntropyBandName);
        configurator.defineSample(this.trgParameters.length + this.trgUncertainties.length + 2, this.weightedNumberOfSamplesBandName);
        configurator.defineSample(this.trgParameters.length + this.trgUncertainties.length + 3, this.daysToTheClosestSampleBandName);
        configurator.defineSample(this.trgParameters.length + this.trgUncertainties.length + 4, this.goodnessOfFitBandName);
        configurator.defineSample(this.trgParameters.length + this.trgUncertainties.length + 5, this.proportionNsamplesBandName);
    }

    private void setupSpectralWaveBandsMap(int numSdrBands) {
        for (int i = 0; i < numSdrBands; ++i) {
            this.spectralWaveBandsMap.put(i, "b" + (i + 1));
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MergeSpectralBrdfOp.class);
        }
    }
}

