/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.globalbedo.inversion.spectral.SpectralIOUtils;
import org.esa.beam.globalbedo.inversion.spectral.SpectralInversionOp;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.inversion.spectral")
public class GlobalbedoLevel3SpectralInversion
extends Operator {
    @Parameter(defaultValue="", description="Globalbedo SDR root directory")
    private String sdrRootDir;
    @Parameter(description="MODIS tile")
    private String tile;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="DoY")
    private int doy;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(description="Sub tiling factor (e.g. 4 for 300x300 subtile size", defaultValue="4", valueSet={"4"})
    private int subtileFactor;
    @Parameter(description="Sub tile start X", valueSet={"0", "300", "600", "900"})
    private int subStartX;
    @Parameter(description="Sub tile start Y", valueSet={"0", "300", "600", "900"})
    private int subStartY;
    int subtileWidth;
    int subtileHeight;

    public void initialize() throws OperatorException {
        Logger logger = BeamLogManager.getSystemLogger();
        this.subtileWidth = 1200 / this.subtileFactor;
        this.subtileHeight = 1200 / this.subtileFactor;
        SpectralInversionOp inversionOp = new SpectralInversionOp();
        inversionOp.setParameterDefaultValues();
        Product dummySourceProduct = AlbedoInversionUtils.createDummySourceProduct(this.subtileWidth, this.subtileHeight);
        inversionOp.setSourceProduct("priorProduct", dummySourceProduct);
        inversionOp.setParameter("sdrRootDir", this.sdrRootDir);
        inversionOp.setParameter("year", this.year);
        inversionOp.setParameter("tile", this.tile);
        inversionOp.setParameter("doy", this.doy);
        inversionOp.setParameter("computeSnow", this.computeSnow);
        inversionOp.setParameter("subStartX", this.subStartX);
        inversionOp.setParameter("subStartY", this.subStartY);
        inversionOp.setParameter("subtileFactor", this.subtileFactor);
        Product inversionProduct = inversionOp.getTargetProduct();
        inversionProduct.setGeoCoding((GeoCoding)SpectralIOUtils.getSinusoidalSubtileGeocoding(this.tile, this.subStartX, this.subStartY));
        this.setTargetProduct(inversionProduct);
        logger.log(Level.INFO, "Finished inversion process for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy) + " , Snow = " + this.computeSnow);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3SpectralInversion.class);
        }
    }
}

