/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.globalbedo.inversion.spectral.SpectralDailyAccumulationOp;
import org.esa.beam.globalbedo.inversion.spectral.SpectralIOUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.dailyacc.spectral", description="'Master' operator for the daily accumulation part in Albedo Inversion", autoWriteDisabled=true, authors="Olaf Danne", version="1.0", copyright="(C) 2011-2016 by Brockmann Consult")
public class GlobalbedoLevel3SpectralDailyAccumulation
extends Operator {
    @Parameter(defaultValue="", description="SDR root directory")
    private String sdrRootDir;
    @Parameter(label="Sensors to ingest in BRDF retrieval", defaultValue="MERIS,VGT")
    private String[] sensors;
    @Parameter(description="MODIS tile")
    private String tile;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="Day of Year", interval="[1,366]")
    private int doy;
    @Parameter(description="Sub tiling factor (e.g. 4 for 300x300 subtile size", defaultValue="4", valueSet={"4"})
    private int subtileFactor;
    @Parameter(description="Sub tile start X", valueSet={"0", "300", "600", "900"})
    private int subStartX;
    @Parameter(description="Sub tile start Y", valueSet={"0", "300", "600", "900"})
    private int subStartY;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;

    public void initialize() throws OperatorException {
        Product[] inputProducts;
        Logger logger = BeamLogManager.getSystemLogger();
        String subTileDir = "SUB_" + Integer.toString(this.subStartX) + "_" + Integer.toString(this.subStartY);
        try {
            inputProducts = SpectralIOUtils.getSpectralAccumulationInputProducts(this.sdrRootDir, this.sensors, this.subStartX, this.subStartY, this.tile, this.year, this.doy);
        }
        catch (IOException e) {
            throw new OperatorException("Daily Accumulator: Cannot get list of SDR input products: " + e.getMessage());
        }
        if (inputProducts.length > 0) {
            boolean madeDir;
            String dailyAccumulatorDir = this.sdrRootDir + File.separator + "DailyAcc" + File.separator + this.year + File.separator + this.tile;
            dailyAccumulatorDir = this.computeSnow ? dailyAccumulatorDir.concat(File.separator + "Snow" + File.separator) : dailyAccumulatorDir.concat(File.separator + "NoSnow" + File.separator);
            if (!new File(dailyAccumulatorDir = dailyAccumulatorDir.concat(File.separator + subTileDir + File.separator)).exists() && !(madeDir = new File(dailyAccumulatorDir).mkdirs())) {
                throw new OperatorException("Could not create sub tile dir '" + dailyAccumulatorDir + "'.");
            }
            JAI.getDefaultInstance().getTileScheduler().setParallelism(1);
            String dailyAccumulatorBinaryFilename = "matrices_" + this.year + IOUtils.getDoyString(this.doy) + "_" + subTileDir + ".bin";
            File dailyAccumulatorBinaryFile = new File(dailyAccumulatorDir + dailyAccumulatorBinaryFilename);
            SpectralDailyAccumulationOp accumulationOp = new SpectralDailyAccumulationOp();
            accumulationOp.setParameterDefaultValues();
            accumulationOp.setSourceProducts(inputProducts);
            accumulationOp.setParameter("subtileFactor", this.subtileFactor);
            accumulationOp.setParameter("computeSnow", this.computeSnow);
            accumulationOp.setParameter("dailyAccumulatorBinaryFile", dailyAccumulatorBinaryFile);
            Product accumulationProduct = accumulationOp.getTargetProduct();
            this.setTargetProduct(accumulationProduct);
        } else {
            logger.log(Level.WARNING, "No SDR input products found for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy) + " , Snow = " + this.computeSnow);
            Product dummyProduct = new Product("dummy", "dummy", 1, 1);
            this.setTargetProduct(dummyProduct);
        }
        logger.log(Level.INFO, "Finished daily accumulation process for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy) + " , Snow = " + this.computeSnow);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3SpectralDailyAccumulation.class);
        }
    }
}

