/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.spectral;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.globalbedo.inversion.spectral.MergeSpectralBrdfOp;
import org.esa.beam.globalbedo.inversion.spectral.SpectralBrdfToAlbedoOp;
import org.esa.beam.globalbedo.inversion.spectral.SpectralIOUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.globalbedo.inversion.util.ModisTileGeoCoding;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.albedo.spectral", description="Computes spectral albedo from spectral BRDF products.", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class GlobalbedoLevel3SpectralAlbedo
extends Operator {
    @Parameter(defaultValue="", description="Globalbedo root directory")
    private String inversionRootDir;
    @Parameter(description="MODIS tile")
    private String tile;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="DoY")
    private int doy;
    @Parameter(defaultValue="false", description="Write merged BRDF product only (no albedo compuation)")
    private boolean mergedProductOnly;
    @Parameter(description="Sub tile start X", valueSet={"0", "300", "600", "900"})
    private int subStartX;
    @Parameter(description="Sub tile start Y", valueSet={"0", "300", "600", "900"})
    private int subStartY;

    public void initialize() throws OperatorException {
        Product brdfNoSnowProduct;
        Product brdfSnowProduct;
        Logger logger = BeamLogManager.getSystemLogger();
        String subTileString = "SUB_" + Integer.toString(this.subStartX) + "_" + Integer.toString(this.subStartY);
        String brdfDir = this.inversionRootDir + File.separator;
        String brdfSnowDir = brdfDir + "Snow" + File.separator + this.year + File.separator + this.tile + File.separator + subTileString;
        String brdfNoSnowDir = brdfDir + "NoSnow" + File.separator + this.year + File.separator + this.tile + File.separator + subTileString;
        logger.log(Level.INFO, "Searching for BRDF SNOW file in directory: '" + brdfSnowDir + "'...");
        logger.log(Level.INFO, "Searching for BRDF NOSNOW file in directory: '" + brdfNoSnowDir + "'...");
        Product brdfMergedProduct = null;
        try {
            brdfSnowProduct = SpectralIOUtils.getSpectralBrdfProduct(brdfSnowDir, this.year, this.doy, true, this.subStartX, this.subStartY);
            brdfNoSnowProduct = SpectralIOUtils.getSpectralBrdfProduct(brdfNoSnowDir, this.year, this.doy, false, this.subStartX, this.subStartY);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot load spectral BRDF product: " + e.getMessage());
        }
        if (brdfSnowProduct != null && brdfNoSnowProduct != null) {
            MergeSpectralBrdfOp mergeBrdfOp = new MergeSpectralBrdfOp();
            mergeBrdfOp.setParameterDefaultValues();
            mergeBrdfOp.setSourceProduct("snowProduct", brdfSnowProduct);
            mergeBrdfOp.setSourceProduct("noSnowProduct", brdfNoSnowProduct);
            brdfMergedProduct = mergeBrdfOp.getTargetProduct();
        } else if (brdfSnowProduct != null) {
            logger.log(Level.WARNING, "Found only 'Snow' BRDF product for tile:" + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy));
            brdfMergedProduct = this.copyFromSingleProduct(brdfSnowProduct, 1.0f);
        } else if (brdfNoSnowProduct != null) {
            logger.log(Level.WARNING, "Found only 'NoSnow' BRDF product for tile:" + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy));
            brdfMergedProduct = this.copyFromSingleProduct(brdfNoSnowProduct, 0.0f);
        } else {
            logger.log(Level.WARNING, "Neither 'Snow' nor 'NoSnow' BRDF product for tile:" + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy));
        }
        if (brdfMergedProduct != null) {
            if (brdfMergedProduct.getGeoCoding() == null) {
                ModisTileGeoCoding sinusoidalSubtileGeocoding = SpectralIOUtils.getSinusoidalSubtileGeocoding(this.tile, this.subStartX, this.subStartY);
                brdfMergedProduct.setGeoCoding((GeoCoding)sinusoidalSubtileGeocoding);
            }
            if (this.mergedProductOnly) {
                this.setTargetProduct(brdfMergedProduct);
            } else {
                SpectralBrdfToAlbedoOp albedoOp = new SpectralBrdfToAlbedoOp();
                albedoOp.setParameterDefaultValues();
                albedoOp.setSourceProduct("spectralBrdfProduct", brdfMergedProduct);
                albedoOp.setParameter("doy", this.doy);
                Product albedoProduct = albedoOp.getTargetProduct();
                ProductUtils.copyGeoCoding((Product)brdfMergedProduct, (Product)albedoProduct);
                this.setTargetProduct(albedoProduct);
            }
            logger.log(Level.INFO, "Finished albedo computation process for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy));
        } else {
            logger.log(Level.WARNING, "No albedos computed for tile: " + this.tile + ", year: " + this.year + ", Doy: " + IOUtils.getDoyString(this.doy));
        }
    }

    private Product copyFromSingleProduct(Product sourceProduct, float propNSampleConstantValue) {
        int width = sourceProduct.getSceneRasterWidth();
        int height = sourceProduct.getSceneRasterHeight();
        Product targetProduct = new Product(sourceProduct.getName(), sourceProduct.getProductType(), width, height);
        for (Band band : sourceProduct.getBands()) {
            ProductUtils.copyBand((String)band.getName(), (Product)sourceProduct, (Product)targetProduct, (boolean)true);
        }
        Band propNSamplesBand = targetProduct.addBand("Proportion_NSamples", 30);
        BufferedImage bi = ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])new Float[]{Float.valueOf(propNSampleConstantValue)}, null).getAsBufferedImage();
        propNSamplesBand.setSourceImage((RenderedImage)bi);
        ProductUtils.copyMetadata((Product)sourceProduct, (Product)targetProduct);
        return targetProduct;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3SpectralAlbedo.class);
        }
    }
}

