/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.singlepixel;

import Jama.LUDecomposition;
import Jama.Matrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.pointop.PixelOperator;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.globalbedo.inversion.Accumulator;
import org.esa.beam.globalbedo.inversion.AlbedoInversionConstants;
import org.esa.beam.globalbedo.inversion.FullAccumulator;
import org.esa.beam.globalbedo.inversion.Prior;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;

@OperatorMetadata(alias="ga.inversion.inversion.single", description="Pixel operator for inversion of a single pixel", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class InversionSinglePixelOp
extends PixelOperator {
    public static final int[][] SRC_PRIOR_MEAN = new int[3][3];
    public static final int[][] SRC_PRIOR_SD = new int[3][3];
    public static final int SOURCE_SAMPLE_OFFSET = 0;
    public static final int PRIOR_OFFSET = (int)Math.pow(3.0, 2.0);
    public static final int SRC_PRIOR_NSAMPLES = 2 * PRIOR_OFFSET;
    public static final int SRC_PRIOR_MASK = 0 + 2 * PRIOR_OFFSET + 1;
    private static final int NUM_TRG_PARAMETERS = 9;
    private static final int NUM_TRG_UNCERTAINTIES = ((int)Math.pow(9.0, 2.0) + 9) / 2;
    private static final int TRG_REL_ENTROPY = 1;
    private static final int TRG_WEIGHTED_NUM_SAMPLES = 2;
    private static final int TRG_GOODNESS_OF_FIT = 3;
    private static final int TRG_DAYS_TO_THE_CLOSEST_SAMPLE = 4;
    private static final int TRG_LAT = 5;
    private static final int TRG_LON = 6;
    private static final String[] PARAMETER_BAND_NAMES = IOUtils.getInversionParameterBandNames();
    private static final String[][] UNCERTAINTY_BAND_NAMES = IOUtils.getInversionUncertaintyBandNames();
    @SourceProduct(description="Prior product", optional=true)
    private Product priorProduct;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="Tile")
    private String tile;
    @Parameter(description="Day of year")
    private int doy;
    @Parameter(description="Latitude")
    private float latitude;
    @Parameter(description="Latitude")
    private float longitude;
    @Parameter(description="Full accumulator")
    private FullAccumulator fullAccumulator;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="true", description="Use prior information")
    private boolean usePrior;
    @Parameter(defaultValue="30.0", description="Prior scale factor")
    private double priorScaleFactor;
    @Parameter(defaultValue="Mean_", description="Prefix of prior mean band (default fits to the latest prior version)")
    private String priorMeanBandNamePrefix;
    @Parameter(defaultValue="Cov_", description="Prefix of prior SD band (default fits to the latest prior version)")
    private String priorSdBandNamePrefix;
    @Parameter(defaultValue="7", description="Prior broad bands start index (default fits to the latest prior version)")
    private int priorBandStartIndex;
    @Parameter(defaultValue="Weighted_number_of_samples", description="Prior NSamples band name (default fits to the latest prior version)")
    private String priorNSamplesBandName;
    @Parameter(defaultValue="Data_Mask", description="Prior NSamples band name (default fits to the latest prior version)")
    private String priorLandMaskBandName;
    Accumulator[][] singlePixelAccumulator;

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        this.singlePixelAccumulator = new Accumulator[1][1];
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        for (String parameterBandName : PARAMETER_BAND_NAMES) {
            productConfigurer.addBand(parameterBandName, 30, -9999.0);
        }
        for (int i = 0; i < 9; ++i) {
            for (int j = i; j < 9; ++j) {
                productConfigurer.addBand(UNCERTAINTY_BAND_NAMES[i][j], 30, -9999.0);
            }
        }
        productConfigurer.addBand("Entropy", 30, -9999.0);
        productConfigurer.addBand("Relative_Entropy", 30, -9999.0);
        productConfigurer.addBand("Weighted_Number_of_Samples", 30, -9999.0);
        productConfigurer.addBand("Time_to_the_Closest_Sample", 30, -9999.0);
        productConfigurer.addBand("Goodness_of_Fit", 30, -9999.0);
        productConfigurer.addBand("latitude", 30, -9999.0);
        productConfigurer.addBand("longitude", 30, -9999.0);
    }

    protected void configureSourceSamples(SampleConfigurer configurator) {
        if (this.usePrior) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    String indexString = Integer.toString(this.priorBandStartIndex + i);
                    String meanBandName = this.priorMeanBandNamePrefix + AlbedoInversionConstants.BBDR_WAVE_BANDS[i] + "_f" + j;
                    configurator.defineSample(SRC_PRIOR_MEAN[i][j], meanBandName, this.priorProduct);
                    String sdMeanBandName = this.priorSdBandNamePrefix + AlbedoInversionConstants.BBDR_WAVE_BANDS[i] + "_f" + j + "_" + AlbedoInversionConstants.BBDR_WAVE_BANDS[i] + "_f" + j;
                    configurator.defineSample(SRC_PRIOR_SD[i][j], sdMeanBandName, this.priorProduct);
                }
            }
            configurator.defineSample(SRC_PRIOR_NSAMPLES, this.priorNSamplesBandName, this.priorProduct);
            configurator.defineSample(SRC_PRIOR_MASK, this.priorLandMaskBandName, this.priorProduct);
        }
    }

    protected void configureTargetSamples(SampleConfigurer configurator) {
        for (int i = 0; i < 9; ++i) {
            configurator.defineSample(i, PARAMETER_BAND_NAMES[i]);
        }
        int index = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = i; j < 9; ++j) {
                configurator.defineSample(9 + index, UNCERTAINTY_BAND_NAMES[i][j]);
                ++index;
            }
        }
        int offset = 9 + NUM_TRG_UNCERTAINTIES;
        configurator.defineSample(offset, "Entropy");
        configurator.defineSample(offset + 1, "Relative_Entropy");
        configurator.defineSample(offset + 2, "Weighted_Number_of_Samples");
        configurator.defineSample(offset + 3, "Goodness_of_Fit");
        configurator.defineSample(offset + 4, "Time_to_the_Closest_Sample");
        configurator.defineSample(offset + 5, "latitude");
        configurator.defineSample(offset + 6, "longitude");
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        Matrix uncertainties;
        Matrix parameters = new Matrix(9, 1, -9999.0);
        double entropy = 0.0;
        double relEntropy = 0.0;
        double maskAcc = 0.0;
        if (this.fullAccumulator != null) {
            this.singlePixelAccumulator[0][0] = this.fullAccumulator.getAccumulator()[0][0];
            maskAcc = this.singlePixelAccumulator[0][0].getMask();
        }
        double maskPrior = 1.0;
        Prior prior = null;
        if (this.usePrior) {
            prior = Prior.createForInversion(sourceSamples, this.priorScaleFactor);
            maskPrior = prior.getMask();
        }
        double goodnessOfFit = 0.0;
        float daysToTheClosestSample = 0.0f;
        if (this.singlePixelAccumulator[0][0] != null && maskAcc > 0.0 && (this.usePrior && maskPrior > 0.0 || !this.usePrior)) {
            LUDecomposition lud;
            Matrix mAcc = this.singlePixelAccumulator[0][0].getM();
            Matrix vAcc = this.singlePixelAccumulator[0][0].getV();
            Matrix eAcc = this.singlePixelAccumulator[0][0].getE();
            if (this.usePrior && prior != null) {
                for (int i = 0; i < 9; ++i) {
                    double m_ii_accum = mAcc.get(i, i);
                    if (prior.getM() != null) {
                        m_ii_accum += prior.getM().get(i, i);
                    }
                    mAcc.set(i, i, m_ii_accum);
                }
                vAcc = vAcc.plus(prior.getV());
            }
            if ((lud = new LUDecomposition(mAcc)).isNonsingular()) {
                Matrix tmpM = mAcc.inverse();
                if (AlbedoInversionUtils.matrixHasNanElements(tmpM) || AlbedoInversionUtils.matrixHasZerosInDiagonale(tmpM)) {
                    tmpM = new Matrix(9, 9, -9999.0);
                }
                uncertainties = tmpM;
            } else {
                parameters = new Matrix(9, 1, -9999.0);
                uncertainties = new Matrix(9, 9, -9999.0);
                maskAcc = 0.0;
            }
            if (maskAcc != 0.0) {
                parameters = mAcc.solve(vAcc);
                entropy = this.getEntropy(mAcc);
                if (this.usePrior && prior != null && prior.getM() != null) {
                    double entropyPrior = this.getEntropy(prior.getM());
                    relEntropy = entropyPrior - entropy;
                } else {
                    relEntropy = -9999.0;
                }
            }
            goodnessOfFit = this.getGoodnessOfFit(mAcc, vAcc, eAcc, parameters, maskAcc);
            daysToTheClosestSample = this.fullAccumulator.getDaysToTheClosestSample()[x][y];
        } else if (maskPrior > 0.0) {
            if (this.usePrior) {
                parameters = prior.getParameters();
                LUDecomposition lud = new LUDecomposition(prior.getM());
                if (lud.isNonsingular()) {
                    uncertainties = prior.getM().inverse();
                    entropy = this.getEntropy(prior.getM());
                } else {
                    uncertainties = new Matrix(9, 9, -9999.0);
                    entropy = -9999.0;
                }
                relEntropy = 0.0;
            } else {
                uncertainties = new Matrix(9, 9, -9999.0);
                entropy = -9999.0;
                relEntropy = -9999.0;
            }
        } else {
            uncertainties = new Matrix(9, 9, -9999.0);
            entropy = -9999.0;
            relEntropy = -9999.0;
        }
        this.fillTargetSamples(targetSamples, parameters, uncertainties, entropy, relEntropy, maskAcc, goodnessOfFit, daysToTheClosestSample);
    }

    private double getGoodnessOfFit(Matrix mAcc, Matrix vAcc, Matrix eAcc, Matrix fPars, double maskAcc) {
        Matrix goodnessOfFitMatrix = new Matrix(1, 1, 0.0);
        if (maskAcc > 0.0) {
            Matrix gofTerm1 = fPars.transpose().times(mAcc).times(fPars);
            Matrix gofTerm2 = fPars.transpose().times(vAcc);
            Matrix m2 = new Matrix(1, 1, 2.0);
            Matrix gofTerm3 = m2.times(eAcc);
            goodnessOfFitMatrix = gofTerm1.plus(gofTerm2).minus(gofTerm3);
        }
        return goodnessOfFitMatrix.get(0, 0);
    }

    private void fillTargetSamples(WritableSample[] targetSamples, Matrix parameters, Matrix uncertainties, double entropy, double relEntropy, double weightedNumberOfSamples, double goodnessOfFit, float daysToTheClosestSample) {
        int j;
        int i;
        int index = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                targetSamples[index].set(parameters.get(index, 0));
                ++index;
            }
        }
        for (i = 0; i < 9; ++i) {
            for (j = i; j < 9; ++j) {
                targetSamples[index].set(uncertainties.get(i, j));
                ++index;
            }
        }
        int offset = 9 + NUM_TRG_UNCERTAINTIES;
        targetSamples[offset].set(entropy);
        targetSamples[offset + 1].set(relEntropy);
        targetSamples[offset + 2].set(weightedNumberOfSamples);
        targetSamples[offset + 3].set(goodnessOfFit);
        targetSamples[offset + 4].set(daysToTheClosestSample);
        targetSamples[offset + 5].set(this.latitude);
        targetSamples[offset + 6].set(this.longitude);
    }

    private double getEntropy(Matrix m) {
        RealMatrix rm = AlbedoInversionUtils.getRealMatrixFromJamaMatrix(m);
        SingularValueDecomposition svdM = new SingularValueDecomposition(rm);
        double[] svdMSingularValues = svdM.getSingularValues();
        double productSvdMSRecip = 1.0;
        for (double svdMSingularValue : svdMSingularValues) {
            if (svdMSingularValue == 0.0) continue;
            productSvdMSRecip *= 1.0 / svdMSingularValue;
        }
        return 0.5 * Math.log(productSvdMSRecip) + (double)svdMSingularValues.length * Math.sqrt(Math.log(17.079468445347132));
    }

    static {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                InversionSinglePixelOp.SRC_PRIOR_MEAN[i][j] = 0 + 3 * i + j;
                InversionSinglePixelOp.SRC_PRIOR_SD[i][j] = 0 + PRIOR_OFFSET + 3 * i + j;
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(InversionSinglePixelOp.class);
        }
    }
}

