/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.singlepixel;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.globalbedo.inversion.Accumulator;
import org.esa.beam.globalbedo.inversion.singlepixel.DailyAccumulationSinglePixel;
import org.esa.beam.globalbedo.inversion.singlepixel.FullAccumulationSinglePixel;
import org.esa.beam.globalbedo.inversion.singlepixel.InversionSinglePixelOp;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.gpf.operators.standard.SubsetOp;
import org.esa.beam.gpf.operators.standard.WriteOp;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.inversion.single", description="'Master' operator for the whole single pixel BRDF computation (daily acc, full acc, inversion)", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class GlobalbedoLevel3InversionSinglePixel
extends Operator {
    @Parameter(defaultValue="", description="Globalbedo root directory")
    private String gaRootDir;
    @Parameter(defaultValue="", description="BBDR root directory")
    private String bbdrRootDir;
    @Parameter(defaultValue="", description="Inversion target directory")
    private String inversionDir;
    @Parameter(description="MODIS tile")
    private String tile;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="Day of Year", interval="[1,366]")
    private int doy;
    @Parameter(defaultValue="180", description="Wings")
    private int wings;
    @Parameter(defaultValue="true", description="Decide whether MODIS priors shall be used in inversion")
    private boolean usePrior = true;
    @Parameter(defaultValue="", description="MODIS Prior root directory")
    private String priorRootDir;
    @Parameter(defaultValue="", description="MODIS Prior root directory suffix")
    private String priorRootDirSuffix;
    @Parameter(defaultValue="kernel", description="MODIS Prior file name prefix")
    private String priorFileNamePrefix;
    @Parameter(defaultValue="Mean_", description="Prefix of prior mean band (default fits to the latest prior version)")
    private String priorMeanBandNamePrefix;
    @Parameter(defaultValue="Cov_", description="Prefix of prior SD band (default fits to the latest prior version)")
    private String priorSdBandNamePrefix;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="", description="Version of BBDR single pixel input (vyyMMdd)")
    private String versionString;
    @Parameter(defaultValue="", description="x pixel index in tile (as string with leading zero)")
    private String pixelX;
    @Parameter(defaultValue="", description="y pixel index in tile (as string with leading zero)")
    private String pixelY;
    @Parameter(defaultValue="true", description="If set, product is written to CSV file following conventions")
    private boolean writeInversionProductToCsv;
    @Parameter(description="Array of all daily accumulators for the pixel (computed externally) ")
    private Accumulator[] allDailyAccs;
    @SourceProduct(description="Prior product as single pixel (i.e. CSV)", optional=true)
    private Product priorPixelProduct;
    @Parameter(defaultValue="5", description="Prior version (MODIS collection)")
    private int priorVersion;
    private float latitude = Float.NaN;
    private float longitude = Float.NaN;

    /*
     * Unable to fully structure code
     */
    public void initialize() throws OperatorException {
        logger = BeamLogManager.getSystemLogger();
        if (this.inversionDir == null) {
            snowDir = this.computeSnow != false ? "Snow" : "NoSnow";
            this.inversionDir = this.gaRootDir + File.separator + "Inversion_single" + File.separator + this.year + File.separator + this.tile + File.separator + snowDir;
        }
        if (this.allDailyAccs == null) {
            allDailyAccsList = new ArrayList<Accumulator>();
            for (iDay = -90; iDay < 455; ++iDay) {
                currentYear = this.year;
                currentDay = iDay;
                if (iDay < 0) {
                    --currentYear;
                    currentDay = iDay + 365;
                } else if (iDay > 365) {
                    ++currentYear;
                    currentDay = iDay - 365;
                }
                try {
                    inputProductList = IOUtils.getAccumulationSinglePixelInputProducts(this.bbdrRootDir, this.tile, currentYear, currentDay, this.pixelX, this.pixelY, this.versionString);
                    inputProducts = inputProductList.toArray(new Product[inputProductList.size()]);
                }
                catch (IOException e) {
                    throw new OperatorException("Daily Accumulator: Cannot get list of input products: " + e.getMessage());
                }
                if (inputProducts.length > 0) {
                    if (Float.isNaN(this.latitude) || Float.isNaN(this.longitude)) {
                        latLon = AlbedoInversionUtils.getLatLonFromProduct(inputProducts[0]);
                        this.latitude = latLon.getLat();
                        this.longitude = latLon.getLon();
                    }
                    logger.log(Level.ALL, "Daily acc 'single': tile: " + this.tile + ", year: " + currentYear + ", day: " + IOUtils.getDoyString(currentDay));
                    for (Product inputProduct : inputProducts) {
                        logger.log(Level.ALL, "       - ': " + inputProduct.getName());
                    }
                    dailyAccumulationSinglePixel = new DailyAccumulationSinglePixel(inputProducts, this.computeSnow);
                    dailyAcc = dailyAccumulationSinglePixel.accumulate();
                    allDailyAccsList.add(dailyAcc);
                    continue;
                }
                allDailyAccsList.add(Accumulator.createZeroAccumulator());
            }
            this.allDailyAccs = allDailyAccsList.toArray(new Accumulator[allDailyAccsList.size()]);
        }
        fullAccumulationSinglePixel = new FullAccumulationSinglePixel(this.year, this.doy);
        fullAcc = fullAccumulationSinglePixel.accumulate(this.allDailyAccs);
        priorProduct = null;
        if (this.usePrior && this.priorPixelProduct == null) {
            priorDir = this.priorRootDir + File.separator + this.tile;
            if (this.priorRootDirSuffix != null) {
                priorDir = priorDir.concat(File.separator + this.priorRootDirSuffix);
            }
            logger.log(Level.INFO, "No single pixel Prior set - searching for prior file in directory: '" + priorDir + "'...");
            try {
                priorProduct = IOUtils.getPriorProduct(this.priorVersion, priorDir, this.priorFileNamePrefix, this.doy, this.computeSnow);
            }
            catch (IOException e) {
                throw new OperatorException("No prior file available for DoY " + IOUtils.getDoyString(this.doy) + " - cannot proceed...: " + e.getMessage());
            }
        }
        if (!this.usePrior || this.usePrior && (priorProduct != null || this.priorPixelProduct != null)) {
            priorSinglePixelProduct = null;
            if (this.usePrior) {
                if (priorProduct != null) {
                    try {
                        IOUtils.attachGeoCodingToPriorProduct(priorProduct, this.tile, null);
                        subsetOp = new SubsetOp();
                        subsetOp.setParameterDefaultValues();
                        subsetOp.setSourceProduct(priorProduct);
                        subsetOp.setRegion(new Rectangle(Integer.parseInt(this.pixelX), Integer.parseInt(this.pixelY), 1, 1));
                        priorSinglePixelProduct = subsetOp.getTargetProduct();
                        if (priorSinglePixelProduct.getSceneRasterWidth() == 1 && priorSinglePixelProduct.getSceneRasterHeight() == 1) ** GOTO lbl75
                        logger.log(Level.WARNING, "Prior subset does not match 1x1 dimension - will not use this Prior!");
                        this.usePrior = false;
                    }
                    catch (IOException e) {
                        throw new OperatorException("Cannot reproject prior products - cannot proceed: " + e.getMessage());
                    }
                } else if (this.priorPixelProduct != null) {
                    priorSinglePixelProduct = this.priorPixelProduct;
                } else {
                    logger.log(Level.WARNING, "No prior file found for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy) + " , Snow = " + this.computeSnow + " - no inversion performed.");
                }
            }
lbl75:
            // 6 sources

            inversionSinglePixelOp = new InversionSinglePixelOp();
            inversionSinglePixelOp.setParameterDefaultValues();
            if (this.usePrior && priorSinglePixelProduct != null) {
                inversionSinglePixelOp.setSourceProduct("priorProduct", priorSinglePixelProduct);
            } else {
                dummySourceProduct = AlbedoInversionUtils.createDummySourceProduct(1, 1);
                inversionSinglePixelOp.setSourceProduct("priorProduct", dummySourceProduct);
            }
            inversionSinglePixelOp.setParameter("year", this.year);
            inversionSinglePixelOp.setParameter("tile", this.tile);
            inversionSinglePixelOp.setParameter("doy", this.doy);
            inversionSinglePixelOp.setParameter("latitude", Float.valueOf(this.latitude));
            inversionSinglePixelOp.setParameter("longitude", Float.valueOf(this.longitude));
            inversionSinglePixelOp.setParameter("fullAccumulator", fullAcc);
            inversionSinglePixelOp.setParameter("computeSnow", this.computeSnow);
            inversionSinglePixelOp.setParameter("usePrior", this.usePrior);
            inversionSinglePixelOp.setParameter("priorMeanBandNamePrefix", this.priorMeanBandNamePrefix);
            inversionSinglePixelOp.setParameter("priorSdBandNamePrefix", this.priorSdBandNamePrefix);
            inversionProduct = inversionSinglePixelOp.getTargetProduct();
            if (priorProduct == null) {
                inversionProduct.setGeoCoding((GeoCoding)IOUtils.getSinusoidalTileGeocoding(this.tile));
            }
            if (this.writeInversionProductToCsv) {
                this.writeCsvProduct(inversionProduct, this.getInversionFilename(this.doy));
            } else {
                this.setTargetProduct(inversionProduct);
            }
            logger.log(Level.INFO, "Finished inversion process for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy) + " , Snow = " + this.computeSnow);
            if (this.writeInversionProductToCsv) {
                this.setTargetProduct(new Product("dummy", "dummy", 1, 1));
            }
        }
    }

    private String getInversionFilename(int doy) {
        String snowString = this.computeSnow ? "Snow" : "NoSnow";
        String inversionFileName = "Qa4ecv.brdf.single." + this.year + "." + IOUtils.getDoyString(doy) + "." + this.tile + "." + this.pixelX + "." + this.pixelY + "." + snowString;
        return inversionFileName;
    }

    private void writeCsvProduct(Product product, String productName) {
        File dir = new File(this.inversionDir);
        dir.mkdirs();
        File file = new File(dir, productName + ".csv");
        WriteOp writeOp = new WriteOp(product, file, "CSV");
        writeOp.writeProduct(ProgressMonitor.NULL);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3InversionSinglePixel.class);
        }
    }
}

