/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.singlepixel;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.globalbedo.inversion.BrdfToAlbedoOp;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.globalbedo.inversion.util.ModisTileGeoCoding;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.albedo.single", description="''Master' operator for the final albedo retrieval part for single pixel", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class GlobalbedoLevel3AlbedoSinglePixel
extends Operator {
    @Parameter(defaultValue="", description="Globalbedo root directory")
    private String gaRootDir;
    @Parameter(defaultValue="", description="Inversion target directory")
    private String brdfDir;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(description="MODIS tile")
    private String tile;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="DoY")
    private int doy;
    @SourceProduct(description="BRDF input product")
    private Product brdfProduct;

    public void initialize() throws OperatorException {
        Logger logger = BeamLogManager.getSystemLogger();
        Product brdfProductToProcess = this.addProportionNSamplesBand(this.brdfProduct);
        if (brdfProductToProcess != null) {
            ModisTileGeoCoding sinusoidalTileGeocoding = IOUtils.getSinusoidalTileGeocoding(this.tile);
            brdfProductToProcess.setGeoCoding((GeoCoding)sinusoidalTileGeocoding);
            GeoPos latLon = AlbedoInversionUtils.getLatLonFromProduct(this.brdfProduct);
            BrdfToAlbedoOp albedoOp = new BrdfToAlbedoOp();
            albedoOp.setParameterDefaultValues();
            albedoOp.setSourceProduct("brdfMergedProduct", brdfProductToProcess);
            albedoOp.setParameter("doy", this.doy);
            albedoOp.setParameter("latLon", latLon);
            albedoOp.setParameter("singlePixelMode", true);
            Product albedoProduct = albedoOp.getTargetProduct();
            this.setTargetProduct(albedoProduct);
            logger.log(Level.INFO, "Finished albedo computation process for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy));
        } else {
            logger.log(Level.WARNING, "No single-pixel albedos computed for tile: " + this.tile + ", year: " + this.year + ", Doy: " + IOUtils.getDoyString(this.doy));
        }
    }

    private Product addProportionNSamplesBand(Product sourceProduct) {
        int width = sourceProduct.getSceneRasterWidth();
        int height = sourceProduct.getSceneRasterHeight();
        Product targetProduct = new Product(sourceProduct.getName(), sourceProduct.getProductType(), width, height);
        for (Band band : sourceProduct.getBands()) {
            ProductUtils.copyBand((String)band.getName(), (Product)sourceProduct, (Product)targetProduct, (boolean)true);
        }
        float propNSampleConstantValue = this.computeSnow ? 1.0f : 0.0f;
        Band propNSamplesBand = targetProduct.addBand("Proportion_NSamples", 30);
        BufferedImage bi = ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])new Float[]{Float.valueOf(propNSampleConstantValue)}, null).getAsBufferedImage();
        propNSamplesBand.setSourceImage((RenderedImage)bi);
        ProductUtils.copyGeoCoding((Product)sourceProduct, (Product)targetProduct);
        ProductUtils.copyMetadata((Product)sourceProduct, (Product)targetProduct);
        return targetProduct;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3AlbedoSinglePixel.class);
        }
    }
}

