/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.singlepixel;

import Jama.Matrix;
import java.util.logging.Level;
import org.esa.beam.globalbedo.inversion.Accumulator;
import org.esa.beam.globalbedo.inversion.FullAccumulator;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.util.logging.BeamLogManager;

public class FullAccumulationSinglePixel {
    private int year;
    private int doy;

    public FullAccumulationSinglePixel(int year, int doy) {
        this.year = year;
        this.doy = doy;
    }

    public FullAccumulator accumulate(Accumulator[] dailyAccs) {
        int numDailyAccs = dailyAccs.length;
        float[][] daysToTheClosestSample = new float[1][1];
        Accumulator[][] tmpAcc = new Accumulator[1][1];
        tmpAcc[0][0] = Accumulator.createZeroAccumulator();
        daysToTheClosestSample[0][0] = 2.1474836E9f;
        for (int iDay = -90; iDay < numDailyAccs - 90; ++iDay) {
            float value;
            int currentYear = this.year;
            int currentDay = iDay;
            if (iDay < 0) {
                --currentYear;
                currentDay = iDay + 365;
            } else if (iDay > 365) {
                ++currentYear;
                currentDay = iDay - 365;
            }
            BeamLogManager.getSystemLogger().log(Level.FINEST, "Full accumulation for year/day:  " + currentYear + "/" + IOUtils.getDoyString(currentDay) + " ...");
            int dayDifference = this.getDayDifference(currentDay);
            float weight = AlbedoInversionUtils.getWeight(dayDifference);
            Matrix dailyAccM = dailyAccs[iDay + 90].getM();
            Matrix dailyAccV = dailyAccs[iDay + 90].getV();
            Matrix dailyAccE = dailyAccs[iDay + 90].getE();
            double dailyAccMask = dailyAccs[iDay + 90].getMask();
            tmpAcc[0][0].setM(tmpAcc[0][0].getM().plus(dailyAccM.times((double)weight)));
            tmpAcc[0][0].setV(tmpAcc[0][0].getV().plus(dailyAccV.times((double)weight)));
            tmpAcc[0][0].setE(tmpAcc[0][0].getE().plus(dailyAccE.times((double)weight)));
            tmpAcc[0][0].setMask(tmpAcc[0][0].getMask() + dailyAccMask * (double)weight);
            if (!(dailyAccMask > 0.0) || !((value = (float)(Math.abs(dayDifference) + 1)) < daysToTheClosestSample[0][0])) continue;
            daysToTheClosestSample[0][0] = Math.abs(dayDifference) + 1;
        }
        return new FullAccumulator(this.year, this.doy, tmpAcc, daysToTheClosestSample);
    }

    private int getDayDifference(int dailAccDay) {
        int referenceYear = this.year;
        if (dailAccDay < 90) {
            --referenceYear;
        } else if (dailAccDay > 455) {
            ++referenceYear;
        }
        int difference = 365 * (this.year - referenceYear) + (this.doy + 8 - dailAccDay);
        return Math.abs(difference);
    }
}

