/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.singlepixel;

import Jama.Matrix;
import java.awt.image.Raster;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.globalbedo.inversion.Accumulator;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.DailyAccumulationUtils;

public class DailyAccumulationSinglePixel {
    private Product[] sourceProducts;
    private boolean computeSnow;
    private int pixelX;
    private int pixelY;

    public DailyAccumulationSinglePixel(Product[] sourceProducts, boolean computeSnow) {
        this.sourceProducts = sourceProducts;
        this.computeSnow = computeSnow;
        this.pixelX = 0;
        this.pixelY = 0;
    }

    public DailyAccumulationSinglePixel(Product[] sourceProducts, boolean computeSnow, int pixelX, int pixelY) {
        this.sourceProducts = sourceProducts;
        this.computeSnow = computeSnow;
        this.pixelX = pixelX;
        this.pixelY = pixelY;
    }

    public void setPixelX(int pixelX) {
        this.pixelX = pixelX;
    }

    public void setPixelY(int pixelY) {
        this.pixelY = pixelY;
    }

    public Accumulator accumulate() {
        Matrix M = new Matrix(9, 9);
        Matrix V = new Matrix(9, 1);
        Matrix E = new Matrix(1, 1);
        double mask = 0.0;
        for (int i = 0; i < this.sourceProducts.length; ++i) {
            long t1 = System.currentTimeMillis();
            Accumulator accumulator = this.getMatricesPerBBDRDataset(i);
            M.plusEquals(accumulator.getM());
            V.plusEquals(accumulator.getV());
            E.plusEquals(accumulator.getE());
            mask += accumulator.getMask();
        }
        return new Accumulator(M, V, E, mask);
    }

    private Accumulator getMatricesPerBBDRDataset(int sourceProductIndex) {
        int k;
        int j;
        long t1 = System.currentTimeMillis();
        Matrix bbdr = this.getBBDR(sourceProductIndex);
        double[] SD = this.getSD(sourceProductIndex);
        long t2 = System.currentTimeMillis();
        long timeGetBBDRandSD = t2 - t1;
        System.out.println("timeGetBBDRandSD [ms] = " + timeGetBBDRandSD);
        if (this.isLandFilter(sourceProductIndex) || this.isSnowFilter(sourceProductIndex) || this.isBBDRFilter(bbdr) || this.isSDFilter(SD)) {
            return Accumulator.createZeroAccumulator();
        }
        Matrix kernels = this.getKernels(sourceProductIndex);
        double[] correlation = this.getCorrelation(sourceProductIndex);
        Matrix C = new Matrix(9, 1);
        Matrix thisC = new Matrix(3, 3);
        int count = 0;
        int cCount = 0;
        for (j = 0; j < 3; ++j) {
            for (k = j + 1; k < 3; ++k) {
                if (k == j + 1) {
                    ++cCount;
                }
                C.set(cCount, 0, correlation[count] * SD[j] * SD[k]);
                ++count;
                ++cCount;
            }
        }
        cCount = 0;
        for (j = 0; j < 3; ++j) {
            C.set(cCount, 0, SD[j] * SD[j]);
            cCount = cCount + 3 - j;
        }
        count = 0;
        for (j = 0; j < 3; ++j) {
            for (k = j; k < 3; ++k) {
                thisC.set(j, k, C.get(count, 0));
                thisC.set(k, j, thisC.get(j, k));
                ++count;
            }
        }
        Matrix inverseC = thisC.inverse();
        Matrix M = kernels.transpose().times(inverseC).times(kernels);
        Matrix inverseCDiagFlat = DailyAccumulationUtils.getRectangularDiagonalMatrix(inverseC);
        if (inverseCDiagFlat == null) {
            return Accumulator.createZeroAccumulator();
        }
        Matrix kernelTimesInvCDiag = kernels.transpose().times(inverseCDiagFlat);
        Matrix V = kernelTimesInvCDiag.times(bbdr);
        Matrix E = bbdr.transpose().times(inverseC).times(bbdr);
        return new Accumulator(M, V, E, 1.0);
    }

    private Matrix getBBDR(int sourceProductIndex) {
        Matrix bbdr = new Matrix(3, 1);
        Product product = this.sourceProducts[sourceProductIndex];
        Band bbVisBand = product.getBand("BB_VIS");
        Raster bbVisData = bbVisBand.getSourceImage().getData();
        double bbVis = bbVisData.getSampleDouble(this.pixelX, this.pixelY, 0);
        bbdr.set(0, 0, bbVis);
        Band bbNirBand = product.getBand("BB_NIR");
        Raster bbNirData = bbNirBand.getSourceImage().getData();
        double bbNir = bbNirData.getSampleDouble(this.pixelX, this.pixelY, 0);
        bbdr.set(1, 0, bbNir);
        Band bbSwBand = product.getBand("BB_SW");
        Raster bbSwData = bbSwBand.getSourceImage().getData();
        double bbSw = bbSwData.getSampleDouble(this.pixelX, this.pixelY, 0);
        bbdr.set(2, 0, bbSw);
        return bbdr;
    }

    private double[] getSD(int sourceProductIndex) {
        double[] SD = new double[3];
        Product product = this.sourceProducts[sourceProductIndex];
        Band sigBbVisVisBand = product.getBand("sig_BB_VIS_VIS");
        Raster sigBbVisVisData = sigBbVisVisBand.getSourceImage().getData();
        SD[0] = sigBbVisVisData.getSampleDouble(this.pixelX, this.pixelY, 0);
        Band sigBbNirNirBand = product.getBand("sig_BB_NIR_NIR");
        Raster sigBbNirNirData = sigBbNirNirBand.getSourceImage().getData();
        SD[1] = sigBbNirNirData.getSampleDouble(this.pixelX, this.pixelY, 0);
        Band sigBbSwSwBand = product.getBand("sig_BB_SW_SW");
        Raster sigBbSwSwData = sigBbSwSwBand.getSourceImage().getData();
        SD[2] = sigBbSwSwData.getSampleDouble(this.pixelX, this.pixelY, 0);
        return SD;
    }

    private double[] getCorrelation(int sourceProductIndex) {
        double[] correlation = new double[3];
        Product product = this.sourceProducts[sourceProductIndex];
        Band sigBbVisNirBand = product.getBand("sig_BB_VIS_NIR");
        Raster sigBbVisNirData = sigBbVisNirBand.getSourceImage().getData();
        correlation[0] = sigBbVisNirData.getSampleDouble(this.pixelX, this.pixelY, 0);
        Band sigBbVisSwBand = product.getBand("sig_BB_VIS_SW");
        Raster sigBbVisSwData = sigBbVisSwBand.getSourceImage().getData();
        correlation[1] = sigBbVisSwData.getSampleDouble(this.pixelX, this.pixelY, 0);
        Band sigBbNirSwBand = product.getBand("sig_BB_NIR_SW");
        Raster sigBbNirSwData = sigBbNirSwBand.getSourceImage().getData();
        correlation[2] = sigBbNirSwData.getSampleDouble(this.pixelX, this.pixelY, 0);
        return correlation;
    }

    private Matrix getKernels(int sourceProductIndex) {
        Matrix kernels = new Matrix(3, 9);
        Product product = this.sourceProducts[sourceProductIndex];
        kernels.set(0, 0, 1.0);
        kernels.set(1, 3, 1.0);
        kernels.set(2, 6, 1.0);
        Band kvolBrdfVisBand = product.getBand("Kvol_BRDF_VIS");
        Raster kvolBrdfVisData = kvolBrdfVisBand.getSourceImage().getData();
        kernels.set(0, 1, kvolBrdfVisData.getSampleDouble(this.pixelX, this.pixelY, 0));
        Band kvolBrdfNirBand = product.getBand("Kvol_BRDF_NIR");
        Raster kvolBrdfNirData = kvolBrdfNirBand.getSourceImage().getData();
        kernels.set(1, 4, kvolBrdfNirData.getSampleDouble(this.pixelX, this.pixelY, 0));
        Band kvolBrdfSwBand = product.getBand("Kvol_BRDF_SW");
        Raster kvolBrdfSwData = kvolBrdfSwBand.getSourceImage().getData();
        kernels.set(2, 7, kvolBrdfSwData.getSampleDouble(this.pixelX, this.pixelY, 0));
        Band kgeoBrdfVisBand = product.getBand("Kgeo_BRDF_VIS");
        Raster kgeoBrdfVisData = kgeoBrdfVisBand.getSourceImage().getData();
        kernels.set(0, 2, kgeoBrdfVisData.getSampleDouble(this.pixelX, this.pixelY, 0));
        Band kgeoBrdfNirBand = product.getBand("Kgeo_BRDF_NIR");
        Raster kgeoBrdfNirData = kgeoBrdfNirBand.getSourceImage().getData();
        kernels.set(1, 5, kgeoBrdfNirData.getSampleDouble(this.pixelX, this.pixelY, 0));
        Band kgeoBrdfSwBand = product.getBand("Kgeo_BRDF_SW");
        Raster kgeoBrdfSwData = kgeoBrdfSwBand.getSourceImage().getData();
        kernels.set(2, 8, kgeoBrdfSwData.getSampleDouble(this.pixelX, this.pixelY, 0));
        return kernels;
    }

    private boolean isLandFilter(int sourceProductIndex) {
        Product product = this.sourceProducts[sourceProductIndex];
        if (product.getProductType().startsWith("MER") || product.getName().startsWith("MER")) {
            Band l1FlagBand = product.getBand("l1_flags");
            Raster l1FlagData = l1FlagBand.getSourceImage().getData();
            int l1 = (int)l1FlagData.getSampleDouble(this.pixelX, this.pixelY, 0);
            return (l1 & 0x10) == 0;
        }
        if (product.getProductType().startsWith("VGT") || product.getName().startsWith("VGT")) {
            Band smFlagBand = product.getBand("SM");
            Raster smFlagData = smFlagBand.getSourceImage().getData();
            int sm = (int)smFlagData.getSampleDouble(this.pixelX, this.pixelY, 0);
            return (sm & 8) == 0;
        }
        return false;
    }

    private boolean isSnowFilter(int sourceProductIndex) {
        Product product = this.sourceProducts[sourceProductIndex];
        Band snowMaskBand = product.getBand("snow_mask");
        Raster snowMaskData = snowMaskBand.getSourceImage().getData();
        int snowValue = (int)snowMaskData.getSampleDouble(this.pixelX, this.pixelY, 0);
        return !this.computeSnow && snowValue != 0 || this.computeSnow && snowValue == 0;
    }

    private boolean isBBDRFilter(Matrix bbdr) {
        double bbVis = bbdr.get(0, 0);
        double bbNir = bbdr.get(1, 0);
        double bbSw = bbdr.get(2, 0);
        return bbVis == 0.0 || !AlbedoInversionUtils.isValid(bbVis) || bbVis == 9999.0 || bbNir == 0.0 || !AlbedoInversionUtils.isValid(bbNir) || bbNir == 9999.0 || bbSw == 0.0 || !AlbedoInversionUtils.isValid(bbSw) || bbSw == 9999.0;
    }

    private boolean isSDFilter(double[] SD) {
        return SD[0] == 0.0 && SD[1] == 0.0 && SD[2] == 0.0;
    }
}

