/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.io.netcdf;

import java.awt.Dimension;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.esa.beam.dataio.netcdf.AbstractNetCdfWriterPlugIn;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfileInitPartWriter;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartWriter;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfGeocodingPart;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.dataio.netcdf.nc.NWritableFactory;
import org.esa.beam.dataio.netcdf.util.DataTypeUtils;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.jai.ImageManager;

public class BrdfNc4WriterPlugIn
extends AbstractNetCdfWriterPlugIn {
    public String[] getFormatNames() {
        return new String[]{"NetCDF4-GA-BRDF"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".nc"};
    }

    public String getDescription(Locale locale) {
        return "QA4ECV BRDF NetCDF4 products";
    }

    public ProfilePartWriter createGeoCodingPartWriter() {
        return new CfGeocodingPart();
    }

    public ProfileInitPartWriter createInitialisationPartWriter() {
        return new BrdfNc4MainPart();
    }

    public NFileWriteable createWritable(String outputPath) throws IOException {
        return NWritableFactory.create((String)outputPath, (String)"netcdf4");
    }

    private class BrdfNc4MainPart
    implements ProfileInitPartWriter {
        private static final float NODATA = -9999.0f;
        private final String[] PARAMETER_BAND_NAMES = IOUtils.getInversionParameterBandNames();
        private final String[][] UNCERTAINTY_BAND_NAMES = IOUtils.getInversionUncertaintyBandNames();
        private final SimpleDateFormat COMPACT_ISO_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        private Dimension tileSize;

        BrdfNc4MainPart() {
            this.COMPACT_ISO_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void writeProductBody(ProfileWriteContext ctx, Product product) throws IOException {
            NFileWriteable writeable = ctx.getNetcdfFileWriteable();
            this.tileSize = ImageManager.getPreferredTileSize((Product)product);
            writeable.addDimension("y", product.getSceneRasterHeight());
            writeable.addDimension("x", product.getSceneRasterWidth());
            this.addGlobalAttributes(writeable);
            for (String bandName : this.PARAMETER_BAND_NAMES) {
                Band b = product.getBand(bandName);
                if (b == null) continue;
                this.addNc4BrdfMeanVariableWithAttributes(writeable, b);
            }
            for (int i = 0; i < 9; ++i) {
                for (int j = i; j < 9; ++j) {
                    Band b = product.getBand(this.UNCERTAINTY_BAND_NAMES[i][j]);
                    if (b == null) continue;
                    this.addNc4BrdfVarVariableWithAttributes(writeable, b);
                }
            }
            this.addAcAncillaryVariableAttributes(writeable, product);
        }

        private void addAcAncillaryVariableAttributes(NFileWriteable writeable, Product p) throws IOException {
            Band lonBand;
            Band latBand;
            Band daysClosestSampleBand;
            Band proportionNSamplesBand;
            Band goodnessOfFitBand;
            Band weightedNumSamplesBand;
            Band relEntropyBand;
            Band entropyBand = p.getBand("Entropy");
            if (entropyBand != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, entropyBand, "Entropy", -9999.0f, "1");
            }
            if ((relEntropyBand = p.getBand("Relative_Entropy")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, relEntropyBand, "Relative Entropy", -9999.0f, "1");
            }
            if ((weightedNumSamplesBand = p.getBand("Weighted_Number_of_Samples")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, weightedNumSamplesBand, "Weighted number of BRDF samples", -9999.0f, "1");
            }
            if ((goodnessOfFitBand = p.getBand("Goodness_of_Fit")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, goodnessOfFitBand, "Goodness of Fit", -9999.0f, "1");
            }
            if ((proportionNSamplesBand = p.getBand("Proportion_NSamples")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, proportionNSamplesBand, "Snow Fraction", -9999.0f, "1");
            }
            if ((daysClosestSampleBand = p.getBand("Time_to_the_Closest_Sample")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, daysClosestSampleBand, "Number of days to the closest sample", -9999.0f, "days");
            }
            if ((latBand = p.getBand("lat")) != null) {
                this.addNc4BrdfLatLonVariableWithAttributes(writeable, latBand, "latitude coordinate", "latitude", "degrees");
            }
            if ((lonBand = p.getBand("lon")) != null) {
                this.addNc4BrdfLatLonVariableWithAttributes(writeable, lonBand, "longitude coordinate", "longitude", "degrees");
            }
        }

        private void addGlobalAttributes(NFileWriteable writeable) throws IOException {
            writeable.addGlobalAttribute("Conventions", "CF-1.6");
            writeable.addGlobalAttribute("history", "QA4ECV Processing, 2014-2017");
            writeable.addGlobalAttribute("title", "QA4ECV BRDF Product");
            writeable.addGlobalAttribute("institution", "Mullard Space Science Laboratory, Department of Space and Climate Physics, University College London");
            writeable.addGlobalAttribute("source", "Satellite observations, BRDF/Albedo Inversion Model");
            writeable.addGlobalAttribute("references", "GlobAlbedo ATBD V4.12");
            writeable.addGlobalAttribute("comment", "none");
        }

        private void addNc4BrdfMeanVariableWithAttributes(NFileWriteable writeable, Band b) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            String[] bSplit = b.getName().split("_");
            String longName = "Mean of parameter " + bSplit[2].toUpperCase() + " in " + bSplit[1];
            variable.addAttribute("long_name", longName);
            Float _fillValue = Float.valueOf((float)b.getNoDataValue());
            variable.addAttribute("_FillValue", (Number)_fillValue);
            variable.addAttribute("coordinates", "lat lon");
            variable.addAttribute("units", "1");
        }

        private void addNc4BrdfVarVariableWithAttributes(NFileWriteable writeable, Band b) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            String[] bSplit = b.getName().split("_");
            String longName = "Covariance(" + bSplit[1] + "_" + bSplit[2].toUpperCase() + "," + bSplit[3] + "_" + bSplit[4].toUpperCase() + ")";
            variable.addAttribute("long_name", longName);
            Float _fillValue = Float.valueOf((float)b.getNoDataValue());
            variable.addAttribute("_FillValue", (Number)_fillValue);
            variable.addAttribute("coordinates", "lat lon");
            variable.addAttribute("units", "1");
        }

        private void addNc4BrdfAncillaryVariableWithAttributes(NFileWriteable writeable, Band b, String longName, float fillValue, String unit) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            variable.addAttribute("long_name", longName);
            Float _fillValue = Float.valueOf(fillValue);
            variable.addAttribute("_FillValue", (Number)_fillValue);
            variable.addAttribute("coordinates", "lat lon");
            this.addUnitAttribute(unit, variable);
        }

        private void addNc4BrdfLatLonVariableWithAttributes(NFileWriteable writeable, Band b, String longName, String standardName, String unit) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            variable.addAttribute("long_name", longName);
            variable.addAttribute("long_name", standardName);
            this.addUnitAttribute(unit, variable);
        }

        private void addUnitAttribute(String unit, NVariable variable) throws IOException {
            if (unit != null) {
                variable.addAttribute("units", unit);
            }
        }

        private NVariable addNc4Variable(NFileWriteable writeable, Band b) throws IOException {
            return writeable.addVariable(b.getName(), DataTypeUtils.getNetcdfDataType((int)30), this.tileSize, writeable.getDimensions());
        }
    }
}

