/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.io.netcdf;

import java.awt.Dimension;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.esa.beam.dataio.netcdf.AbstractNetCdfWriterPlugIn;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfileInitPartWriter;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartWriter;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfGeocodingPart;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.dataio.netcdf.nc.NWritableFactory;
import org.esa.beam.dataio.netcdf.util.DataTypeUtils;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.jai.ImageManager;

public class AlbedoNc4WriterPlugIn
extends AbstractNetCdfWriterPlugIn {
    public String[] getFormatNames() {
        return new String[]{"NetCDF4-GA-ALBEDO"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".nc"};
    }

    public String getDescription(Locale locale) {
        return "QA4ECV Albedo NetCDF4 products";
    }

    public ProfilePartWriter createGeoCodingPartWriter() {
        return new CfGeocodingPart();
    }

    public ProfileInitPartWriter createInitialisationPartWriter() {
        return new AlbedoNc4MainPart();
    }

    public NFileWriteable createWritable(String outputPath) throws IOException {
        return NWritableFactory.create((String)outputPath, (String)"netcdf4");
    }

    private class AlbedoNc4MainPart
    implements ProfileInitPartWriter {
        private static final float NODATA = -9999.0f;
        private final String[] BHR_BAND_NAMES = IOUtils.getAlbedoBhrBandNames();
        private final String[] DHR_BAND_NAMES = IOUtils.getAlbedoDhrBandNames();
        private final String[] BHR_ALPHA_BAND_NAMES = IOUtils.getAlbedoBhrAlphaBandNames();
        private final String[] DHR_ALPHA_BAND_NAMES = IOUtils.getAlbedoDhrAlphaBandNames();
        private final String[] BHR_SIGMA_BAND_NAMES = IOUtils.getAlbedoBhrSigmaBandNames();
        private final String[] DHR_SIGMA_BAND_NAMES = IOUtils.getAlbedoDhrSigmaBandNames();
        private final SimpleDateFormat COMPACT_ISO_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        private Dimension tileSize;

        AlbedoNc4MainPart() {
            this.COMPACT_ISO_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void writeProductBody(ProfileWriteContext ctx, Product product) throws IOException {
            Band b;
            NFileWriteable writeable = ctx.getNetcdfFileWriteable();
            this.tileSize = ImageManager.getPreferredTileSize((Product)product);
            writeable.addDimension("y", product.getSceneRasterHeight());
            writeable.addDimension("x", product.getSceneRasterWidth());
            this.addGlobalAttributes(writeable);
            for (String bandName : this.BHR_BAND_NAMES) {
                b = product.getBand(bandName);
                if (b == null) continue;
                this.addNc4BhrVariableWithAttributes(writeable, b);
            }
            for (String bandName : this.DHR_BAND_NAMES) {
                b = product.getBand(bandName);
                if (b == null) continue;
                this.addNc4DhrVariableWithAttributes(writeable, b);
            }
            for (String bandName : this.BHR_ALPHA_BAND_NAMES) {
                b = product.getBand(bandName);
                if (b == null) continue;
                this.addNc4BhrAlphaVariableWithAttributes(writeable, b);
            }
            for (String bandName : this.DHR_ALPHA_BAND_NAMES) {
                b = product.getBand(bandName);
                if (b == null) continue;
                this.addNc4DhrAlphaVariableWithAttributes(writeable, b);
            }
            for (String bandName : this.BHR_SIGMA_BAND_NAMES) {
                b = product.getBand(bandName);
                if (b == null) continue;
                this.addNc4BhrSigmaVariableWithAttributes(writeable, b);
            }
            for (String bandName : this.DHR_SIGMA_BAND_NAMES) {
                b = product.getBand(bandName);
                if (b == null) continue;
                this.addNc4DhrSigmaVariableWithAttributes(writeable, b);
            }
            this.addAcAncillaryVariableAttributes(writeable, product);
        }

        private void addAcAncillaryVariableAttributes(NFileWriteable writeable, Product p) throws IOException {
            Band lonBand;
            Band latBand;
            Band szaBand;
            Band dataMaskBand;
            Band snowFractionBand;
            Band goodnessOfFitBand;
            Band weightedNumSamplesBand;
            Band relEntropyBand = p.getBand("Relative_Entropy");
            if (relEntropyBand != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, relEntropyBand, "Relative Entropy", -9999.0f, "1");
            }
            if ((weightedNumSamplesBand = p.getBand("Weighted_Number_of_Samples")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, weightedNumSamplesBand, "Weighted number of albedo samples", -9999.0f, "1");
            }
            if ((goodnessOfFitBand = p.getBand("Goodness_of_Fit")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, goodnessOfFitBand, "Goodness of Fit", -9999.0f, "1");
            }
            if ((snowFractionBand = p.getBand("Snow_Fraction")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, snowFractionBand, "Snow Fraction", -9999.0f, "1");
            }
            if ((dataMaskBand = p.getBand("Data_Mask")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, dataMaskBand, "Data Mask", -9999.0f, "1");
            }
            if ((szaBand = p.getBand("Solar_Zenith_Angle")) != null) {
                this.addNc4BrdfAncillaryVariableWithAttributes(writeable, szaBand, "Solar Zenith Angle", -9999.0f, "degrees");
            }
            if ((latBand = p.getBand("lat")) != null) {
                this.addNc4BrdfLatLonVariableWithAttributes(writeable, latBand, "latitude coordinate", "latitude", "degrees");
            }
            if ((lonBand = p.getBand("lon")) != null) {
                this.addNc4BrdfLatLonVariableWithAttributes(writeable, lonBand, "longitude coordinate", "longitude", "degrees");
            }
        }

        private void addGlobalAttributes(NFileWriteable writeable) throws IOException {
            writeable.addGlobalAttribute("Conventions", "CF-1.6");
            writeable.addGlobalAttribute("history", "QA4ECV Processing, 2014-2017");
            writeable.addGlobalAttribute("title", "QA4ECV Albedo Product");
            writeable.addGlobalAttribute("institution", "Mullard Space Science Laboratory, Department of Space and Climate Physics, University College London");
            writeable.addGlobalAttribute("source", "Satellite observations, BRDF/Albedo Inversion Model");
            writeable.addGlobalAttribute("references", "GlobAlbedo ATBD V4.12");
            writeable.addGlobalAttribute("comment", "none");
        }

        private void addNc4BhrVariableWithAttributes(NFileWriteable writeable, Band b) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            String[] bSplit = b.getName().split("_");
            String longName = "Bi-Hemisphere Reflectance albedo - " + bSplit[1].toUpperCase() + " band";
            this.addAlbedoVariableAttributes(b, variable, longName);
        }

        private void addNc4DhrVariableWithAttributes(NFileWriteable writeable, Band b) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            String[] bSplit = b.getName().split("_");
            String longName = "Directional Hemisphere Reflectance albedo - " + bSplit[1].toUpperCase() + " band";
            this.addAlbedoVariableAttributes(b, variable, longName);
        }

        private void addNc4BhrAlphaVariableWithAttributes(NFileWriteable writeable, Band b) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            String[] bSplit = b.getName().split("_");
            String longName = "Bi-Hemisphere Reflectance albedo - (" + bSplit[2].toUpperCase() + "," + bSplit[3].toUpperCase() + ") alpha correlation term";
            this.addAlbedoVariableAttributes(b, variable, longName);
        }

        private void addNc4DhrAlphaVariableWithAttributes(NFileWriteable writeable, Band b) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            String[] bSplit = b.getName().split("_");
            String longName = "Directional Hemisphere Reflectance albedo - (" + bSplit[2].toUpperCase() + "," + bSplit[3].toUpperCase() + ") alpha correlation term";
            this.addAlbedoVariableAttributes(b, variable, longName);
        }

        private void addNc4BhrSigmaVariableWithAttributes(NFileWriteable writeable, Band b) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            String[] bSplit = b.getName().split("_");
            String longName = "Uncertainty of Bi-Hemisphere Reflectance albedo - " + bSplit[2].toUpperCase() + " band";
            this.addAlbedoVariableAttributes(b, variable, longName);
        }

        private void addNc4DhrSigmaVariableWithAttributes(NFileWriteable writeable, Band b) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            String[] bSplit = b.getName().split("_");
            String longName = "Uncertainty of Directional Hemisphere Reflectance albedo - " + bSplit[2].toUpperCase() + " band";
            this.addAlbedoVariableAttributes(b, variable, longName);
        }

        private void addAlbedoVariableAttributes(Band b, NVariable variable, String longName) throws IOException {
            variable.addAttribute("long_name", longName);
            Float _fillValue = Float.valueOf((float)b.getNoDataValue());
            variable.addAttribute("_FillValue", (Number)_fillValue);
            variable.addAttribute("units", "1");
            variable.addAttribute("coordinates", "lat lon");
        }

        private void addNc4BrdfAncillaryVariableWithAttributes(NFileWriteable writeable, Band b, String longName, float fillValue, String unit) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            variable.addAttribute("long_name", longName);
            Float _fillValue = Float.valueOf(fillValue);
            variable.addAttribute("_FillValue", (Number)_fillValue);
            variable.addAttribute("coordinates", "lat lon");
            this.addUnitAttribute(unit, variable);
        }

        private void addNc4BrdfLatLonVariableWithAttributes(NFileWriteable writeable, Band b, String longName, String standardName, String unit) throws IOException {
            NVariable variable = this.addNc4Variable(writeable, b);
            variable.addAttribute("long_name", longName);
            variable.addAttribute("long_name", standardName);
            this.addUnitAttribute(unit, variable);
        }

        private void addUnitAttribute(String unit, NVariable variable) throws IOException {
            if (unit != null) {
                variable.addAttribute("units", unit);
            }
        }

        private NVariable addNc4Variable(NFileWriteable writeable, Band b) throws IOException {
            return writeable.addVariable(b.getName(), DataTypeUtils.getNetcdfDataType((int)30), this.tileSize, writeable.getDimensions());
        }
    }
}

