/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion.io.netcdf;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfGeocodingPart;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.globalbedo.inversion.util.ModisTileGeoCoding;
import org.esa.beam.util.StringUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import ucar.ma2.DataType;

public class AlbedoInversionGeocodingPart
extends CfGeocodingPart {
    public static final String TIEPOINT_COORDINATES = "tiepoint_coordinates";
    private static final int LON_INDEX = 0;
    private static final int LAT_INDEX = 1;

    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        GeoCoding geoCoding = p.getGeoCoding();
        if (geoCoding instanceof TiePointGeoCoding) {
            TiePointGeoCoding tpGC = (TiePointGeoCoding)geoCoding;
            String[] names = new String[]{tpGC.getLonGrid().getName(), tpGC.getLatGrid().getName()};
            String value = StringUtils.arrayToString((Object)names, (String)" ");
            ctx.getNetcdfFileWriteable().addGlobalAttribute(TIEPOINT_COORDINATES, value);
        } else if (geoCoding instanceof CrsGeoCoding || geoCoding instanceof ModisTileGeoCoding) {
            this.addWktAsVariable(ctx.getNetcdfFileWriteable(), geoCoding);
        }
    }

    private void addWktAsVariable(NFileWriteable ncFile, GeoCoding geoCoding) throws IOException {
        CoordinateReferenceSystem crs = geoCoding.getMapCRS();
        if (crs != null && crs.toWKT() != null) {
            double[] matrix = new double[6];
            MathTransform transform = geoCoding.getImageToMapTransform();
            if (transform instanceof AffineTransform) {
                ((AffineTransform)transform).getMatrix(matrix);
            }
            NVariable crsVariable = ncFile.addScalarVariable("crs", DataType.INT);
            crsVariable.addAttribute("wkt", crs.toWKT());
            crsVariable.addAttribute("i2m", StringUtils.arrayToCsv((Object)matrix));
            crsVariable.addAttribute("long_name", "Coordinate Reference System");
            String crsCommentString = "A coordinate reference system (CRS) defines defines how the georeferenced spatial data relates to real locations on the Earth's surface";
            crsVariable.addAttribute("comment", "A coordinate reference system (CRS) defines defines how the georeferenced spatial data relates to real locations on the Earth's surface");
        }
    }
}

