/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import Jama.LUDecomposition;
import Jama.Matrix;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.globalbedo.inversion.InversionOp;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;

public class Prior {
    private Matrix M;
    private Matrix V;
    private double mask;
    private Matrix parameters;

    public Prior(Matrix m, Matrix v, double mask, Matrix parameters) {
        this.M = m;
        this.V = v;
        this.mask = mask;
        this.parameters = parameters;
    }

    public static Prior createForInversion(Sample[] sourceSamples, double priorScaleFactor) {
        int i;
        Matrix C = new Matrix(9, 9);
        Matrix inverseC = new Matrix(9, 9);
        Matrix inverseC_F = new Matrix(9, 1);
        int priorIndexNsamples = InversionOp.SRC_PRIOR_NSAMPLES;
        double nSamplesValue = sourceSamples[priorIndexNsamples].getDouble();
        double nSamples = AlbedoInversionUtils.isValid(nSamplesValue) ? nSamplesValue : 0.0;
        Matrix priorMean = new Matrix(9, 1);
        Matrix priorSD = new Matrix(9, 1);
        int index = 0;
        double mask = 1.0;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int priorIndexMij = InversionOp.SRC_PRIOR_MEAN[i][j];
                double m_ij_value = sourceSamples[priorIndexMij].getDouble();
                double m_ij = AlbedoInversionUtils.isValid(m_ij_value) ? m_ij_value : 0.0;
                priorMean.set(index, 0, m_ij);
                int priorIndexSDij = InversionOp.SRC_PRIOR_SD[i][j];
                double cov_ij_value = sourceSamples[priorIndexSDij].getDouble();
                double sd_ij = AlbedoInversionUtils.isValid(cov_ij_value) ? Math.sqrt(cov_ij_value) : 0.0;
                priorSD.set(index, 0, sd_ij);
                if (priorMean.get(index, 0) > 0.0 && priorSD.get(index, 0) == 0.0) {
                    priorSD.set(index, 0, 1.0);
                }
                ++index;
            }
        }
        for (i = 0; i < 9; ++i) {
            priorSD.set(i, 0, Math.min(1.0, priorSD.get(i, 0) * priorScaleFactor * 0.01));
            C.set(i, i, priorSD.get(i, 0) * priorSD.get(i, 0));
        }
        mask = 1.0;
        LUDecomposition lud = new LUDecomposition(C);
        if (lud.isNonsingular()) {
            inverseC = C.inverse();
        } else {
            index = 0;
            boolean processPixel = true;
            block3: for (int i2 = 0; i2 < 3; ++i2) {
                for (int j = 0; j < 3; ++j) {
                    if (priorMean.get(index, 0) <= 0.0 || priorMean.get(index, 0) > 1.0 || priorSD.get(index, 0) <= 0.0 || priorSD.get(index, 0) > 1.0) {
                        processPixel = false;
                        continue block3;
                    }
                    ++index;
                }
            }
            if (processPixel) {
                Matrix cIdentity = Matrix.identity((int)9, (int)9);
                inverseC = cIdentity.inverse();
                index = 0;
                for (int i3 = 0; i3 < 3; ++i3) {
                    for (int j = 0; j < 3; ++j) {
                        inverseC_F.set(index, 0, inverseC.get(index, index) * priorMean.get(index, 0));
                        ++index;
                    }
                }
            } else {
                mask = 0.0;
            }
        }
        index = 0;
        for (int i4 = 0; i4 < 3; ++i4) {
            for (int j = 0; j < 3; ++j) {
                inverseC_F.set(index, 0, inverseC.get(index, index) * priorMean.get(index, 0));
                ++index;
            }
        }
        return new Prior(inverseC, inverseC_F, mask, priorMean);
    }

    public Matrix getM() {
        return this.M;
    }

    public Matrix getV() {
        return this.V;
    }

    public double getMask() {
        return this.mask;
    }

    public Matrix getParameters() {
        return this.parameters;
    }
}

