/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import javax.media.jai.BorderExtender;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.util.ProductUtils;

@OperatorMetadata(alias="ga.l3.outlierremoval", description="Provides daily accumulation of single BBDR observations (new improved prototype)", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class OutlierRetrievalOp
extends Operator {
    @SourceProduct(description="BBDR source product")
    private Product sourceProduct;
    @SourceProduct(description="BBDR source product")
    private Product priorProduct;
    @Parameter(defaultValue="BRDF_Albedo_Parameters_", description="Prefix of prior mean band (default fits to the latest prior version)")
    private String priorMeanBandNamePrefix;
    @Parameter(defaultValue="BRDF_Albedo_Parameters_", description="Prefix of prior SD band (default fits to the latest prior version)")
    private String priorSdBandNamePrefix;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="4", description="Outlier criterion threshold")
    private int outlierThresh;
    @Parameter(defaultValue="6.0", valueSet={"0.5", "1.0", "2.0", "4.0", "6.0", "10.0", "12.0", "20.0", "60.0"}, description="Scale factor with regard to MODIS default 1200x1200. Values > 1.0 reduce product size. For AVHRR/GEO set to 6.0")
    protected double modisTileScaleFactor;
    private Tile kvolVisTile;
    private Tile kvolNirTile;
    private Tile kvolSwTile;
    private Tile kgeoVisTile;
    private Tile kgeoNirTile;
    private Tile kgeoSwTile;
    private Tile[] priorVisAvrTiles;
    private Tile[] priorVisSdTiles;
    private Tile[] priorNirAvrTiles;
    private Tile[] priorNirSdTiles;
    private Tile[] priorSwAvrTiles;
    private Tile[] priorSwSdTiles;

    public void initialize() throws OperatorException {
        int sourceProductWidth = (int)(1200.0 / this.modisTileScaleFactor);
        int sourceProductHeight = (int)(1200.0 / this.modisTileScaleFactor);
        Rectangle sourceRect = new Rectangle(0, 0, sourceProductWidth, sourceProductHeight);
        this.kvolVisTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("Kvol_BRDF_VIS"), sourceRect);
        this.kvolNirTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("Kvol_BRDF_NIR"), sourceRect);
        this.kvolSwTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("Kvol_BRDF_SW"), sourceRect);
        this.kgeoVisTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("Kgeo_BRDF_VIS"), sourceRect);
        this.kgeoNirTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("Kgeo_BRDF_NIR"), sourceRect);
        this.kgeoSwTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("Kgeo_BRDF_SW"), sourceRect);
        this.priorVisAvrTiles = new Tile[3];
        this.priorVisSdTiles = new Tile[3];
        this.priorNirAvrTiles = new Tile[3];
        this.priorNirSdTiles = new Tile[3];
        this.priorSwAvrTiles = new Tile[3];
        this.priorSwSdTiles = new Tile[3];
        for (int i = 0; i < 3; ++i) {
            this.priorVisAvrTiles[i] = this.getSourceTile((RasterDataNode)this.priorProduct.getBand(this.priorMeanBandNamePrefix + "vis_f" + i + "_avr"), sourceRect);
            this.priorVisSdTiles[i] = this.getSourceTile((RasterDataNode)this.priorProduct.getBand(this.priorSdBandNamePrefix + "vis_f" + i + "_sd"), sourceRect);
            this.priorNirAvrTiles[i] = this.getSourceTile((RasterDataNode)this.priorProduct.getBand(this.priorMeanBandNamePrefix + "nir_f" + i + "_avr"), sourceRect);
            this.priorNirSdTiles[i] = this.getSourceTile((RasterDataNode)this.priorProduct.getBand(this.priorSdBandNamePrefix + "nir_f" + i + "_sd"), sourceRect);
            this.priorSwAvrTiles[i] = this.getSourceTile((RasterDataNode)this.priorProduct.getBand(this.priorMeanBandNamePrefix + "shortwave_f" + i + "_avr"), sourceRect);
            this.priorSwSdTiles[i] = this.getSourceTile((RasterDataNode)this.priorProduct.getBand(this.priorSdBandNamePrefix + "shortwave_f" + i + "_sd"), sourceRect);
        }
        Product targetProduct = this.createTargetProduct();
        this.setTargetProduct(targetProduct);
    }

    private Product createTargetProduct() {
        Product targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)targetProduct);
        targetProduct.setStartTime(this.sourceProduct.getStartTime());
        targetProduct.setEndTime(this.sourceProduct.getEndTime());
        targetProduct.addBand("BB_VIS", 30);
        targetProduct.addBand("BB_NIR", 30);
        targetProduct.addBand("BB_SW", 30);
        for (Band band : this.sourceProduct.getBands()) {
            if (targetProduct.containsBand(band.getName()) || this.isBbdrBand(band.getName())) continue;
            ProductUtils.copyBand((String)band.getName(), (Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)band, (RasterDataNode)targetProduct.getBand(band.getName()));
        }
        for (Band band : this.sourceProduct.getTiePointGrids()) {
            if (targetProduct.containsTiePointGrid(band.getName())) continue;
            ProductUtils.copyTiePointGrid((String)band.getName(), (Product)this.sourceProduct, (Product)targetProduct);
        }
        for (Band band : targetProduct.getBands()) {
            band.setNoDataValue(Double.NaN);
            band.setNoDataValueUsed(true);
        }
        return targetProduct;
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        RasterDataNode sourceRaster = this.sourceProduct.getRasterDataNode(targetBand.getName());
        Rectangle rectangle = targetTile.getRectangle();
        Tile sourceTile = this.getSourceTile(sourceRaster, rectangle, BorderExtender.createInstance((int)1));
        Tile[] priorAvrTiles = this.getPriorAvrTiles(targetBand.getName());
        Tile[] priorSdTiles = this.getPriorSdTiles(targetBand.getName());
        float[] priorParms = new float[3];
        float[] priorSd = new float[3];
        Tile kvolTile = this.getKvolTile(targetBand.getName());
        Tile kgeoTile = this.getKgeoTile(targetBand.getName());
        for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
            for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                float bbdrValue = sourceTile.getSampleFloat(x, y);
                float kvolValue = kvolTile.getSampleFloat(x, y);
                float kgeoValue = kgeoTile.getSampleFloat(x, y);
                for (int i = 0; i < 3; ++i) {
                    priorParms[i] = priorAvrTiles[i].getSampleFloat(x, y);
                    priorSd[i] = priorSdTiles[i].getSampleFloat(x, y);
                }
                float outlierDelta = OutlierRetrievalOp.checkForOutliers(bbdrValue, priorParms, priorSd, kvolValue, kgeoValue);
                if (outlierDelta > (float)this.outlierThresh) {
                    targetTile.setSample(x, y, Float.NaN);
                    continue;
                }
                targetTile.setSample(x, y, bbdrValue);
            }
        }
    }

    static float checkForOutliers(float bbdrValue, float[] priorParms, float[] priorSd, float kvol, float kgeo) {
        float obsPrediction = priorParms[0] + priorParms[1] * kvol + priorParms[2] * kgeo;
        float sdMean = (priorSd[0] + priorSd[1] + priorSd[2]) / 3.0f;
        return Math.abs((obsPrediction - bbdrValue) / sdMean);
    }

    private Tile[] getPriorAvrTiles(String bbChannel) {
        if (bbChannel.endsWith("VIS")) {
            return this.priorVisAvrTiles;
        }
        if (bbChannel.endsWith("NIR")) {
            return this.priorNirAvrTiles;
        }
        if (bbChannel.endsWith("SW")) {
            return this.priorSwAvrTiles;
        }
        return null;
    }

    private Tile[] getPriorSdTiles(String bbChannel) {
        if (bbChannel.endsWith("VIS")) {
            return this.priorVisSdTiles;
        }
        if (bbChannel.endsWith("NIR")) {
            return this.priorNirSdTiles;
        }
        if (bbChannel.endsWith("SW")) {
            return this.priorSwSdTiles;
        }
        return null;
    }

    private Tile getKvolTile(String bbChannel) {
        if (bbChannel.endsWith("VIS")) {
            return this.kvolVisTile;
        }
        if (bbChannel.endsWith("NIR")) {
            return this.kvolNirTile;
        }
        if (bbChannel.endsWith("SW")) {
            return this.kvolSwTile;
        }
        return null;
    }

    private Tile getKgeoTile(String bbChannel) {
        if (bbChannel.endsWith("VIS")) {
            return this.kgeoVisTile;
        }
        if (bbChannel.endsWith("NIR")) {
            return this.kgeoNirTile;
        }
        if (bbChannel.endsWith("SW")) {
            return this.kgeoSwTile;
        }
        return null;
    }

    private boolean isBbdrBand(String bandName) {
        return bandName.equals("BB_VIS") || bandName.equals("BB_NIR") || bandName.equals("BB_SW");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OutlierRetrievalOp.class);
        }
    }
}

