/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProducts;
import org.esa.beam.framework.gpf.pointop.PixelOperator;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.globalbedo.inversion.AlbedoResult;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;

@OperatorMetadata(alias="ga.albedo.monthlymosaics", description="Provides monthly from 8-day albedo mosaics. Includes now BHR and DHR alpha terms.", authors="Olaf Danne", version="1.0", copyright="(C) 2011 by Brockmann Consult")
public class MonthlyFrom8DayAlbedoMosaicsOp
extends PixelOperator {
    private String[] dhrBandNames = new String[3];
    private String[] dhrAlphaBandNames = new String[3];
    private String[] dhrSigmaBandNames = new String[3];
    private String[] bhrBandNames = new String[3];
    private String[] bhrAlphaBandNames = new String[3];
    private String[] bhrSigmaBandNames = new String[3];
    private String relEntropyBandName;
    private String weightedNumberOfSamplesBandName;
    private String goodnessOfFitBandName;
    private String snowFractionBandName;
    private String dataMaskBandName;
    private String szaBandName;
    private static final int[] SRC_DHR = new int[3];
    private static final int[] SRC_DHR_ALPHA = new int[3];
    private static final int[] SRC_DHR_SIGMA = new int[3];
    private static final int[] SRC_BHR = new int[3];
    private static final int[] SRC_BHR_ALPHA = new int[3];
    private static final int[] SRC_BHR_SIGMA = new int[3];
    private static final int SRC_WEIGHTED_NUM_SAMPLES = 12;
    private static final int SRC_REL_ENTROPY = 13;
    private static final int SRC_GOODNESS_OF_FIT = 14;
    private static final int SRC_SNOW_FRACTION = 15;
    private static final int SRC_DATA_MASK = 16;
    private static final int SRC_SZA = 17;
    public static final int SOURCE_SAMPLE_OFFSET = 25;
    private static final int[] TRG_DHR = new int[3];
    private static final int[] TRG_DHR_ALPHA = new int[3];
    private static final int[] TRG_DHR_SIGMA = new int[3];
    private static final int[] TRG_BHR = new int[3];
    private static final int[] TRG_BHR_ALPHA = new int[3];
    private static final int[] TRG_BHR_SIGMA = new int[3];
    private static final int TRG_WEIGHTED_NUM_SAMPLES = 0;
    private static final int TRG_REL_ENTROPY = 1;
    private static final int TRG_GOODNESS_OF_FIT = 2;
    private static final int TRG_SNOW_FRACTION = 3;
    private static final int TRG_DATA_MASK = 4;
    private static final int TRG_SZA = 5;
    @SourceProducts(description="Albedo 8-day products")
    private Product[] albedo8DayProduct;
    @Parameter(defaultValue="1", interval="[1,12]", description="Month index")
    private int monthIndex;
    private int[] doy;
    private float[][] monthlyWeighting;

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        double[] monthlyDHR = new double[3];
        double[] monthlyBHR = new double[3];
        double[] monthlyDHRAlpha = new double[3];
        double[] monthlyBHRAlpha = new double[3];
        double[] monthlyDHRSigma = new double[3];
        double[] monthlyBHRSigma = new double[3];
        double monthlyNsamples = 0.0;
        double monthlyRelativeEntropy = 0.0;
        double monthlyGoodnessOfFit = 0.0;
        double monthlySnowFraction = 0.0;
        double monthlyDataMask = 0.0;
        double monthlySza = 0.0;
        double sumWeights = 0.0;
        for (int j = 0; j < this.albedo8DayProduct.length; ++j) {
            double dataMask = sourceSamples[j * 25 + 16].getDouble();
            double relEntropy = sourceSamples[j * 25 + 13].getDouble();
            if (!AlbedoInversionUtils.isValid(relEntropy) || !(relEntropy > 0.0)) continue;
            float thisWeight = this.monthlyWeighting[this.monthIndex - 1][this.doy[j] - 1];
            for (int i = 0; i < 3; ++i) {
                double bhrSigmaSample;
                double dhrSigmaSample;
                double bhrAlphaSample;
                double dhrAlphaSample;
                double bhrSample;
                double dhrSample = sourceSamples[j * 25 + SRC_DHR[i]].getDouble();
                if (AlbedoInversionUtils.isValid(dhrSample)) {
                    int n = i;
                    monthlyDHR[n] = monthlyDHR[n] + (double)thisWeight * dhrSample;
                }
                if (AlbedoInversionUtils.isValid(bhrSample = sourceSamples[j * 25 + SRC_BHR[i]].getDouble())) {
                    int n = i;
                    monthlyBHR[n] = monthlyBHR[n] + (double)thisWeight * bhrSample;
                }
                if (AlbedoInversionUtils.isValid(dhrAlphaSample = sourceSamples[j * 25 + SRC_DHR_ALPHA[i]].getDouble())) {
                    int n = i;
                    monthlyDHRAlpha[n] = monthlyDHRAlpha[n] + (double)thisWeight * dhrAlphaSample;
                }
                if (AlbedoInversionUtils.isValid(bhrAlphaSample = sourceSamples[j * 25 + SRC_BHR_ALPHA[i]].getDouble())) {
                    int n = i;
                    monthlyBHRAlpha[n] = monthlyBHRAlpha[n] + (double)thisWeight * bhrAlphaSample;
                }
                if (AlbedoInversionUtils.isValid(dhrSigmaSample = sourceSamples[j * 25 + SRC_DHR_SIGMA[i]].getDouble())) {
                    int n = i;
                    monthlyDHRSigma[n] = monthlyDHRSigma[n] + (double)thisWeight * dhrSigmaSample;
                }
                if (!AlbedoInversionUtils.isValid(bhrSigmaSample = sourceSamples[j * 25 + SRC_BHR_SIGMA[i]].getDouble())) continue;
                int n = i;
                monthlyBHRSigma[n] = monthlyBHRSigma[n] + (double)thisWeight * bhrSigmaSample;
            }
            if (AlbedoInversionUtils.isValid(sourceSamples[j * 25 + 12].getDouble())) {
                monthlyNsamples += (double)thisWeight * sourceSamples[j * 25 + 12].getDouble();
            }
            if (AlbedoInversionUtils.isValid(sourceSamples[j * 25 + 13].getDouble())) {
                monthlyRelativeEntropy += (double)thisWeight * sourceSamples[j * 25 + 13].getDouble();
            }
            if (AlbedoInversionUtils.isValid(sourceSamples[j * 25 + 14].getDouble())) {
                monthlyGoodnessOfFit += (double)thisWeight * sourceSamples[j * 25 + 14].getDouble();
            }
            if (AlbedoInversionUtils.isValid(sourceSamples[j * 25 + 15].getDouble())) {
                monthlySnowFraction += (double)thisWeight * sourceSamples[j * 25 + 15].getDouble();
            }
            monthlyDataMask = 1.0;
            if (AlbedoInversionUtils.isValid(sourceSamples[j * 25 + 17].getDouble())) {
                monthlySza += (double)thisWeight * sourceSamples[j * 25 + 17].getDouble();
            }
            sumWeights += (double)thisWeight;
        }
        if (sumWeights > 0.0) {
            int i = 0;
            while (i < 3) {
                int n = i;
                monthlyDHR[n] = monthlyDHR[n] / sumWeights;
                int n2 = i;
                monthlyBHR[n2] = monthlyBHR[n2] / sumWeights;
                int n3 = i;
                monthlyDHRSigma[n3] = monthlyDHRSigma[n3] / sumWeights;
                int n4 = i;
                monthlyBHRSigma[n4] = monthlyBHRSigma[n4] / sumWeights;
                int n5 = i;
                monthlyDHRAlpha[n5] = monthlyDHRAlpha[n5] / sumWeights;
                int n6 = i++;
                monthlyBHRAlpha[n6] = monthlyBHRAlpha[n6] / sumWeights;
            }
            monthlyNsamples /= sumWeights;
            monthlyRelativeEntropy /= sumWeights;
            monthlyGoodnessOfFit /= sumWeights;
            monthlySnowFraction /= sumWeights;
            monthlySza /= sumWeights;
        }
        AlbedoResult result = new AlbedoResult(monthlyDHR, monthlyDHRAlpha, monthlyDHRSigma, monthlyBHR, monthlyBHRAlpha, monthlyBHRSigma, monthlyNsamples, monthlyRelativeEntropy, monthlyGoodnessOfFit, monthlySnowFraction, monthlyDataMask, monthlySza);
        this.fillTargetSamples(targetSamples, result);
    }

    private void fillTargetSamples(WritableSample[] targetSamples, AlbedoResult result) {
        int i;
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_DHR[i]].set(result.getBsa()[i]);
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_DHR_ALPHA[i]].set(result.getBsaAlpha()[i]);
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_DHR_SIGMA[i]].set(result.getBsaSigmaArray()[i]);
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_BHR[i]].set(result.getWsa()[i]);
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_BHR_ALPHA[i]].set(result.getWsaAlpha()[i]);
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_BHR_SIGMA[i]].set(result.getWsaSigmaArray()[i]);
        }
        int index = 18;
        targetSamples[index + 0].set(result.getWeightedNumberOfSamples());
        targetSamples[index + 1].set(result.getRelEntropy());
        targetSamples[index + 2].set(result.getGoodnessOfFit());
        targetSamples[index + 3].set(result.getSnowFraction());
        targetSamples[index + 4].set(result.getDataMask());
        targetSamples[index + 5].set(result.getSza());
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        int i;
        super.configureTargetProduct(productConfigurer);
        Product targetProduct = productConfigurer.getTargetProduct();
        this.dhrBandNames = IOUtils.getAlbedoDhrBandNames();
        int index = 0;
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.SRC_DHR[i] = index++;
            targetProduct.addBand(this.dhrBandNames[i], 30);
        }
        this.dhrAlphaBandNames = IOUtils.getAlbedoDhrAlphaBandNames();
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.SRC_DHR_ALPHA[i] = index++;
            targetProduct.addBand(this.dhrAlphaBandNames[i], 30);
        }
        this.dhrSigmaBandNames = IOUtils.getAlbedoDhrSigmaBandNames();
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.SRC_DHR_SIGMA[i] = index++;
            targetProduct.addBand(this.dhrSigmaBandNames[i], 30);
        }
        this.bhrBandNames = IOUtils.getAlbedoBhrBandNames();
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.SRC_BHR[i] = index++;
            targetProduct.addBand(this.bhrBandNames[i], 30);
        }
        this.bhrAlphaBandNames = IOUtils.getAlbedoBhrAlphaBandNames();
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.SRC_BHR_ALPHA[i] = index++;
            targetProduct.addBand(this.bhrAlphaBandNames[i], 30);
        }
        this.bhrSigmaBandNames = IOUtils.getAlbedoBhrSigmaBandNames();
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.SRC_BHR_SIGMA[i] = index++;
            targetProduct.addBand(this.bhrSigmaBandNames[i], 30);
        }
        this.weightedNumberOfSamplesBandName = "Weighted_Number_of_Samples";
        targetProduct.addBand(this.weightedNumberOfSamplesBandName, 30);
        this.relEntropyBandName = "Relative_Entropy";
        targetProduct.addBand(this.relEntropyBandName, 30);
        this.goodnessOfFitBandName = "Goodness_of_Fit";
        targetProduct.addBand(this.goodnessOfFitBandName, 30);
        this.snowFractionBandName = "Snow_Fraction";
        targetProduct.addBand(this.snowFractionBandName, 30);
        this.dataMaskBandName = "Data_Mask";
        targetProduct.addBand(this.dataMaskBandName, 30);
        this.szaBandName = "Solar_Zenith_Angle";
        targetProduct.addBand(this.szaBandName, 30);
        for (Band b : targetProduct.getBands()) {
            b.setNoDataValue(-9999.0);
            b.setNoDataValueUsed(true);
        }
    }

    protected void configureSourceSamples(SampleConfigurer configurator) throws OperatorException {
        this.doy = new int[this.albedo8DayProduct.length];
        for (int j = 0; j < this.albedo8DayProduct.length; ++j) {
            int i;
            for (i = 0; i < 3; ++i) {
                configurator.defineSample(j * 25 + SRC_DHR[i], this.dhrBandNames[i], this.albedo8DayProduct[j]);
            }
            for (i = 0; i < 3; ++i) {
                configurator.defineSample(j * 25 + SRC_DHR_ALPHA[i], this.dhrAlphaBandNames[i], this.albedo8DayProduct[j]);
            }
            for (i = 0; i < 3; ++i) {
                configurator.defineSample(j * 25 + SRC_BHR[i], this.bhrBandNames[i], this.albedo8DayProduct[j]);
            }
            for (i = 0; i < 3; ++i) {
                configurator.defineSample(j * 25 + SRC_BHR_ALPHA[i], this.bhrAlphaBandNames[i], this.albedo8DayProduct[j]);
            }
            for (i = 0; i < 3; ++i) {
                configurator.defineSample(j * 25 + SRC_DHR_SIGMA[i], this.dhrSigmaBandNames[i], this.albedo8DayProduct[j]);
            }
            for (i = 0; i < 3; ++i) {
                configurator.defineSample(j * 25 + SRC_BHR_SIGMA[i], this.bhrSigmaBandNames[i], this.albedo8DayProduct[j]);
            }
            configurator.defineSample(j * 25 + 12, this.weightedNumberOfSamplesBandName, this.albedo8DayProduct[j]);
            configurator.defineSample(j * 25 + 13, this.relEntropyBandName, this.albedo8DayProduct[j]);
            configurator.defineSample(j * 25 + 14, this.goodnessOfFitBandName, this.albedo8DayProduct[j]);
            configurator.defineSample(j * 25 + 15, this.snowFractionBandName, this.albedo8DayProduct[j]);
            configurator.defineSample(j * 25 + 16, this.dataMaskBandName, this.albedo8DayProduct[j]);
            configurator.defineSample(j * 25 + 17, this.szaBandName, this.albedo8DayProduct[j]);
            this.doy[j] = IOUtils.getDoyFromAlbedoProductName(this.albedo8DayProduct[j].getName());
        }
        this.monthlyWeighting = AlbedoInversionUtils.getMonthlyWeighting();
    }

    protected void configureTargetSamples(SampleConfigurer configurator) throws OperatorException {
        int i;
        int index = 0;
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.TRG_DHR[i] = index++;
            configurator.defineSample(TRG_DHR[i], this.dhrBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.TRG_DHR_ALPHA[i] = index++;
            configurator.defineSample(TRG_DHR_ALPHA[i], this.dhrAlphaBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.TRG_DHR_SIGMA[i] = index++;
            configurator.defineSample(TRG_DHR_SIGMA[i], this.dhrSigmaBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.TRG_BHR[i] = index++;
            configurator.defineSample(TRG_BHR[i], this.bhrBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.TRG_BHR_ALPHA[i] = index++;
            configurator.defineSample(TRG_BHR_ALPHA[i], this.bhrAlphaBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            MonthlyFrom8DayAlbedoMosaicsOp.TRG_BHR_SIGMA[i] = index++;
            configurator.defineSample(TRG_BHR_SIGMA[i], this.bhrSigmaBandNames[i]);
        }
        configurator.defineSample(index++, this.weightedNumberOfSamplesBandName);
        configurator.defineSample(index++, this.relEntropyBandName);
        configurator.defineSample(index++, this.goodnessOfFitBandName);
        configurator.defineSample(index++, this.snowFractionBandName);
        configurator.defineSample(index++, this.dataMaskBandName);
        configurator.defineSample(index++, this.szaBandName);
    }
}

