/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.pointop.PixelOperator;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;

@OperatorMetadata(alias="ga.albedo.mergebrdf", description="Merges BRDF Snow/NoSnow products.", authors="Olaf Danne", version="1.0", copyright="(C) 2011 by Brockmann Consult")
public class MergeBrdfOp
extends PixelOperator {
    private static final int[] SRC_SNOW_PARAMETERS = new int[9];
    private static final int[] SRC_NOSNOW_PARAMETERS = new int[9];
    private static final int urMatrixOffset = ((int)Math.pow(9.0, 2.0) + 9) / 2;
    private static final int[] SRC_SNOW_UNCERTAINTIES = new int[urMatrixOffset];
    private static final int[] SRC_NOSNOW_UNCERTAINTIES = new int[urMatrixOffset];
    private static final int SRC_SNOW_ENTROPY = 0;
    private static final int SRC_NOSNOW_ENTROPY = 0;
    private static final int SRC_SNOW_REL_ENTROPY = 1;
    private static final int SRC_NOSNOW_REL_ENTROPY = 1;
    private static final int SRC_SNOW_WEIGHTED_NUM_SAMPLES = 2;
    private static final int SRC_NOSNOW_WEIGHTED_NUM_SAMPLES = 2;
    private static final int SRC_SNOW_DAYS_CLOSEST_SAMPLE = 3;
    private static final int SRC_NOSNOW_DAYS_CLOSEST_SAMPLE = 3;
    private static final int SRC_SNOW_GOODNESS_OF_FIT = 4;
    private static final int SRC_NOSNOW_GOODNESS_OF_FIT = 4;
    private static final int sourceSampleOffset = 100;
    public static final int priorOffset = (int)Math.pow(3.0, 2.0);
    public static final int SRC_PRIOR_NSAMPLES = 200 + 2 * priorOffset;
    public static final int SRC_PRIOR_MASK = 200 + 2 * priorOffset + 1;
    private static final int[] TRG_PARAMETERS = new int[9];
    private static final int[] TRG_UNCERTAINTIES = new int[urMatrixOffset];
    private static final int TRG_ENTROPY = 0;
    private static final int TRG_REL_ENTROPY = 1;
    private static final int TRG_WEIGHTED_NUM_SAMPLES = 2;
    private static final int TRG_DAYS_CLOSEST_SAMPLE = 3;
    private static final int TRG_GOODNESS_OF_FIT = 4;
    private static final int TRG_PROPORTION_NSAMPLES = 5;
    private String[] parameterBandNames = new String[9];
    private String[][] uncertaintyBandNames = new String[9][9];
    private String entropyBandName;
    private String relEntropyBandName;
    private String weightedNumberOfSamplesBandName;
    private String daysToTheClosestSampleBandName;
    private String goodnessOfFitBandName;
    private String proportionNsamplesBandName;
    @SourceProduct(description="BRDF Snow product")
    private Product snowProduct;
    @SourceProduct(description="BRDF NoSnow product")
    private Product noSnowProduct;
    @SourceProduct(description="Prior product", optional=true)
    private Product priorProduct;
    @Parameter(defaultValue="MEAN:_BAND_", description="Prefix of prior mean band (default fits to the latest prior version)")
    private String priorMeanBandNamePrefix;
    @Parameter(defaultValue="SD:_BAND_", description="Prefix of prior SD band (default fits to the latest prior version)")
    private String priorSdBandNamePrefix;
    @Parameter(defaultValue="7", description="Prior broad bands start index (default fits to the latest prior version)")
    private int priorBandStartIndex;
    @Parameter(defaultValue="Weighted_number_of_samples", description="Prior NSamples band name (default fits to the latest prior version)")
    private String priorNSamplesBandName;
    @Parameter(defaultValue="snowFraction", description="Prior data mask band name (default fits to the latest prior version)")
    private String priorDataMaskBandName;

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        double nSamplesSnowDataValue = sourceSamples[SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 2].getDouble();
        double nSamplesSnow = AlbedoInversionUtils.isValid(nSamplesSnowDataValue) ? nSamplesSnowDataValue : 0.0;
        double nSamplesNoSnowDataValue = sourceSamples[100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 2].getDouble();
        double nSamplesNoSnow = AlbedoInversionUtils.isValid(nSamplesNoSnowDataValue) ? nSamplesNoSnowDataValue : 0.0;
        double totalNSamples = nSamplesSnow + nSamplesNoSnow;
        double entropySnowDataValue = sourceSamples[SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 0].getDouble();
        double entropySnow = AlbedoInversionUtils.isValid(entropySnowDataValue) ? entropySnowDataValue : 0.0;
        double entropyNoSnowDataValue = sourceSamples[100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 0].getDouble();
        double entropyNoSnow = AlbedoInversionUtils.isValid(entropyNoSnowDataValue) ? entropyNoSnowDataValue : 0.0;
        double priorMask = 0.0;
        if (this.priorProduct != null) {
            double priorMaskDataValue = sourceSamples[SRC_PRIOR_MASK].getDouble();
            double d = priorMask = AlbedoInversionUtils.isValid(priorMaskDataValue) ? priorMaskDataValue : 0.0;
        }
        if (!(!(totalNSamples > 0.0) || this.areSnowSamplesZero() && this.areNoSnowSamplesZero())) {
            if (nSamplesNoSnow == 0.0 && !this.areNoSnowSamplesZero() && priorMask == 3.0) {
                this.setMergedBandsToZero(sourceSamples, targetSamples);
                targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 5].set(-9999.0f);
            } else if (priorMask == 0.0 || priorMask == 2.0) {
                this.setMergedBandsToNoSnowBands(sourceSamples, targetSamples);
                targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 5].set(0.0);
            } else {
                double proportionNsamplesNoSnow = nSamplesNoSnow / totalNSamples;
                double proportionNsamplesSnow = nSamplesSnow / totalNSamples;
                this.setMergedBands(sourceSamples, targetSamples, proportionNsamplesSnow, proportionNsamplesNoSnow);
                targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 5].set(proportionNsamplesSnow);
            }
        } else if (this.priorMaskOk(priorMask) && entropySnow != 0.0 && entropyNoSnow != 0.0) {
            if (entropySnow <= entropyNoSnow) {
                this.setMergedBandsToSnowBands(sourceSamples, targetSamples);
                targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 5].set(1.0);
            } else {
                this.setMergedBandsToNoSnowBands(sourceSamples, targetSamples);
                targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 5].set(0.0);
            }
        } else if (this.priorMaskOk(priorMask) && entropySnow != 0.0) {
            this.setMergedBandsToSnowBands(sourceSamples, targetSamples);
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 5].set(1.0);
        } else if (this.priorMaskOk(priorMask) && entropyNoSnow != 0.0) {
            this.setMergedBandsToNoSnowBands(sourceSamples, targetSamples);
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 5].set(0.0);
        } else {
            this.setMergedBandsToZero(sourceSamples, targetSamples);
            targetSamples[5].set(-9999.0f);
        }
    }

    private boolean areSnowSamplesZero() {
        for (int SRC_SNOW_PARAMETER : SRC_SNOW_PARAMETERS) {
            if (!((double)SRC_SNOW_PARAMETER > 0.0)) continue;
            return false;
        }
        return true;
    }

    private boolean areNoSnowSamplesZero() {
        for (int SRC_NOSNOW_PARAMETER : SRC_NOSNOW_PARAMETERS) {
            if (!((double)SRC_NOSNOW_PARAMETER > 0.0)) continue;
            return false;
        }
        return true;
    }

    private void setMergedBandsToSnowBands(Sample[] sourceSamples, WritableSample[] targetSamples) {
        this.setMergedBands(sourceSamples, targetSamples, 1.0, 0.0);
    }

    private void setMergedBandsToZero(Sample[] sourceSamples, WritableSample[] targetSamples) {
        this.setMergedBands(sourceSamples, targetSamples, 0.0, 0.0);
    }

    private void setMergedBandsToNoSnowBands(Sample[] sourceSamples, WritableSample[] targetSamples) {
        this.setMergedBands(sourceSamples, targetSamples, 0.0, 1.0);
    }

    private void setMergedBands(Sample[] sourceSamples, WritableSample[] targetSamples, double proportionNsamplesSnow, double proportionNsamplesNoSnow) {
        int j;
        int i;
        int index = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                double sampleParameterSnowDataValue = sourceSamples[index].getDouble();
                double sampleParameterSnow = AlbedoInversionUtils.isValid(sampleParameterSnowDataValue) ? sampleParameterSnowDataValue : 0.0;
                double sampleParameterNoSnowDataValue = sourceSamples[100 + index].getDouble();
                double sampleParameterNoSnow = AlbedoInversionUtils.isValid(sampleParameterNoSnowDataValue) ? sampleParameterNoSnowDataValue : 0.0;
                double resultParameters = sampleParameterSnow * proportionNsamplesSnow + sampleParameterNoSnow * proportionNsamplesNoSnow;
                if (sampleParameterNoSnow == 0.0 && sampleParameterSnow == 0.0) {
                    targetSamples[TRG_PARAMETERS[index]].set(-9999.0f);
                } else {
                    targetSamples[TRG_PARAMETERS[index]].set(resultParameters);
                }
                ++index;
            }
        }
        index = 0;
        for (i = 0; i < 9; ++i) {
            for (j = i; j < 9; ++j) {
                double sampleUncertaintySnowDataValue = sourceSamples[SRC_SNOW_PARAMETERS.length + index].getDouble();
                double sampleUncertaintySnow = AlbedoInversionUtils.isValid(sampleUncertaintySnowDataValue) ? sampleUncertaintySnowDataValue : 0.0;
                double sampleUncertaintyNoSnowDataValue = sourceSamples[100 + SRC_SNOW_PARAMETERS.length + index].getDouble();
                double sampleUncertaintyNoSnow = AlbedoInversionUtils.isValid(sampleUncertaintyNoSnowDataValue) ? sampleUncertaintyNoSnowDataValue : 0.0;
                double resultUncertainties = sampleUncertaintySnow * proportionNsamplesSnow + sampleUncertaintyNoSnow * proportionNsamplesNoSnow;
                if (sampleUncertaintySnow == 0.0 && sampleUncertaintyNoSnow == 0.0) {
                    targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES[index]].set(-9999.0f);
                } else {
                    targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES[index]].set(resultUncertainties);
                }
                ++index;
            }
        }
        double sampleEntropySnowDataValue = sourceSamples[SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 0].getDouble();
        double sampleEntropySnow = AlbedoInversionUtils.isValid(sampleEntropySnowDataValue) ? sampleEntropySnowDataValue : 0.0;
        double sampleEntropyNoSnowDataValue = sourceSamples[100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 0].getDouble();
        double sampleEntropyNoSnow = AlbedoInversionUtils.isValid(sampleEntropyNoSnowDataValue) ? sampleEntropyNoSnowDataValue : 0.0;
        double resultEntropy = sampleEntropySnow * proportionNsamplesSnow + sampleEntropyNoSnow * proportionNsamplesNoSnow;
        if (sampleEntropyNoSnow == 0.0 && sampleEntropySnow == 0.0) {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 0].set(-9999.0f);
        } else {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 0].set(resultEntropy);
        }
        double sampleRelEntropySnowDataValue = sourceSamples[SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 1].getDouble();
        double sampleRelEntropySnow = AlbedoInversionUtils.isValid(sampleRelEntropySnowDataValue) ? sampleRelEntropySnowDataValue : 0.0;
        double sampleRelEntropyNoSnowDataValue = sourceSamples[100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 1].getDouble();
        double sampleRelEntropyNoSnow = AlbedoInversionUtils.isValid(sampleRelEntropyNoSnowDataValue) ? sampleRelEntropyNoSnowDataValue : 0.0;
        double resultRelEntropy = sampleRelEntropySnow * proportionNsamplesSnow + sampleRelEntropyNoSnow * proportionNsamplesNoSnow;
        if (sampleRelEntropyNoSnow == 0.0 && sampleRelEntropySnow == 0.0) {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 1].set(-9999.0f);
        } else {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 1].set(resultRelEntropy);
        }
        double sampleWeightedNumSamplesSnowDataValue = sourceSamples[SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 2].getDouble();
        double sampleWeightedNumSamplesSnow = AlbedoInversionUtils.isValid(sampleWeightedNumSamplesSnowDataValue) ? sampleWeightedNumSamplesSnowDataValue : 0.0;
        double sampleWeightedNumSamplesNoSnowDataValue = sourceSamples[100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 2].getDouble();
        double sampleWeightedNumSamplesNoSnow = AlbedoInversionUtils.isValid(sampleWeightedNumSamplesNoSnowDataValue) ? sampleWeightedNumSamplesNoSnowDataValue : 0.0;
        double resultWeightedNumSamples = sampleWeightedNumSamplesSnow * proportionNsamplesSnow + sampleWeightedNumSamplesNoSnow * proportionNsamplesNoSnow;
        if (sampleWeightedNumSamplesNoSnow == 0.0 && sampleWeightedNumSamplesSnow == 0.0) {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 2].set(-9999.0f);
        } else {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 2].set(resultWeightedNumSamples);
        }
        double sampleDoyClosestSampleSnowDataValue = sourceSamples[SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 3].getDouble();
        double sampleDoyClosestSampleSnow = AlbedoInversionUtils.isValid(sampleDoyClosestSampleSnowDataValue) ? sampleDoyClosestSampleSnowDataValue : 0.0;
        double sampleDoyClosestSampleNoSnowDataValue = sourceSamples[100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 3].getDouble();
        double sampleDoyClosestSampleNoSnow = AlbedoInversionUtils.isValid(sampleDoyClosestSampleNoSnowDataValue) ? sampleDoyClosestSampleNoSnowDataValue : 0.0;
        double resultDoyClosestSample = sampleDoyClosestSampleSnow * proportionNsamplesSnow + sampleDoyClosestSampleNoSnow * proportionNsamplesNoSnow;
        if (sampleDoyClosestSampleNoSnow == 0.0 && sampleDoyClosestSampleSnow == 0.0) {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 3].set(-9999.0f);
        } else {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 3].set(resultDoyClosestSample);
        }
        double sampleGoodnessOfFitSnowDataValue = sourceSamples[SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 4].getDouble();
        double sampleGoodnessOfFitSnow = AlbedoInversionUtils.isValid(sampleGoodnessOfFitSnowDataValue) ? sampleGoodnessOfFitSnowDataValue : 0.0;
        double sampleGoodnessOfFitNoSnowDataValue = sourceSamples[100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 4].getDouble();
        double sampleGoodnessOfFitNoSnow = AlbedoInversionUtils.isValid(sampleGoodnessOfFitNoSnowDataValue) ? sampleGoodnessOfFitNoSnowDataValue : 0.0;
        double resultGoodnessOfFit = sampleGoodnessOfFitSnow * proportionNsamplesSnow + sampleGoodnessOfFitNoSnow * proportionNsamplesNoSnow;
        if (sampleGoodnessOfFitNoSnow == 0.0 && sampleGoodnessOfFitSnow == 0.0) {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 4].set(-9999.0f);
        } else {
            targetSamples[TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 4].set(resultGoodnessOfFit);
        }
    }

    private boolean priorMaskOk(double priorMask) {
        boolean maskValueOk = priorMask != 0.0 && priorMask != 2.0 && priorMask != 3.0 && priorMask != 5.0 && priorMask != 15.0;
        return this.priorProduct == null || maskValueOk;
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) throws OperatorException {
        super.configureTargetProduct(productConfigurer);
        Product targetProduct = productConfigurer.getTargetProduct();
        for (String parameterBandName : this.parameterBandNames = IOUtils.getInversionParameterBandNames()) {
            targetProduct.addBand(parameterBandName, 30);
        }
        this.uncertaintyBandNames = IOUtils.getInversionUncertaintyBandNames();
        for (int i = 0; i < 9; ++i) {
            for (int j = i; j < 9; ++j) {
                targetProduct.addBand(this.uncertaintyBandNames[i][j], 30);
            }
        }
        this.entropyBandName = "Entropy";
        targetProduct.addBand(this.entropyBandName, 30);
        this.relEntropyBandName = "Relative_Entropy";
        targetProduct.addBand(this.relEntropyBandName, 30);
        this.weightedNumberOfSamplesBandName = "Weighted_Number_of_Samples";
        targetProduct.addBand(this.weightedNumberOfSamplesBandName, 30);
        this.daysToTheClosestSampleBandName = "Time_to_the_Closest_Sample";
        targetProduct.addBand(this.daysToTheClosestSampleBandName, 30);
        this.goodnessOfFitBandName = "Goodness_of_Fit";
        targetProduct.addBand(this.goodnessOfFitBandName, 30);
        this.proportionNsamplesBandName = "Proportion_NSamples";
        targetProduct.addBand(this.proportionNsamplesBandName, 30);
        for (Band b : targetProduct.getBands()) {
            b.setNoDataValue(-9999.0);
            b.setNoDataValueUsed(true);
        }
    }

    protected void configureSourceSamples(SampleConfigurer configurator) throws OperatorException {
        int j;
        int i;
        for (int i2 = 0; i2 < 9; ++i2) {
            MergeBrdfOp.SRC_SNOW_PARAMETERS[i2] = i2;
            configurator.defineSample(SRC_SNOW_PARAMETERS[i2], this.parameterBandNames[i2], this.snowProduct);
        }
        int index = 0;
        for (i = 0; i < 9; ++i) {
            for (j = i; j < 9; ++j) {
                MergeBrdfOp.SRC_SNOW_UNCERTAINTIES[index] = index;
                configurator.defineSample(SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES[index], this.uncertaintyBandNames[i][j], this.snowProduct);
                ++index;
            }
        }
        configurator.defineSample(SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 0, this.entropyBandName, this.snowProduct);
        configurator.defineSample(SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 1, this.relEntropyBandName, this.snowProduct);
        configurator.defineSample(SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 2, this.weightedNumberOfSamplesBandName, this.snowProduct);
        configurator.defineSample(SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 3, "Time_to_the_Closest_Sample", this.snowProduct);
        configurator.defineSample(SRC_SNOW_PARAMETERS.length + SRC_SNOW_UNCERTAINTIES.length + 4, this.goodnessOfFitBandName, this.snowProduct);
        for (i = 0; i < 9; ++i) {
            MergeBrdfOp.SRC_NOSNOW_PARAMETERS[i] = 100 + i;
            configurator.defineSample(SRC_NOSNOW_PARAMETERS[i], this.parameterBandNames[i], this.noSnowProduct);
        }
        index = 0;
        for (i = 0; i < 9; ++i) {
            for (j = i; j < 9; ++j) {
                MergeBrdfOp.SRC_NOSNOW_UNCERTAINTIES[index] = 100 + index;
                configurator.defineSample(SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES[index], this.uncertaintyBandNames[i][j], this.noSnowProduct);
                ++index;
            }
        }
        configurator.defineSample(100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 0, this.entropyBandName, this.noSnowProduct);
        configurator.defineSample(100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 1, this.relEntropyBandName, this.noSnowProduct);
        configurator.defineSample(100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 2, this.weightedNumberOfSamplesBandName, this.noSnowProduct);
        configurator.defineSample(100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 3, "Time_to_the_Closest_Sample", this.noSnowProduct);
        configurator.defineSample(100 + SRC_NOSNOW_PARAMETERS.length + SRC_NOSNOW_UNCERTAINTIES.length + 4, this.goodnessOfFitBandName, this.noSnowProduct);
        if (this.priorProduct != null) {
            configurator.defineSample(SRC_PRIOR_MASK, this.priorDataMaskBandName, this.priorProduct);
        }
    }

    protected void configureTargetSamples(SampleConfigurer configurator) throws OperatorException {
        for (int i = 0; i < 9; ++i) {
            MergeBrdfOp.TRG_PARAMETERS[i] = i;
            configurator.defineSample(TRG_PARAMETERS[i], this.parameterBandNames[i]);
        }
        int index = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = i; j < 9; ++j) {
                MergeBrdfOp.TRG_UNCERTAINTIES[index] = index;
                configurator.defineSample(TRG_PARAMETERS.length + TRG_UNCERTAINTIES[index], this.uncertaintyBandNames[i][j]);
                ++index;
            }
        }
        configurator.defineSample(TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 0, this.entropyBandName);
        configurator.defineSample(TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 1, this.relEntropyBandName);
        configurator.defineSample(TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 2, this.weightedNumberOfSamplesBandName);
        configurator.defineSample(TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 3, this.daysToTheClosestSampleBandName);
        configurator.defineSample(TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 4, this.goodnessOfFitBandName);
        configurator.defineSample(TRG_PARAMETERS.length + TRG_UNCERTAINTIES.length + 5, this.proportionNsamplesBandName);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MergeBrdfOp.class);
        }
    }
}

