/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import Jama.LUDecomposition;
import Jama.Matrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.pointop.PixelOperator;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.globalbedo.inversion.Accumulator;
import org.esa.beam.globalbedo.inversion.AlbedoInversionConstants;
import org.esa.beam.globalbedo.inversion.FullAccumulation;
import org.esa.beam.globalbedo.inversion.FullAccumulator;
import org.esa.beam.globalbedo.inversion.Prior;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;

@OperatorMetadata(alias="ga.inversion.inversion", description="Performs final inversion from fully accumulated optimal estimation matrices", authors="Olaf Danne", version="1.0", copyright="(C) 2011 by Brockmann Consult")
public class InversionOp
extends PixelOperator {
    public static final int[][] SRC_PRIOR_MEAN = new int[3][3];
    public static final int[][] SRC_PRIOR_SD = new int[3][3];
    public static final int SOURCE_SAMPLE_OFFSET = 0;
    public static final int PRIOR_OFFSET = (int)Math.pow(3.0, 2.0);
    public static final int SRC_PRIOR_NSAMPLES = 2 * PRIOR_OFFSET;
    public static final int SRC_PRIOR_MASK = 0 + 2 * PRIOR_OFFSET + 1;
    private static final int NUM_TRG_PARAMETERS = 9;
    private static final int NUM_TRG_UNCERTAINTIES = ((int)Math.pow(9.0, 2.0) + 9) / 2;
    private static final int TRG_REL_ENTROPY = 1;
    private static final int TRG_WEIGHTED_NUM_SAMPLES = 2;
    private static final int TRG_GOODNESS_OF_FIT = 3;
    private static final int TRG_DAYS_TO_THE_CLOSEST_SAMPLE = 4;
    private static final int TRG_GOODNESS_OF_FIT_TERM_1 = 5;
    private static final int TRG_GOODNESS_OF_FIT_TERM_2 = 6;
    private static final int TRG_GOODNESS_OF_FIT_TERM_3 = 7;
    private static final String[] PARAMETER_BAND_NAMES = IOUtils.getInversionParameterBandNames();
    private static final String[][] UNCERTAINTY_BAND_NAMES = IOUtils.getInversionUncertaintyBandNames();
    @SourceProduct(description="Prior product", optional=true)
    private Product priorProduct;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="Tile")
    private String tile;
    @Parameter(description="Day of year", interval="[1,366]")
    private int doy;
    @Parameter(defaultValue="180", description="Wings")
    private int wings;
    @Parameter(defaultValue="", description="Globalbedo BBDR root directory")
    private String bbdrRootDir;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="false", description="Computation for seaice mode (polar tiles)")
    private boolean computeSeaice;
    @Parameter(defaultValue="false", description="Write only SW related outputs (usually in case of MVIRI/SEVIRI)")
    private boolean writeSwOnly;
    @Parameter(defaultValue="true", description="Use prior information")
    private boolean usePrior;
    @Parameter(defaultValue="6", description="Prior version (MODIS collection)")
    private int priorVersion;
    @Parameter(defaultValue="30.0", description="Prior scale factor")
    private double priorScaleFactor;
    @Parameter(defaultValue="BRDF_Albedo_Parameters_", description="Prefix of prior mean band (default fits to the latest prior version)")
    private String priorMeanBandNamePrefix;
    @Parameter(defaultValue="BRDF_Albedo_Parameters_", description="Prefix of prior SD band (default fits to the latest prior version)")
    private String priorSdBandNamePrefix;
    @Parameter(defaultValue="7", description="Prior broad bands start index (no longer needed for Collection 6 priors)")
    private int priorBandStartIndex;
    @Parameter(defaultValue="BRDF_Albedo_Parameters_nir_wns", description="Prior NSamples band name (default fits to the latest prior version)")
    private String priorNSamplesBandName;
    @Parameter(defaultValue="snowFraction", description="Prior data mask band name (default fits to the latest prior version)")
    private String priorDataMaskBandName;
    @Parameter(defaultValue="1.0", valueSet={"0.5", "1.0", "2.0", "4.0", "6.0", "10.0", "12.0", "20.0", "60.0"}, description="Scale factor with regard to MODIS default 1200x1200. Values > 1.0 reduce product size.Should usually be set to 6.0 for AVHRR/GEO (tiles of 200x200).")
    protected double modisTileScaleFactor;
    private FullAccumulator fullAccumulator;

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        for (String parameterBandName : PARAMETER_BAND_NAMES) {
            boolean addBand;
            boolean bl = addBand = !this.writeSwOnly || this.writeSwOnly && parameterBandName.contains("SW");
            if (!addBand) continue;
            Band b = productConfigurer.addBand(parameterBandName, 30, -9999.0);
            if (!this.computeSeaice) continue;
            b.setValidPixelExpression("Weighted_Number_of_Samples > 0.0");
        }
        for (int i = 0; i < 9; ++i) {
            for (int j = i; j < 9; ++j) {
                boolean addBand;
                boolean bl = addBand = !this.writeSwOnly || this.writeSwOnly && UNCERTAINTY_BAND_NAMES[i][j].contains("SW") && !UNCERTAINTY_BAND_NAMES[i][j].contains("VIS") && !UNCERTAINTY_BAND_NAMES[i][j].contains("NIR");
                if (!addBand) continue;
                Band b = productConfigurer.addBand(UNCERTAINTY_BAND_NAMES[i][j], 30, -9999.0);
                if (!this.computeSeaice) continue;
                b.setValidPixelExpression("Weighted_Number_of_Samples > 0.0");
            }
        }
        Band bInvEntr = productConfigurer.addBand("Entropy", 30, -9999.0);
        Band bInvRelEntr = productConfigurer.addBand("Relative_Entropy", 30, -9999.0);
        Band bInvWeighNumSampl = productConfigurer.addBand("Weighted_Number_of_Samples", 30, -9999.0);
        Band bAccDaysClSampl = productConfigurer.addBand("Time_to_the_Closest_Sample", 30, -9999.0);
        Band bInvGoodnessFit = productConfigurer.addBand("Goodness_of_Fit", 30, -9999.0);
        if (this.computeSeaice) {
            bInvEntr.setValidPixelExpression("Weighted_Number_of_Samples > 0.0");
            bInvRelEntr.setValidPixelExpression("Weighted_Number_of_Samples > 0.0");
            bInvWeighNumSampl.setValidPixelExpression("Weighted_Number_of_Samples > 0.0");
            bAccDaysClSampl.setValidPixelExpression("Weighted_Number_of_Samples > 0.0");
            bInvGoodnessFit.setValidPixelExpression("Weighted_Number_of_Samples > 0.0");
        }
        for (Band b : this.getTargetProduct().getBands()) {
            b.setNoDataValue(-9999.0);
            b.setNoDataValueUsed(true);
        }
    }

    protected void configureSourceSamples(SampleConfigurer configurator) {
        int rasterHeight;
        int rasterWidth;
        if (this.computeSeaice) {
            rasterWidth = 2250;
            rasterHeight = 2250;
        } else {
            rasterWidth = (int)(1200.0 / this.modisTileScaleFactor);
            rasterHeight = (int)(1200.0 / this.modisTileScaleFactor);
        }
        FullAccumulation fullAccumulation = new FullAccumulation(rasterWidth, rasterHeight, this.bbdrRootDir, this.tile, this.year, this.doy, this.wings, this.computeSnow);
        this.fullAccumulator = fullAccumulation.getResult();
        if (this.usePrior) {
            this.configurePriorSourceSamples(configurator);
        }
    }

    protected void configureTargetSamples(SampleConfigurer configurator) {
        int i;
        int index = 0;
        for (i = 0; i < 9; ++i) {
            boolean addedBand;
            boolean bl = addedBand = !this.writeSwOnly || this.writeSwOnly && PARAMETER_BAND_NAMES[i].contains("SW");
            if (!addedBand) continue;
            configurator.defineSample(index++, PARAMETER_BAND_NAMES[i]);
        }
        index = 0;
        for (i = 0; i < 9; ++i) {
            for (int j = i; j < 9; ++j) {
                boolean addedBand;
                boolean bl = addedBand = !this.writeSwOnly || this.writeSwOnly && UNCERTAINTY_BAND_NAMES[i][j].contains("SW") && !UNCERTAINTY_BAND_NAMES[i][j].contains("VIS") && !UNCERTAINTY_BAND_NAMES[i][j].contains("NIR");
                if (!addedBand) continue;
                configurator.defineSample(9 + index, UNCERTAINTY_BAND_NAMES[i][j]);
                ++index;
            }
        }
        int offset = 9 + NUM_TRG_UNCERTAINTIES;
        configurator.defineSample(offset, "Entropy");
        configurator.defineSample(offset + 1, "Relative_Entropy");
        configurator.defineSample(offset + 2, "Weighted_Number_of_Samples");
        configurator.defineSample(offset + 3, "Goodness_of_Fit");
        configurator.defineSample(offset + 4, "Time_to_the_Closest_Sample");
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        Matrix parameters = new Matrix(9, 1, -9999.0);
        Matrix uncertainties = new Matrix(9, 9);
        double entropy = 0.0;
        double relEntropy = 0.0;
        double maskAcc = 0.0;
        Accumulator accumulator = null;
        float daysToTheClosestSample = 0.0f;
        boolean trustAccumulation = false;
        if (this.fullAccumulator != null) {
            accumulator = Accumulator.createForInversion(this.fullAccumulator.getSumMatrices(), x, y);
            maskAcc = accumulator.getMask();
            daysToTheClosestSample = this.fullAccumulator.getDaysToTheClosestSample()[x][y];
            trustAccumulation = maskAcc > 1.0 && (double)daysToTheClosestSample < 10.0;
            trustAccumulation = true;
        }
        double maskPrior = 1.0;
        Prior prior = null;
        if (this.usePrior) {
            prior = Prior.createForInversion(sourceSamples, this.priorScaleFactor);
            maskPrior = prior.getMask();
        }
        double goodnessOfFit = 0.0;
        double[] goodnessOfFitTerms = new double[]{0.0, 0.0, 0.0};
        if (trustAccumulation && accumulator != null && maskAcc > 0.0 && (this.usePrior && maskPrior > 0.0 || !this.usePrior)) {
            LUDecomposition lud;
            Matrix mAcc = accumulator.getM();
            Matrix vAcc = accumulator.getV();
            Matrix eAcc = accumulator.getE();
            double priorWeighting = 1.0;
            if (this.usePrior && prior != null) {
                int i;
                for (i = 0; i < 9; ++i) {
                    double m_ii_accum = mAcc.get(i, i);
                    if (prior.getM() != null) {
                        m_ii_accum += prior.getM().get(i, i) * 1.0;
                    }
                    mAcc.set(i, i, m_ii_accum);
                }
                for (i = 0; i < 9; ++i) {
                    double v_i_accum = vAcc.get(i, 0);
                    if (prior.getV() != null) {
                        v_i_accum += prior.getV().get(i, 0) * 1.0;
                    }
                    vAcc.set(i, 0, v_i_accum);
                }
            }
            if ((lud = new LUDecomposition(mAcc)).isNonsingular()) {
                Matrix tmpM = mAcc.inverse();
                if (AlbedoInversionUtils.matrixHasNanElements(tmpM) || AlbedoInversionUtils.matrixHasZerosInDiagonale(tmpM)) {
                    tmpM = new Matrix(9, 9, -9999.0);
                }
                uncertainties = tmpM;
            } else {
                parameters = new Matrix(9, 1, -9999.0);
                uncertainties = new Matrix(9, 9, -9999.0);
                maskAcc = 0.0;
            }
            if (maskAcc != 0.0) {
                parameters = mAcc.solve(vAcc);
                relEntropy = entropy = InversionOp.getEntropy(mAcc);
                if (this.usePrior && prior != null && prior.getM() != null) {
                    double entropyPrior = InversionOp.getEntropy(prior.getM());
                    relEntropy = entropyPrior - entropy;
                }
            }
            goodnessOfFit = InversionOp.getGoodnessOfFit(mAcc, vAcc, eAcc, parameters, maskAcc);
        } else if (maskPrior > 0.0) {
            if (this.usePrior) {
                parameters = prior.getParameters();
                LUDecomposition lud = new LUDecomposition(prior.getM());
                if (lud.isNonsingular()) {
                    uncertainties = prior.getM().inverse();
                    entropy = InversionOp.getEntropy(prior.getM());
                } else {
                    uncertainties = new Matrix(9, 9, -9999.0);
                    entropy = -9999.0;
                }
                relEntropy = 0.0;
            } else {
                uncertainties = new Matrix(9, 9, -9999.0);
                entropy = -9999.0;
                relEntropy = -9999.0;
            }
        } else {
            uncertainties = new Matrix(9, 9, -9999.0);
            entropy = -9999.0;
            relEntropy = -9999.0;
        }
        this.fillTargetSamples(targetSamples, parameters, uncertainties, entropy, relEntropy, maskAcc, goodnessOfFit, goodnessOfFitTerms, daysToTheClosestSample);
    }

    static double getGoodnessOfFit(Matrix mAcc, Matrix vAcc, Matrix eAcc, Matrix fPars, double maskAcc) {
        Matrix goodnessOfFitMatrix = new Matrix(1, 1, 0.0);
        if (maskAcc > 0.0) {
            Matrix gofTerm1 = fPars.transpose().times(mAcc).times(fPars);
            Matrix gofTerm2 = fPars.transpose().times(vAcc);
            Matrix m2 = new Matrix(1, 1, 2.0);
            Matrix gofTerm3 = m2.times(eAcc);
            goodnessOfFitMatrix = gofTerm1.plus(gofTerm2).minus(gofTerm3);
        }
        return goodnessOfFitMatrix.get(0, 0);
    }

    static double[] getGoodnessOfFitTerms(Matrix mAcc, Matrix vAcc, Matrix eAcc, Matrix fPars, double maskAcc) {
        if (maskAcc > 0.0) {
            Matrix gofTerm1 = fPars.transpose().times(mAcc).times(fPars);
            Matrix gofTerm2 = fPars.transpose().times(vAcc);
            Matrix m2 = new Matrix(1, 1, 2.0);
            Matrix gofTerm3 = m2.times(eAcc);
            return new double[]{gofTerm1.get(0, 0), gofTerm2.get(0, 0), gofTerm3.get(0, 0)};
        }
        return new double[]{0.0, 0.0, 0.0};
    }

    private void fillTargetSamples(WritableSample[] targetSamples, Matrix parameters, Matrix uncertainties, double entropy, double relEntropy, double weightedNumberOfSamples, double goodnessOfFit, double[] goodnessOfFitTerms, float daysToTheClosestSample) {
        int j;
        int i;
        int index = 0;
        int bandIndex = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                boolean addedBand;
                boolean bl = addedBand = !this.writeSwOnly || this.writeSwOnly && PARAMETER_BAND_NAMES[bandIndex].contains("SW");
                if (addedBand) {
                    targetSamples[index].set(parameters.get(bandIndex, 0));
                    ++index;
                }
                ++bandIndex;
            }
        }
        index = 0;
        for (i = 0; i < 9; ++i) {
            for (j = i; j < 9; ++j) {
                boolean addBand;
                boolean bl = addBand = !this.writeSwOnly || this.writeSwOnly && UNCERTAINTY_BAND_NAMES[i][j].contains("SW") && !UNCERTAINTY_BAND_NAMES[i][j].contains("VIS") && !UNCERTAINTY_BAND_NAMES[i][j].contains("NIR");
                if (!addBand) continue;
                targetSamples[9 + index].set(uncertainties.get(i, j));
                ++index;
            }
        }
        int offset = 9 + NUM_TRG_UNCERTAINTIES;
        targetSamples[offset].set(entropy);
        targetSamples[offset + 1].set(relEntropy);
        targetSamples[offset + 2].set(weightedNumberOfSamples);
        targetSamples[offset + 3].set(goodnessOfFit);
        targetSamples[offset + 4].set(daysToTheClosestSample);
    }

    static double getEntropy(Matrix m) {
        RealMatrix rm = AlbedoInversionUtils.getRealMatrixFromJamaMatrix(m);
        SingularValueDecomposition svdM = new SingularValueDecomposition(rm);
        double[] svdMSingularValues = svdM.getSingularValues();
        double productSvdMSRecip = 1.0;
        for (double svdMSingularValue : svdMSingularValues) {
            if (svdMSingularValue == 0.0) continue;
            productSvdMSRecip *= 1.0 / svdMSingularValue;
        }
        return 0.5 * Math.log(productSvdMSRecip) + (double)svdMSingularValues.length * Math.sqrt(Math.log(17.079468445347132));
    }

    private void configurePriorSourceSamples(SampleConfigurer configurator) {
        for (int i = 0; i < 3; ++i) {
            int j;
            if (this.priorVersion == 6) {
                for (j = 0; j < 3; ++j) {
                    String meanBandName = this.priorMeanBandNamePrefix + AlbedoInversionConstants.PRIOR_6_WAVE_BANDS[i] + "_f" + j + "_avr";
                    int meanIndex = SRC_PRIOR_MEAN[i][j];
                    configurator.defineSample(meanIndex, meanBandName, this.priorProduct);
                    String sdMeanBandName = this.priorMeanBandNamePrefix + AlbedoInversionConstants.PRIOR_6_WAVE_BANDS[i] + "_f" + j + "_sd";
                    int sdIndex = SRC_PRIOR_SD[i][j];
                    configurator.defineSample(sdIndex, sdMeanBandName, this.priorProduct);
                }
                configurator.defineSample(SRC_PRIOR_NSAMPLES, this.priorNSamplesBandName, this.priorProduct);
                configurator.defineSample(SRC_PRIOR_MASK, this.priorDataMaskBandName, this.priorProduct);
                continue;
            }
            for (j = 0; j < 3; ++j) {
                String indexString = Integer.toString(this.priorBandStartIndex + i);
                String meanBandName = this.priorMeanBandNamePrefix + AlbedoInversionConstants.BBDR_WAVE_BANDS[i] + "_f" + j;
                int meanIndex = SRC_PRIOR_MEAN[i][j];
                configurator.defineSample(meanIndex, meanBandName, this.priorProduct);
                String sdMeanBandName = this.priorSdBandNamePrefix + AlbedoInversionConstants.BBDR_WAVE_BANDS[i] + "_f" + j + "_" + AlbedoInversionConstants.BBDR_WAVE_BANDS[i] + "_f" + j;
                int sdIndex = SRC_PRIOR_SD[i][j];
                configurator.defineSample(sdIndex, sdMeanBandName, this.priorProduct);
            }
            configurator.defineSample(SRC_PRIOR_NSAMPLES, this.priorNSamplesBandName, this.priorProduct);
            configurator.defineSample(SRC_PRIOR_MASK, this.priorDataMaskBandName, this.priorProduct);
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                InversionOp.SRC_PRIOR_MEAN[i][j] = 0 + 3 * i + j;
                InversionOp.SRC_PRIOR_SD[i][j] = 0 + PRIOR_OFFSET + 3 * i + j;
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(InversionOp.class);
        }
    }
}

