/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.globalbedo.inversion.MonthlyFrom8DayAlbedoMosaicsOp;
import org.esa.beam.globalbedo.inversion.MonthlyFrom8DayAlbedoOp;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.albedo.monthly")
public class GlobalbedoLevel3MonthlyFrom8DayAlbedo
extends Operator {
    @Parameter(defaultValue="", description="Globalbedo root directory")
    private String gaRootDir;
    @Parameter(defaultValue="h18v04", description="MODIS tile")
    private String tile;
    @Parameter(defaultValue="2005", description="Year")
    private String year;
    @Parameter(defaultValue="1", interval="[1,12]", description="Month index")
    private int monthIndex;
    @Parameter(defaultValue="true", description="True if input is 8-day mosaic, not single tile")
    private boolean isMosaicAlbedo;
    @Parameter(valueSet={"05", "005", "025"}, description="Scaling (05 = 1/2deg, 005 = 1/20deg, 025 = 1/4deg resolution", defaultValue="05")
    private String mosaicScaling;
    @Parameter(valueSet={"SIN", "PC"}, description="Plate Carree or Sinusoidal", defaultValue="PC")
    private String reprojection;
    private Logger logger;

    public void initialize() throws OperatorException {
        this.logger = BeamLogManager.getSystemLogger();
        Product[] albedo8DayProducts = this.isMosaicAlbedo ? IOUtils.getAlbedo8DayMosaicProducts(this.gaRootDir, this.monthIndex, this.year, this.mosaicScaling) : IOUtils.getAlbedo8DayTileProducts(this.gaRootDir, this.year, this.tile);
        if (albedo8DayProducts != null && albedo8DayProducts.length > 0) {
            if (this.isMosaicAlbedo) {
                MonthlyFrom8DayAlbedoMosaicsOp monthlyAlbedoMosaicsOp = new MonthlyFrom8DayAlbedoMosaicsOp();
                monthlyAlbedoMosaicsOp.setParameterDefaultValues();
                monthlyAlbedoMosaicsOp.setSourceProducts(albedo8DayProducts);
                monthlyAlbedoMosaicsOp.setParameter("monthIndex", this.monthIndex);
                this.setTargetProduct(monthlyAlbedoMosaicsOp.getTargetProduct());
            } else {
                float[][] monthlyWeighting = AlbedoInversionUtils.getMonthlyWeighting();
                MonthlyFrom8DayAlbedoOp monthlyAlbedoOp = new MonthlyFrom8DayAlbedoOp();
                monthlyAlbedoOp.setParameterDefaultValues();
                monthlyAlbedoOp.setSourceProducts(albedo8DayProducts);
                monthlyAlbedoOp.setParameter("monthlyWeighting", monthlyWeighting);
                monthlyAlbedoOp.setParameter("monthIndex", this.monthIndex);
                this.setTargetProduct(monthlyAlbedoOp.getTargetProduct());
            }
            this.logger.log(Level.INFO, "Finished monthly albedo computation process for tile: " + this.tile + ", year: " + this.year + ", month: " + this.monthIndex);
        } else {
            this.logger.log(Level.WARNING, "\nNo input products found --> no monthly albedos computed for tile: " + this.tile + ", year: " + this.year + ", month: " + this.monthIndex);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3MonthlyFrom8DayAlbedo.class);
        }
    }
}

