/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.globalbedo.inversion.InversionOp;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.globalbedo.inversion.util.SouthPoleCorrectionOp;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.inversion")
public class GlobalbedoLevel3Inversion
extends Operator {
    @SourceProduct(optional=true)
    private Product seaiceGeocodingProduct;
    @Parameter(defaultValue="", description="Globalbedo BBDR root directory")
    private String bbdrRootDir;
    @Parameter(defaultValue="", description="MODIS Prior root directory")
    private String priorRootDir;
    @Parameter(defaultValue="", description="MODIS Prior root directory suffix")
    private String priorRootDirSuffix;
    @Parameter(defaultValue="prior.modis.c6", description="MODIS Prior file name prefix")
    private String priorFileNamePrefix;
    @Parameter(defaultValue="BRDF_Albedo_Parameters_", description="Prefix of prior mean band (default fits to the latest prior version)")
    private String priorMeanBandNamePrefix;
    @Parameter(defaultValue="BRDF_Albedo_Parameters_", description="Prefix of prior SD band (default fits to the latest prior version)")
    private String priorSdBandNamePrefix;
    @Parameter(defaultValue="7", description="Prior broad bands start index (no longer needed for Collection 6 priors)")
    private int priorBandStartIndex;
    @Parameter(defaultValue="BRDF_Albedo_Parameters_nir_wns", description="Prior NSamples band name (default fits to the latest prior version)")
    private String priorNSamplesBandName;
    @Parameter(defaultValue="snowFraction", description="Prior data mask band name (default fits to the latest prior version)")
    private String priorDataMaskBandName;
    @Parameter(description="MODIS tile")
    private String tile;
    @Parameter(description="Name of tile info filename providing the geocoding")
    private String tileInfoFilename;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="DoY", interval="[1,366]")
    private int doy;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="false", description="Computation for seaice mode (polar tiles)")
    private boolean computeSeaice;
    @Parameter(defaultValue="false", description="Computation for AVHRR and/or Meteosat (tiles usually have coarser resolution)")
    private boolean computeAvhrrGeo;
    @Parameter(defaultValue="30.0", description="Prior scale factor")
    private double priorScaleFactor;
    @Parameter(defaultValue="true", description="Use binary accumulator files instead of dimap (to be decided)")
    private boolean useBinaryAccumulators;
    @Parameter(defaultValue="false", description="Do accumulation only (no inversion)")
    private boolean accumulationOnly;
    @Parameter(defaultValue="false", description="Write only SW related outputs (usually in case of MVIRI/SEVIRI)")
    private boolean writeSwOnly;
    @Parameter(defaultValue="true", description="Decide whether MODIS priors shall be used in inversion")
    private boolean usePrior = true;
    @Parameter(defaultValue="6", description="Prior version (MODIS collection)")
    private int priorVersion;
    @Parameter(defaultValue="1.0", valueSet={"0.5", "1.0", "2.0", "4.0", "6.0", "10.0", "12.0", "20.0", "60.0"}, description="Scale factor with regard to MODIS default 1200x1200. Values > 1.0 reduce product size.Should usually be set to 6.0 for AVHRR/GEO (tiles of 200x200).")
    protected double modisTileScaleFactor;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() throws OperatorException {
        Logger logger;
        block23: {
            Product inversionProduct;
            block22: {
                block21: {
                    block19: {
                        Product priorProduct;
                        block20: {
                            logger = BeamLogManager.getSystemLogger();
                            String fullAccumulatorDir = this.bbdrRootDir + File.separator + "FullAcc" + File.separator + this.year + File.separator + this.tile;
                            priorProduct = null;
                            if (this.usePrior) {
                                String priorDir = this.priorRootDir + File.separator + this.tile;
                                if (this.priorRootDirSuffix == null) {
                                    if (this.priorVersion == 6) {
                                        this.priorRootDirSuffix = IOUtils.getDoyString(this.doy);
                                    } else {
                                        int refDoy = 8 * ((this.doy - 1) / 8) + 1;
                                        this.priorRootDirSuffix = IOUtils.getDoyString(refDoy);
                                    }
                                }
                                priorDir = priorDir.concat(File.separator + this.priorRootDirSuffix);
                                logger.log(Level.INFO, "Searching for prior file in directory: '" + priorDir + "'...");
                                try {
                                    Product tmpPriorProduct = IOUtils.getPriorProduct(this.priorVersion, priorDir, this.priorFileNamePrefix, this.doy, this.computeSnow);
                                    if (tmpPriorProduct != null) {
                                        tmpPriorProduct.setGeoCoding((GeoCoding)IOUtils.getSinusoidalTileGeocoding(this.tile));
                                        priorProduct = this.modisTileScaleFactor != 1.0 ? AlbedoInversionUtils.reprojectToModisTile(tmpPriorProduct, this.tile, "Nearest", this.modisTileScaleFactor) : tmpPriorProduct;
                                    } else {
                                        this.usePrior = false;
                                    }
                                }
                                catch (IOException e) {
                                    throw new OperatorException("No prior file available for DoY " + IOUtils.getDoyString(this.doy) + " - cannot proceed...: " + e.getMessage());
                                }
                            }
                            if (!this.computeSeaice && this.usePrior && (!this.usePrior || priorProduct == null)) break block19;
                            InversionOp inversionOp = new InversionOp();
                            inversionOp.setParameterDefaultValues();
                            if (priorProduct != null) {
                                inversionOp.setSourceProduct("priorProduct", priorProduct);
                            } else {
                                Product dummySourceProduct;
                                int height;
                                int width;
                                if (this.computeSeaice) {
                                    width = (int)(2250.0 / this.modisTileScaleFactor);
                                    height = (int)(2250.0 / this.modisTileScaleFactor);
                                    dummySourceProduct = AlbedoInversionUtils.createDummySourceProduct(width, height);
                                } else {
                                    width = (int)(1200.0 / this.modisTileScaleFactor);
                                    height = (int)(1200.0 / this.modisTileScaleFactor);
                                    dummySourceProduct = AlbedoInversionUtils.createDummySourceProduct(width, height);
                                }
                                inversionOp.setSourceProduct("priorProduct", dummySourceProduct);
                            }
                            inversionOp.setParameter("bbdrRootDir", this.bbdrRootDir);
                            inversionOp.setParameter("year", this.year);
                            inversionOp.setParameter("tile", this.tile);
                            inversionOp.setParameter("doy", this.doy);
                            inversionOp.setParameter("computeSnow", this.computeSnow);
                            inversionOp.setParameter("computeSeaice", this.computeSeaice);
                            inversionOp.setParameter("writeSwOnly", this.writeSwOnly);
                            inversionOp.setParameter("usePrior", this.usePrior);
                            inversionOp.setParameter("priorScaleFactor", this.priorScaleFactor);
                            inversionOp.setParameter("priorMeanBandNamePrefix", this.priorMeanBandNamePrefix);
                            inversionOp.setParameter("priorSdBandNamePrefix", this.priorSdBandNamePrefix);
                            inversionOp.setParameter("priorVersion", this.priorVersion);
                            inversionOp.setParameter("priorNSamplesBandName", this.priorNSamplesBandName);
                            inversionOp.setParameter("priorDataMaskBandName", this.priorDataMaskBandName);
                            inversionOp.setParameter("modisTileScaleFactor", this.modisTileScaleFactor);
                            inversionProduct = inversionOp.getTargetProduct();
                            if (!this.computeSeaice) break block20;
                            break block21;
                        }
                        if (priorProduct == null) {
                            inversionProduct.setGeoCoding((GeoCoding)IOUtils.getSinusoidalTileGeocoding(this.tile, this.modisTileScaleFactor));
                        }
                        break block22;
                    }
                    logger.log(Level.WARNING, "No prior file found for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy) + " , Snow = " + this.computeSnow + " - no inversion performed.");
                    break block23;
                }
                for (int i = this.doy; i < this.doy + 8; ++i) {
                    try {
                        Product[] bbdrpstProducts = IOUtils.getAccumulationInputProducts(this.bbdrRootDir, this.tile, this.year, i);
                        if (bbdrpstProducts.length <= 0) continue;
                        inversionProduct.setGeoCoding(bbdrpstProducts[0].getGeoCoding());
                        continue;
                    }
                    catch (IOException e) {
                        throw new OperatorException("Cannot attach geocoding from BBDR PST product: ", (Throwable)e);
                    }
                }
            }
            this.setTargetProduct(inversionProduct);
            if (this.includesSouthPole()) {
                SouthPoleCorrectionOp correctionOp = new SouthPoleCorrectionOp();
                correctionOp.setParameterDefaultValues();
                correctionOp.setSourceProduct("sourceProduct", inversionProduct);
                Product southPoleCorrectedProduct = correctionOp.getTargetProduct();
                ProductUtils.copyMetadata((Product)inversionProduct, (Product)southPoleCorrectedProduct);
                this.setTargetProduct(southPoleCorrectedProduct);
            }
            if (!this.computeSeaice) {
                // empty if block
            }
        }
        logger.log(Level.INFO, "Finished inversion process for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy) + " , Snow = " + this.computeSnow);
    }

    private boolean includesSouthPole() {
        return this.tile.equals("h17v17") || this.tile.equals("h18v17");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3Inversion.class);
        }
    }
}

