/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.experimental.Output;
import org.esa.beam.globalbedo.inversion.AccumulatorHolder;
import org.esa.beam.globalbedo.inversion.FullAccumulator;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.fullacc")
public class GlobalbedoLevel3FullAccumulation
extends Operator
implements Output {
    private int rasterWidth;
    private int rasterHeight;
    @Parameter(defaultValue="", description="GA root directory")
    private String gaRootDir;
    @Parameter(description="MODIS tile")
    private String tile;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="Start Day of Year", interval="[1,366]")
    private int startDoy;
    @Parameter(description="End Day of Year", interval="[1,366]")
    private int endDoy;
    @Parameter(defaultValue="180", description="Wings")
    private int wings;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="false", description="Computation for seaice mode (polar tiles)")
    private boolean computeSeaice;
    @Parameter(defaultValue="false", description="Debug - write more target bands")
    private boolean debug;
    @Parameter(defaultValue="1.0", valueSet={"0.5", "1.0", "2.0", "4.0", "6.0", "10.0", "12.0", "20.0", "60.0"}, description="Scale factor with regard to MODIS default 1200x1200. Values > 1.0 reduce product size.")
    protected double modisTileScaleFactor;
    private Logger logger;

    public void initialize() throws OperatorException {
        this.logger = BeamLogManager.getSystemLogger();
        int numDoys = (this.endDoy - this.startDoy) / 8 + 1;
        int[] doys = new int[numDoys];
        for (int i = 0; i < doys.length; ++i) {
            doys[i] = this.startDoy + 8 * i;
        }
        if (this.computeSeaice) {
            this.rasterWidth = 2250;
            this.rasterHeight = 2250;
        } else {
            this.rasterWidth = (int)(1200.0 / this.modisTileScaleFactor);
            this.rasterHeight = (int)(1200.0 / this.modisTileScaleFactor);
        }
        String bbdrDir = this.computeSeaice ? "BBDR_PST" : "BBDR";
        String dailyAccDir = this.gaRootDir + File.separator + bbdrDir + File.separator + "DailyAcc";
        AccumulatorHolder[] dailyAccumulators = new AccumulatorHolder[doys.length];
        for (int i = 0; i < doys.length; ++i) {
            dailyAccumulators[i] = IOUtils.getDailyAccumulator(dailyAccDir, doys[i], this.year, this.tile, this.wings, this.computeSnow, this.computeSeaice);
        }
        String[] dailyAccBinaryFilenames = this.getDailyAccumulatorFilenameList(dailyAccumulators);
        String[] bandNames = IOUtils.getDailyAccumulatorBandNames();
        FullAccumulator[] accsToWrite = this.getDailyAccFromBinaryFileAndAccumulate(dailyAccBinaryFilenames, dailyAccumulators, doys, bandNames.length);
        String fullAccDir = this.gaRootDir + File.separator + bbdrDir + File.separator + "FullAcc" + File.separator + this.year + File.separator + this.tile;
        fullAccDir = this.computeSnow ? fullAccDir.concat(File.separator + "Snow" + File.separator) : (this.computeSeaice ? fullAccDir.concat(File.separator) : fullAccDir.concat(File.separator + "NoSnow" + File.separator));
        for (FullAccumulator acc : accsToWrite) {
            if (acc == null) continue;
            String fullAccumulatorBinaryFilename = "matrices_full_" + acc.getYear() + IOUtils.getDoyString(acc.getDoy()) + ".bin";
            File fullAccumulatorBinaryFile = new File(fullAccDir + fullAccumulatorBinaryFilename);
            IOUtils.writeFullAccumulatorToFile(fullAccumulatorBinaryFile, acc.getSumMatrices(), acc.getDaysToTheClosestSample());
        }
        String productName = "SUCCESS_fullacc_" + this.year + "_" + this.startDoy;
        Product successProduct = new Product(productName, "SUCCESS", 1, 1);
        this.setTargetProduct(successProduct);
        this.logger.log(Level.INFO, "Finished full accumulation process for tile: " + this.tile + ", year: " + this.year + ", DoYs: " + IOUtils.getDoyString(this.startDoy) + "-" + IOUtils.getDoyString(this.endDoy) + " , Snow = " + this.computeSnow);
    }

    private String[] getDailyAccumulatorFilenameList(AccumulatorHolder[] inputProducts) {
        ArrayList<String> filenameList = new ArrayList<String>();
        for (AccumulatorHolder input : inputProducts) {
            if (input == null) continue;
            String[] thisInputFilenames = input.getProductBinaryFilenames();
            if (input.getProductBinaryFilenames().length == 0) {
                this.logger.log(Level.WARNING, "No daily accumulators found for DoY " + IOUtils.getDoyString(input.getReferenceDoy()) + " ...");
            }
            for (int index = 0; index < thisInputFilenames.length; ++index) {
                if (filenameList.contains(thisInputFilenames[index])) continue;
                filenameList.add(thisInputFilenames[index]);
            }
        }
        return filenameList.toArray(new String[filenameList.size()]);
    }

    private FullAccumulator[] getDailyAccFromBinaryFileAndAccumulate(String[] sourceBinaryFilenames, AccumulatorHolder[] inputProducts, int[] doys, int numBands) {
        int numDoys = doys.length;
        int numFiles = sourceBinaryFilenames.length;
        float[][][] daysToTheClosestSample = new float[numDoys][this.rasterWidth][this.rasterHeight];
        float[][][][] sumMatrices = new float[numDoys][numBands][this.rasterWidth][this.rasterHeight];
        float[][][] mask = new float[numDoys][this.rasterWidth][this.rasterHeight];
        int size = numBands * this.rasterWidth * this.rasterHeight;
        boolean[][] accumulate = new boolean[numFiles][numDoys];
        int[][] dayDifference = new int[numFiles][numDoys];
        float[][] weight = new float[numFiles][numDoys];
        int fileIndex = 0;
        for (String filename : sourceBinaryFilenames) {
            BeamLogManager.getSystemLogger().log(Level.INFO, "Full accumulation: reading daily acc file = " + filename + " ...");
            File dailyAccumulatorBinaryFile = new File(filename);
            try {
                FileInputStream f = new FileInputStream(dailyAccumulatorBinaryFile);
                FileChannel ch = f.getChannel();
                ByteBuffer bb = ByteBuffer.allocateDirect(size);
                for (int i = 0; i < doys.length; ++i) {
                    accumulate[fileIndex][i] = GlobalbedoLevel3FullAccumulation.doAccumulation(filename, inputProducts[i].getProductBinaryFilenames());
                    dayDifference[fileIndex][i] = GlobalbedoLevel3FullAccumulation.getDayDifference(dailyAccumulatorBinaryFile.getName(), inputProducts[i]);
                    weight[fileIndex][i] = GlobalbedoLevel3FullAccumulation.getWeight(dailyAccumulatorBinaryFile.getName(), inputProducts[i]);
                }
                try {
                    int nRead;
                    long t1 = System.currentTimeMillis();
                    int ii = 0;
                    int jj = 0;
                    int kk = 0;
                    int count = 0;
                    while ((nRead = ch.read(bb)) != -1) {
                        if (nRead == 0) continue;
                        bb.position(0);
                        bb.limit(nRead);
                        while (bb.hasRemaining() && ii < numBands) {
                            float value = bb.getFloat();
                            ++count;
                            for (int doyIndex = 0; doyIndex < doys.length; ++doyIndex) {
                                if (!accumulate[fileIndex][doyIndex]) continue;
                                if (ii == numBands - 1) {
                                    mask[doyIndex][jj][kk] = value;
                                }
                                float[] fArray = sumMatrices[doyIndex][ii][jj];
                                int n = kk;
                                fArray[n] = fArray[n] + weight[fileIndex][doyIndex] * value;
                            }
                            if (++kk != this.rasterWidth) continue;
                            kk = 0;
                            if (++jj != this.rasterHeight) continue;
                            ++ii;
                            jj = 0;
                        }
                        bb.clear();
                    }
                    ch.close();
                    f.close();
                    long t2 = System.currentTimeMillis();
                    BeamLogManager.getSystemLogger().log(Level.ALL, "daily acc read in: " + (t2 - t1) + " ms");
                    for (int doyIndex = 0; doyIndex < doys.length; ++doyIndex) {
                        if (!accumulate[fileIndex][doyIndex]) continue;
                        float[][] dayOfClosestSampleOld = daysToTheClosestSample[doyIndex];
                        daysToTheClosestSample[doyIndex] = this.updateDoYOfClosestSampleArray(dayOfClosestSampleOld, mask[doyIndex], dayDifference[fileIndex][doyIndex], fileIndex);
                    }
                    ++fileIndex;
                }
                catch (IOException e) {
                    BeamLogManager.getSystemLogger().log(Level.SEVERE, "Could not read daily acc " + filename + "  - skipping.");
                }
            }
            catch (FileNotFoundException e) {
                BeamLogManager.getSystemLogger().log(Level.SEVERE, "Could not find daily acc " + filename + "  - skipping.");
            }
        }
        FullAccumulator[] accumulators = new FullAccumulator[numDoys];
        for (int i = 0; i < numDoys; ++i) {
            accumulators[i] = null;
            if (inputProducts[i] == null) continue;
            accumulators[i] = new FullAccumulator(inputProducts[i].getReferenceYear(), inputProducts[i].getReferenceDoy(), sumMatrices[i], daysToTheClosestSample[i]);
        }
        return accumulators;
    }

    private static int getDayDifference(String filename, AccumulatorHolder inputProduct) {
        int year = inputProduct.getReferenceYear();
        int fileYear = Integer.parseInt(filename.substring(9, 13));
        int doy = inputProduct.getReferenceDoy();
        int fileDoy = Integer.parseInt(filename.substring(13, 16));
        return IOUtils.getDayDifference(fileDoy, fileYear, doy, year);
    }

    private static float getWeight(String filename, AccumulatorHolder inputProduct) {
        int difference = GlobalbedoLevel3FullAccumulation.getDayDifference(filename, inputProduct);
        return AlbedoInversionUtils.getWeight(difference);
    }

    private static boolean doAccumulation(String filename, String[] doyFilenames) {
        for (String doyFilename : doyFilenames) {
            if (!filename.equals(doyFilename)) continue;
            return true;
        }
        return false;
    }

    private float[][] updateDoYOfClosestSampleArray(float[][] doyOfClosestSampleOld, float[][] mask, int dayDifference, int productIndex) {
        float[][] doyOfClosestSample = new float[this.rasterWidth][this.rasterHeight];
        for (int i = 0; i < this.rasterWidth; ++i) {
            for (int j = 0; j < this.rasterHeight; ++j) {
                float doy;
                float bbdrDaysToDoY = Math.abs(dayDifference) + 1;
                if (productIndex == 0) {
                    doy = (double)mask[i][j] > 0.0 ? bbdrDaysToDoY : doyOfClosestSampleOld[i][j];
                } else {
                    doy = mask[i][j] > 0.0f && doyOfClosestSampleOld[i][j] == 0.0f ? bbdrDaysToDoY : doyOfClosestSampleOld[i][j];
                    doy = mask[i][j] > 0.0f && doy > 0.0f ? Math.min(bbdrDaysToDoY, doy) : doyOfClosestSampleOld[i][j];
                }
                doyOfClosestSample[i][j] = doy;
            }
        }
        return doyOfClosestSample;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3FullAccumulation.class);
        }
    }
}

