/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.globalbedo.inversion.DailyAccumulationOp;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.dailyacc", description="'Master' operator for the daily accumulation part in Albedo Inversion", autoWriteDisabled=true, authors="Olaf Danne", version="1.0", copyright="(C) 2011-2016 by Brockmann Consult")
public class GlobalbedoLevel3DailyAccumulation
extends Operator {
    @Parameter(defaultValue="", description="BBDR root directory")
    private String bbdrRootDir;
    @Parameter(label="Sensors to ingest in BRDF retrieval", defaultValue="MERIS,VGT")
    private String[] sensors;
    @Parameter(label="If true for a Meteosat sensor, ingest all longitudes (000, 057 and 063) in BRDF retrieval. Otherwise 000 only", defaultValue="false")
    private boolean meteosatUseAllLongitudes;
    @Parameter(description="MODIS tile")
    private String tile;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="Day of Year", interval="[1,366]")
    private int doy;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="false", description="Computation for seaice mode (polar tiles)")
    private boolean computeSeaice;
    @Parameter(defaultValue="false", description="Debug - write more target bands")
    private boolean debug;
    @Parameter(defaultValue="1.0", description="Weighting of uncertainties (test option, should be 1.0 usually!).")
    private double uncertaintyWeightingFactor;
    @Parameter(defaultValue="1.0", valueSet={"0.5", "1.0", "2.0", "4.0", "6.0", "10.0", "12.0", "20.0", "60.0"}, description="Scale factor with regard to MODIS default 1200x1200. Values > 1.0 reduce product size.")
    protected double modisTileScaleFactor;

    public void initialize() throws OperatorException {
        Product[] inputProducts;
        Logger logger = BeamLogManager.getSystemLogger();
        try {
            inputProducts = IOUtils.getAccumulationInputProducts(this.bbdrRootDir, this.sensors, this.meteosatUseAllLongitudes, this.tile, this.year, this.doy);
        }
        catch (IOException e) {
            throw new OperatorException("Daily Accumulator: Cannot get list of input products: " + e.getMessage());
        }
        if (inputProducts.length > 0) {
            String dailyAccumulatorDir = this.bbdrRootDir + File.separator + "DailyAcc" + File.separator + this.year + File.separator + this.tile;
            dailyAccumulatorDir = this.computeSnow ? dailyAccumulatorDir.concat(File.separator + "Snow" + File.separator) : (this.computeSeaice ? dailyAccumulatorDir.concat(File.separator) : dailyAccumulatorDir.concat(File.separator + "NoSnow" + File.separator));
            JAI.getDefaultInstance().getTileScheduler().setParallelism(1);
            String dailyAccumulatorBinaryFilename = "matrices_" + this.year + IOUtils.getDoyString(this.doy) + ".bin";
            File dailyAccumulatorBinaryFile = new File(dailyAccumulatorDir + dailyAccumulatorBinaryFilename);
            DailyAccumulationOp accumulationOp = new DailyAccumulationOp();
            accumulationOp.setParameterDefaultValues();
            accumulationOp.setSourceProducts(inputProducts);
            accumulationOp.setParameter("computeSnow", this.computeSnow);
            accumulationOp.setParameter("computeSeaice", this.computeSeaice);
            accumulationOp.setParameter("debug", this.debug);
            accumulationOp.setParameter("uncertaintyWeightingFactor", this.uncertaintyWeightingFactor);
            accumulationOp.setParameter("dailyAccumulatorBinaryFile", dailyAccumulatorBinaryFile);
            accumulationOp.setParameter("modisTileScaleFactor", this.modisTileScaleFactor);
            Product accumulationProduct = accumulationOp.getTargetProduct();
            this.setTargetProduct(accumulationProduct);
        } else {
            logger.log(Level.WARNING, "No input products found for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy) + " , Snow = " + this.computeSnow);
            Product dummyProduct = new Product("dummy", "dummy", 1, 1);
            this.setTargetProduct(dummyProduct);
        }
        this.getTargetProduct().setName("SUCCESS_dailyacc_" + this.year + "_" + this.doy);
        logger.log(Level.INFO, "Finished daily accumulation process for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy) + " , Snow = " + this.computeSnow);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3DailyAccumulation.class);
        }
    }
}

