/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.globalbedo.inversion.BrdfToAlbedoOp;
import org.esa.beam.globalbedo.inversion.MergeBrdfOp;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.globalbedo.inversion.util.ModisTileGeoCoding;
import org.esa.beam.globalbedo.inversion.util.SouthPoleCorrectionOp;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.l3.albedo", description="Computes albedo from BRDF products.", authors="Olaf Danne", version="1.0", copyright="(C) 2011 by Brockmann Consult")
public class GlobalbedoLevel3Albedo
extends Operator {
    @Parameter(defaultValue="", description="Globalbedo root directory")
    private String inversionRootDir;
    @Parameter(defaultValue="", description="MODIS Prior root directory")
    private String priorRootDir;
    @Parameter(defaultValue="6", description="Prior version (MODIS collection)")
    private int priorVersion;
    @Parameter(defaultValue="", description="MODIS Prior root directory suffix")
    private String priorRootDirSuffix;
    @Parameter(defaultValue="prior.modis.c6", description="MODIS Prior file name prefix")
    private String priorFileNamePrefix;
    @Parameter(defaultValue="MEAN:_BAND_", description="Prefix of prior mean band (default fits to the latest prior version)")
    private String priorMeanBandNamePrefix;
    @Parameter(defaultValue="SD:_BAND_", description="Prefix of prior SD band (default fits to the latest prior version)")
    private String priorSdBandNamePrefix;
    @Parameter(defaultValue="true", description="Decide whether MODIS priors shall be used in inversion")
    private boolean usePrior = true;
    @Parameter(description="MODIS tile")
    private String tile;
    @Parameter(description="Year")
    private int year;
    @Parameter(description="DoY", interval="[1,366]")
    private int doy;
    @Parameter(defaultValue="false", description="Write merged BRDF product only (no albedo compuation)")
    private boolean mergedProductOnly;
    @Parameter(defaultValue="false", description="Computation for seaice mode (polar tiles)")
    private boolean computeSeaice;
    @Parameter(defaultValue="1.0", valueSet={"0.5", "1.0", "2.0", "4.0", "6.0", "10.0", "12.0", "20.0", "60.0"}, description="Scale factor with regard to MODIS default 1200x1200. Values > 1.0 reduce product size.Should usually be set to 6.0 for AVHRR/GEO (tiles of 200x200).")
    protected double modisTileScaleFactor;

    public void initialize() throws OperatorException {
        Logger logger = BeamLogManager.getSystemLogger();
        String brdfSnowDir = this.inversionRootDir + File.separator + "Snow" + File.separator + this.year + File.separator + this.tile;
        String brdfNoSnowDir = this.inversionRootDir + File.separator + "NoSnow" + File.separator + this.year + File.separator + this.tile;
        logger.log(Level.INFO, "Searching for BRDF SNOW file in directory: '" + brdfSnowDir + "'...");
        logger.log(Level.INFO, "Searching for BRDF NOSNOW file in directory: '" + brdfNoSnowDir + "'...");
        Product priorProduct = null;
        Product brdfMergedProduct = null;
        if (this.computeSeaice) {
            Product brdfSeaiceProduct;
            try {
                brdfSeaiceProduct = IOUtils.getBrdfSeaiceProduct(this.inversionRootDir, this.year, this.doy);
            }
            catch (IOException e) {
                throw new OperatorException("Cannot load BRDF Seaice product: " + e.getMessage());
            }
            brdfMergedProduct = this.copyFromSingleProduct(brdfSeaiceProduct, 0.0f);
        } else {
            Product brdfNoSnowProduct;
            String priorDir = this.priorRootDir + File.separator + this.tile;
            if (this.priorRootDirSuffix == null) {
                if (this.priorVersion == 6) {
                    this.priorRootDirSuffix = IOUtils.getDoyString(this.doy);
                } else {
                    int refDoy = 8 * ((this.doy - 1) / 8) + 1;
                    this.priorRootDirSuffix = IOUtils.getDoyString(refDoy);
                }
            }
            priorDir = priorDir.concat(File.separator + this.priorRootDirSuffix);
            logger.log(Level.INFO, "Searching for SNOW prior file in directory: '" + priorDir + "'...");
            if (this.usePrior) {
                try {
                    Product tmpPriorProduct = IOUtils.getPriorProduct(this.priorVersion, priorDir, this.priorFileNamePrefix, this.doy, true);
                    if (tmpPriorProduct != null) {
                        tmpPriorProduct.setGeoCoding((GeoCoding)IOUtils.getSinusoidalTileGeocoding(this.tile));
                        priorProduct = this.modisTileScaleFactor != 1.0 ? AlbedoInversionUtils.reprojectToModisTile(tmpPriorProduct, this.tile, "Nearest", this.modisTileScaleFactor) : tmpPriorProduct;
                    } else {
                        this.usePrior = false;
                    }
                }
                catch (IOException e) {
                    throw new OperatorException("Cannot load prior product: " + e.getMessage());
                }
                if (priorProduct == null) {
                    logger.log(Level.WARNING, "No 'snow' prior file available for DoY " + IOUtils.getDoyString(this.doy) + " - will compute albedos from 'NoSnow' BRDF product...");
                }
            }
            Product brdfSnowProduct = null;
            try {
                brdfSnowProduct = IOUtils.getBrdfProduct(brdfSnowDir, this.year, this.doy, true);
                brdfNoSnowProduct = IOUtils.getBrdfProduct(brdfNoSnowDir, this.year, this.doy, false);
            }
            catch (IOException e) {
                throw new OperatorException("Cannot load BRDF product: " + e.getMessage());
            }
            if (!(brdfSnowProduct == null || brdfNoSnowProduct == null || this.usePrior && priorProduct == null)) {
                MergeBrdfOp mergeBrdfOp = new MergeBrdfOp();
                mergeBrdfOp.setParameterDefaultValues();
                mergeBrdfOp.setParameter("priorMeanBandNamePrefix", this.priorMeanBandNamePrefix);
                mergeBrdfOp.setParameter("priorSdBandNamePrefix", this.priorSdBandNamePrefix);
                mergeBrdfOp.setSourceProduct("snowProduct", brdfSnowProduct);
                mergeBrdfOp.setSourceProduct("noSnowProduct", brdfNoSnowProduct);
                if (priorProduct != null) {
                    mergeBrdfOp.setSourceProduct("priorProduct", priorProduct);
                }
                brdfMergedProduct = mergeBrdfOp.getTargetProduct();
            } else if (brdfSnowProduct != null && brdfNoSnowProduct == null) {
                logger.log(Level.WARNING, "Found only 'Snow' BRDF product for tile:" + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy));
                brdfMergedProduct = this.copyFromSingleProduct(brdfSnowProduct, 1.0f);
            } else if (brdfNoSnowProduct != null && brdfSnowProduct == null) {
                logger.log(Level.WARNING, "Found only 'NoSnow' BRDF product for tile:" + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy));
                brdfMergedProduct = this.copyFromSingleProduct(brdfNoSnowProduct, 0.0f);
            } else {
                logger.log(Level.WARNING, "Neither 'Snow' nor 'NoSnow' BRDF product for tile:" + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy));
            }
        }
        if (brdfMergedProduct != null) {
            if (brdfMergedProduct.getGeoCoding() == null) {
                ModisTileGeoCoding sinusoidalTileGeocoding = IOUtils.getSinusoidalTileGeocoding(this.tile, this.modisTileScaleFactor);
                brdfMergedProduct.setGeoCoding((GeoCoding)sinusoidalTileGeocoding);
            }
            if (this.mergedProductOnly) {
                this.setTargetProduct(brdfMergedProduct);
            } else {
                BrdfToAlbedoOp albedoOp = new BrdfToAlbedoOp();
                albedoOp.setParameterDefaultValues();
                albedoOp.setSourceProduct("brdfMergedProduct", brdfMergedProduct);
                albedoOp.setParameter("doy", this.doy);
                albedoOp.setParameter("computeSeaice", this.computeSeaice);
                Product targetProduct = albedoOp.getTargetProduct();
                this.setTargetProduct(targetProduct);
            }
            if (this.includesSouthPole(this.tile)) {
                SouthPoleCorrectionOp correctionOp = new SouthPoleCorrectionOp();
                correctionOp.setParameterDefaultValues();
                correctionOp.setSourceProduct("sourceProduct", this.getTargetProduct());
                Product southPoleCorrectedProduct = correctionOp.getTargetProduct();
                this.setTargetProduct(southPoleCorrectedProduct);
            }
            if (this.computeSeaice) {
                // empty if block
            }
            logger.log(Level.INFO, "Finished albedo computation process for tile: " + this.tile + ", year: " + this.year + ", DoY: " + IOUtils.getDoyString(this.doy));
        } else {
            logger.log(Level.WARNING, "No albedos computed for tile: " + this.tile + ", year: " + this.year + ", Doy: " + IOUtils.getDoyString(this.doy));
        }
    }

    private boolean includesSouthPole(String tile) {
        return tile.equals("h17v17") || tile.equals("h18v17");
    }

    private Product copyFromSingleProduct(Product sourceProduct, float propNSampleConstantValue) {
        int width = sourceProduct.getSceneRasterWidth();
        int height = sourceProduct.getSceneRasterHeight();
        Product targetProduct = new Product(sourceProduct.getName(), sourceProduct.getProductType(), width, height);
        for (Band band : sourceProduct.getBands()) {
            ProductUtils.copyBand((String)band.getName(), (Product)sourceProduct, (Product)targetProduct, (boolean)true);
        }
        Band propNSamplesBand = targetProduct.addBand("Proportion_NSamples", 30);
        BufferedImage bi = ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])new Float[]{Float.valueOf(propNSampleConstantValue)}, null).getAsBufferedImage();
        propNSamplesBand.setSourceImage((RenderedImage)bi);
        ProductUtils.copyGeoCoding((Product)sourceProduct, (Product)targetProduct);
        ProductUtils.copyMetadata((Product)sourceProduct, (Product)targetProduct);
        return targetProduct;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GlobalbedoLevel3Albedo.class);
        }
    }
}

