/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.globalbedo.inversion.AccumulatorHolder;
import org.esa.beam.globalbedo.inversion.FullAccumulator;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.util.logging.BeamLogManager;

public class FullAccumulation {
    private int rasterWidth;
    private int rasterHeight;
    private String bbdrRootDir;
    private String tile;
    private int year;
    private int doy;
    private int wings;
    private boolean computeSnow;
    private Logger logger;
    FullAccumulator result;

    public FullAccumulation(int rasterWidth, int rasterHeight, String bbdrRootDir, String tile, int year, int doy, int wings, boolean computeSnow) {
        this.rasterWidth = rasterWidth;
        this.rasterHeight = rasterHeight;
        this.bbdrRootDir = bbdrRootDir;
        this.tile = tile;
        this.year = year;
        this.doy = doy;
        this.wings = wings;
        this.computeSnow = computeSnow;
        this.accumulate();
    }

    public FullAccumulator getResult() {
        return this.result;
    }

    private void accumulate() throws OperatorException {
        this.logger = BeamLogManager.getSystemLogger();
        String dailyAccDir = this.bbdrRootDir + File.separator + "DailyAcc";
        AccumulatorHolder dailyAccumulators = IOUtils.getDailyAccumulator(dailyAccDir, this.doy, this.year, this.tile, this.wings, this.computeSnow, false);
        if (dailyAccumulators != null) {
            String[] dailyAccBinaryFilenames = this.getDailyAccumulatorFilenameList(dailyAccumulators);
            String[] bandNames = IOUtils.getDailyAccumulatorBandNames();
            this.result = this.accumulateAndWeightDailyAccs(dailyAccBinaryFilenames, dailyAccumulators, bandNames.length);
        }
    }

    private String[] getDailyAccumulatorFilenameList(AccumulatorHolder accumulatorHolder) {
        ArrayList<String> filenameList = new ArrayList<String>();
        if (accumulatorHolder != null) {
            String[] thisInputFilenames = accumulatorHolder.getProductBinaryFilenames();
            int numDailyAccBinFiles = accumulatorHolder.getProductBinaryFilenames().length;
            if (numDailyAccBinFiles == 0) {
                this.logger.log(Level.WARNING, "No daily accumulators found for DoY " + IOUtils.getDoyString(accumulatorHolder.getReferenceDoy()) + " ...");
            } else {
                this.logger.log(Level.INFO, "Found " + numDailyAccBinFiles + " daily accumulators for DoY " + IOUtils.getDoyString(accumulatorHolder.getReferenceDoy()) + " ...");
            }
            for (int index = 0; index < thisInputFilenames.length; ++index) {
                if (filenameList.contains(thisInputFilenames[index])) continue;
                filenameList.add(thisInputFilenames[index]);
            }
        }
        return filenameList.toArray(new String[filenameList.size()]);
    }

    private FullAccumulator accumulateAndWeightDailyAccs(String[] sourceBinaryFilenames, AccumulatorHolder accumulatorHolder, int numBands) {
        int numFiles = sourceBinaryFilenames.length;
        float[][] daysToTheClosestSample = new float[this.rasterWidth][this.rasterHeight];
        float[][][] sumMatrices = new float[numBands][this.rasterWidth][this.rasterHeight];
        float[][] mask = new float[this.rasterWidth][this.rasterHeight];
        int size = numBands * this.rasterWidth * this.rasterHeight;
        boolean[] accumulate = new boolean[numFiles];
        int[] dayDifference = new int[numFiles];
        float[] weight = new float[numFiles];
        int fileIndex = 0;
        for (String filename : sourceBinaryFilenames) {
            BeamLogManager.getSystemLogger().log(Level.INFO, "Full accumulation: reading daily acc file = " + filename + " ...");
            File dailyAccumulatorBinaryFile = new File(filename);
            try {
                FileInputStream f = new FileInputStream(dailyAccumulatorBinaryFile);
                FileChannel ch = f.getChannel();
                ByteBuffer bb = ByteBuffer.allocateDirect(size);
                accumulate[fileIndex] = FullAccumulation.doAccumulation(filename, accumulatorHolder.getProductBinaryFilenames());
                dayDifference[fileIndex] = FullAccumulation.getDayDifference(dailyAccumulatorBinaryFile.getName(), accumulatorHolder);
                weight[fileIndex] = FullAccumulation.getWeight(dailyAccumulatorBinaryFile.getName(), accumulatorHolder);
                try {
                    int nRead;
                    long t1 = System.currentTimeMillis();
                    int ii = 0;
                    int jj = 0;
                    int kk = 0;
                    while ((nRead = ch.read(bb)) != -1) {
                        if (nRead == 0) continue;
                        bb.position(0);
                        bb.limit(nRead);
                        while (bb.hasRemaining() && ii < numBands) {
                            float value = bb.getFloat();
                            if (accumulate[fileIndex]) {
                                if (ii == numBands - 1) {
                                    mask[jj][kk] = value;
                                }
                                float[] fArray = sumMatrices[ii][jj];
                                int n = kk;
                                fArray[n] = fArray[n] + weight[fileIndex] * value;
                            }
                            if (++kk != this.rasterWidth) continue;
                            kk = 0;
                            if (++jj != this.rasterHeight) continue;
                            ++ii;
                            jj = 0;
                        }
                        bb.clear();
                    }
                    ch.close();
                    f.close();
                    long t2 = System.currentTimeMillis();
                    BeamLogManager.getSystemLogger().log(Level.ALL, "daily acc read in: " + (t2 - t1) + " ms");
                    if (accumulate[fileIndex]) {
                        float[][] dayOfClosestSampleOld = daysToTheClosestSample;
                        daysToTheClosestSample = this.updateDoYOfClosestSampleArray(dayOfClosestSampleOld, mask, dayDifference[fileIndex], fileIndex);
                    }
                    ++fileIndex;
                }
                catch (IOException e) {
                    BeamLogManager.getSystemLogger().log(Level.SEVERE, "Could not read daily acc " + filename + "  - skipping.");
                }
            }
            catch (FileNotFoundException e) {
                BeamLogManager.getSystemLogger().log(Level.SEVERE, "Could not find daily acc " + filename + "  - skipping.");
            }
        }
        return new FullAccumulator(accumulatorHolder.getReferenceYear(), accumulatorHolder.getReferenceDoy(), sumMatrices, daysToTheClosestSample);
    }

    private static int getDayDifference(String filename, AccumulatorHolder inputProduct) {
        int year = inputProduct.getReferenceYear();
        int fileYear = Integer.parseInt(filename.substring(9, 13));
        int doy = inputProduct.getReferenceDoy();
        int fileDoy = Integer.parseInt(filename.substring(13, 16));
        return IOUtils.getDayDifference(fileDoy, fileYear, doy, year);
    }

    private static float getWeight(String filename, AccumulatorHolder inputProduct) {
        int difference = FullAccumulation.getDayDifference(filename, inputProduct);
        return AlbedoInversionUtils.getWeight(difference);
    }

    private static boolean doAccumulation(String filename, String[] doyFilenames) {
        for (String doyFilename : doyFilenames) {
            if (!filename.equals(doyFilename)) continue;
            return true;
        }
        return false;
    }

    private float[][] updateDoYOfClosestSampleArray(float[][] doyOfClosestSampleOld, float[][] mask, int dayDifference, int productIndex) {
        float[][] doyOfClosestSample = new float[this.rasterWidth][this.rasterHeight];
        for (int i = 0; i < this.rasterWidth; ++i) {
            for (int j = 0; j < this.rasterHeight; ++j) {
                float doy;
                float bbdrDaysToDoY = Math.abs(dayDifference) + 1;
                if (productIndex == 0) {
                    doy = (double)mask[i][j] > 0.0 ? bbdrDaysToDoY : doyOfClosestSampleOld[i][j];
                } else {
                    doy = mask[i][j] > 0.0f && doyOfClosestSampleOld[i][j] == 0.0f ? bbdrDaysToDoY : doyOfClosestSampleOld[i][j];
                    doy = mask[i][j] > 0.0f && doy > 0.0f ? Math.min(bbdrDaysToDoY, doy) : doyOfClosestSampleOld[i][j];
                }
                doyOfClosestSample[i][j] = doy;
            }
        }
        return doyOfClosestSample;
    }
}

