/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import Jama.Matrix;
import java.awt.Rectangle;
import java.io.File;
import java.util.logging.Level;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProducts;
import org.esa.beam.globalbedo.inversion.Accumulator;
import org.esa.beam.globalbedo.inversion.util.DailyAccumulationUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;
import org.esa.beam.util.logging.BeamLogManager;

@OperatorMetadata(alias="ga.inversion.dailyaccbinary", description="Provides daily accumulation of single BBDR observations (new improved prototype)", authors="Olaf Danne", version="1.0", copyright="(C) 2016 by Brockmann Consult")
public class DailyAccumulationOp
extends Operator {
    @SourceProducts(description="BBDR source product")
    private Product[] sourceProducts;
    @Parameter(defaultValue="false", description="Compute only snow pixels")
    private boolean computeSnow;
    @Parameter(defaultValue="false", description="Computation for seaice mode (polar tiles)")
    private boolean computeSeaice;
    @Parameter(defaultValue="false", description="Debug - run additional parts of code if needed.")
    private boolean debug;
    @Parameter(defaultValue="true", description="Write binary accumulator file.")
    private boolean writeBinaryFile;
    @Parameter(defaultValue="1.0", description="Weighting of uncertainties (test option, should be 1.0 usually!).")
    private double uncertaintyWeightingFactor;
    @Parameter(description="Daily accumulator binary file")
    private File dailyAccumulatorBinaryFile;
    @Parameter(defaultValue="1.0", valueSet={"0.5", "1.0", "2.0", "4.0", "6.0", "10.0", "12.0", "20.0", "60.0"}, description="Scale factor with regard to MODIS default 1200x1200. Values > 1.0 reduce product size.")
    protected double modisTileScaleFactor;
    private float[][][] resultArray;
    private Tile[] bbVisTile;
    private Tile[] bbNirTile;
    private Tile[] bbSwTile;
    private Tile[] sigBbVisVisTile;
    private Tile[] sigBbVisNirTile;
    private Tile[] sigBbVisSwTile;
    private Tile[] sigBbNirNirTile;
    private Tile[] sigBbNirSwTile;
    private Tile[] sigBbSwSwTile;
    private Tile[] kvolVisTile;
    private Tile[] kvolNirTile;
    private Tile[] kvolSwTile;
    private Tile[] kgeoVisTile;
    private Tile[] kgeoNirTile;
    private Tile[] kgeoSwTile;
    private Tile[] snowMaskTile;
    private int currentSourceProductIndex;

    public void initialize() throws OperatorException {
        int sourceProductWidth = (int)(1200.0 / this.modisTileScaleFactor);
        int sourceProductHeight = (int)(1200.0 / this.modisTileScaleFactor);
        Rectangle sourceRect = new Rectangle(0, 0, sourceProductWidth, sourceProductHeight);
        this.bbVisTile = new Tile[this.sourceProducts.length];
        this.bbNirTile = new Tile[this.sourceProducts.length];
        this.bbSwTile = new Tile[this.sourceProducts.length];
        this.sigBbVisVisTile = new Tile[this.sourceProducts.length];
        this.sigBbVisNirTile = new Tile[this.sourceProducts.length];
        this.sigBbVisSwTile = new Tile[this.sourceProducts.length];
        this.sigBbNirNirTile = new Tile[this.sourceProducts.length];
        this.sigBbNirSwTile = new Tile[this.sourceProducts.length];
        this.sigBbSwSwTile = new Tile[this.sourceProducts.length];
        this.kvolVisTile = new Tile[this.sourceProducts.length];
        this.kvolNirTile = new Tile[this.sourceProducts.length];
        this.kvolSwTile = new Tile[this.sourceProducts.length];
        this.kgeoVisTile = new Tile[this.sourceProducts.length];
        this.kgeoNirTile = new Tile[this.sourceProducts.length];
        this.kgeoSwTile = new Tile[this.sourceProducts.length];
        this.snowMaskTile = new Tile[this.sourceProducts.length];
        this.resultArray = new float[92][sourceProductWidth][sourceProductHeight];
        for (int k = 0; k < this.sourceProducts.length; ++k) {
            this.bbVisTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("BB_VIS"), sourceRect);
            this.bbNirTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("BB_NIR"), sourceRect);
            this.bbSwTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("BB_SW"), sourceRect);
            this.sigBbVisVisTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("sig_BB_VIS_VIS"), sourceRect);
            this.sigBbVisNirTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("sig_BB_VIS_NIR"), sourceRect);
            this.sigBbVisSwTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("sig_BB_VIS_SW"), sourceRect);
            this.sigBbNirNirTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("sig_BB_NIR_NIR"), sourceRect);
            this.sigBbNirSwTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("sig_BB_NIR_SW"), sourceRect);
            this.sigBbSwSwTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("sig_BB_SW_SW"), sourceRect);
            this.kvolVisTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("Kvol_BRDF_VIS"), sourceRect);
            this.kvolNirTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("Kvol_BRDF_NIR"), sourceRect);
            this.kvolSwTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("Kvol_BRDF_SW"), sourceRect);
            this.kgeoVisTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("Kgeo_BRDF_VIS"), sourceRect);
            this.kgeoNirTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("Kgeo_BRDF_NIR"), sourceRect);
            this.kgeoSwTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("Kgeo_BRDF_SW"), sourceRect);
            this.snowMaskTile[k] = this.getSourceTile((RasterDataNode)this.sourceProducts[k].getBand("snow_mask"), sourceRect);
        }
        for (int x = 0; x < sourceProductWidth; ++x) {
            for (int y = 0; y < sourceProductHeight; ++y) {
                this.accumulate(x, y);
            }
        }
        BeamLogManager.getSystemLogger().log(Level.INFO, "all pixels processed.");
        BeamLogManager.getSystemLogger().log(Level.INFO, "...writing accumulator result array...");
        IOUtils.writeFloatArrayToFile(this.dailyAccumulatorBinaryFile, this.resultArray);
        BeamLogManager.getSystemLogger().log(Level.INFO, "accumulator result array written.");
        this.setTargetProduct(new Product("n", "d", 1, 1));
    }

    private void accumulate(int x, int y) {
        Matrix M = new Matrix(9, 9);
        Matrix V = new Matrix(9, 1);
        Matrix E = new Matrix(1, 1);
        double mask = 0.0;
        int k = 0;
        while (k < this.sourceProducts.length) {
            this.currentSourceProductIndex = k++;
            Accumulator accumulator = this.getMatricesPerBBDRDataset(x, y);
            M.plusEquals(accumulator.getM());
            V.plusEquals(accumulator.getV());
            E.plusEquals(accumulator.getE());
            mask += accumulator.getMask();
        }
        Accumulator finalAccumulator = new Accumulator(M, V, E, mask);
        this.fillBinaryResultArray(finalAccumulator, x, y);
    }

    private Accumulator getMatricesPerBBDRDataset(int x, int y) {
        Matrix bbdr = this.getBBDR(x, y);
        double[] stdev = this.getSD(x, y);
        double[] correlation = this.getCorrelation(x, y);
        Matrix kernels = this.getKernels(x, y);
        if (this.isSnowFilter(x, y) || DailyAccumulationUtils.isAccumulatorInputInvalid(bbdr, stdev, correlation, kernels)) {
            return this.getZeroAccumulator();
        }
        Matrix C = new Matrix(9, 1);
        Matrix thisC = new Matrix(3, 3);
        int count = 0;
        int cCount = 0;
        DailyAccumulationUtils.setDailyAccCMatrix(stdev, correlation[count], C, count, cCount);
        cCount = 0;
        for (int j = 0; j < 3; ++j) {
            C.set(cCount, 0, stdev[j] * stdev[j]);
            cCount = cCount + 3 - j;
        }
        count = 0;
        DailyAccumulationUtils.setDailyAccThisCMatrix(C, thisC, count);
        if (thisC.lu().isNonsingular()) {
            Matrix inverseC = thisC.inverse();
            Matrix M = kernels.transpose().times(inverseC).times(kernels);
            Matrix inverseCDiagFlat = DailyAccumulationUtils.getRectangularDiagonalMatrix(inverseC);
            if (inverseCDiagFlat != null) {
                Matrix kernelTimesInvCDiag = kernels.transpose().times(inverseCDiagFlat);
                Matrix V = kernelTimesInvCDiag.times(bbdr);
                Matrix E = bbdr.transpose().times(inverseC).times(bbdr);
                return new Accumulator(M, V, E, 1.0);
            }
            return this.getZeroAccumulator();
        }
        return this.getZeroAccumulator();
    }

    private Accumulator getZeroAccumulator() {
        Matrix zeroM = new Matrix(9, 9);
        Matrix zeroV = new Matrix(9, 1);
        Matrix zeroE = new Matrix(1, 1);
        return new Accumulator(zeroM, zeroV, zeroE, 0.0);
    }

    private Matrix getBBDR(int x, int y) {
        Matrix bbdr = new Matrix(3, 1);
        bbdr.set(0, 0, this.bbVisTile[this.currentSourceProductIndex].getSampleDouble(x, y));
        bbdr.set(1, 0, this.bbNirTile[this.currentSourceProductIndex].getSampleDouble(x, y));
        bbdr.set(2, 0, this.bbSwTile[this.currentSourceProductIndex].getSampleDouble(x, y));
        return bbdr;
    }

    private double[] getSD(int x, int y) {
        double[] SD = new double[]{this.sigBbVisVisTile[this.currentSourceProductIndex].getSampleDouble(x, y), this.sigBbNirNirTile[this.currentSourceProductIndex].getSampleDouble(x, y), this.sigBbSwSwTile[this.currentSourceProductIndex].getSampleDouble(x, y)};
        return SD;
    }

    private double[] getCorrelation(int x, int y) {
        double[] correlation = new double[]{this.sigBbVisNirTile[this.currentSourceProductIndex].getSampleDouble(x, y), this.sigBbVisSwTile[this.currentSourceProductIndex].getSampleDouble(x, y), this.sigBbNirSwTile[this.currentSourceProductIndex].getSampleDouble(x, y)};
        return correlation;
    }

    private void fillBinaryResultArray(Accumulator accumulator, int x, int y) {
        int i;
        int offset = 0;
        for (i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.resultArray[offset++][x][y] = (float)accumulator.getM().get(i, j);
            }
        }
        for (i = 0; i < 9; ++i) {
            this.resultArray[offset++][x][y] = (float)accumulator.getV().get(i, 0);
        }
        this.resultArray[offset++][x][y] = (float)accumulator.getE().get(0, 0);
        this.resultArray[offset][x][y] = (float)accumulator.getMask();
    }

    private Matrix getKernels(int x, int y) {
        Matrix kernels = new Matrix(3, 9);
        kernels.set(0, 0, 1.0);
        kernels.set(1, 3, 1.0);
        kernels.set(2, 6, 1.0);
        kernels.set(0, 1, this.kvolVisTile[this.currentSourceProductIndex].getSampleDouble(x, y));
        kernels.set(1, 4, this.kvolNirTile[this.currentSourceProductIndex].getSampleDouble(x, y));
        kernels.set(2, 7, this.kvolSwTile[this.currentSourceProductIndex].getSampleDouble(x, y));
        kernels.set(0, 2, this.kgeoVisTile[this.currentSourceProductIndex].getSampleDouble(x, y));
        kernels.set(1, 5, this.kgeoNirTile[this.currentSourceProductIndex].getSampleDouble(x, y));
        kernels.set(2, 8, this.kgeoSwTile[this.currentSourceProductIndex].getSampleDouble(x, y));
        return kernels;
    }

    private boolean isSnowFilter(int x, int y) {
        return this.computeSnow && this.snowMaskTile[this.currentSourceProductIndex].getSampleInt(x, y) != 1 || !this.computeSnow && this.snowMaskTile[this.currentSourceProductIndex].getSampleInt(x, y) == 1;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(DailyAccumulationOp.class);
        }
    }
}

