/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.globalbedo.inversion;

import Jama.LUDecomposition;
import Jama.Matrix;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.pointop.PixelOperator;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.globalbedo.inversion.AlbedoResult;
import org.esa.beam.globalbedo.inversion.util.AlbedoInversionUtils;
import org.esa.beam.globalbedo.inversion.util.IOUtils;

@OperatorMetadata(alias="ga.albedo.brdfmosaic.albedomosaic", description="Provides final mosaics of albedo retrieval from merged BRDF mosaics. Includes BHR and DHR alpha terms.", authors="Olaf Danne", version="1.0", copyright="(C) 2011, 2013 by Brockmann Consult")
public class BrdfMosaicToAlbedoMosaicOp
extends PixelOperator {
    private static final int[] SRC_PARAMETERS = new int[9];
    private String[] parameterBandNames = new String[9];
    private String[][] uncertaintyBandNames = new String[9][9];
    private static final int urMatrixOffset = ((int)Math.pow(9.0, 2.0) + 9) / 2;
    private static final int[] SRC_UNCERTAINTIES = new int[urMatrixOffset];
    private static final int SRC_ENTROPY = 0;
    private static final int SRC_REL_ENTROPY = 1;
    private static final int SRC_WEIGHTED_NUM_SAMPLES = 2;
    private static final int SRC_DAYS_CLOSEST_SAMPLE = 3;
    private static final int SRC_GOODNESS_OF_FIT = 4;
    private static final int SRC_PROPORTION_NSAMPLE = 5;
    private String[] dhrBandNames = new String[3];
    private String[] bhrBandNames = new String[3];
    private String[] dhrAlphaBandNames = new String[3];
    private String[] bhrAlphaBandNames = new String[3];
    private String[] dhrSigmaBandNames = new String[3];
    private String[] bhrSigmaBandNames = new String[3];
    private String relEntropyBandName;
    private String weightedNumberOfSamplesBandName;
    private String goodnessOfFitBandName;
    private String snowFractionBandName;
    private String dataMaskBandName;
    private String szaBandName;
    private static final int[] TRG_DHR = new int[3];
    private static final int[] TRG_DHR_ALPHA = new int[3];
    private static final int[] TRG_BHR = new int[3];
    private static final int[] TRG_BHR_ALPHA = new int[3];
    private static final int[] TRG_SIGMA_DHR = new int[3];
    private static final int[] TRG_SIGMA_BHR = new int[3];
    private static final int TRG_WEIGHTED_NUM_SAMPLES = 0;
    private static final int TRG_REL_ENTROPY = 1;
    private static final int TRG_GOODNESS_OF_FIT = 2;
    private static final int TRG_SNOW_FRACTION = 3;
    private static final int TRG_DATA_MASK = 4;
    private static final int TRG_SZA = 5;
    @SourceProduct(description="BRDF merged product")
    private Product brdfMergedProduct;
    @Parameter(description="doy", interval="[1,366]")
    private int doy;

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        int i;
        PixelPos pixelPos = new PixelPos((float)x, (float)y);
        GeoPos geoPos = this.brdfMergedProduct.getGeoCoding().getGeoPos(pixelPos, null);
        double SZAdeg = AlbedoInversionUtils.computeSza(geoPos, this.doy);
        double SZA = SZAdeg * (Math.PI / 180);
        Matrix C = this.getCMatrixFromInversionProduct(sourceSamples);
        Matrix[] wsaSigma = new Matrix[3];
        Matrix[] bsaSigma = new Matrix[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            wsaSigma[i2] = new Matrix(1, 1, -9999.0);
            bsaSigma[i2] = new Matrix(1, 1, -9999.0);
        }
        Matrix uWsaVis = new Matrix(1, 9);
        Matrix uWsaNir = new Matrix(1, 9);
        Matrix uWsaSw = new Matrix(1, 9);
        uWsaVis.set(0, 0, 1.0);
        uWsaVis.set(0, 1, 0.189184);
        uWsaVis.set(0, 2, -1.377622);
        for (int i3 = 0; i3 < 3; ++i3) {
            uWsaNir.set(0, i3 + 3, uWsaVis.get(0, i3));
            uWsaSw.set(0, i3 + 6, uWsaVis.get(0, i3));
        }
        double maskEntropyDataValue = sourceSamples[SRC_PARAMETERS.length + SRC_PARAMETERS.length + 0].getDouble();
        if (AlbedoInversionUtils.isValid(maskEntropyDataValue)) {
            LUDecomposition cLUD = new LUDecomposition(C.transpose());
            if (cLUD.isNonsingular()) {
                wsaSigma[0] = uWsaVis.times(C.transpose()).times(uWsaVis.transpose());
                wsaSigma[1] = uWsaNir.times(C.transpose()).times(uWsaNir.transpose());
                wsaSigma[2] = uWsaSw.times(C.transpose()).times(uWsaSw.transpose());
                Matrix uBsaVis = new Matrix(1, 9);
                Matrix uBsaNir = new Matrix(1, 9);
                Matrix uBsaSw = new Matrix(1, 9);
                double[] uBsaArray = new double[]{1.0, -0.007574 + -0.070887 * Math.pow(SZA, 2.0) + 0.307588 * Math.pow(SZA, 3.0), -1.284909 + -0.166314 * Math.pow(SZA, 2.0) + 0.04184 * Math.pow(SZA, 3.0)};
                for (int i4 = 0; i4 < 3; ++i4) {
                    uBsaVis.set(0, i4, uBsaArray[i4]);
                    uBsaNir.set(0, i4 + 3, uBsaArray[i4]);
                    uBsaSw.set(0, i4 + 6, uBsaArray[i4]);
                }
                bsaSigma[0] = uBsaVis.times(C.transpose()).times(uBsaVis.transpose());
                bsaSigma[1] = uBsaNir.times(C.transpose()).times(uBsaNir.transpose());
                bsaSigma[2] = uBsaSw.times(C.transpose()).times(uBsaSw.transpose());
            } else {
                for (int i5 = 0; i5 < 3; ++i5) {
                    wsaSigma[i5].set(0, 0, -9999.0);
                    bsaSigma[i5].set(0, 0, -9999.0);
                }
            }
        }
        int numParams = 9;
        double[] fParams = new double[9];
        for (int i6 = 0; i6 < 9; ++i6) {
            fParams[i6] = sourceSamples[i6].getDouble();
        }
        double[] blackSkyAlbedo = new double[3];
        for (int i7 = 0; i7 < blackSkyAlbedo.length; ++i7) {
            blackSkyAlbedo[i7] = fParams[3 * i7] + fParams[1 + 3 * i7] * (-0.007574 + -0.070887 * Math.pow(SZA, 2.0) + 0.307588 * Math.pow(SZA, 3.0)) + fParams[2 + 3 * i7] * (-1.284909 + -0.166314 * Math.pow(SZA, 2.0) + 0.04184 * Math.pow(SZA, 3.0));
        }
        double[] whiteSkyAlbedo = new double[]{fParams[0] + fParams[1] * uWsaVis.get(0, 1) + fParams[2] * uWsaVis.get(0, 2), fParams[3] + fParams[4] * uWsaNir.get(0, 4) + fParams[5] * uWsaNir.get(0, 5), fParams[6] + fParams[7] * uWsaSw.get(0, 7) + fParams[8] * uWsaSw.get(0, 8)};
        double[] alphaDHR = new double[3];
        double[] alphaBHR = new double[3];
        if (AlbedoInversionUtils.isValid(maskEntropyDataValue)) {
            alphaDHR = this.computeAlphaDHR(SZA, C);
            alphaBHR = this.computeAlphaBHR(C);
        } else {
            for (i = 0; i < 3; ++i) {
                alphaDHR[i] = -9999.0;
                alphaBHR[i] = -9999.0;
            }
        }
        for (i = 0; i < 3; ++i) {
            double bsa;
            double wsa = wsaSigma[i].get(0, 0);
            if (AlbedoInversionUtils.isValid(wsa)) {
                wsaSigma[i].set(0, 0, Math.min(1.0, Math.sqrt(wsa)));
            }
            if (!AlbedoInversionUtils.isValid(bsa = bsaSigma[i].get(0, 0))) continue;
            bsaSigma[i].set(0, 0, Math.min(1.0, Math.sqrt(bsa)));
        }
        double relEntropy = sourceSamples[SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 1].getDouble();
        if (AlbedoInversionUtils.isValid(relEntropy)) {
            relEntropy = Math.exp(relEntropy / 9.0);
        }
        double weightedNumberOfSamples = sourceSamples[SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 2].getDouble();
        double goodnessOfFit = sourceSamples[SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 4].getDouble();
        double snowFraction = sourceSamples[SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 5].getDouble();
        double entropy = sourceSamples[SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 0].getDouble();
        double maskEntropy = AlbedoInversionUtils.isValid(entropy) ? 1.0 : 0.0;
        AlbedoResult result = new AlbedoResult(blackSkyAlbedo, alphaDHR, bsaSigma, whiteSkyAlbedo, alphaBHR, wsaSigma, weightedNumberOfSamples, relEntropy, goodnessOfFit, snowFraction, maskEntropy, SZAdeg);
        this.fillTargetSamples(targetSamples, result);
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        int i;
        super.configureTargetProduct(productConfigurer);
        Product targetProduct = productConfigurer.getTargetProduct();
        this.dhrBandNames = IOUtils.getAlbedoDhrBandNames();
        for (i = 0; i < 3; ++i) {
            targetProduct.addBand(this.dhrBandNames[i], 30);
        }
        this.dhrAlphaBandNames = IOUtils.getAlbedoDhrAlphaBandNames();
        for (i = 0; i < 3; ++i) {
            targetProduct.addBand(this.dhrAlphaBandNames[i], 30);
        }
        this.dhrSigmaBandNames = IOUtils.getAlbedoDhrSigmaBandNames();
        for (i = 0; i < 3; ++i) {
            targetProduct.addBand(this.dhrSigmaBandNames[i], 30);
        }
        this.bhrBandNames = IOUtils.getAlbedoBhrBandNames();
        for (i = 0; i < 3; ++i) {
            targetProduct.addBand(this.bhrBandNames[i], 30);
        }
        this.bhrAlphaBandNames = IOUtils.getAlbedoBhrAlphaBandNames();
        for (i = 0; i < 3; ++i) {
            targetProduct.addBand(this.bhrAlphaBandNames[i], 30);
        }
        this.bhrSigmaBandNames = IOUtils.getAlbedoBhrSigmaBandNames();
        for (i = 0; i < 3; ++i) {
            targetProduct.addBand(this.bhrSigmaBandNames[i], 30);
        }
        this.weightedNumberOfSamplesBandName = "Weighted_Number_of_Samples";
        targetProduct.addBand(this.weightedNumberOfSamplesBandName, 30);
        this.relEntropyBandName = "Relative_Entropy";
        targetProduct.addBand(this.relEntropyBandName, 30);
        this.goodnessOfFitBandName = "Goodness_of_Fit";
        targetProduct.addBand(this.goodnessOfFitBandName, 30);
        this.snowFractionBandName = "Snow_Fraction";
        targetProduct.addBand(this.snowFractionBandName, 30);
        this.dataMaskBandName = "Data_Mask";
        targetProduct.addBand(this.dataMaskBandName, 30);
        this.szaBandName = "Solar_Zenith_Angle";
        targetProduct.addBand(this.szaBandName, 30);
        for (Band b : targetProduct.getBands()) {
            b.setNoDataValue(-9999.0);
            b.setNoDataValueUsed(true);
        }
    }

    protected void configureSourceSamples(SampleConfigurer configurator) throws OperatorException {
        this.parameterBandNames = IOUtils.getInversionParameterBandNames();
        for (int i = 0; i < 9; ++i) {
            BrdfMosaicToAlbedoMosaicOp.SRC_PARAMETERS[i] = i;
            configurator.defineSample(SRC_PARAMETERS[i], this.parameterBandNames[i], this.brdfMergedProduct);
        }
        int index = 0;
        this.uncertaintyBandNames = IOUtils.getInversionUncertaintyBandNames();
        for (int i = 0; i < 9; ++i) {
            for (int j = i; j < 9; ++j) {
                BrdfMosaicToAlbedoMosaicOp.SRC_UNCERTAINTIES[index] = index;
                configurator.defineSample(SRC_PARAMETERS.length + SRC_UNCERTAINTIES[index], this.uncertaintyBandNames[i][j], this.brdfMergedProduct);
                ++index;
            }
        }
        String entropyBandName = "Entropy";
        configurator.defineSample(SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 0, entropyBandName, this.brdfMergedProduct);
        this.relEntropyBandName = "Relative_Entropy";
        configurator.defineSample(SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 1, this.relEntropyBandName, this.brdfMergedProduct);
        this.weightedNumberOfSamplesBandName = "Weighted_Number_of_Samples";
        configurator.defineSample(SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 2, this.weightedNumberOfSamplesBandName, this.brdfMergedProduct);
        String closestSampleBandName = "Time_to_the_Closest_Sample";
        if (this.brdfMergedProduct.getBand(closestSampleBandName) == null) {
            closestSampleBandName = "Days_to_the_Closest_Sample";
        }
        configurator.defineSample(SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 3, closestSampleBandName, this.brdfMergedProduct);
        this.goodnessOfFitBandName = "Goodness_of_Fit";
        configurator.defineSample(SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 4, this.goodnessOfFitBandName, this.brdfMergedProduct);
        String proportionNsamplesBandName = "Proportion_NSamples";
        configurator.defineSample(SRC_PARAMETERS.length + SRC_UNCERTAINTIES.length + 5, proportionNsamplesBandName, this.brdfMergedProduct);
    }

    protected void configureTargetSamples(SampleConfigurer configurator) throws OperatorException {
        int i;
        int index = 0;
        for (i = 0; i < 3; ++i) {
            BrdfMosaicToAlbedoMosaicOp.TRG_DHR[i] = index++;
            configurator.defineSample(TRG_DHR[i], this.dhrBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            BrdfMosaicToAlbedoMosaicOp.TRG_DHR_ALPHA[i] = index++;
            configurator.defineSample(TRG_DHR_ALPHA[i], this.dhrAlphaBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            BrdfMosaicToAlbedoMosaicOp.TRG_BHR[i] = index++;
            configurator.defineSample(TRG_BHR[i], this.bhrBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            BrdfMosaicToAlbedoMosaicOp.TRG_BHR_ALPHA[i] = index++;
            configurator.defineSample(TRG_BHR_ALPHA[i], this.bhrAlphaBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            BrdfMosaicToAlbedoMosaicOp.TRG_SIGMA_DHR[i] = index++;
            configurator.defineSample(TRG_SIGMA_DHR[i], this.dhrSigmaBandNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            BrdfMosaicToAlbedoMosaicOp.TRG_SIGMA_BHR[i] = index++;
            configurator.defineSample(TRG_SIGMA_BHR[i], this.bhrSigmaBandNames[i]);
        }
        configurator.defineSample(index++, this.weightedNumberOfSamplesBandName);
        configurator.defineSample(index++, this.relEntropyBandName);
        configurator.defineSample(index++, this.goodnessOfFitBandName);
        configurator.defineSample(index++, this.snowFractionBandName);
        configurator.defineSample(index++, this.dataMaskBandName);
        configurator.defineSample(index, this.szaBandName);
    }

    private double[] computeAlphaDHR(double SZA, Matrix c) {
        double[] alphaDHR = new double[3];
        double[] kDHR = new double[]{1.0, -0.007574 + -0.070887 * Math.pow(SZA, 2.0) + 0.307588 * Math.pow(SZA, 3.0), -1.284909 + -0.166314 * Math.pow(SZA, 2.0) + 0.04184 * Math.pow(SZA, 3.0)};
        Matrix mDHR = new Matrix(3, 9, 0.0);
        for (int a = 0; a < 3; ++a) {
            mDHR.set(a, a * 3, kDHR[0]);
            mDHR.set(a, a * 3 + 1, kDHR[1]);
            mDHR.set(a, a * 3 + 2, kDHR[2]);
        }
        Matrix cDHR = mDHR.times(c.transpose()).times(mDHR.transpose());
        alphaDHR[0] = (float)(cDHR.get(0, 1) / Math.sqrt(cDHR.get(0, 0) * cDHR.get(1, 1)));
        alphaDHR[1] = (float)(cDHR.get(0, 2) / Math.sqrt(cDHR.get(0, 0) * cDHR.get(2, 2)));
        alphaDHR[2] = (float)(cDHR.get(1, 2) / Math.sqrt(cDHR.get(1, 1) * cDHR.get(2, 2)));
        return alphaDHR;
    }

    private double[] computeAlphaBHR(Matrix c) {
        double[] alphaBHR = new double[3];
        double[] kBHR = new double[]{1.0, 0.189184, -1.377622};
        Matrix mBHR = new Matrix(3, 9, 0.0);
        for (int a = 0; a < 3; ++a) {
            mBHR.set(a, a * 3, kBHR[0]);
            mBHR.set(a, a * 3 + 1, kBHR[1]);
            mBHR.set(a, a * 3 + 2, kBHR[2]);
        }
        Matrix cBHR = mBHR.times(c.transpose()).times(mBHR.transpose());
        alphaBHR[0] = (float)(cBHR.get(0, 1) / Math.sqrt(cBHR.get(0, 0) * cBHR.get(1, 1)));
        alphaBHR[1] = (float)(cBHR.get(0, 2) / Math.sqrt(cBHR.get(0, 0) * cBHR.get(2, 2)));
        alphaBHR[2] = (float)(cBHR.get(1, 2) / Math.sqrt(cBHR.get(1, 1) * cBHR.get(2, 2)));
        return alphaBHR;
    }

    private void fillTargetSamples(WritableSample[] targetSamples, AlbedoResult result) {
        int i;
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_DHR[i]].set(result.getBsa()[i]);
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_DHR_ALPHA[i]].set(result.getBsaAlpha()[i]);
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_SIGMA_DHR[i]].set(result.getBsaSigma()[i].get(0, 0));
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_BHR[i]].set(result.getWsa()[i]);
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_BHR_ALPHA[i]].set(result.getWsaAlpha()[i]);
        }
        for (i = 0; i < 3; ++i) {
            targetSamples[TRG_SIGMA_BHR[i]].set(result.getWsaSigma()[i].get(0, 0));
        }
        int index = 18;
        targetSamples[index + 0].set(result.getWeightedNumberOfSamples());
        targetSamples[index + 1].set(result.getRelEntropy());
        targetSamples[index + 2].set(result.getGoodnessOfFit());
        targetSamples[index + 3].set(result.getSnowFraction());
        targetSamples[index + 4].set(result.getDataMask());
        targetSamples[index + 5].set(result.getSza());
    }

    private Matrix getCMatrixFromInversionProduct(Sample[] sourceSamples) {
        Matrix C = new Matrix(9, 9);
        double[] cTmp = new double[SRC_UNCERTAINTIES.length];
        int index = 0;
        int n = 9;
        for (int i = 0; i < SRC_UNCERTAINTIES.length; ++i) {
            double sampleUncertainty;
            cTmp[i] = sampleUncertainty = sourceSamples[SRC_PARAMETERS.length + index].getDouble();
            ++index;
        }
        int index2 = 0;
        for (int k = 9; k > 0; --k) {
            int index1;
            if (k == 9) {
                index1 = 9;
                index2 = 2 * index1 - 1;
            } else {
                index1 = index2 + 1;
                index2 += k;
            }
            for (int i = 0; i < k; ++i) {
                C.set(9 - k, 9 - k + i, cTmp[index1 - 9 + i]);
                C.set(9 - k + i, 9 - k, cTmp[index1 - 9 + i]);
            }
        }
        return C;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(BrdfMosaicToAlbedoMosaicOp.class);
        }
    }
}

