/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.spot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import junit.framework.TestCase;

public class GridTest
extends TestCase {
    private static final int MAX_USHORT = 65535;
    private static final int SAMPLING = 100;

    public void testJaiImageScaling() throws Exception {
        int destW = 1024;
        int destH = 512;
        int srcW = destW / 100 + 1;
        int srcH = destH / 100 + 1;
        BufferedImage srcImg = GridTest.createSrcImage(srcW, srcH);
        int tempW = srcW * 100 + 1;
        int tempH = srcH * 100 + 1;
        float xScale = (float)tempW / (float)srcW;
        float yScale = (float)tempH / (float)srcH;
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        RenderedOp tempImg = ScaleDescriptor.create((RenderedImage)srcImg, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(-49.0f), (Float)Float.valueOf(-49.0f), (Interpolation)Interpolation.getInstance((int)1), (RenderingHints)renderingHints);
        GridTest.assertEquals((int)tempW, (int)tempImg.getWidth());
        GridTest.assertEquals((int)tempH, (int)tempImg.getHeight());
        RenderedOp dstImg = CropDescriptor.create((RenderedImage)tempImg, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(destW), (Float)Float.valueOf(destH), null);
        GridTest.assertEquals((int)1024, (int)dstImg.getWidth());
        GridTest.assertEquals((int)512, (int)dstImg.getHeight());
        Raster data = dstImg.getData();
        GridTest.assertEquals((int)65535, (int)data.getSample(0, 0, 0));
        GridTest.assertEquals((int)65535, (int)data.getSample(destW - 1, 0, 0));
        GridTest.assertEquals((int)65535, (int)data.getSample(0, destH - 1, 0));
        GridTest.assertEquals((int)65535, (int)data.getSample(destW - 1, destH - 1, 0));
    }

    private static BufferedImage createSrcImage(int srcW, int srcH) {
        BufferedImage srcImg = new BufferedImage(srcW, srcH, 11);
        for (int y = 0; y < srcH; ++y) {
            for (int x = 0; x < srcW; ++x) {
                srcImg.getRaster().setSample(x, y, 0, (int)(65535.0 * Math.random()));
            }
        }
        srcImg.getRaster().setSample(0, 0, 0, 65535);
        srcImg.getRaster().setSample(srcW - 1, 0, 0, 65535);
        srcImg.getRaster().setSample(0, srcH - 1, 0, 65535);
        srcImg.getRaster().setSample(srcW - 1, srcH - 1, 0, 65535);
        return srcImg;
    }

    public static void main(String[] args) {
        int destW = 1024;
        int destH = 512;
        int srcW = destW / 100 + 1;
        int srcH = destH / 100 + 1;
        BufferedImage srcImg = GridTest.createSrcImage(srcW, srcH);
        int tempW = srcW * 100 + 1;
        int tempH = srcH * 100 + 1;
        float xScale = (float)tempW / (float)srcW;
        float yScale = (float)tempH / (float)srcH;
        float xTrans = -50.0f;
        float yTrans = -50.0f;
        Interpolation[] interpolations = new Interpolation[]{Interpolation.getInstance((int)0), Interpolation.getInstance((int)1), Interpolation.getInstance((int)2), Interpolation.getInstance((int)3)};
        for (int i = 0; i < interpolations.length; ++i) {
            Interpolation interpolation = interpolations[i];
            RenderingHints renderingHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            RenderedOp image = ScaleDescriptor.create((RenderedImage)srcImg, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(xTrans), (Float)Float.valueOf(yTrans), (Interpolation)interpolation, (RenderingHints)renderingHints);
            System.out.println("==============================");
            System.out.println("x = " + image.getMinX());
            System.out.println("y = " + image.getMinY());
            System.out.println("w = " + image.getWidth());
            System.out.println("h = " + image.getHeight());
            GridTest.showImage("[" + i + "] - " + interpolation, (RenderedImage)image);
        }
    }

    private static void showImage(String name, final RenderedImage image) {
        JFrame frame = new JFrame(name);
        frame.add(new JScrollPane(new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(image.getWidth(), image.getHeight());
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                ((Graphics2D)g).drawRenderedImage(image, new AffineTransform());
                Color oldColor = g.getColor();
                g.setColor(Color.ORANGE);
                for (int x = image.getMinX(); x < image.getMinX() + image.getWidth(); x += 100) {
                    g.drawLine(x, image.getMinY(), x, image.getMinY() + image.getWidth());
                }
                for (int y = image.getMinY(); y < image.getMinY() + image.getHeight(); y += 100) {
                    g.drawLine(image.getMinX(), y, image.getMinX() + image.getWidth(), y);
                }
                g.setColor(oldColor);
            }
        }));
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

