/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.jpy;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.jpy.PyBridge;
import org.jpy.PyLib;
import org.jpy.PyModule;
import org.jpy.PyObject;

@OperatorMetadata(alias="PyOp", description="Uses Python code to process data products", version="0.8", authors="N. Fomferra", internal=true)
public class PyOperator
extends Operator {
    @Parameter(description="Path to the Python module(s). Can be either an absolute path or relative to the current working directory.", defaultValue=".")
    private String pythonModulePath;
    @Parameter(description="Name of the Python module.")
    private String pythonModuleName;
    @Parameter(description="Name of the Python class which implements the operator. Please refer to the BEAM help for details.")
    private String pythonClassName;
    private transient PyModule pyModule;
    private transient PythonProcessor pythonProcessor;

    public String getPythonModulePath() {
        return this.pythonModulePath;
    }

    public void setPythonModulePath(String pythonModulePath) {
        this.pythonModulePath = pythonModulePath;
    }

    public String getPythonModuleName() {
        return this.pythonModuleName;
    }

    public void setPythonModuleName(String pythonModuleName) {
        this.pythonModuleName = pythonModuleName;
    }

    public String getPythonClassName() {
        return this.pythonClassName;
    }

    public void setPythonClassName(String pythonClassName) {
        this.pythonClassName = pythonClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws OperatorException {
        if (this.pythonModuleName == null || this.pythonModuleName.isEmpty()) {
            throw new OperatorException("Missing parameter 'pythonModuleName'");
        }
        if (this.pythonClassName == null || this.pythonClassName.isEmpty()) {
            throw new OperatorException("Missing value for parameter 'pythonClassName'");
        }
        PyBridge.establish();
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            PyBridge.extendSysPath(this.pythonModulePath);
            String code = String.format("if '%s' in globals(): del %s", this.pythonModuleName, this.pythonModuleName);
            PyLib.execScript((String)code);
            this.pyModule = PyModule.importModule((String)this.pythonModuleName);
            PyObject pythonProcessorImpl = this.pyModule.call(this.pythonClassName, new Object[0]);
            this.pythonProcessor = (PythonProcessor)pythonProcessorImpl.createProxy(PythonProcessor.class);
            this.pythonProcessor.initialize(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            this.pythonProcessor.compute(this, targetTiles, targetRectangle);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            this.pythonProcessor.dispose(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static interface PythonProcessor {
        public void initialize(Operator var1);

        public void compute(Operator var1, Map<Band, Tile> var2, Rectangle var3);

        public void dispose(Operator var1);
    }
}

