/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.jpy;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.util.Debug;
import org.esa.beam.util.logging.BeamLogManager;
import org.jpy.PyLib;

public class PyBridge {
    public static final String BEAMPYUTIL_PY_FILENAME = "beampyutil.py";
    public static final String BEAMPYUTIL_LOG_FILENAME = "beampyutil.log";
    public static final String JPY_JAVA_API_CONFIG_FILENAME = "jpyconfig.properties";
    private static boolean established;
    private static File beampyDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void establish() {
        if (established) {
            return;
        }
        beampyDir = PyBridge.getResourceFile("/beampy");
        if (beampyDir == null) {
            throw new OperatorException("Can't find BEAM-Python module directory.\n(Make sure the BEAM-Python module is unpacked.)");
        }
        BeamLogManager.getSystemLogger().info("BEAM-Python module directory: " + beampyDir);
        boolean forcePythonConfig = System.getProperty("beam.forcePythonConfig", "true").equalsIgnoreCase("true");
        File jpyConfigFile = new File(beampyDir, JPY_JAVA_API_CONFIG_FILENAME);
        if (forcePythonConfig || !jpyConfigFile.exists()) {
            PyBridge.configureJpy();
        }
        if (!jpyConfigFile.exists()) {
            throw new OperatorException(String.format("Python configuration incomplete.\nMissing file '%s'.\nPlease check '%s'.", jpyConfigFile, new File(beampyDir, BEAMPYUTIL_LOG_FILENAME)));
        }
        System.setProperty("jpy.config", jpyConfigFile.getPath());
        if (Debug.isEnabled() && System.getProperty("jpy.debug") == null) {
            System.setProperty("jpy.debug", "true");
        }
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            if (!established) {
                String pythonVersion = PyLib.getPythonVersion();
                BeamLogManager.getSystemLogger().info("Running Python " + pythonVersion);
                if (!PyLib.isPythonRunning()) {
                    PyLib.startPython((String[])new String[]{beampyDir.getPath()});
                } else {
                    PyBridge.extendSysPath(beampyDir.getPath());
                }
                established = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void extendSysPath(String path) {
        if (path != null) {
            String code = String.format("import sys;\np = '%s';\nif not p in sys.path: sys.path.append(p)", path.replace("\\", "\\\\"));
            PyLib.execScript((String)code);
        }
    }

    private static void configureJpy() {
        String osArch;
        String javaHome;
        BeamLogManager.getSystemLogger().info("Configuring BEAM-Python bridge...");
        String pythonExecutable = System.getProperty("beam.pythonExecutable", "python");
        ArrayList<String> command = new ArrayList<String>();
        command.add(pythonExecutable);
        command.add(BEAMPYUTIL_PY_FILENAME);
        command.add("--force");
        command.add("--log_file");
        command.add(BEAMPYUTIL_LOG_FILENAME);
        if (Debug.isEnabled()) {
            command.add("--log_level");
            command.add("DEBUG");
        }
        if ((javaHome = System.getProperty("java.home")) != null) {
            command.add("--java_home");
            command.add(javaHome);
        }
        if ((osArch = System.getProperty("os.arch")) != null) {
            command.add("--req_arch");
            command.add(osArch);
        }
        String commandLine = PyBridge.toCommandLine(command);
        BeamLogManager.getSystemLogger().info(String.format("Executing command: [%s]\n", commandLine));
        try {
            Process process = new ProcessBuilder(new String[0]).command(command).directory(beampyDir).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new OperatorException(String.format("Python configuration failed.\nCommand [%s]\nfailed with return code %s.", commandLine, exitCode));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new OperatorException(String.format("Python configuration failed.\nCommand [%s]\nfailed with exception %s.", commandLine, e.getMessage()), (Throwable)e);
        }
    }

    private static String toCommandLine(List<String> command) {
        StringBuilder sb = new StringBuilder();
        for (String arg : command) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(arg.contains(" ") ? String.format("\"%s\"", arg) : arg);
        }
        return sb.toString();
    }

    private static File getResourceFile(String resourcePath) {
        URL resourceUrl = PyBridge.class.getResource(resourcePath);
        if (resourceUrl != null) {
            try {
                File resourceFile = new File(resourceUrl.toURI());
                if (resourceFile.exists()) {
                    return resourceFile;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }
}

