/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import java.text.ParseException;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.logging.BeamLogManager;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public class TimeUtils {
    public static ProductData.UTC getSceneRasterTime(NetcdfFile ncFile, String dateAttrName, String timeAttrName) {
        Attribute timeAttr;
        Attribute dateAttr = ncFile.findGlobalAttribute(dateAttrName);
        String dateTimeStr = TimeUtils.getDateTimeString(dateAttr, timeAttr = ncFile.findGlobalAttribute(timeAttrName));
        if (dateTimeStr != null) {
            return TimeUtils.parseDateTime(dateTimeStr);
        }
        return null;
    }

    public static String getDateTimeString(Attribute dateAttr, Attribute timeAttr) {
        String time;
        String date = dateAttr != null ? dateAttr.getStringValue() : null;
        String string = time = timeAttr != null ? timeAttr.getStringValue() : null;
        if (date != null && date.endsWith("UTC")) {
            date = date.substring(0, date.length() - 3).trim();
        }
        if (time != null && time.endsWith("UTC")) {
            time = time.substring(0, time.length() - 3).trim();
        }
        if (date != null && time != null) {
            return date + " " + time;
        }
        if (date != null) {
            return date + (date.indexOf(58) == -1 ? " 00:00:00" : "");
        }
        if (time != null) {
            return time + (time.indexOf(58) == -1 ? " 00:00:00" : "");
        }
        return null;
    }

    public static ProductData.UTC parseDateTime(String dateTimeStr) {
        try {
            return ProductData.UTC.parse((String)dateTimeStr);
        }
        catch (ParseException ignore) {
            try {
                return ProductData.UTC.parse((String)dateTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException ignore2) {
                BeamLogManager.getSystemLogger().warning("Failed to parse time string '" + dateTimeStr + "'");
                return null;
            }
        }
    }
}

