/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.beam.dataio.netcdf.util.DataTypeUtils;
import org.esa.beam.dataio.netcdf.util.DimKey;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;

public class RasterDigest {
    private final DimKey rasterDim;
    private final Variable[] variables;

    public RasterDigest(DimKey rasterDim, Variable[] variables) {
        this.rasterDim = rasterDim;
        this.variables = variables;
    }

    public DimKey getRasterDim() {
        return this.rasterDim;
    }

    public Variable[] getRasterVariables() {
        return this.variables;
    }

    public static RasterDigest createRasterDigest(Group group) {
        Map<DimKey, List<Variable>> variableListMap = RasterDigest.getVariableListMap(group);
        if (variableListMap.isEmpty()) {
            return null;
        }
        DimKey rasterDim = RasterDigest.getBestRasterDim(variableListMap);
        Variable[] rasterVariables = RasterDigest.getRasterVariables(variableListMap, rasterDim);
        return new RasterDigest(rasterDim, rasterVariables);
    }

    static Variable[] getRasterVariables(Map<DimKey, List<Variable>> variableLists, DimKey rasterDim) {
        List<Variable> list = variableLists.get(rasterDim);
        return list.toArray(new Variable[list.size()]);
    }

    static DimKey getBestRasterDim(Map<DimKey, List<Variable>> variableListMap) {
        Set<DimKey> ncRasterDims = variableListMap.keySet();
        if (ncRasterDims.size() == 0) {
            return null;
        }
        DimKey bestRasterDim = null;
        List<Variable> bestVarList = null;
        for (DimKey rasterDim : ncRasterDims) {
            if (rasterDim.isTypicalRasterDim()) {
                return rasterDim;
            }
            List<Variable> varList = variableListMap.get(rasterDim);
            if (bestVarList != null && varList.size() <= bestVarList.size()) continue;
            bestRasterDim = rasterDim;
            bestVarList = varList;
        }
        return bestRasterDim;
    }

    static Map<DimKey, List<Variable>> getVariableListMap(Group group) {
        HashMap<DimKey, List<Variable>> variableLists = new HashMap<DimKey, List<Variable>>();
        RasterDigest.collectVariableLists(group, variableLists);
        return variableLists;
    }

    static void collectVariableLists(Group group, Map<DimKey, List<Variable>> variableLists) {
        List variables = group.getVariables();
        for (Variable variable : variables) {
            int rank = variable.getRank();
            if (rank < 2 || !DataTypeUtils.isValidRasterDataType(variable.getDataType()) && variable.getDataType() != DataType.LONG) continue;
            DimKey rasterDim = new DimKey(variable.getDimensions().toArray(new Dimension[variable.getDimensions().size()]));
            Dimension dimX = rasterDim.getDimensionX();
            Dimension dimY = rasterDim.getDimensionY();
            if (dimX.getLength() <= 1 || dimY.getLength() <= 1) continue;
            List<Variable> list = variableLists.get(rasterDim);
            if (list == null) {
                list = new ArrayList<Variable>();
                variableLists.put(rasterDim, list);
            }
            list.add(variable);
        }
        List subGroups = group.getGroups();
        for (Group subGroup : subGroups) {
            RasterDigest.collectVariableLists(subGroup, variableLists);
        }
    }
}

